------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                                E I N F O                                 --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.240 $                            --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Types; use Types;

package Einfo is

--  This package defines the annotations to the abstract syntax tree that
--  are are needed to support semantic processing of an Ada compilation.

--  These annotations are for the most part attributes of declared entities,
--  and they correspond to conventional symbol table information. Other
--  attributes include sets of meanings for overloaded names, possible
--  types for overloaded expressions, flags to indicate deferred constants,
--  incomplete types, etc. These attributes are stored in available fields
--  in tree nodes (i.e. fields not used by the parser, as defined by the
--  Sinfo package specification), and accessed by means of a set of
--  subprograms which define an abstract interface.

--  There are two kinds of semantic information

--    First, the tree nodes with the following Nkind values:

--      N_Defining_Identifier
--      N_Defining_Character_Literal
--      N_Defining_Operator_Symbol

--    are called Entities, and constitute the information that would often
--    be stored separately in a symbol table. These nodes are all extended
--    to provide extra space, and contain fields which depend on the entity
--    kind, as defined by the contents of the Ekind field. The use of the
--    Ekind field, and the associated fields in the entity, are defined
--    in this package, as are the access functions to these fields.

--    Second, in some cases semantic information is stored directly in other
--    kinds of nodes, e.g. the Etype field, used to indicate the type of an
--    expression. The access functions to these fields are defined in the
--    Sinfo package, but their full documentation is to be found in
--    the Einfo package specification.

--  Declaration processing places information in the nodes of their defining
--  identifiers. Name resolution places in all other occurences of an
--  identifier a pointer to the corresponding defining occurrence.

--  --------------------------------
--  -- The XEINFO Utility Program --
--  --------------------------------

--  XEINFO is a utility program which automatically produces a C header file,
--  a-xeinfo.h from the spec and body of package Einfo. It reads the input
--  files einfo.ads and einfo.adb and produces the output file a-xeinfo.h.

--  In order for this utility program to operate correctly, the form of the
--  xeinfo.ads and xeinfo.adb files must meet certain requirements and be layed
--  out in a specific manner.

--  The general form of xeinfo.ads is as follows:

--     type declaration for type Entity_Kind
--     subtype declarations declaring subranges of Entity_Kind
--     subtype declarations declaring synonyms for some standard types
--     function specs for attributes
--     procedure specs
--     pragma Inline declarations

--  This order must be observed. There are no restrictions on the procedures,
--  since the C header file only includes functions (Gigi is not allowed to
--  modify the generated tree). However, functions are required to have headers
--  that fit on a single line.

--  XEINFO reads and processes the function specs and the pragma Inlines. For
--  functions that are declared as inlined, XEINFO reads the corresponding body
--  from xeinfo.adb, and processes it into C code. This results in some strict
--  restrictions on which functions can be inlined:

--     The function spec must be on a single line

--     There can only be a single statement, contained on a single line,
--     not counting any pragma Assert statements.

--     This single statement must either by a function call with simple,
--     single token arguments, or it must be a membership test of the form
--     a in b, where a and b are single tokens.

--  For functions that are not inlined, there is no restriction on the body,
--  and XEINFO generates a direct reference in the C header file which allows
--  the C code in Gigi to directly call the corresponding Ada body.

--  -----------------------
--  -- Entity Attributes --
--  -----------------------

--  This section contains a complete list of the attributes that are defined
--  on entities. Some attributes apply to all entities, others only to certain
--  kinds of entities. In the latter case the attribute should only be set or
--  accessed if the Ekind field indicates an appropriate entity.

--  There are two kinds of entities, stored and synthesized. Stored attributes
--  correspond to a field or flag in the entity itself. Such attributes are
--  identified in the table below by giving the field or flag in the attribute
--  that is used to hold the attribute value. Synthesized attributes are not
--  stored directly, but are rather computed as needed from other attributes,
--  or from information in the tree. These are marked "synthesized" in the
--  table below. The stored attributes have both access functions and set
--  procedures to set the corresponding values, while synethesized attributes
--  have only access functions.

--  Note: in the case of Node, Uint, or Elist fields, there are cases where
--  the same physical field is used for different purposes in different
--  entities, so these access functions should only be referenced for the
--  class of entities in which they are defined as being present. Flags are
--  not overlapped in this way, but nevertheless as a matter of style and
--  abstraction (which may or may not be checked by asertions in the body),
--  this restriction should be observed for flag fields as well.

--    Accept_Address (Elist6)
--       Present in entries. If an accept has a statement sequence, then an
--       address variable is created, which is used to hold the address of the
--       parameters, as passed by the runtime. Accept_Address holds an element
--       list which represents a stack of entities for these address variables.
--       The current entry is the top of the stack, which is the last element
--       on the list. A stack is required to handle the case of nested select
--       statements referencing the same entry.

--    Access_Disp_Table (Node15)
--       Present in record types and subtypes. For a tagged type, points to
--       the dispatch table associated with the tagged type. For a non-tagged
--       record, contains Empty.

--    Alias (Node7)
--       Present in enumeration literals, functions, procedures. Points to
--       parent subprogram of a derived subprogram.

--    Alignment_Clause (Node8)
--       Present in all type entities, and in constants and variables. If an
--       alignment attribute definition clause is present for the type, then
--       the Alignment_Clause field points to the N_Attribute_Definition
--       clause that specifies the alignment. If no alignment clause applies
--       to the type, then this field is Empty. Note that Alignment_Clause can
--       be set even if Has_Alignment_Clause is not set (happens with subtype
--       and derived type declarations). Note also that a record definition
--       clause with an (obsolescent) mod clause is converted into an attribute
--       definition clause for this purpose.

--    Associated_Storage_Pool (Node13)
--       Present in all access kind entities. References the storage pool to
--       be used for the corresponding collection. A value of Empty means that
--       the default pool is to be used.

--    Base_Init_Proc (synthesized)
--       Applicable to all type entities. Obtains the Init_Proc attribute
--       from the base type of the entity, and also deals with going indirect
--       through the Corresponding_Record_Type field for tasks (which are
--       initialized with the initialization routine for the corresponding
--       record type).

--    Base_Type (synthesized)
--       Applicable to all type entities. Returns the base type of a type or
--       subtype. The base type of a type is the type itself. The base type
--       of a subtype is the type that it constrains (which is always a type
--       entity, not some other subtype).

--    Chars (Name1)
--       Present in all entities. This field contains an entry into the names
--       table that has the character string of the identifier, character
--       literal or operator symbol. See Namet for further details.

--    Class_Wide_Type (Field17)
--       Applicable to all type entities. For a tagged type, returns the
--       corresponding implicitly declared class-wide type. Set to Empty
--       for non-tagged types.

--    Comes_From_Source (Flag2)
--       Set by the parser for any defining identifier, defining character
--       literal, or defining oeprator symbol that appears in the original
--       source. Always false for defining identifiers created by semantic
--       analysis or expansion.

--    Component_Clause (Node7)
--       Present for record components. If a record representation clause
--       is present for the corresponding record type that specifies a
--       position for the component, then the Component_Clause field of
--       the E_Component entity points to the N_Component_Clause node.
--       Set to Empty if no record representation clause was present, or
--       if there was no specification for this component.

--    Component_First_Bit (Uint11)
--       Present in record components (E_Component, E_Discriminant) if a
--       component clause applies to the component. First bit position of
--       given component, computed from the first bit and position values
--       given in the component clause. Always non-negative.

--    Component_Size_Clause (Node13)
--       Present in array types only (not in array subtypes}. Points to the
--       component size attribute definition clause if one is present. Set to
--       Empty if no component size clause is present for the array. Note that
--       this field can be set even if Has_Component_Size_Clause is not set as
--       a result of derived type declarations. Note that this field is present
--       only in the base type.

--    Component_Type (Node10)
--       Present in array types and subtypes, and also in the special
--       enumeration table type created for enumeration type. References
--       the entity for the component type.

--    Constant_Value (synthesized)
--       Applicable to constants, named integers, and named reals. Obtains
--       the initialization expression for the entity. Will return Empty for
--       for a deferred constant whose full view is not available.

--    Controlled_Component_Iterator (Node14)
--       Present in composite types and subtypes which can have controlled
--       components (arrays, records, protected types). Points to the
--       entity for the procedure used to iterate through controlled
--       components in objects of the type. See Exp_Ch7 for further details.

--    Corresponding_Concurrent_Type (Node7)
--       Present in record types that are constructed by the expander to
--       represent task and protected types (Is_Concurrent_Record_Type flag
--       set True). Points to the entity for the corresponding task type or
--       protected type.

--    Corresponding_Discriminant (Node7)
--       Present in discriminants of a derived type, when the discriminant is
--       used to constrain a discriminant of the parent type.

--    Corresponding_Integer_Type (Node13)
--       Present in decimal fixed types, ordinary fixed types and enumeration
--       types. Points to the entity in Standard for the integer type used for
--       the underlying implementation of the fixed-point type.

--    Corresponding_Record_Type (Node7)
--       Present in task types and subtypes. References the entity for the
--       corresponding record type constructed by the expander (see Exp_Ch9).
--       This type is used to represent values of the task type.

--    Corresponding_Unprotected (Node11)
--       Present in protected procedures and functions.  References the
--       entity for the unprotected version of the subprogram generated
--       by the expander.  This is called from the protected version, and
--       between protected operations of the same protected object.

--    Declaration_Node (synthesized)
--       Applicable to all entities. Returns the tree node for the declaration
--       that declared the entity. Normally this is just the Parent of the
--       entity. The exception arises with child units, where the parent of
--       the entity is a selected component.

--    Default_Value (Node10)
--       Present in IN parameters. Points to the node representing the
--       expression for the default value for the parameter. Empty if the
--       parameter has no default value.

--    Delta_Value (Ureal7)
--       Present in fixed and decimal types. Points to a universal real
--       that holds value of delta for the type, as given in the declaration
--       or as inherited by a subtype or derived type.

--    Depends_On_Private_Type (Flag14)
--       Present in all type entities. Set if the type is private or if it
--       depends on a private type.

--    Designated_Type (synthesized)
--       Applicable to access types. Returns the designated type. Differs
--       from Directly_Designated_Type in that if the access type refers
--       to an incomplete type, and the full type is available, then this
--       full type is returned instead of the incomplete type.

--    Digits_Value (Uint9)
--       Present in floating point types and subtypes and decimal types and
--       subtypes. Contains the Digits value specified in the declaration.

--    Directly_Designated_Type (Node10)
--       Present in access types. This field points to the type that is
--       directly designated by the access type. In the case of an access
--       type to an incomplete type, this field references the incomplete
--       type. Note that in the semantic processing, what is useful in
--       nearly all cases is the full type designated by the access type.
--       The function Designated_Type obtains this full type in the case of
--       access to an incomplete type.

--    Discriminal (Node9)
--       Present in discriminants (Discriminant formal: GNAT's first
--       coinage). The entity used as a formal parameter that corresponds
--       to a discriminant. See section "Use of Discriminants" for details.

--    Discriminant_Checking_Func (Node10)
--       Present in components. Points to the defining identifier of the
--       function built by the expander returns a Boolean indicating whether
--       the given record component exists for the current discriminant
--       values.

--    Discriminant_Constraint (Elist6)
--       Present in entities that can have discriminants (concurrent types
--       subtypes, record types and subtypes, private types and subtypes,
--       limited private types and subtypes and incomplete types). Points
--       to an element list containing the discriminant constraint (list
--       of discriminant associations) for a record (sub)type.

--    Discriminant_Default_Value (Node10)
--       Present in discriminants. Points to the node representing the
--       expression for the default value of the discriminant. Set to
--       Empty if the discriminant has no default value.

--    Ekind (Ekind)
--       Present in all entities. Contains a value of the enumeration type
--       Entity_Kind declared in a subsequent section in this spec.

--    Entry_Component (Node11)
--       Present in formal parameters (in, in out and out parameters). Used
--       only for formals of entries. References the corresponding component
--       of the entry parameter record for the entry.

--    Entry_Index_Value (Uint12)
--       Present on entries (but not entry families). This field contains
--       the ordinal number of the simple entry (i.e. first entry is 1). This
--       value is used in calling tasking routines. For entry families, the
--       required index is computed from the Number_Simple_Entries field of
--       the task type entity, and the bounds of the entry families.

--    Entry_Index_Type (synth)
--       applies to an entry family. Denotes Etype of the subtype indication
--       in the entry declaration. Used to resolve the index expression in an
--       accept statement for a member of the family, and in the prefix of
--       'COUNT when it applies to a family member.

--    Entry_Parameters_Type (Node7)
--       Present in entries. Points to the access-to-record type that is
--       constructed by the expander to hold a reference to the parameter
--       values. This reference is manipulated (as an address) by the
--       tasking runtime. The designated record represents a packaging
--       up of the entry parameters (see Exp_Ch9.Expand_N_Entry_Declaration
--       for further details). Entry_Parameters_Type is Empty if the entry
--       has no parameters.

--    Enumeration_Pos (Uint11)
--       Present in enumeration literals. Contains the position number
--       corresponding to the value of the enumeration literal.

--    Enumeration_Rep (Uint12)
--       Present in enumeration literals. Contains the representation that
--       corresponds to the value of the the enumeration literal. Note that
--       this is normally the same as Enumeration_Pos except in the presence
--       of representation clauses, where Pos will still represent the
--       position of the literal within the type and Rep will have be the
--       value given in the representation clause.

--    Enumeration_Rep_Expr (Node8)
--       Present in enumeration literals. Points to the expression in an
--       associated enumeration rep clause that provides the representation
--       value for this literal. Empty if no enumeration rep clause for this
--       literal (or if rep clause does not have an entry for this literal,
--       an error situation). This is also used to catch duplicate entries
--       for the same literal.

--    Enum_Pos_To_Rep (Node14)
--       Present in enumeration types (but not enumeration subtypes). Set to
--       Empty unless the enumeration type has a non-standard representation
--       (i.e. at least one literal has a representation value different from
--       its pos value). In this case, Enum_Pos_To_Rep is the entity for an
--       array constructed when the type is frozen that maps Pos values to
--       corresponding Rep values. The index type of this array is Natural,
--       and the component type is whatever the underlying representation
--       type of the enumeration type is (i.e. Corresponding_Integer_Type).

--    Enum_Rep_To_Pos (Node15)
--       Present in enumeration types (but not enumeration subtypes). Set to
--       Empty unless the enumeration type has a non-standard representation
--       (i.e. at least one literal has a representation value different from
--       its pos value). In this case, Enum_Pos_To_Rep is the entity for a
--       function, constructed when the type is frozen, that takes a value of
--       the enumeration type as its argument, and returns as the result the
--       pos value (of type Natural).

--    Equivalent_Type (Node7)
--       Present in class wide types and subtypes. For a class wide type, it
--       is always Empty. For a class wide subtype, it points to an entity
--       created by the expander which gives Gigi an easily understandable
--       equivalent of the class subtype with a known size (given by an initial
--       value ). See Exp_Util.Expand_Class_Wide_Subtype for further details.

--    Esize (Node12)
--       Present in all types and subtypes, an also for components, constants,
--       and variables. Contains the size of a type or object. A value of zero
--       is used in the case of composite types or objects for which no size
--       clause has been given (i.e. those types for which only Gigi knows the
--       allocated size). In the case of components where a component clause is
--       present, the value is the value from the component clause, which must
--       be non-negative (but may be zero, which is acceptable for the case of
--       a type with only one possible value).

--    Etype (Node5)
--       Present in all entities. Represents the type of the entity, which
--       is itself another entity. For a type entity, this pointer is self-
--       referential. For a subtype entity, Etype is the base type.

--    Finalization_Chain_Entity (Node13)
--       Present in scopes which can have finalizable entities (blocks,
--       functions, procedures, tasks, entries). This is the entity for
--       the finalization chain object. See Exp_Ch7 for full details.

--    First_Component (synthesized)
--       Applicable to record types. Returns the first component by following
--       the chain of declared entities for the record until the component
--       is found (one with an Ekind of E_Variable). The discriminants are
--       skipped. If the record is null, then Empty is returned.

--    First_Discriminant (synthesized)
--       Applicable to types with discriminants. The discriminants are the
--       first entities declared in the type, so normally this is equivalent
--       to First_Entity. The exception arises for tagged types, where the
--       tag itself is prepended to the front of the entity chain, so the
--       First_Discriminant function steps past the tag if it is present.

--    First_Entity (Node9)
--       Present in all entities which act as scopes to which a list of
--       associated entities is attached (blocks, class subtypes and types,
--       entries, functions, loops, packages, procedures, protected objects,
--       record types and subtypes, task types and subtypes). Points to a
--       list of associated entities chained through the Next_Entity field
--       with Empty marking the end of the list.

--    First_Formal (synthesized)
--       Applicable to subprograms or subprogram types, and also to entries
--       and entry families. Returns first formal of the subprogram or entry.
--       The formals are the first entities declared in a subprogram or in
--       a subprogram type (the designated type of an Access_To_Subprogram
--       definition) or in an entry..

--    First_Index (Node9)
--       Present in array types and subtypes and in string types and subtypes.
--       By introducing implicit subtypes for the index constraints,
--       we obtain the same structure for constrained and unconstrained
--       arrays: subtype marks and discrete ranges are both lists of
--       subtypes. First_Index returns the tree node corresponding to the
--       Subtype_Marks (index_subtype_definition) in the case of
--       E_Array_Type and Discrete_Subtype_Definitions (index constraint)
--       in the case of an E_Array_Subtype. To get the defining occurence
--       representing the type or subtype corresponding to the first index
--       it is necessary to retrieve the Etype (First_Index (Id)).

--    First_Literal (Node9)
--       Present in all enumeration types, including character and boolean
--       types. This field points to the first enumeration literal entity
--       for the type (i.e. it is set to First (Literals (N)) where N is
--       the enumeration type definition node. A special case occurs with
--       standard character and wide character types, where this field is
--       Empty, since there str no enumeration literal lists in these cases.

--    First_Private_Entity (Node11)
--       Present in all entities containing private parts (packages,
--       protected types and subtypes, task types and subtypes). The
--       entities on the entity chain are in order of declaration, so the
--       entries for private entities are at the end of the chain. This
--       field points to the first entity for the private part. It is
--       Empty if there are no entities declared in the private part or
--       if there is no private part.

--    Full_View (Node11)
--       Present in incomplete types, private types, limited private types,
--       and deferred constants. Points to the entity for the corresponding
--       full type declaration. See also Underlying_Type.

--    Has_Address_Clause (Flag28)
--       Present for objects and subprograms. Set if an address clause is
--       present which references the object or subprogram.

--    Has_Alignment_Clause (Flag46)
--       Present in all type entities and objects. Indicates if an alignment
--       clause has been given for the entity. If set, then Alignment_Clause
--       points to the N_Attribute_Definition node for the alignment attribute
--       definition clause. Note that it is possible for this flag to be False
--       even when Alignment_Clause is set (this happens in the case of subtype
--       declarations and derived type declarations).

--    Has_Completion (Flag26)
--       Present in all entities that require a completion (functions,
--       procedures, private types, limited private types, incomplete types,
--       and packages that require a body). Set if the completion has been
--       encountered and analyzed.

--    Has_Completion_In_Body (Flag71)
--       Present in  "Taft amendment types" that is to say private types whose
--       full declaration appears in the package body.

--    Has_Component_Size_Clause (Flag68)
--       Present in array types (but not in array subtypes). Set if a component
--       size clause is present for the given type. Note that this flag can be
--       False even if Component_Size_Clause is set (happens in the case of
--       derived types). Note that this flag is only set on the base type.

--    Has_Controlled (Flag43)
--       Present for composite types. Indicates that the type or one of its
--       components has Is_Controlled set, i.e. that there is at least one
--       controlled component in the type somewhere.

--    Has_Convention_C (Flag70)
--       Present in functions and procedures. Set if a pragma Import (C, ..)
--       or pragma Interface (C,..) is present. Used to indicate that the
--       appropriate C calling sequence should be used, and that in particular
--       unconstrained arrays should be passed simply by passing the address
--       of the first element.

--    Has_Convention_Intrinsic (Flag27)
--       Present in functions and procedures. Set if a pragma Convention
--       Intrinsic has been given for the subprogram or if pragma Import
--       is given with Convention=>Intrinsic. Note that this flag does NOT
--       mean that the subprogram is an intrinsic subprogram (see separate
--       flag Is_Intrinsic_Subprogram). The purpose of this flag is to allow
--       certain semantic checks, e.g. that 'Access is not applied to such
--       a subprogram. This flag has no effect on the generated code.

--    Has_Discriminants (Flag5)
--       Present in entities for types that can have discriminants (record
--       types and subtypes, task types and subtypes, protected types and
--       subtypes, private types, limited private types, and incomplete types)
--       if the corresponding type or subtypes has a known discriminant part.

--    Has_Enumeration_Rep_Clause (Flag66)
--       Present for enumeration types. Set if an enumeration representation
--       clause has been given for this enumeration type. Used to prevent more
--       than one enumeration representation clause for a given type. Note
--       that this does not imply a representation with holes, since the rep
--       clause may merely confirm the default 0..N representation.

--    Has_Exit (Flag47)
--       Present on loop entities. Set if the loop contains an exit statement.

--    Has_Homonym (Flag56)
--       Present in all entities. Set if an entity has a homonym in the same
--       scope. Used by Gigi to generate unique names for such entities.

--    Has_Master_Entity (Flag21)
--       A flag present on entities that can appear in the scope stack (see
--       Sem spec). It is set if a task master entity (_Master) has been
--       declared and initialized in the corresponding scope.

--    Has_Size_Clause (Flag29)
--       Present for entities for types and objects. Set if a size clause is
--       present for the entity. Used to prevent multiple Size clauses for a
--       given entity. Note that it is always initially cleared for a derived
--       type, even though the Size for such a type is inherited from a Size
--       clause given for the parent type.

--    Has_Small_Clause (Flag67)
--       Present for ordinary fixed point types (but not subtypes). Indicates
--       that a small clause has been given for the entity. Used to prevent
--       multiple Small clauses for a given entity. Note that it is always
--       initially cleared for a derived type, even though the Small for such
--       a type is inherited from a Small clause given for the parent type.

--    Has_Storage_Size_Clause (Flag23)
--       Present for task types and access types. Set if Storage_Size clause
--       is present for the type. Used to prevent multiple clauses for one
--       type. Note that this flag is initially cleared for a derived type
--       even though the Storage_Size for such a type is inherited from a
--       Storage_Size clause given for the parent type. Note that this flag
--       is only present on the base type.

--    Has_Record_Rep_Clause (Flag65)
--       Present for record types. Set if a record representation clause has
--       been given for this record type. Used to prevent more than one such
--       clause for a given record type.

--    Has_Tasks (Flag30)
--       Present in all type entities. Set on task types themselves, and also
--       (recursively) on any composite type which has a component for which
--       Has_Tasks is set. The meaning is that an allocator of such an object
--       must create the required tasks. Note that the flag is not set on
--       access types, even if they designate an object that Has_Tasks.

--    Homonym (Node4)
--       Present in all entities. Contains a link to chain entities that are
--       homonyms and that are declared in the same or enclosing scopes.
--       (Homonyms in the same scope are overloaded). Since this field is
--       in the base part of the entity, the access routines for this field
--       are in Sinfo.

--    In_Package_Body (Flag48)
--       Set on the entity that denotes the package (the defining occurrence
--       of the package declaration) while analyzing the package body. Reset
--       on completion of the analysis.

--    In_Private_Part (Flag45)
--       Present in package entities. Flag is set to indicate that the
--       private part is being analyzed. The flag is reset at the end of the
--       package declaration.

--    Init_Proc (Node8)
--       Present in all type entities. Points to the entity for the
--       Initialization procedure if one is required. If this field is
--       Empty, then no Initialization proc is defined for the type. Note
--       that subtyupes and implicit types do not have this field set.
--       Subtype objects are initialized using the initialization procedure
--       of the base type. A special case arises for task types. The
--       Init_Proc field of task types is Empty, but initialization is
--       required. The initialization procedure used is the one for the
--       corresponding record type (see Base_Init_Proc).

--    Interface_Name (Node12)
--       Present in functions and procedures, contains Empty unless a pragma
--       Interface_Name or Import has been given, in which case it points to
--       the N_String_Literal node for the specified link name.

--    Is_Abstract (Flag19)
--       Present in all types, and also for functions and procedures. Set
--       for abstract types and abstract subprograms.

--    Is_Access_Constant (Flag69)
--       Present for access types and subtypes. Indicates that the keyword
--       constant was present in the access type definition.

--    Is_Aliased (Flag15)
--       Present in objects whose declarations carry the keyword aliased,
--       and on record components that have the keyword. For arrays with an
--       aliased component declaration, the flag is on the array type itself.

--    Is_Access_Type (synthesized)
--       Applicable to all entities, true for access types and subtypes

--    Is_Array_Type (synthesized)
--       Applicable to all entities, true for array types and subtypes

--    Is_Boolean_Type (synthesized)
--       Applicable to all entities, true for boolean types and subtypes,
--       i.e. Standard.Boolean and all types ultimately derived from it.

--    Is_Character_Type (Flag63)
--       Applicable to all entities, true for character types and subtypes,
--       i.e. enumeration types that have at least one character literal.

--    Is_Class_Wide_Type (synthesized)
--       Applicable to all entities, true for class wide types and subtypes

--    Is_Composite_Type (synthesized)
--       Applicable to all entities, true for all composite types and
--       subtypes. Either Is_Composite_Type or Is_Elementary_Type (but
--       not both) is true of any type.

--    Is_Concurrent_Record_Type (Flag20)
--       Present in record types and subtypes. Set if the type was created
--       by the expander to represent a task or protected type. For every
--       concurrent type, such as record type is constructed, and task and
--       protected objects are instances of this record type at runtime
--       (Gigi will replace declarations of the concurrent type using the
--       declarations of the corresponding record type). See package Exp_Ch9
--       for further details.

--    Is_Constrained (Flag3)
--       Present in types or subtypes which may have index or discriminant
--       constraints (i.e. array types and subtypes, record types and
--       subtypes, and string types and subtypes). Set if the type or
--       subtype is constrained.

--    Is_Controlled (Flag42)
--       Present in all type entities. Indicates that this type is controlled,
--       i.e. is is either a descendant of Ada.Finalization.Controlled or
--       Ada.Finalization.Limited_Controlled.

--    Is_Decimal_Fixed_Point_Type (synthesized)
--       Applicable to all type entities, true for decimal fixed point
--       types and subtypes.

--    Is_Delayed (Flag18)
--       Present in all entities. Set to indicate that the elaboration of
--       the declaration for the entity must be deferred in Gigi, until the
--       completion of some other entity (typically a private type) is
--       encountered. Could use more explanation on this one ???

--    Is_Discrete_Type (synthesized)
--       Applicable to all entities, true for all discrete types and subtypes

--    Is_Dispatching_Operation (Flag6)
--       Present in procedures, functions, generic procedures and generic
--       functions. Set if the corresponding operation is dispatching.

--    Is_Elementary_Type (synthesized)
--       Applicable to all entities, true for all elementary types and
--       subtypes. Either Is_Composite_Type or Is_Elementary_Type (but
--       not both) is true of any type.

--    Is_Entry_Formal (Flag52)
--       Present in formal parameters (in, in out and out parameters). Set
--       for the case of entry formals (for use in speeding up the test for
--       need to replace references in Exp_Ch2).

--    Is_Enumeration_Type (synthesized)
--       Applicable to all entities, true for enumeration types and subtypes

--    Is_First_Named_Subtype (synthesized)
--       Applicable to all types and subtypes. Checks if the given entity is
--       a first named subtype, and if so returns True. Otherwise returns
--       False (if this is an error, the caller must post the error message).

--    Is_Fixed_Point_Type (synthesized)
--       Applicable to all entities, true for decimal and ordinary fixed
--       point types and subtypes

--    Is_Floating_Point_Type (synthesized)
--       Applicable to all entities, true for float types and subtypes

--    Is_Frozen (Flag4)
--       Present in all type entities. Set if the type has been frozen.

--    Is_Generic_Type (Flag1)
--       Present on types which are generic formal types. Such types have an
--       Ekind that corresponds to their classification, so the Ekind cannot
--       be used to identify generic types.

--    Is_Immediately_Visible (Flag7)
--       Present in all entities. Set if entity is immediately visible, i.e.
--       is defined in some currently open scope (RM 8.3(4)).

--    Is_Imported (Flag24)
--       Present in all entities. Set if the entity is imported. For now we
--       only allow the import of functions and procedures, but that may well
--       change later on.

--    Is_Incomplete_Or_Private_Type (synthesized)
--       Applicable to all entities, true for private and incomplete types

--    Is_Inlined (Flag11)
--       Present in functions and procedures. Set if a pragma Inline applies
--       to the subprogram. For subprograms created during expansion, this
--       flag may be set directly by the expander to request inlining.

--    Is_Integer_Type (synthesized)
--       Applicable to all entities, true for integer types and subtypes

--    Is_Internal (Flag17)
--       Present in all entities. Set to indicate an entity created during
--       semantic processing (e.g. an implicit type). Need more documentation
--       on this one! ???

--    Is_Intrinsic_Subprogram (Flag64)
--       This flag applicable to functions and procedures. It is set if a
--       valid pragma Interface or Import is present for this subprogram
--       specifying pragma Intrinsic. Valid means that the name and profile
--       of the subprogram match the requirements of one of the recognized
--       intrinsic subprograms (see package Sem_Intr for details). Note that
--       the Has_Convention_Intrinsic flag will also be set if this flag is
--       set, but it is this flag, NOT Has_Convention_Intrinsic, that actually
--       causes intrinsic code to be generated.

--    Is_Limited_Record (Flag25)
--       Present in for record (sub)types and set to true if the record
--       is declared to be limited.

--    Is_Limited_Type (synthesized)
--       Applicable to all type entities. True if the type is a limited type
--       (limited private type, task type, protected type, composite
--       containing a limited component, or subtypes of any of these
--       types).

--    Is_Numeric_Type (synthesized)
--       Applicable to all entities, true for all numeric types and subtypes
--       (integer, fixed, float).

--    Is_Ordinary_Fixed_Point_Type (synthesized)
--       Applicable to all entities, true for ordinary fixed point types
--       and subtypes

--    Is_Packed (Flag51)
--       Present in all type entities. Set if a pragma Pack is present
--       referring to this type.

--    Is_Potentially_Use_Visible (Flag9)
--       Applicable to all entities. Set if entity is potentially use visible,
--       i.e. it is defined in a package that appears in a currently active
--       use clause (RM 8.4(8)). Note that potentially use visible entities
--       are not necessarily use visible (RM 8.4(9-11)).

--    Is_Preelaborated (Field59)
--       Applicable to E_Package and E_Generic_Package entities, set if a
--       pragma Preelaborate applies to the package. Note that this does
--       not necessarily mean that no elaboration code is generated.

--    Is_Private (Flag57)
--       Present in all entities. Indicates whether entity is directly
--       declared within the private part of a package.

--    Is_Private_Descendant (Flag53)
--       Present in entities that can represent library units (packages,
--       functions, procedures). Set if the library unit is itself a private
--       child unit, or if it is the descendent of a private child unit.

--    Is_Private_Type (synthesized)
--       Applicable to all entities, true for private types and subtypes,
--       as well as for record with private types a subtypes

--    Is_Protected_Type (synthesized)
--       Applicable to all entities, true for protected types and subtypes

--    Is_Public (Flag10)
--       Present in all entities. Set to indicate that an entity defined in
--       one compilation unit can be referenced from other compilation units.
--       If this reference causes a reference in the generated variable, for
--       example in the case of a variable name, then Gigi will generate an
--       appropriate external name for use by the linker.

--    Is_Protected_Private (synthesized)
--       Applicable to a record component. Returns true if this componant
--       is used to represent a private declaration of a protected type.

--    Is_Protected_Record_Type (synthesized)
--       Applicable to all entities, true if Is_Concurrent_Record_Type
--       Corresponding_Concurrent_Type is a protected type.

--    Is_Pure (Flag44)
--       Present in all entities. Set in all entities of a unit to which a
--       pragma Pure is applied, and also set for the entity of the unit
--       itself. In addition, this flag may be set for any other functions
--       or procedures that are known to be side effect free, so in the case
--       of subprograms, the Is_Pure flag may be used by the optimizer to
--       imply that freedom from side effects can be assumed.

--    Is_Real_Type (synthesized)
--       Applicable to all entities, true for real types and subtypes

--    Is_Record_Type (synthesized)
--       Applicable to all entities, true for record types and subtypes,
--       includes class-wide types and subtypes (which are also records)

--    Is_Remote_Call_Interface (Flag62)
--       Applicable to E_Package and E_Generic_Package entities, set
--       if a pragma Remote_Call_Interface applies to the package.

--    Is_Remote_Types (Flag61)
--       Applicable to E_Package and E_Generic_Package entities, set
--       if a pragma Remote_Types applies to the package.

--    Is_Scalar_Type (synthesized)
--       Applicable to all entities, true for scalar types and subtypes

--    Is_Shared_Passive (Flag60)
--       Applicable to E_Package and E_Generic_Package entities, set
--       if a pragma Shared_Passive applies to the package.

--    Is_String_Type (synthesized)
--       Applicable to all type entities. Determines if the given type is
--       a string type, i.e. it is directly a string type or string subtype,
--       or a string slice type, or an array type with one dimension and a
--       component type that is a character type.

--    Is_Tagged_Type (Flag55)
--       Applicable to all entities, true for an entity for a tagged type.

--    Is_Task_Record_Type (synthesized)
--       Applicable to all entities, true if Is_Concurrent_Record_Type
--       Corresponding_Concurrent_Type is a task type.

--    Is_Task_Type (synthesized)
--       Applicable to all entities, true for task types and subtypes

--    Is_Type (synthesized)
--       Applicable to all entities, true for a type entity

--    Is_Volatile (Flag16)
--       Present in all type entities, and also in constants, components and
--       variables. Set if a pragma Volatile applies to the entity.

--    Last_Entity (Node10)
--       Present in all entities which act as scopes to which a list of
--       associated entities is attached (blocks, class subtypes and types,
--       entries, functions, loops, packages, procedures, protected types,
--       record types and subtypes, task types and subtypes). Points to the
--       last entry in the list of associated entities chained through the
--       Next_Entity field. Empty if no entities are chained.

--    Lit_Name_Table (Node7)
--       Present in enumeration types and subtypes. Points to the entity
--       (which is of the special type E_Enum_Table_Type) for a table of
--       accesses to strings, generated by Gigi for each enumeration type.
--       The table is an array whose index values are 'Pos values and whose
--       entries are access to string, where each string is the 'Image value.

--    Master_Id (Node9)
--       Present in access types and subtypes. . Empty unless Has_Tasks is
--       set for the designated type, in which case it points to the entity
--       for the Master_Id for the access type master.

--    Modulus (Uint9)
--       Present in modular types. Contains the modulus (a power of 2).

--    Needs_Discr_Check (Flag50)
--       Present in components. Set if references to this component
--       require a discriminant check.

--    Needs_No_Actuals (Flag22)
--       Applies to callable entities (subprograms, entries, access to
--       subprograms)  which can be called without actuals because all of
--       their formals (if any) have default values. This flag simplifies the
--       resolution of the syntactic ambiguity involving a call to these
--       entities when the return type is an array type, and a call can be
--       interpreted as an indexing of the result of the call. It is also
--       used to resolve various cases of entry calls.

--    Next_Component (synthesized)
--       Applicable to a record component. Returns the next component by
--       following the chain of declared entities until one is found which
--       corresponds to a component (Ekind is E_Variable). Any internal types
--       generated from the subtype indications of the record components are
--       skipped. Returns Empty if no more components.

--    Next_Discriminant  (synthesized)
--       Applicable to a discriminant. Returns the next discriminant by
--       following the chain of declared entities as long as the kind of
--       the entity corresponds to a discriminant. Note that the discriminants
--       might be the only components of the record. Returns Empty if there
--       are no more discriminants.

--    Next_Entity (Node2)
--       Present in all entities. The entities of a scope are chained, with
--       the head of the list being in the First_Entity field of the scope
--       entity. All entities use the Next_Entity field as a forward pointer
--       for this list, with Empty indicating the end of the list. Since this
--       field is in the base part of the entity, the access routines for this
--       field are in Sinfo.

--    Next_Formal (synthesized)
--       Applicable to the entity for a formal parameter. Returns the next
--       formal parameter of the subprogram or subprogram type. Returns
--       Empty if there are no more formals.

--    Next_Itype (Node16)
--       Applicable to all entities for types. Used as a forward link for a
--       chain of implicit Itypes (See spec of package itypes for details)

--    Next_Overloads (synthesized)
--       Applicable to all entities. This is a synonym for Homonym used in
--       conjunction with overloading resolution

--    Number_Dimensions (synthesized)
--       Applicable to array entities. Returns the number of dimensions of
--       the array entity as a value of type Pos.

--    Number_Discriminants (synthesized)
--       Applicable to all types with discriminants.

--    Number_Simple_Entries (Uint15)
--       Present for concurrent types and subtypes. Set to the number of simple
--       entries (i.e. entry families excluded) defined in the corresponding
--       task or protected definition.

--    Original_Record_Component (Node8)
--       Present for components. When this component is inherited in a record
--       extension, it points to the original component (the entity of the
--       ancestor component which is not itself inherited) otherwise it points
--       to itself. Gigi uses this attribute to implement the automatic
--       dereference in the extension and to apply the transformation:
--         Rec_Ext.Comp ===> Rec_Ext.Parent. ... .Parent.Comp

--    Parameter_Mode (synthesized)
--       Applicable to formal parameter entities. This is a synonym for Ekind,
--       used when obtaining the formal kind of a formal parameter (the result
--       is one of E_[In/Out/In_Out]_Paramter)

--    Parent_Subtype (Node11)
--       Defined for all scalar subtypes. Always Empty for types. For
--       subtypes, references the entity for the type or subtype from
--       which the subtype was immediately obtained. This attribute is
--       used in recognizing some cases of range checking which can be
--       eliminated at compile time.

--    Primitive_Operations (Elist7)
--       Present in tagged record types and subtypes and in tagged private
--       types. Points to an element list of entities for primitive operations
--       for the tagged type. Not present (and not set) in untagged types (it
--       is an error to reference the primitive operations field of a type
--       that is not tagged).

--    Private_Subtype_List (Node7)
--       Present in private (sub)types. List of all the private subtypes
--       defined before the full declaration of the base type. This list is
--       defined to keep track of these subtypes in order to define their fake
--       full declaration just after the full declaration of the base type.

--    Prival (Node9)
--       Present in components.  Used for representing private declarations
--       of protected objects (private formal: by analogy to discriminal).
--       Empty unless the synthesized Is_Protected_Private attribute is true.
--       The entity used as a formal parameter that corresponds
--       to the private declaration in protected operations.  See
--       "Private data in protected objects" for details.

--    Protected_Formal (Node8)
--       Present in formal parameters (in, in out and out parameters). Used
--       only for formals of protected operations.  References the
--       corresponding formal parameter in the unprotected version of the
--       operation created during expansion.

--    Protected_Subprogram (Node14)
--       Present in components.  Used for representing private declarations
--       of protected objects.  Empty unless the synthesized
--       Is_Protected_Private attribute is true.  This is the entity
--       corresponding to the protected subprogram currently being analyzed,
--       and which will eventually use the current Prival associated with
--       this component to refer to the renaming of a private object
--       component.  As soon as the expander generates this renaming, this
--       attribute is changed to refer to the next protected subprogram.
--       See "Private data in protected objects" for details.

--    Reachable (Flag49)
--       Present in labels. The flag is set over the range of statements in
--       which a goto to that label is legal.

--    Renamed_Object (Node7)
--       Present in constants and variables. References the entity for the
--       renamed object.

--    Return_Present (Flag54)
--       Present in function and generic function entities. Set if the
--       function contains a return statement (used for error checking).

--    Root_Type (synthesized)
--       Applicable to all entity types. Returns the root type (i.e. the
--       ultimate derivation ancestor) of the given type. For a predefined
--       type, this is the type itself.

--    Scalar_Range (Node10)
--       Present in all scalar types (including modular types, where the
--       bounds are 0 .. modulus - 1). References a node in the tree that
--       contains the bounds for the range. Note that this information
--       could be obtained by rummaging around the tree, but it is more
--       convenient to have it immediately at hand in the entity.

--    Scope (Node3)
--       Present in all entities. Points to the entity for the scope (block,
--       loop, subprogram, package etc.) in which the entity is declared.
--       Since this field is in the base part of the entity node, the access
--       routines for this field are in Sinfo.

--    Slice_Range (Node11)
--       Present in slice subtypes, which are created to represent the type
--       of slices appearing in the program. References the N_Discrete_Range
--       node of the slice for which this subtype was created.

--    Small_Value (Ureal6)
--       Present in fixed point types. Points to the universal real for the
--       Small of the type, either as given in a representation clause, or
--       as computed (as a power of two) by the compiler.

--    Storage_Size_Variable (Node14)
--       Present for access kind entities. Points to the entity for a variable
--       that is created to hold the value given in a Storage_Size pragma for
--       an access collection.

--    String_Literal_Length (Uint11)
--       Present in string literal subtypes (which are created to correspond
--       to string literals in the program). Contains the length of the string
--       literal.

--    Suppress_Access_Checks (Flag31)
--       Present on all entities. Set if access checks associated with this
--       entity are to be suppressed (see separate section on "Handling of
--       Check Suppression")

--    Suppress_Accessibility_Checks (Flag32)
--       Present on all entities. Set if accessibility checks associated with
--       this entity are to be suppressed (see separate section on "Handling
--       of Check Suppression")

--    Suppress_Discriminant_Checks (Flag33)
--       Present on all entities. Set if discriminant checks associated with
--       this entity are to be suppressed (see separate section on "Handling
--       of Check Suppression")

--    Suppress_Division_Checks (Flag34)
--       Present on all entities. Set if division checks associated with
--       this entity are to be suppressed (see separate section on "Handling
--       of Check Suppression")

--    Suppress_Elaboration_Checks (Flag35)
--       Present on all entities. Set if elaboration checks associated with
--       this entity are to be suppressed (see separate section on "Handling
--       of Check Suppression")

--    Suppress_Index_Checks (Flag36)
--       Present on all entities. Set if index checks associated with this
--       entity are to be suppressed (see separate section on "Handling of
--       Check Suppression")

--    Suppress_Length_Checks (Flag37)
--       Present on all entities. Set if length checks associated with this
--       entity are to be suppressed (see separate section on "Handling of
--       Check Suppression")

--    Suppress_Overflow_Checks (Flag38)
--       Present on all entities. Set if overflow checks associated with
--       this entity are to be suppressed (see separate section on "Handling
--       of Check Suppression")

--    Suppress_Range_Checks (Flag39)
--       Present on all entities. Set if range checks associated with this
--       entity are to be suppressed (see separate section on "Handling of
--       Check Suppression")

--    Suppress_Storage_Checks (Flag40)
--       Present on all entities. Set if storage checks associated with
--       this entity are to be suppressed (see separate section on "Handling
--       of Check Suppression")

--    Suppress_Tag_Checks (Flag41)
--       Present on all entities. Set if tag checks associated with this
--       entity are to be suppressed (see separate section on "Handling of
--       Check Suppression")

--    Table_High_Bound (Node11)
--       Present in the special Enum_Table_Type entities created to
--       represent the Lit_Name_Table created by Gigi. Contains the high
--       bound (i.e. number of entries minus one) of the created table.
--       Equal to Enum_Type'Pos (Enum_Type'Last).

--    Tag_Component (synthesized)
--       Applicable to tagged record types, returns the entity for the _Tag
--       field in this record, which must be present.

--    Task_Activation_Chain_Entity (Node14)
--       Present in scopes which can have an associated task activation chain
--       (blocks, functions, procedures, task types, entries, packages). It
--       holds the entity associated with this activation chain. Empty if no
--       chain is currently established. See Exp_Ch9 for details.

--    Type_High_Bound (synthesized)
--       Applicable to scalar types. Returns the tree node (Node_Id) that
--       contains the high bound of a scalar type. The returned value is a
--       literal for a base type, but may be an expression in the case of a
--       scalar type with dynamic bounds. Note that in the case of a fixed
--       point type, the high bound is in units of small, and is an integer.

--    Type_Low_Bound (synthesized)
--       Applicable to scalar types. Returns the tree node (Node_Id) that
--       contains the low bound of a scalar type. The returned value is a
--       literal for a base type, but may be an expression in the case of a
--       scalar type with dynamic bounds. Note that in the case of a fixed
--       point type, the low bound is in units of small, and is an integer.

--    Underlying_Type (synthesized)
--       Present in all type entities. Gives the entity of the underlying
--       type. For types other than private and incomplete types, this is
--       the type itself. For incomplete and private types, it is the
--       underlying type of the type declared by the completion, or Empty
--       if the completion has not yet been encountered and analyzed.

   ------------------
   -- Access Kinds --
   ------------------

   --  The following three entity kinds are introduced by the corresponding
   --  type definitions:

   --    E_Access_Type,  E_General_Access_Type,  E_Anonymous_Access_Type.

   --  In  addition, we define the kind E_Allocator_Type to label allocators
   --  and attribute references with 'Access. This is because special
   --  resolution rules apply to these constructs. Eventually the constructs
   --  are labelled with the access type imposed by the context.  Gigi should
   --  never see the type E_Allocator.

   --  Finally, the type Any_Access is used to label -null- during type
   --  resolution. Any_Access is also replaced by the context type after
   --  resolution.

   --------------------------------
   -- Classification of Entities --
   --------------------------------

   --  The classification of program entities which follows is a refinement of
   --  the list given in RM 3.1(1). E.g., separate entities denote subtypes of
   --  different type classes. Ada9X entities include class wide types,
   --  protected types, subprogram types, generalized access types,  generic
   --  formal derived types and generic formal packages.

   --  The order chosen for these kinds allows us to classify related entities
   --  sp that they are contiguous. As a result, they do not appear in the
   --  exact same order as their order of first appearance in the LRM (For
   --  example, private types are listed before packages). The contiguity
   --  allows us to define useful subtypes (see below) such as type entities,
   --  overloaded entities, etc.

   --  Each entity (explicitly or implicitly declared) has a kind, which is
   --  a value of the following type:

   type Entity_Kind is (

      E_Void,
      --  The initial Ekind value for a newly created entity. Also used as
      --  the Ekind for Standard_Void_Type, a type entity in Standard used
      --  as a dummy type for the return type of a procedure (the reason we
      --  create this type is to share the circuits for performing overload
      --  resolution on calls).

      -------------
      -- Objects --
      -------------

      E_Variable,
      --  Variables created by an object declaration with no constant keyword

      E_Component,
      --  Components of a record declaration, private declarations of
      --  protected objects.

      E_Constant,
      --  Constants created by an object declaration with a constant keyword

      -------------------
      -- Named Numbers --
      -------------------

      E_Named_Integer,
      --  Named numbers created by a number declaration with an integer value

      E_Named_Real,
      --  Named numbers created by a number declaration with a real value

      -----------------------
      -- Enumeration Types --
      -----------------------

      E_Enumeration_Type,
      --  Enumeration types, created by an enumeration type declaration

      E_Enumeration_Subtype,
      --  Enumeration subtypes, created by an explicit or implicit subtype
      --  declaration applied to an enumeration type or subtype.

      -------------------
      -- Numeric Types --
      -------------------

      E_Signed_Integer_Type,
      --  Signed integer type, used for the anonymous base type of the
      --  integer subtype created by an integer type declaration.

      E_Signed_Integer_Subtype,
      --  Signed integer subtype, created by either an integer subtype or
      --  integer type declaration (in the latter case an integer type is
      --  created for the base type, and this is the first named subtype).

      E_Modular_Integer_Type,
      --  Modular integer type, used for the anonymous base type of the
      --  integer subtype created by a modular integer type declaration.

      E_Modular_Integer_Subtype,
      --  Modular integer subtype, created by either an modular subtype
      --  or modular type declaration (in the latter case a modular type
      --  is created for the base type, and this is the first named subtype).

      E_Ordinary_Fixed_Point_Type,
      --  Ordinary fixed type, used for the anonymous base type of the
      --  fixed subtype created by an ordinary fixed point type declaration.

      E_Ordinary_Fixed_Point_Subtype,
      --  Ordinary fixed point subtype, created by either an ordinary fixed
      --  point subtype or ordinary fixed point type declaration (in the
      --  latter case a fixed point type is created for the base type, and
      --  this is the first named subtype).

      E_Decimal_Fixed_Point_Type,
      --  Decimal fixed type, used for the anonymous base type of the decimal
      --  fixed subtype created by an ordinary fixed point type declaration.

      E_Decimal_Fixed_Point_Subtype,
      --  Decimal fixed point subtype, created by either a decimal fixed point
      --  subtype or decimal fixed point type declaration (in the latter case
      --  a fixed point type is created for the base type, and this is the
      --  first named subtype).

      E_Floating_Point_Type,
      --  Floating point type, used for the anonymous base type of the
      --  floating point subtype created by a floating point type declaration.

      E_Floating_Point_Subtype,
      --  Floating point subtype, created by either a floating point subtype
      --  or floating point type declaration (in the latter case a floating
      --  point type is created for the base type, and this is the first
      --  named subtype).

      ------------------
      -- Access types --
      ------------------

      E_Access_Type,
      --  An access type created by an access type declaration with no all
      --  keyword present. Note that the predefined type Any_Access, which
      --  has E_Access_Type Ekind, is used to label NULL in the upwards pass
      --  of type analysis, to be replaced by the true access type in the
      --  downwards resolution pass.

      E_Access_Subtype,
      --  An access subtype created by a subtype declaration for any access
      --  type (whether or not it is a general access type).

      E_Allocator_Type,
      --  A special internal type used to label allocators and attribute
      --  references using 'Access. This is needed because special resolution
      --  rules apply to these constructs. On the resolution pass, this type
      --  is always replaced by the actual access type, so Gigi should never
      --  see types with this Ekind.

      E_General_Access_Type,
      --  An access type created by an access type declaration with the all
      --  keyword present.

      E_Access_Subprogram_Type,
      --  An access to subprogram type, created by an access to subprogram
      --  declaration.

      E_Anonymous_Access_Type,
      --  An anonymous access type created by an access parameter or access
      --  discriminant (i.e. by an anonymous access type definition).

      ---------------------
      -- Composite types --
      ---------------------

      E_Array_Type,
      --  An array type created by an array type declaration. Includes all
      --  cases of arrays, except for string types.

      E_Array_Subtype,
      --  An array subtype, created by an explicit array subtype declaration,
      --  or the use of an anonymous array subtype.

      E_String_Type,
      --  A string type, i.e. an array type whose component type is a character
      --  type, and for which string literals can thus be written.

      E_String_Subtype,
      --  A string subtype, created by an explicit subtype declaration for a
      --  string type, or the use of an anonymous subtype of a string type,

      E_String_Literal_Subtype,
      --  A special string subtype, used only to describe the type of a string
      --  literal (will always be one dimensional, with literal bounds).

      E_Enum_Table_Type,
      --  A special type used to describe the table built for an enumeration
      --  type containing the literal strings. This is a one dimensional
      --  array whose index type is the enumeration type in question, and
      --  whose component type is access to string. The actual string values
      --  for the table are filled in by Gigi.

      E_Slice_Subtype,
      --  An implicit one dimensional array subtype, used to describe the
      --  result of a slice. Its bounds are the bounds of the slice.

      E_Class_Wide_Type,
      --  A class wide type, created by any tagged type declaration (i.e. if
      --  a tagged type is declared, the corresponding class type is always
      --  created, using this Ekind value).

      E_Class_Wide_Subtype,
      --  A subtype of a class wide type, created by a subtype declaration
      --  used to declare a subtype of a class type.

      E_Record_Type,
      --  A record type, created by a record type declaration

      E_Record_Subtype,
      --  A record subtype, created by a record subtype declaration.

      E_Record_Type_With_Private,
      --  Used for types defined by a private extension declaration. Includes
      --  the fields for both private types and for record types (with the
      --  sole exception of Corresponding_Concurrent_Type which is obviously
      --  not needed). This entity is considered to be both a record type and
      --  a private type.

      E_Record_Subtype_With_Private,
      --  A subtype of a type defined by a private extension declaration.

      E_Private_Type,
      --  A private type, created by a private type declaration that does
      --  not have the keyword limited.

      E_Private_Subtype,
      --  A subtype of a private type, created by a subtype declaration used
      --  to declare a subtype of a private type.

      E_Limited_Private_Type,
      --  A limited private type, created by a private type declaration that
      --  has the keyword limited.

      E_Limited_Private_Subtype,
      --  A subtype of a limited private type, created by a subtype declaration
      --  used to declare a subtype of a limited private type.

      E_Limited_Type,
      --  A limited type, ???

      E_Incomplete_Type,
      --  An incomplete type, created by an incomplete type declaration

      E_Task_Type,
      --  A task type, created by a task type declaration. An entity with this
      --  Ekind is also created to describe the anonymous type of a task that
      --  is created by a single task declaration.

      E_Task_Subtype,
      --  A subtype of a task type, created by a subtype declaration used to
      --  declare a subtype of a task type.

      E_Protected_Type,
      --  A protected type, created by a protected type declaration. An entity
      --  with this Ekind is also created to describe the anonymous type of
      --  a protected object created by a single protected declaration.

      E_Protected_Subtype,
      --  A subtype of a protected type, created by a subtype declaration used
      --  to declare a subtype of a protected type.

      -----------------
      -- Other types --
      -----------------

      E_Exception_Type,
      --  The type of an exception created by an exception declaration

      E_Subprogram_Type,
      --  ??? what is this used for?

      ---------------------------
      -- Overloadable entities --
      ---------------------------

      E_Enumeration_Literal,
      --  An enumeration literal, created by the use of the literal in an
      --  enumeration type definition.

      E_Function,
      --  A function, created by a function declaration or a function body
      --  that acts as its own declaration.

      E_Operator,
      --  A predefined operator, appearing in Standard, or an implicitly
      --  defined concatenation operator created whenever an array is
      --  declared. We do not make normal derived operators explicit in
      --  the tree, but the concatenation operators are made explicit.

      E_Procedure,
      --  A procedure, created by a procedure declaration or a procedure
      --  body that acts as its own declaration.

      E_Entry,
      --  An entry, created by an entry declaration in a task or protected
      --  object.

      ------------------------
      -- Parameter entities --
      ------------------------

      E_In_Parameter,
      --  An in parameter of a subprogram or entry

      E_Out_Parameter,
      --  An out parameter of a subprogram or entry

      E_In_Out_Parameter,
      --  An in-out parameter of a subprogram or entry

      --------------------
      -- Other entities --
      --------------------

      E_Block,
      --  A block identifier, created by an explicit or implicit label on
      --  a block or declare statement.

      E_Discriminant,
      --  A discriminant, created by the use of a discriminant in a type
      --  declaration.

      E_Entry_Family,
      --  An entry family, created by an entry family declaration in a
      --  task or protected type definition.

      E_Exception,
      --  An exception created by an exception declaration. The exception
      --  itself uses E_Exception for the Ekind, the implicit type that is
      --  created to represent its type uses the Ekind E_Exception_Type.

      E_Generic_Function,
      --  A generic function. This is the entity for a generic function
      --  created by a generic subprogram declaration.

      E_Generic_In_Out_Parameter,
      --  A generic in out parameter, created by the use of a generic in out
      --  parameter in a generic declaration.

      E_Generic_In_Parameter,
      --  A generic in parameter, created by the use of a generic in
      --  parameter in a generic declaration.

      E_Generic_Package,
      --  A generic package, this is the entity for a generic package created
      --  by a generic package declaration.

      E_Generic_Procedure,
      --  A generic function. This is the entity for a generic procedure
      --  created by a generic subprogram declaration.

      E_Label,
      --  The defining entity for a label. Note that this is created by the
      --  implicit label declaration, not the occurrence of the label itself,
      --  which is simply a direct name referring to the label.

      E_Loop,
      --  A loop identifier, created by an explicit or implicit label on a
      --  loop statement.

      E_Loop_Parameter,
      --  A loop parameter created by a for loop

      E_Package,
      --  A package, created by a package declaration

      E_Package_Body,
      --  A package body. This entity serves almost no function, since all
      --  semantic analysis uses the package entity (E_Package).

      E_Protected_Body,
      --  A protected body. This entity serves almost no function, since all
      --  semantic analysis uses the protected entity (E_Protected_Type)

      E_Protected_Object,
      --  A protected object, created by an object declaration that declares
      --  an object of a protected type.

      E_Task_Body,
      --  A task body. This entity serves almost no function, since all
      --  semantic analysis uses the protected entity (E_Task_Type).

      E_Subprogram_Body
      --  A subprogram body. Used when a subprogram has a separate declaration
      --  to represent the entity for the body. This entity serves almost no
      --  function, since all semantic analysis uses the subprogram entity
      --  for the declaration (E_Function or E_Procedure).
   );

   --------------------------
   -- Subtype Declarations --
   --------------------------

   --  The above entities are arranged so that they can be conveniently
   --  grouped into subtype ranges. Note that for each of the xxx_KInd
   --  ranges defined below, there is a corresponding Is_xxx.. predicate
   --  which is to be used in preference to direct range tests using the
   --  subtype name. However, the subtype names are available for direct
   --  use, e.g. as choices in case statements.

   subtype Access_Kind                 is Entity_Kind range
       E_Access_Type ..
   --  E_Access_Subtype
   --  E_Allocator_Type
   --  E_General_Access_Type
   --  E_Access_Subprogram_Type
       E_Anonymous_Access_Type;

   subtype Array_Kind                  is Entity_Kind range
       E_Array_Type ..
   --  E_Array_Subtype
   --  E_String_Type
   --  E_String_Subtype
   --  E_String_Literal_Subtype
       E_Slice_Subtype;

   subtype Class_Wide_Kind             is Entity_Kind range
       E_Class_Wide_Type ..
       E_Class_Wide_Subtype;

   subtype Composite_Kind              is Entity_Kind range
       E_Array_Type ..
   --  E_Array_Subtype
   --  E_String_Type
   --  E_String_Subtype
   --  E_String_Literal_Subtype
   --  E_Slice_Subtype
   --  E_Class_Wide_Type
   --  E_Class_Wide_Subtype
   --  E_Record_Type
   --  E_Record_Subtype
   --  E_Record_Type_With_Private
   --  E_Record_Subtype_With_Private
   --  E_Private_Type
   --  E_Private_Subtype
   --  E_Limited_Private_Type
   --  E_Limited_Private_Subtype
   --  E_Limited_Type
   --  E_Incomplete_Type
   --  E_Task_Type
   --  E_Task_Subtype,
   --  E_Protected_Type,
       E_Protected_Subtype;

   subtype Concurrent_Kind             is Entity_Kind range
       E_Task_Type ..
   --  E_Task_Subtype,
   --  E_Protected_Type,
       E_Protected_Subtype;

   subtype Decimal_Fixed_Point_Kind    is Entity_Kind range
       E_Decimal_Fixed_Point_Type ..
       E_Decimal_Fixed_Point_Subtype;

   subtype Digits_Kind                 is Entity_Kind range
       E_Decimal_Fixed_Point_Type ..
   --  E_Decimal_Fixed_Point_Subtype
   --  E_Floating_Point_Type
       E_Floating_Point_Subtype;

   subtype Discrete_Kind               is Entity_Kind range
       E_Enumeration_Type ..
   --  E_Enumeration_Subtype
   --  E_Signed_Integer_Type
   --  E_Signed_Integer_Subtype
   --  E_Modular_Integer_Type
       E_Modular_Integer_Subtype;

   subtype Elementary_Kind             is Entity_Kind range
       E_Enumeration_Type ..
   --  E_Enumeration_Subtype
   --  E_Signed_Integer_Type
   --  E_Signed_Integer_Subtype
   --  E_Modular_Integer_Type
   --  E_Modular_Integer_Subtype
   --  E_Ordinary_Fixed_Point_Type
   --  E_Ordinary_Fixed_Point_Subtype
   --  E_Decimal_Fixed_Point_Type
   --  E_Decimal_Fixed_Point_Subtype
   --  E_Floating_Point_Type
   --  E_Floating_Point_Subtype
   --  E_Access_Type
   --  E_Access_Subtype
   --  E_Allocator_Type
   --  E_General_Access_Type
   --  E_Access_Subprogram_Type
       E_Anonymous_Access_Type;

   subtype Enumeration_Kind            is Entity_Kind range
       E_Enumeration_Type ..
       E_Enumeration_Subtype;

   subtype Fixed_Point_Kind            is Entity_Kind range
       E_Ordinary_Fixed_Point_Type ..
   --  E_Ordinary_Fixed_Point_Subtype
   --  E_Decimal_Fixed_Point_Type
       E_Decimal_Fixed_Point_Subtype;

   subtype Float_Kind                  is Entity_Kind range
       E_Floating_Point_Type ..
       E_Floating_Point_Subtype;

   subtype Formal_Kind                 is Entity_Kind range
       E_In_Parameter ..
   --  E_Out_Parameter
       E_In_Out_Parameter;

   subtype Incomplete_Or_Private_Kind  is Entity_Kind range
       E_Record_Type_With_Private ..
   --  E_Record_Subtype_With_Private
   --  E_Private_Type
   --  E_Private_Subtype
   --  E_Limited_Private_Type
   --  E_Limited_Private_Subtype
   --  E_Limited_Type
       E_Incomplete_Type;

   subtype Integer_Kind                is Entity_Kind range
       E_Signed_Integer_Type ..
   --  E_Signed_Integer_Subtype
   --  E_Modular_Integer_Type
       E_Modular_Integer_Subtype;

   subtype Modular_Integer_Kind        is Entity_Kind range
       E_Modular_Integer_Type ..
       E_Modular_Integer_Subtype;

   subtype Named_Kind                  is Entity_Kind range
       E_Named_Integer ..
       E_Named_Real;

   subtype Numeric_Kind                is Entity_Kind range
       E_Signed_Integer_Type ..
   --  E_Signed_Integer_Subtype
   --  E_Modular_Integer_Type
   --  E_Modular_Integer_Subtype
   --  E_Ordinary_Fixed_Point_Type
   --  E_Ordinary_Fixed_Point_Subtype
   --  E_Decimal_Fixed_Point_Type
   --  E_Decimal_Fixed_Point_Subtype
   --  E_Floating_Point_Type
       E_Floating_Point_Subtype;

   subtype Ordinary_Fixed_Point_Kind   is Entity_Kind range
       E_Ordinary_Fixed_Point_Type ..
       E_Ordinary_Fixed_Point_Subtype;

   subtype Overloadable_Kind           is Entity_Kind range
       E_Enumeration_Literal ..
   --  E_Function
   --  E_Procedure
       E_Entry;

   subtype Private_Kind                is Entity_Kind range
       E_Record_Type_With_Private ..
   --  E_Record_Subtype_With_Private
   --  E_Private_Type
   --  E_Private_Subtype
   --  E_Limited_Private_Type
       E_Limited_Private_Subtype;

   subtype Protected_Kind              is Entity_Kind range
       E_Protected_Type ..
       E_Protected_Subtype;

   subtype Real_Kind                   is Entity_Kind range
       E_Ordinary_Fixed_Point_Type ..
   --  E_Ordinary_Fixed_Point_Subtype
   --  E_Decimal_Fixed_Point_Type
   --  E_Decimal_Fixed_Point_Subtype
   --  E_Floating_Point_Type
       E_Floating_Point_Subtype;

   subtype Record_Kind                 is Entity_Kind range
       E_Class_Wide_Type ..
   --  E_Class_Wide_Subtype
   --  E_Record_Type
   --  E_Record_Subtype
   --  E_Record_Type_With_Private
       E_Record_Subtype_With_Private;

   subtype Scalar_Kind                 is Entity_Kind range
       E_Enumeration_Type ..
   --  E_Enumeration_Subtype
   --  E_Signed_Integer_Type
   --  E_Signed_Integer_Subtype
   --  E_Modular_Integer_Type
   --  E_Modular_Integer_Subtype
   --  E_Ordinary_Fixed_Point_Type
   --  E_Ordinary_Fixed_Point_Subtype
   --  E_Decimal_Fixed_Point_Type
   --  E_Decimal_Fixed_Point_Subtype
   --  E_Floating_Point_Type
       E_Floating_Point_Subtype;

   subtype String_Kind                 is Entity_Kind range
       E_String_Type ..
   --  E_String_Subtype
       E_String_Literal_Subtype;

   subtype Subprogram_Kind             is Entity_Kind range
       E_Function ..
       E_Procedure;

   subtype Signed_Integer_Kind         is Entity_Kind range
       E_Signed_Integer_Type ..
       E_Signed_Integer_Subtype;

   subtype Task_Kind                   is Entity_Kind range
       E_Task_Type ..
       E_Task_Subtype;

   subtype Type_Kind                   is Entity_Kind range
       E_Enumeration_Type ..
   --  E_Enumeration_Subtype
   --  E_Signed_Integer_Type
   --  E_Signed_Integer_Subtype
   --  E_Modular_Integer_Type
   --  E_Modular_Integer_Subtype
   --  E_Ordinary_Fixed_Point_Type
   --  E_Ordinary_Fixed_Point_Subtype
   --  E_Decimal_Fixed_Point_Type
   --  E_Decimal_Fixed_Point_Subtype
   --  E_Floating_Point_Type
   --  E_Floating_Point_Subtype
   --  E_Access_Type
   --  E_Access_Subprogram_Type,
   --  E_Allocator_Type,
   --  E_General_Access_Type
   --  E_Anonymous_Access_Type
   --  E_Array_Type
   --  E_Array_Subtype
   --  E_Class_Wide_Subtype
   --  E_Class_Wide_Type
   --  E_Record_Type
   --  E_Record_Subtype
   --  E_Record_Type_With_Private
   --  E_Record_Subtype_With_Private
   --  E_Private_Type
   --  E_Private_Subtype
   --  E_Limited_Private_Type
   --  E_Limited_Private_Subtype
   --  E_Limited_Type
   --  E_Incomplete_Type
   --  E_Task_Type
   --  E_Task_Subtype
   --  E_Protected_Type
   --  E_Protected_Subtype
   --  E_Exception_Type
       E_Subprogram_Type;

   --------------------------------------------------------------
   -- Description of Defined Access Functions for Entity_Kinds --
   --------------------------------------------------------------

   --  For each enumeration value defined in Entity_Kind we list all the
   --  attributes defined in Einfo which can legallybe applied to an entity
   --  of that kind. The implementation of the attribute functions (and for
   --  non-synthesized attributes, or the corresponding set procedures) are
   --  in the Einfo body.

   --  The following attributes apply to all entities

   --    Ekind                         (Ekind)

   --    Chars                         (Name1)
   --    Next_Entity                   (Node2)
   --    Scope                         (Node3)
   --    Homonym                       (Node4)
   --    Etype                         (Node5)

   --    Is_Immediately_Visible        (Flag7)
   --    Is_Potentially_Use_Visible    (Flag9)
   --    Is_Public                     (Flag10)
   --    Is_Internal                   (Flag17)
   --    Is_Delayed                    (Flag18)
   --    Is_Imported                   (Flag24)
   --    Suppress_Access_Checks        (Flag31)
   --    Suppress_Accessibility_Checks (Flag32)
   --    Suppress_Discriminant_Checks  (Flag33)
   --    Suppress_Division_Checks      (Flag34)
   --    Suppress_Elaboration_Checks   (Flag35)
   --    Suppress_Index_Checks         (Flag36)
   --    Suppress_Length_Checks        (Flag37)
   --    Suppress_Overflow_Checks      (Flag38)
   --    Suppress_Range_Checks         (Flag39)
   --    Suppress_Storage_Checks       (Flag40)
   --    Suppress_Tag_Checks           (Flag41)
   --    Is_Pure                       (Flag44)
   --    Has_Homonym                   (Flag56)
   --    Is_Private                    (Flag57)

   --    Declaration_Node              (synth)
   --    Next_Overloads                (synth)
   --    Is_xxx_Type                   (synth)
   --    Is_Type                       (synth)

   --  The following list of access functions applies to all entities for
   --  types and subtypes. References to this list appear subsequently as
   --  as "(plus type attributes)" for each appropriate Entity_Kind.

   --    Alignment_Clause              (Node8)
   --    Esize                         (Uint12)
   --    Next_Itype                    (Node16)
   --    Class_Wide_Type               (Node17)
   --    Init_Proc                     (Node18)

   --    Is_Generic_Type               (Flag1)
   --    Is_Frozen                     (Flag4)
   --    Is_Volatile                   (Flag16)
   --    Is_Internal                   (Flag17)
   --    Is_Abstract                   (Flag19)
   --    Has_Size_Clause               (Flag29)
   --    Is_Controlled                 (Flag42)
   --    Is_Packed                     (Flag51)
   --    Is_Tagged_Type                (Flag55)
   --    Has_Alignment_Clause          (Flag46)

   --    Base_Type                     (synth)
   --    Is_First_Named_Subtype        (synth)
   --    Is_Limited_Type               (synth)
   --    Root_Type                     (synth)
   --    Next_Index                    (synth)
   --    Underlying_Type               (synth)

   --  Applicable attributes by entity kind

   --  E_Access_Subprogram_Type
   --    Directly_Designated_Type      (Node10)
   --    Needs_No_Actuals (Flag22)
   --    (plus type attributes)

   --  E_Access_Type
   --  E_Access_Subtype
   --    Master_Id                     (Node9)
   --    Directly_Designated_Type      (Node10)
   --    Associated_Storage_Pool       (Node13)
   --    Storage_Size_Variable         (Node14)
   --    Has_Storage_Size_Clause       (Flag23)   (type only, not subtype)
   --    Is_Access_Constant            (Flag69)
   --    (plus type attributes)

   --  E_Allocator_Type
   --    Directly_Designated_Type      (Node10)
   --    (plus type attributes)

   --  E_Anonymous_Access_Type
   --    Directly_Designated_Type      (Node10)
   --    Associated_Storage_Pool       (Node13)
   --    Storage_Size_Variable         (Node14)
   --    (plus type attributes)

   --  E_Array_Type
   --  E_Array_Subtype
   --    First_Index                   (Node9)
   --    Component_Type                (Node10)
   --    Component_Size_Clause         (Node13)   (type only, not subtype)
   --    Controlled_Component_Iterator (Node14)
   --    Is_Constrained                (Flag3)
   --    Is_Aliased                    (Flag15)
   --    Has_Tasks                     (Flag30)
   --    Has_Controlled                (Flag43)
   --    Has_Component_Size_Clause     (Flag68)   (type only, not subtype)
   --    Number_Dimensions             (synth)
   --    (plus type attributes)

   --  E_Block
   --    First_Entity                  (Node9)
   --    Last_Entity                   (Node10)
   --    Finalization_Chain_Entity     (Node13)
   --    Task_Activation_Chain_Entity  (Node14)
   --    Has_Master_Entity             (Flag21)

   --  E_Class_Wide_Type
   --  E_Class_Wide_Subtype
   --    Equivalent_Type               (Node7)
   --    First_Entity                  (Node9)
   --    Last_Entity                   (Node10)
   --    Controlled_Component_Iterator (Node14)
   --    Has_Controlled                (Flag43)
   --    Has_Tasks                     (Flag30)
   --    First_Component               (synth)
   --    (plus type attributes)

   --  E_Component
   --    Component_Clause              (Node7)                     (
   --    Original_Record_Component     (Node8)
   --    Discriminant_Checking_Func    (Node10)
   --    Component_First_Bit           (Uint11)
   --    Esize                         (Uint12)
   --    Is_Volatile                   (Flag16)
   --    Needs_Discr_Check             (Flag50)
   --    Next_Component                (synth)
   --    Is_Protected_Private          (synth)
   --    Prival                        (Node9)
   --    Protected_Subprogram          (Node14)

   --  E_Constant
   --    Renamed_Object                (Node7)
   --    Alignment_Clause              (Node8)
   --    Full_View                     (Node11)
   --    should it be called Full_Declaration in this context???
   --    Esize                         (Uint12)
   --    Is_Volatile                   (Flag16)
   --    Has_Address_Clause            (Flag28)
   --    Has_Size_Clause               (Flag29)
   --    Has_Alignment_Clause          (Flag46)

   --  E_Decimal_Fixed_Point_Type
   --  E_Decimal_Fixed_Subype
   --    Small_Value                   (Ureal6)
   --    Delta_Value                   (Ureal7)
   --    Digits_Value                  (Uint9)
   --    Scalar_Range                  (Node10)
   --    Parent_Subtype                (Node11)
   --    Corresponding_Integer_Type    (Node13)
   --    Type_Low_Bound                (synth)
   --    Type_High_Bound               (synth)
   --    (plus type attributes)

   --  E_Discriminant
   --    Corresponding_Discriminant    (Node7)
   --    Discriminal                   (Node9)
   --    Discriminant_Default_Value    (Node10)
   --    Component_First_Bit           (Uint11)
   --    Next_Discriminant             (synth)

   --  E_Entry
   --  E_Entry_Family
   --    Accept_Address                (Elist6)
   --    Entry_Parameters_Type         (Node7)
   --    First_Entity                  (Node9)
   --    Last_Entity                   (Node10)
   --    Entry_Index_Value             (Uint12)   (entry only, not family)
   --    Finalization_Chain_Entity     (Node13)
   --    Task_Activation_Chain_Entity  (Node14)
   --    Needs_No_Actuals              (Flag22)
   --    First_Formal                  (synth)
   --    Entry_Index_Type              (synth)

   --  E_Enumeration_Literal
   --    Alias                         (Node7)
   --    Enumeration_Rep_Expr          (Node8)
   --    Enumeration_Pos               (Uint11)
   --    Enumeration_Rep               (Uint12)
   --    Next_Literal

   --  E_Enumeration_Type
   --  E_Enumeration_Subtype
   --    Lit_Name_Table                (Node7)
   --    First_Literal                 (Node9)
   --    Scalar_Range                  (Node10)
   --    Parent_Subtype                (Node11)
   --    Corresponding_Integer_Type    (Node13)
   --    Enum_Pos_To_Rep               (Node14)   (type only, not subtype)
   --    Enum_Rep_To_Pos               (Node15)   (type only, not subtype)
   --    Has_Enumeration_Rep_Clause    (Flag66)
   --    Type_Low_Bound                (synth)
   --    Type_High_Bound               (synth)
   --    (plus type attributes)

   --  E_Enum_Table_Type
   --    Component_Type                (Node10)
   --    Table_High_Bound              (Node11)

   --  E_Exception
   --  E_Exception_Type
   --    (no additional fields)

   --  E_Floating_Point_Type
   --  E_Floating_Point_Subtype
   --    Digits_Value                  (Uint9)
   --    Scalar_Range                  (Node10)
   --    Parent_Subtype                (Node11)
   --    Type_Low_Bound                (synth)
   --    Type_High_Bound               (synth)
   --    (plus type attributes)

   --  E_Function
   --  E_Generic_Function
   --    Alias                         (Node7)
   --    First_Entity                  (Node9)
   --    Last_Entity                   (Node10)
   --    Corresponding_Unprotected     (Node11)
   --    Interface_Name                (Node12)
   --    Finalization_Chain_Entity     (Node13)
   --    Task_Activation_Chain_Entity  (Node14)
   --    Is_Dispatching_Operation      (Flag6)
   --    Is_Inlined                    (Flag11)
   --    Is_Abstract                   (Flag19)
   --    Has_Master_Entity             (Flag21)
   --    Needs_No_Actuals              (Flag22)
   --    Has_Completion                (Flag26)
   --    Has_Convention_Intrinsic      (Flag27)
   --    Has_Address_Clause            (Flag28)
   --    Is_Pure                       (Flag44)
   --    Is_Private_Descendant         (Flag53)
   --    Return_Present                (Flag54)
   --    Is_Intrinsic_Subprogram       (Flag64)
   --    Has_Convention_Intrinsic      (Flag70)
   --    First_Formal                  (synth)

   --  E_General_Access_Type
   --    Master_Id                     (Node9)
   --    Directly_Designated_Type      (Node10)
   --    Associated_Storage_Pool       (Node13)
   --    Storage_Size_Variable         (Node14)
   --    (plus type attributes)

   --  E_Incomplete_Type
   --    Full_View                     (Node11)
   --    Discriminant_Constraint       (Elist6)
   --    Has_Discriminants             (Flag5)
   --    First_Discriminant            (synth)
   --    (plus type attributes)

   --  E_In_Parameter
   --  E_Generic_In_Parameter
   --    Protected_Formal              (Node8)
   --    Default_Value                 (Node10)
   --    Entry_Component               (Node11)
   --    Is_Entry_Formal               (Flag52)
   --    Parameter_Mode                (synth)

   --  E_In_Out_Parameter
   --  E_Generic_In_Out_Parameter
   --    Protected_Formal              (Node8)
   --    Entry_Component               (Node11)
   --    Is_Entry_Formal               (Flag52)
   --    Parameter_Mode                (synth)

   --  E_Label
   --    Reachable                     (Flag49)

   --  E_Limited_Private_Type
   --  E_Limited_Private_Subtype
   --    Private_Subtype_List          (Node7)
   --    Full_View                     (Node11)
   --    Discriminant_Constraint       (Elist6)
   --    Has_Discriminants             (Flag5)
   --    Has_Completion                (Flag26)
   --    Has_Completion_In_Body        (Flag71)
   --    First_Discriminant            (synth)
   --    (plus type attributes)

   --  E_Limited_Type

   --  E_Loop
   --    Has_Master_Entity             (Flag21)
   --    Has_Exit                      (Flag47)

   --  E_Modular_Integer_Type
   --  E_Modular_Integer_Subtype
   --    Modulus                       (Uint9)
   --    Scalar_Range                  (Node10)
   --    Parent_Subtype                (Node11)
   --    Non_Binary_Modulus            (Flag58)
   --    Type_Low_Bound                (synth)
   --    Type_High_Bound               (synth)
   --    (plus type attributes)

   --  E_Named_Integer
   --    (no additional fields)

   --  E_Named_Real
   --    (no additional fields)

   --  E_Operator
   --    First_Entity                  (Node9)
   --    Last_Entity                   (Node10)
   --    Has_Convention_Intrinsic      (Flag27)
   --    Is_Pure                       (Flag44)
   --    Is_Intrinsic_Subprogram       (Flag64)
   --    Has_Convention_Intrinsic      (Flag70)

   --  E_Ordinary_Fixed_Point_Type
   --  E_Ordinary_Fixed_Point_Subtype
   --    Small_Value                   (Ureal6)
   --    Delta_Value                   (Ureal7)
   --    Scalar_Range                  (Node10)
   --    Parent_Subtype                (Node11)
   --    Corresponding_Integer_Type    (Node13)
   --    Has_Small_Clause              (Flag67)
   --    Type_Low_Bound                (synth)
   --    Type_High_Bound               (synth)
   --    (plus type attributes)

   --  E_Out_Parameter
   --    Protected_Formal              (Node8)
   --    Entry_Component               (Node11)
   --    Is_Entry_Formal               (Flag52)
   --    Parameter_Mode                (synth)

   --  E_Package
   --  E_Generic_Package
   --    First_Entity                  (Node9)
   --    Last_Entity                   (Node10)
   --    First_Private_Entity          (Node11)
   --    Task_Activation_Chain_Entity  (Node14)
   --    In_Use                        (Flag8)
   --    Has_Master_Entity             (Flag21)
   --    Has_Completion                (Flag26)
   --    In_Private_Part               (Flag45)
   --    In_Package_Body               (Flag48)
   --    Is_Private_Descendant         (Flag53)
   --    Is_Preelaborated              (Flag59)
   --    Is_Shared_Passive             (Flag60)
   --    Is_Remote_Types               (Flag61)
   --    Is_Remote_Call_Interface      (Flag62)

   --  E_Package_Body
   --    (no additional fields)

   --  E_Private_Type
   --  E_Private_Subtype
   --    Discriminant_Constraint       (Elist6)
   --    Private_Subtype_List          (Node7)
   --    Full_View                     (Node11)
   --    Primitive_Operations          (Elist13)
   --    Controlled_Component_Iterator (Node14)
   --    Has_Discriminants             (Flag5)
   --    Has_Completion                (Flag26)
   --    Has_Completion_In_Body        (Flag71)
   --    Is_Controlled                 (Flag42)
   --    First_Discriminant            (synth)
   --    (plus type attributes)

   --  E_Procedure
   --  E_Generic_Procedure
   --    Alias                         (Node7)
   --    First_Entity                  (Node9)
   --    Last_Entity                   (Node10)
   --    Corresponding_Unprotected     (Node11)
   --    Interface_Name                (Node12)
   --    Finalization_Chain_Entity     (Node13)
   --    Task_Activation_Chain_Entity  (Node14)
   --    Is_Dispatching_Operation      (Flag6)
   --    Is_Inlined                    (Flag11)
   --    Is_Abstract                   (Flag19)
   --    Has_Master_Entity             (Flag21)
   --    Needs_No_Actuals              (Flag22)
   --    Has_Completion                (Flag26)
   --    Has_Convention_Intrinsic      (Flag27)
   --    Has_Address_Clause            (Flag28)
   --    Is_Pure                       (Flag44)
   --    Is_Private_Descendant         (Flag53)
   --    Is_Intrinsic_Subprogram       (Flag64)
   --    Has_Convention_Intrinsic      (Flag70)
   --    First_Formal                  (synth)

   --  E_Protected_Body
   --    (no additional fields)

   --  E_Protected_Object

   --  E_Protected_Type
   --  E_Protected_Subtype
   --    Corresponding_Record_Type     (Node7)
   --    First_Entity                  (Node9)
   --    Last_Entity                   (Node10)
   --    First_Private_Entity          (Node11)
   --    Controlled_Component_Iterator (Node14)
   --    Discriminant_Constraint       (Elist6)
   --    Has_Discriminants             (Flag5)
   --    Has_Controlled                (Flag43)
   --    Number_Simple_Entries         (Uint15)

   --  E_Record_Type
   --  E_Record_Subtype
   --    Discriminant_Constraint       (Elist6)
   --    Corresponding_Concurrent_Type (Node7)
   --    First_Entity                  (Node9)
   --    Last_Entity                   (Node10)
   --    Primitive_Operations          (Elist13)
   --    Controlled_Component_Iterator (Node14)
   --    Access_Disp_Table             (Node15)
   --    Is_Constrained                (Flag3)
   --    Has_Discriminants             (Flag5)
   --    Is_Concurrent_Record_Type     (Flag20)
   --    Is_Limited_Record             (Flag25)
   --    Has_Tasks                     (Flag30)
   --    Is_Controlled                 (Flag42)
   --    Has_Controlled                (Flag43)
   --    Has_Record_Rep_Clause         (Flag65)
   --    First_Component               (synth)
   --    First_Discriminant            (synth)
   --    Tag_Component                 (synth)
   --    (plus type attributes)

   --  E_Record_Type_With_Private
   --  E_Record_Subtype_With_Private
   --    Discriminant_Constraint       (Elist6)
   --    Private_Subtype_List          (Node7)
   --    First_Entity                  (Node9)
   --    Last_Entity                   (Node10)
   --    Full_View                     (Node11)
   --    Primitive_Operations          (Elist13)
   --    Controlled_Component_Iterator (Node14)
   --    Access_Disp_Table             (Node15)
   --    Is_Constrained                (Flag3)
   --    Has_Discriminants             (Flag5)
   --    Is_Concurrent_Record_Type     (Flag20)
   --    Has_Completion                (Flag26)
   --    Has_Tasks                     (Flag30)
   --    Is_Controlled                 (Flag42)
   --    Has_Controlled                (Flag43)
   --    Has_Record_Rep_Clause         (Flag65)
   --    Has_Completion_In_Body        (Flag71)
   --    First_Component               (synth)
   --    First_Discriminant            (synth)
   --    Tag_Component                 (synth)
   --    (plus type attributes)

   --  E_Signed_Integer_Type
   --  E_Signed_Integer_Subtype
   --    Scalar_Range                  (Node10)
   --    Parent_Subtype                (Node11)
   --    Type_Low_Bound                (synth)
   --    Type_High_Bound               (synth)
   --    (plus type attributes)

   --  E_Slice_Subtype
   --    Component_Type                (Node10)
   --    Slice_Range                   (Node11)
   --    (plus type attributes)

   --  E_String_Type
   --  E_String_Subtype
   --    First_Index                   (Node9)
   --    Component_Type                (Node10)
   --    Is_Constrained                (Flag3)
   --    Number_Dimensions             (synth)
   --    (plus type attributes)

   --  E_String_Literal_Subtype
   --    Component_Type                (Node10)
   --    String_Literal_Length         (Uint11)
   --    (plus type attributes)

   --  E_Subprogram_Body
   --    (no additional fields)

   --  E_Subprogram_Type
   --    Directly_Designated_Type      (Node10)
   --    First_Formal                  (synth)
   --    (plus type attributes)

   --  E_Task_Body
   --    (no additional fields)

   --  E_Task_Type
   --  E_Task_Subtype
   --    Discriminant_Constraint       (Elist6)
   --    Corresponding_Record_Type     (Node7)
   --    First_Entity                  (Node9)
   --    Last_Entity                   (Node10)
   --    First_Private_Entity          (Node11)
   --    Finalization_Chain_Entity     (Node13)
   --    Task_Activation_Chain_Entity  (Node14)
   --    Number_Simple_Entries         (Uint15)
   --    Has_Discriminants             (Flag5)
   --    Has_Master_Entity             (Flag21)
   --    Has_Storage_Size_Clause       (Flag23)   (type only, not subtype)
   --    (plus type attributes)

   --  E_Variable
   --    Renamed_Object                (Node7)
   --    Alignment_Clause              (Node8)
   --    Esize                         (Uint12)
   --    Is_Volatile                   (Flag16)
   --    Has_Address_Clause            (Flag28)
   --    Has_Size_Clause               (Flag29)
   --    Has_Alignment_Clause          (Flag46)

   --  E_Void
   --    Since E_Void is the initial Ekind value of an entity when it is first
   --    created, one might expect that no attributes would be defined on such
   --    an entity until its Ekind field is set. However, in practice, there
   --    are many instances in which fields of an E_Void entity are set in the
   --    code prior to setting the Ekind field. This is not well documented or
   --    well controlled, and needs cleaning up later. Meanwhile, the access
   --    procedures in the body of Einfo permit many, but not all, attributes
   --    to be applied to an E_Void entity, precisely so that this kind of
   --    pre-setting of attributes works. This is really a hole in the dynamic
   --    type checking, since there is no assurance that the eventual Ekind
   --    value will be appropriate for the attributes set, and the consequence
   --    is that the dynamic type checking in the Einfo body is unnecessarily
   --    weak. To be looked at systematically some time ???

   ---------------
   -- Iterators --
   ---------------

   --  In addition to attributes that are stored as plain data, other
   --  attributes are procedural, and require some small amount of
   --  computation. Of course, from the point of view of a user of this
   --  package, the distinction is not visible (even the field information
   --  provided below should be disregarded, as it is subject to  change
   --  without notice!). A number of  attributes appear as lists: lists of
   --  formals,  lists of actuals, of discriminants, etc. For these, pairs
   --  of functions are defined, which take the form:

   --      function First_Thing (E : Enclosing_Construct) return Thing;
   --      function Next_Thing (T : Thing) return Thing;

   --  The end of iteration is always signalled by a value of Empty, so that
   --  loops over these chains invariably have the form:

   --      This : Thing;
   --      ...
   --      This := First_Thing (E);

   --      while Present (This) loop
   --         Do_Something_With (This);
   --        ...
   --        This := Next_Thing (This);
   --      end loop;

   -----------------------------------
   -- Handling of Check Suppression --
   -----------------------------------

   --  There are three ways that checks can be suppressed:

   --    1.  At the command line level. Package Opt contains global Boolean
   --        flags with names Suppress_Options.xxx_Checks, where xxx is the
   --        name of one of the checks that can be suppressed (excluding
   --        All_Checks, which is simply reflected by setting all the
   --        individual flags)

   --    2.  At the scope level. The body of Sem contains flags with names
   --        Suppress.xxx_Checks which are set to indicate that the given
   --        check is suppressed for the current scope. These flags are
   --        saved in the scope stack on entry to a scope and restored on
   --        exit from the scope.

   --    3.  At the entity level. Each entity contains a set of flags named
   --        Suppress_xxx_Checks which suppress the given check for that
   --        particularly entity (of course not all flags are meaningful for
   --        all entities).

   -------------------------------
   -- Handling of Discriminants --
   -------------------------------

   --  During semantic processing, discriminants are separate entities which
   --  reflect the semantic properties and allowed usage of discriminants in
   --  the language.

   --  In the case of discriminants used as bounds, the references are handled
   --  directly, since special processing is needed in any case. However, there
   --  are two circumstances in which discriminants are referenced in a quite
   --  general manner, like any other variables:

   --     In initialization expressions for records. Note that the expressions
   --     used in Priority and Storage_Size pragmas are effectively in this
   --     category, since these pragmas are converted to initialized record
   --     fields in the Corresponding_Record_Type.

   --     In task and protected bodies, where the discriminant values may be
   --     referenced freely within these bodies.

   --  In both these cases, the discriminants must be treated essentially as
   --  objects. The following approach is used to simplify and minimize the
   --  special processing that is required.

   --  When a record type with discriminants is processed, the semantic
   --  processing creates the entities for the discriminants. It also creates
   --  an additional set of entities, called discriminals, one for each of
   --  the discriminants, and the Discriminal field of the discriminant entity
   --  points to this additional entity, which is initially created as an
   --  uninitialized (E_Void) entity.

   --  During expansion of expressions, any discriminant reference is replaced
   --  by a reference to the corresponding discriminal. When the initialization
   --  procedure for the record is created (there will always be one, since
   --  discriminants are present, see Exp_Ch3 for further details), the
   --  discriminals are used as the entities for the formal parameters of
   --  this initialization procedure. The references to these discriminants
   --  have already been replaced by references to these discriminals, which
   --  are now the formal parameters corresponding to the required objects.

   --  In the case of a task or protected body, the semantics similarly
   --  creates a set of discriminals for the discriminants of the task or
   --  protected type. When the procedure is created for the task body,
   --  the parameter passed in is a reference to the task value type, which
   --  contains the required discriminant values. The expander creates a
   --  set of declarations of the form:

   --      discriminal : constant dtype renames _Task.discriminant;

   --  where disriminal is the discriminal entity referenced by the task
   --  discriminant, and _Task is the task value passed in as the parameter.
   --  Again, any references to discriminants in the task body have been
   --  replaced by the discriminal reference, which is now an object that
   --  contains the required value.

   --  This approach for tasks means that two sets of discriminals are needed
   --  for a task type, one for the initialization procedure, and one for the
   --  task body. This works out nicely, since the semantics allocates one set
   --  for the task itself, and one set for the corresponding record.

   --  The one bit of trickiness arises in making sure that the right set of
   --  discriminals is used at the right time. First the task definition is
   --  processed. Any references to discriminants here are replaced by the
   --  the corresponding *task* discriminals (the record type doesn't even
   --  exist yet, since it is constructed as part of the expansion of the
   --  task declaration, which happens after the semantic processing of the
   --  task definition).

   --  Just before the record initialization routine is constructed, the
   --  expander exchanges the task and record discriminals. This has two
   --  effects. First the generation of the record initialization routine
   --  uses the discriminals that are now on the record, which is the set
   --  that used to be on the task, which is what we want.

   --  Second, a new set of (so far unused) discriminals is now on the task
   --  discriminants, and it is this set that will be used for expanding the
   --  task body, and also for the discriminal declarations at the start of
   --  the task body.

   ---------------------------------------
   -- Private data in protected objects --
   ---------------------------------------

   --  Private object declarations in protected types pose problems
   --  similar to those of discriminants.  They are expanded to
   --  components of a record which is passed as the parameter
   --  "_object" to expanded forms of all protected operations.  As
   --  with discriminants, timing of this expansion is a problem.  The
   --  sequence of statements for a protected operation is expanded
   --  before the operation itself, so the formal parameter for the
   --  record object containing the private data does not exist when
   --  the references to that data are expanded.

   --  For this reason, private data is handled in the same way as
   --  discriminants, expanding references to private data in protected
   --  operations (which appear as components) to placeholders which will
   --  eventually become renamings of the private selected compenents
   --  of the "_object" formal parameter.  These placeholders are called
   --  "privals", by analogy to the "discriminals" used to implement
   --  discriminants.  They are attached to the component declaration nodes
   --  representing the private object declarations of the protected type.

   --  As with discriminals, each protected subprogram needs a unique
   --  set of privals, since they must refer to renamings of
   --  components of a formal parameter of that operation.  Entry
   --  bodies need another set, which they all share and which is
   --  associated with renamings in the Service_Entries procedure for
   --  the protected type (??? not yet implemented).  This means that
   --  a new set of privals (and discriminals) must be associated with
   --  the private declarations after the body of a protected
   --  subprogram is processed.

   -------------------
   -- Type Synonyms --
   -------------------

   --  The following type synonyms are used to tidy up the function and
   --  procedure declarations that follow, and also to make it possible
   --  to meet the requirement for the XEINFO utility that all function
   --  specs must fit on a single source line.

   subtype B is Boolean;
   subtype E is Entity_Id;
   subtype N is Node_Id;
   subtype U is Uint;
   subtype R is Ureal;
   subtype L is Elist_Id;

   ---------------------------------
   --  Attribute Access Functions --
   ---------------------------------

   --  All attributes are manipulated through a procedural interface. This
   --  section contains the functions used to obtain attribute values which
   --  correspond to values in fields or flags in the entity itself.

   function Accept_Address                     (Id : E) return L;
   function Access_Disp_Table                  (Id : E) return E;
   function Alias                              (Id : E) return E;
   function Alignment_Clause                   (Id : E) return N;
   function Associated_Storage_Pool            (Id : E) return E;
   function Class_Wide_Type                    (Id : E) return E;
   function Component_Clause                   (Id : E) return N;
   function Component_Size_Clause              (Id : E) return N;
   function Component_Type                     (Id : E) return E;
   function Component_First_Bit                (Id : E) return U;
   function Controlled_Component_Iterator      (Id : E) return E;
   function Corresponding_Concurrent_Type      (Id : E) return E;
   function Corresponding_Discriminant         (Id : E) return E;
   function Corresponding_Integer_Type         (Id : E) return E;
   function Corresponding_Record_Type          (Id : E) return E;
   function Corresponding_Unprotected          (Id : E) return E;
   function Default_Value                      (Id : E) return N;
   function Delta_Value                        (Id : E) return R;
   function Digits_Value                       (Id : E) return U;
   function Directly_Designated_Type           (Id : E) return E;
   function Discriminal                        (Id : E) return N;
   function Discriminant_Checking_Func         (Id : E) return E;
   function Discriminant_Constraint            (Id : E) return L;
   function Discriminant_Default_Value         (Id : E) return N;
   function Entry_Component                    (Id : E) return E;
   function Entry_Index_Type                   (Id : E) return E;
   function Entry_Index_Value                  (Id : E) return U;
   function Entry_Parameters_Type              (Id : E) return E;
   function Enumeration_Pos                    (Id : E) return U;
   function Enumeration_Rep                    (Id : E) return U;
   function Enumeration_Rep_Expr               (Id : E) return N;
   function Enum_Pos_To_Rep                    (Id : E) return E;
   function Enum_Rep_To_Pos                    (Id : E) return E;
   function Equivalent_Type                    (Id : E) return E;
   function Esize                              (Id : E) return U;
   function Finalization_Chain_Entity          (Id : E) return E;
   function First_Entity                       (Id : E) return E;
   function First_Index                        (Id : E) return N;
   function First_Literal                      (Id : E) return E;
   function First_Private_Entity               (Id : E) return E;
   function Full_View                          (Id : E) return E;
   function Has_Address_Clause                 (Id : E) return B;
   function Has_Alignment_Clause               (Id : E) return B;
   function Has_Completion                     (Id : E) return B;
   function Has_Completion_In_Body             (Id : E) return B;
   function Has_Component_Size_Clause          (Id : E) return B;
   function Has_Controlled                     (Id : E) return B;
   function Has_Convention_C                   (Id : E) return B;
   function Has_Convention_Intrinsic           (Id : E) return B;
   function Has_Discriminants                  (Id : E) return B;
   function Has_Enumeration_Rep_Clause         (Id : E) return B;
   function Has_Exit                           (Id : E) return B;
   function Has_Homonym                        (Id : E) return B;
   function Has_Master_Entity                  (Id : E) return B;
   function Has_Record_Rep_Clause              (Id : E) return B;
   function Has_Size_Clause                    (Id : E) return B;
   function Has_Small_Clause                   (Id : E) return B;
   function Has_Storage_Size_Clause            (Id : E) return B;
   function Has_Tasks                          (Id : E) return B;
   function In_Package_Body                    (Id : E) return B;
   function In_Private_Part                    (Id : E) return B;
   function In_Use                             (Id : E) return B;
   function Init_Proc                          (Id : E) return E;
   function Interface_Name                     (Id : E) return N;
   function Is_Abstract                        (Id : E) return B;
   function Is_Access_Constant                 (Id : E) return B;
   function Is_Aliased                         (Id : E) return B;
   function Is_Character_Type                  (Id : E) return B;
   function Is_Constrained                     (Id : E) return B;
   function Is_Controlled                      (Id : E) return B;
   function Is_Delayed                         (Id : E) return B;
   function Is_Dispatching_Operation           (Id : E) return B;
   function Is_Entry_Formal                    (Id : E) return B;
   function Is_Frozen                          (Id : E) return B;
   function Is_Immediately_Visible             (Id : E) return B;
   function Is_Imported                        (Id : E) return B;
   function Is_Inlined                         (Id : E) return B;
   function Is_Internal                        (Id : E) return B;
   function Is_Intrinsic_Subprogram            (Id : E) return B;
   function Is_Named_Number                    (Id : E) return B;
   function Is_Overloadable                    (Id : E) return B;
   function Is_Packed                          (Id : E) return B;
   function Is_Potentially_Use_Visible         (Id : E) return B;
   function Is_Preelaborated                   (Id : E) return B;
   function Is_Private                         (Id : E) return B;
   function Is_Private_Descendant              (Id : E) return B;
   function Is_Public                          (Id : E) return B;
   function Is_Pure                            (Id : E) return B;
   function Is_Remote_Call_Interface           (Id : E) return B;
   function Is_Remote_Types                    (Id : E) return B;
   function Is_Shared_Passive                  (Id : E) return B;
   function Is_Subprogram                      (Id : E) return B;
   function Is_Volatile                        (Id : E) return B;
   function Last_Entity                        (Id : E) return E;
   function Lit_Name_Table                     (Id : E) return E;
   function Master_Id                          (Id : E) return E;
   function Modulus                            (Id : E) return U;
   function Needs_Discr_Check                  (Id : E) return B;
   function Needs_No_Actuals                   (Id : E) return B;
   function Next_Literal                       (Id : E) return E;
   function Next_Itype                         (Id : E) return E;
   function Non_Binary_Modulus                 (Id : E) return B;
   function Number_Simple_Entries              (Id : E) return U;
   function Original_Record_Component          (Id : E) return E;
   function Parent_Subtype                     (Id : E) return E;
   function Primitive_Operations               (Id : E) return L;
   function Private_Subtype_List               (Id : E) return E;
   function Prival                             (Id : E) return E;
   function Protected_Formal                   (Id : E) return E;
   function Protected_Subprogram               (Id : E) return E;
   function Reachable                          (Id : E) return B;
   function Renamed_Object                     (Id : E) return N;
   function Return_Present                     (Id : E) return B;
   function Scalar_Range                       (Id : E) return N;
   function Small_Value                        (Id : E) return R;
   function Slice_Range                        (Id : E) return N;
   function Storage_Size_Variable              (Id : E) return E;
   function String_Literal_Length              (Id : E) return U;
   function Suppress_Access_Checks             (Id : E) return B;
   function Suppress_Accessibility_Checks      (Id : E) return B;
   function Suppress_Discriminant_Checks       (Id : E) return B;
   function Suppress_Division_Checks           (Id : E) return B;
   function Suppress_Elaboration_Checks        (Id : E) return B;
   function Suppress_Index_Checks              (Id : E) return B;
   function Suppress_Length_Checks             (Id : E) return B;
   function Suppress_Overflow_Checks           (Id : E) return B;
   function Suppress_Range_Checks              (Id : E) return B;
   function Suppress_Storage_Checks            (Id : E) return B;
   function Suppress_Tag_Checks                (Id : E) return B;
   function Table_High_Bound                   (Id : E) return N;
   function Task_Activation_Chain_Entity       (Id : E) return E;

   ------------------------------------
   -- Type Classification Attributes --
   ------------------------------------

   --  These functions provide a convenient functional notation for testing
   --  whether an Ekind value belongs to a specified kind, for example the
   --  function Is_Elementary_Type tests if its argument is in Elementary_Kind.
   --  In some cases, the test is of an entity attribute (e.g. in the case of
   --  Is_Generic_Type where the Ekind does not provide the needed information)

   function Is_Access_Type                     (Id : E) return B;
   function Is_Array_Type                      (Id : E) return B;
   function Is_Class_Wide_Type                 (Id : E) return B;
   function Is_Composite_Type                  (Id : E) return B;
   function Is_Concurrent_Record_Type          (Id : E) return B;
   function Is_Concurrent_Type                 (Id : E) return B;
   function Is_Decimal_Fixed_Point_Type        (Id : E) return B;
   function Is_Digits_Type                     (Id : E) return B;
   function Is_Discrete_Type                   (Id : E) return B;
   function Is_Elementary_Type                 (Id : E) return B;
   function Is_Enumeration_Type                (Id : E) return B;
   function Is_Fixed_Point_Type                (Id : E) return B;
   function Is_Floating_Point_Type             (Id : E) return B;
   function Is_Generic_Type                    (Id : E) return B;
   function Is_Incomplete_Or_Private_Type      (Id : E) return B;
   function Is_Integer_Type                    (Id : E) return B;
   function Is_Limited_Record                  (Id : E) return B;
   function Is_Modular_Integer_Type            (Id : E) return B;
   function Is_Numeric_Type                    (Id : E) return B;
   function Is_Ordinary_Fixed_Point_Type       (Id : E) return B;
   function Is_Private_Type                    (Id : E) return B;
   function Is_Protected_Type                  (Id : E) return B;
   function Is_Real_Type                       (Id : E) return B;
   function Is_Record_Type                     (Id : E) return B;
   function Is_Scalar_Type                     (Id : E) return B;
   function Is_Signed_Integer_Type             (Id : E) return B;
   function Is_Tagged_Type                     (Id : E) return B;
   function Is_Task_Type                       (Id : E) return B;
   function Is_Type                            (Id : E) return B;

   -------------------------------------
   -- Synthesized Attribute Functions --
   -------------------------------------

   --  The functions in this section synthesize attributes from the tree,
   --  so they do not correspond to defined fields in the entity itself.

   function Base_Init_Proc                     (Id : E) return E;
   function Base_Type                          (Id : E) return E;
   function Constant_Value                     (Id : E) return N;
   function Declaration_Node                   (Id : E) return N;
   function Depends_On_Private                 (Id : E) return B;
   function Designated_Type                    (Id : E) return E;
   function First_Component                    (Id : E) return E;
   function First_Discriminant                 (Id : E) return E;
   function First_Formal                       (Id : E) return E;
   function Is_Boolean_Type                    (Id : E) return B;
   function Is_First_Named_Subtype             (Id : E) return B;
   function Is_Limited_Type                    (Id : E) return B;
   function Is_Protected_Private               (Id : E) return B;
   function Is_Protected_Record_Type           (Id : E) return B;
   function Is_String_Type                     (Id : E) return B;
   function Is_Task_Record_Type                (Id : E) return B;
   function Next_Component                     (Id : E) return E;
   function Next_Discriminant                  (Id : E) return E;
   function Next_Formal                        (Id : E) return E;
   function Next_Overloads                     (Id : E) return E;
   function Number_Dimensions                  (Id : E) return Pos;
   function Number_Discriminants               (Id : E) return Pos;
   function Parameter_Mode                     (Id : E) return Formal_Kind;
   function Root_Type                          (Id : E) return E;
   function Tag_Component                      (Id : E) return E;
   function Type_High_Bound                    (Id : E) return N;
   function Type_Low_Bound                     (Id : E) return N;
   function Underlying_Type                    (Id : E) return E;

   ------------------------------
   -- Attribute Set Procedures --
   ------------------------------

   procedure Set_Accept_Address                (Id : E; V : L);
   procedure Set_Access_Disp_Table             (Id : E; V : E);
   procedure Set_Alias                         (Id : E; V : E);
   procedure Set_Alignment_Clause              (Id : E; V : N);
   procedure Set_Associated_Storage_Pool       (Id : E; V : E);
   procedure Set_Class_Wide_Type               (Id : E; V : E);
   procedure Set_Component_Clause              (Id : E; V : N);
   procedure Set_Component_Size_Clause         (Id : E; V : N);
   procedure Set_Component_Type                (Id : E; V : E);
   procedure Set_Component_First_Bit           (Id : E; V : U);
   procedure Set_Controlled_Component_Iterator (Id : E; V : E);
   procedure Set_Corresponding_Concurrent_Type (Id : E; V : E);
   procedure Set_Corresponding_Discriminant    (Id : E; V : E);
   procedure Set_Corresponding_Integer_Type    (Id : E; V : E);
   procedure Set_Corresponding_Record_Type     (Id : E; V : E);
   procedure Set_Corresponding_Unprotected     (Id : E; V : E);
   procedure Set_Default_Value                 (Id : E; V : N);
   procedure Set_Delta_Value                   (Id : E; V : R);
   procedure Set_Depends_On_Private            (Id : E; V : B := True);
   procedure Set_Digits_Value                  (Id : E; V : U);
   procedure Set_Directly_Designated_Type      (Id : E; V : E);
   procedure Set_Discriminal                   (Id : E; V : E);
   procedure Set_Discriminant_Checking_Func    (Id : E; V : E);
   procedure Set_Discriminant_Constraint       (Id : E; V : L);
   procedure Set_Discriminant_Default_Value    (Id : E; V : N);
   procedure Set_Entry_Component               (Id : E; V : E);
   procedure Set_Entry_Index_Value             (Id : E; V : U);
   procedure Set_Entry_Parameters_Type         (Id : E; V : E);
   procedure Set_Enumeration_Pos               (Id : E; V : U);
   procedure Set_Enumeration_Rep               (Id : E; V : U);
   procedure Set_Enumeration_Rep_Expr          (Id : E; V : N);
   procedure Set_Enum_Pos_To_Rep               (Id : E; V : E);
   procedure Set_Enum_Rep_To_Pos               (Id : E; V : E);
   procedure Set_Equivalent_Type               (Id : E; V : E);
   procedure Set_Esize                         (Id : E; V : U);
   procedure Set_Finalization_Chain_Entity     (Id : E; V : E);
   procedure Set_First_Entity                  (Id : E; V : E);
   procedure Set_First_Index                   (Id : E; V : N);
   procedure Set_First_Literal                 (Id : E; V : E);
   procedure Set_First_Private_Entity          (Id : E; V : E);
   procedure Set_Full_View                     (Id : E; V : E);
   procedure Set_Has_Address_Clause            (Id : E; V : B := True);
   procedure Set_Has_Alignment_Clause          (Id : E; V : B := True);
   procedure Set_Has_Completion                (Id : E; V : B := True);
   procedure Set_Has_Completion_In_Body        (Id : E; V : B := True);
   procedure Set_Has_Component_Size_Clause     (Id : E; V : B := True);
   procedure Set_Has_Controlled                (Id : E; V : B := True);
   procedure Set_Has_Convention_C              (Id : E; V : B := True);
   procedure Set_Has_Convention_Intrinsic      (Id : E; V : B := True);
   procedure Set_Has_Discriminants             (Id : E; V : B := True);
   procedure Set_Has_Enumeration_Rep_Clause    (Id : E; V : B := True);
   procedure Set_Has_Exit                      (Id : E; V : B := True);
   procedure Set_Has_Homonym                   (Id : E; V : B := True);
   procedure Set_Has_Master_Entity             (Id : E; V : B := True);
   procedure Set_Has_Record_Rep_Clause         (Id : E; V : B := True);
   procedure Set_Has_Size_Clause               (Id : E; V : B := True);
   procedure Set_Has_Small_Clause              (Id : E; V : B := True);
   procedure Set_Has_Storage_Size_Clause       (Id : E; V : B := True);
   procedure Set_Has_Tasks                     (Id : E; V : B := True);
   procedure Set_In_Package_Body               (Id : E; V : B := True);
   procedure Set_In_Private_Part               (Id : E; V : B := True);
   procedure Set_In_Use                        (Id : E; V : B := True);
   procedure Set_Init_Proc                     (Id : E; V : E);
   procedure Set_Interface_Name                (Id : E; V : N);
   procedure Set_Is_Abstract                   (Id : E; V : B := True);
   procedure Set_Is_Access_Constant            (Id : E; V : B := True);
   procedure Set_Is_Aliased                    (Id : E; V : B := True);
   procedure Set_Is_Character_Type             (Id : E; V : B := True);
   procedure Set_Is_Constrained                (Id : E; V : B := True);
   procedure Set_Is_Controlled                 (Id : E; V : B := True);
   procedure Set_Is_Delayed                    (Id : E; V : B := True);
   procedure Set_Is_Dispatching_Operation      (Id : E; V : B := True);
   procedure Set_Is_Entry_Formal               (Id : E; V : B := True);
   procedure Set_Is_Frozen                     (Id : E; V : B := True);
   procedure Set_Is_Generic_Type               (Id : E; V : B := True);
   procedure Set_Is_Immediately_Visible        (Id : E; V : B := True);
   procedure Set_Is_Imported                   (Id : E; V : B := True);
   procedure Set_Is_Inlined                    (Id : E; V : B := True);
   procedure Set_Is_Internal                   (Id : E; V : B := True);
   procedure Set_Is_Intrinsic_Subprogram       (Id : E; V : B := True);
   procedure Set_Is_Limited_Record             (Id : E; V : B := True);
   procedure Set_Is_Packed                     (Id : E; V : B := True);
   procedure Set_Is_Potentially_Use_Visible    (Id : E; V : B := True);
   procedure Set_Is_Preelaborated              (Id : E; V : B := True);
   procedure Set_Is_Private                    (Id : E; V : B := True);
   procedure Set_Is_Private_Descendant         (Id : E; V : B := True);
   procedure Set_Is_Public                     (Id : E; V : B := True);
   procedure Set_Is_Pure                       (Id : E; V : B := True);
   procedure Set_Is_Remote_Call_Interface      (Id : E; V : B := True);
   procedure Set_Is_Remote_Types               (Id : E; V : B := True);
   procedure Set_Is_Shared_Passive             (Id : E; V : B := True);
   procedure Set_Is_Tagged_Type                (Id : E; V : B := True);
   procedure Set_Is_Concurrent_Record_Type     (Id : E; V : B := True);
   procedure Set_Is_Volatile                   (Id : E; V : B := True);
   procedure Set_Last_Entity                   (Id : E; V : E);
   procedure Set_Lit_Name_Table                (Id : E; V : E);
   procedure Set_Master_Id                     (Id : E; V : E);
   procedure Set_Modulus                       (Id : E; V : U);
   procedure Set_Needs_Discr_Check             (Id : E; V : B := True);
   procedure Set_Needs_No_Actuals              (Id : E; V : B := True);
   procedure Set_Next_Itype                    (Id : E; V : E);
   procedure Set_Non_Binary_Modulus            (Id : E; V : B := True);
   procedure Set_Number_Simple_Entries         (Id : E; V : U);
   procedure Set_Original_Record_Component     (Id : E; V : E);
   procedure Set_Parent_Subtype                (Id : E; V : E);
   procedure Set_Primitive_Operations          (Id : E; V : L);
   procedure Set_Prival                        (Id : E; V : E);
   procedure Set_Protected_Formal              (Id : E; V : E);
   procedure Set_Protected_Subprogram          (Id : E; V : E);
   procedure Set_Private_Subtype_List          (Id : E; V : E);
   procedure Set_Reachable                     (Id : E; V : B := True);
   procedure Set_Renamed_Object                (Id : E; V : N);
   procedure Set_Return_Present                (Id : E; V : B := True);
   procedure Set_Scalar_Range                  (Id : E; V : N);
   procedure Set_Small_Value                   (Id : E; V : R);
   procedure Set_Slice_Range                   (Id : E; V : N);
   procedure Set_Storage_Size_Variable         (Id : E; V : E);
   procedure Set_String_Literal_Length         (Id : E; V : U);
   procedure Set_Suppress_Access_Checks        (Id : E; V : B := True);
   procedure Set_Suppress_Accessibility_Checks (Id : E; V : B := True);
   procedure Set_Suppress_Discriminant_Checks  (Id : E; V : B := True);
   procedure Set_Suppress_Division_Checks      (Id : E; V : B := True);
   procedure Set_Suppress_Elaboration_Checks   (Id : E; V : B := True);
   procedure Set_Suppress_Index_Checks         (Id : E; V : B := True);
   procedure Set_Suppress_Length_Checks        (Id : E; V : B := True);
   procedure Set_Suppress_Overflow_Checks      (Id : E; V : B := True);
   procedure Set_Suppress_Range_Checks         (Id : E; V : B := True);
   procedure Set_Suppress_Storage_Checks       (Id : E; V : B := True);
   procedure Set_Suppress_Tag_Checks           (Id : E; V : B := True);
   procedure Set_Table_High_Bound              (Id : E; V : N);
   procedure Set_Task_Activation_Chain_Entity  (Id : E; V : E);

   -------------------------------
   -- Miscellaneous Subprograms --
   -------------------------------

   procedure Append_Entity (Id : Entity_Id; V : Entity_Id);
   --  Add an entity to the list of entities declared in the scope E

   function Next_Index (Id : Node_Id) return Node_Id;
   --  A synonym for Next, used in conjunction with First_Index when
   --  following the chain of index subtype definitions or index
   --  constraints.

   function Subtype_Kind (K : Entity_Kind) return Entity_Kind;
   --  Given an entity_kind K this function returns the entity_kind
   --  corresponding to subtype kind of the type represented by K. For
   --  example if K is E_Signed_Integer_Type then E_Siggned_Integer_Subtype
   --  is returned. If K is already a subtype kind it itself is returned. An
   --  internal error is generated if no such correspondence exists for K.

   ----------------------------------
   -- Debugging Output Subprograms --
   ----------------------------------

   procedure Write_Entity_Flags (Id : Entity_Id; Prefix : String);
   --  Writes a series of entries giving a line for each flag that is
   --  set to True. Each line is prefixed by the given string

   procedure Write_Entity_Info (Id : Entity_Id; Prefix : String);
   --  A debugging procedure to write out information about an entity

   procedure Write_Field6_Name  (Id : Entity_Id);
   procedure Write_Field7_Name  (Id : Entity_Id);
   procedure Write_Field8_Name  (Id : Entity_Id);
   procedure Write_Field9_Name  (Id : Entity_Id);
   procedure Write_Field10_Name (Id : Entity_Id);
   procedure Write_Field11_Name (Id : Entity_Id);
   procedure Write_Field12_Name (Id : Entity_Id);
   procedure Write_Field13_Name (Id : Entity_Id);
   procedure Write_Field14_Name (Id : Entity_Id);
   procedure Write_Field15_Name (Id : Entity_Id);
   procedure Write_Field16_Name (Id : Entity_Id);
   procedure Write_Field17_Name (Id : Entity_Id);
   procedure Write_Field18_Name (Id : Entity_Id);
   --  These routines are used to output a nice symbolic name for the given
   --  field, depending on the Ekind. No blanks or end of lines are output,
   --  just the characters of the field name.

   ---------------------
   --  Inline Pragmas --
   ---------------------

   --  Note that these inline pragmas are referenced by the XEINFO utility
   --  program in preparing the corresponding C header, and only those
   --  subprograms meeting the requiremens documented in the section on
   --  XEINFO may be referenced in this section.

   pragma Inline (Accept_Address);
   pragma Inline (Access_Disp_Table);
   pragma Inline (Alias);
   pragma Inline (Alignment_Clause);
   pragma Inline (Associated_Storage_Pool);
   pragma Inline (Class_Wide_Type);
   pragma Inline (Component_Clause);
   pragma Inline (Component_First_Bit);
   pragma Inline (Component_Size_Clause);
   pragma Inline (Component_Type);
   pragma Inline (Corresponding_Concurrent_Type);
   pragma Inline (Corresponding_Discriminant);
   pragma Inline (Corresponding_Integer_Type);
   pragma Inline (Corresponding_Record_Type);
   pragma Inline (Corresponding_Unprotected);
   pragma Inline (Default_Value);
   pragma Inline (Delta_Value);
   pragma Inline (Depends_On_Private);
   pragma Inline (Digits_Value);
   pragma Inline (Full_View);
   pragma Inline (Directly_Designated_Type);
   pragma Inline (Discriminal);
   pragma Inline (Discriminant_Checking_Func);
   pragma Inline (Discriminant_Constraint);
   pragma Inline (Discriminant_Default_Value);
   pragma Inline (Entry_Component);
   pragma Inline (Entry_Index_Value);
   pragma Inline (Entry_Parameters_Type);
   pragma Inline (Enumeration_Pos);
   pragma Inline (Enumeration_Rep);
   pragma Inline (Enumeration_Rep_Expr);
   pragma Inline (Enum_Pos_To_Rep);
   pragma Inline (Enum_Rep_To_Pos);
   pragma Inline (Equivalent_Type);
   pragma Inline (Esize);
   pragma Inline (Finalization_Chain_Entity);
   pragma Inline (First_Entity);
   pragma Inline (First_Index);
   pragma Inline (First_Literal);
   pragma Inline (First_Private_Entity);
   pragma Inline (Has_Address_Clause);
   pragma Inline (Has_Alignment_Clause);
   pragma Inline (Has_Completion);
   pragma Inline (Has_Completion_In_Body);
   pragma Inline (Has_Component_Size_Clause);
   pragma Inline (Has_Controlled);
   pragma Inline (Has_Convention_C);
   pragma Inline (Has_Convention_Intrinsic);
   pragma Inline (Has_Discriminants);
   pragma Inline (Has_Enumeration_Rep_Clause);
   pragma Inline (Has_Exit);
   pragma Inline (Has_Homonym);
   pragma Inline (Has_Master_Entity);
   pragma Inline (Has_Record_Rep_Clause);
   pragma Inline (Has_Size_Clause);
   pragma Inline (Has_Small_Clause);
   pragma Inline (Has_Storage_Size_Clause);
   pragma Inline (Has_Tasks);
   pragma Inline (In_Package_Body);
   pragma Inline (In_Private_Part);
   pragma Inline (In_Use);
   pragma Inline (Init_Proc);
   pragma Inline (Interface_Name);
   pragma Inline (Is_Abstract);
   pragma Inline (Is_Access_Constant);
   pragma Inline (Is_Access_Type);
   pragma Inline (Is_Aliased);
   pragma Inline (Is_Array_Type);
   pragma Inline (Is_Class_Wide_Type);
   pragma Inline (Is_Character_Type);
   pragma Inline (Is_Composite_Type);
   pragma Inline (Is_Concurrent_Record_Type);
   pragma Inline (Is_Concurrent_Type);
   pragma Inline (Is_Controlled);
   pragma Inline (Is_Constrained);
   pragma Inline (Is_Decimal_Fixed_Point_Type);
   pragma Inline (Is_Delayed);
   pragma Inline (Is_Digits_Type);
   pragma Inline (Is_Discrete_Type);
   pragma Inline (Is_Dispatching_Operation);
   pragma Inline (Is_Elementary_Type);
   pragma Inline (Is_Entry_Formal);
   pragma Inline (Is_Enumeration_Type);
   pragma Inline (Is_Fixed_Point_Type);
   pragma Inline (Is_Floating_Point_Type);
   pragma Inline (Is_Frozen);
   pragma Inline (Is_Generic_Type);
   pragma Inline (Is_Immediately_Visible);
   pragma Inline (Is_Imported);
   pragma Inline (Is_Incomplete_Or_Private_Type);
   pragma Inline (Is_Inlined);
   pragma Inline (Is_Integer_Type);
   pragma Inline (Is_Internal);
   pragma Inline (Is_Intrinsic_Subprogram);
   pragma Inline (Is_Limited_Record);
   pragma Inline (Is_Modular_Integer_Type);
   pragma Inline (Is_Named_Number);
   pragma Inline (Is_Numeric_Type);
   pragma Inline (Is_Ordinary_Fixed_Point_Type);
   pragma Inline (Is_Overloadable);
   pragma Inline (Is_Packed);
   pragma Inline (Is_Potentially_Use_Visible);
   pragma Inline (Is_Preelaborated);
   pragma Inline (Is_Private);
   pragma Inline (Is_Private_Descendant);
   pragma Inline (Is_Private_Type);
   pragma Inline (Is_Protected_Type);
   pragma Inline (Is_Public);
   pragma Inline (Is_Pure);
   pragma Inline (Is_Real_Type);
   pragma Inline (Is_Record_Type);
   pragma Inline (Is_Remote_Call_Interface);
   pragma Inline (Is_Remote_Types);
   pragma Inline (Is_Shared_Passive);
   pragma Inline (Is_Scalar_Type);
   pragma Inline (Is_Signed_Integer_Type);
   pragma Inline (Is_Subprogram);
   pragma Inline (Is_Tagged_Type);
   pragma Inline (Is_Task_Type);
   pragma Inline (Is_Type);
   pragma Inline (Is_Volatile);
   pragma Inline (Last_Entity);
   pragma Inline (Lit_Name_Table);
   pragma Inline (Master_Id);
   pragma Inline (Modulus);
   pragma Inline (Needs_Discr_Check);
   pragma Inline (Needs_No_Actuals);
   pragma Inline (Next_Index);
   pragma Inline (Next_Itype);
   pragma Inline (Next_Literal);
   pragma Inline (Next_Overloads);
   pragma Inline (Non_Binary_Modulus);
   pragma Inline (Number_Simple_Entries);
   pragma Inline (Original_Record_Component);
   pragma Inline (Parameter_Mode);
   pragma Inline (Parent_Subtype);
   pragma Inline (Private_Subtype_List);
   pragma Inline (Primitive_Operations);
   pragma Inline (Prival);
   pragma Inline (Protected_Formal);
   pragma Inline (Protected_Subprogram);
   pragma Inline (Reachable);
   pragma Inline (Renamed_Object);
   pragma Inline (Return_Present);
   pragma Inline (Scalar_Range);
   pragma Inline (Small_Value);
   pragma Inline (Slice_Range);
   pragma Inline (Storage_Size_Variable);
   pragma Inline (String_Literal_Length);
   pragma Inline (Suppress_Access_Checks);
   pragma Inline (Suppress_Accessibility_Checks);
   pragma Inline (Suppress_Discriminant_Checks);
   pragma Inline (Suppress_Division_Checks);
   pragma Inline (Suppress_Elaboration_Checks);
   pragma Inline (Suppress_Index_Checks);
   pragma Inline (Suppress_Length_Checks);
   pragma Inline (Suppress_Overflow_Checks);
   pragma Inline (Suppress_Range_Checks);
   pragma Inline (Suppress_Storage_Checks);
   pragma Inline (Suppress_Tag_Checks);
   pragma Inline (Table_High_Bound);
   pragma Inline (Task_Activation_Chain_Entity);
   pragma Inline (Type_High_Bound);
   pragma Inline (Type_Low_Bound);

   pragma Inline (Set_Accept_Address);
   pragma Inline (Set_Access_Disp_Table);
   pragma Inline (Set_Alias);
   pragma Inline (Set_Alignment_Clause);
   pragma Inline (Set_Associated_Storage_Pool);
   pragma Inline (Set_Class_Wide_Type);
   pragma Inline (Set_Component_Clause);
   pragma Inline (Set_Component_First_Bit);
   pragma Inline (Set_Component_Size_Clause);
   pragma Inline (Set_Component_Type);
   pragma Inline (Set_Corresponding_Concurrent_Type);
   pragma Inline (Set_Corresponding_Discriminant);
   pragma Inline (Set_Corresponding_Integer_Type);
   pragma Inline (Set_Corresponding_Record_Type);
   pragma Inline (Set_Corresponding_Unprotected);
   pragma Inline (Set_Default_Value);
   pragma Inline (Set_Delta_Value);
   pragma Inline (Set_Depends_On_Private);
   pragma Inline (Set_Digits_Value);
   pragma Inline (Set_Full_View);
   pragma Inline (Set_Directly_Designated_Type);
   pragma Inline (Set_Discriminal);
   pragma Inline (Set_Discriminant_Checking_Func);
   pragma Inline (Set_Discriminant_Constraint);
   pragma Inline (Set_Discriminant_Default_Value);
   pragma Inline (Set_Entry_Component);
   pragma Inline (Set_Entry_Index_Value);
   pragma Inline (Set_Entry_Parameters_Type);
   pragma Inline (Set_Enumeration_Pos);
   pragma Inline (Set_Enumeration_Rep);
   pragma Inline (Set_Enumeration_Rep_Expr);
   pragma Inline (Set_Enum_Pos_To_Rep);
   pragma Inline (Set_Enum_Rep_To_Pos);
   pragma Inline (Set_Equivalent_Type);
   pragma Inline (Set_Esize);
   pragma Inline (Set_Finalization_Chain_Entity);
   pragma Inline (Set_First_Entity);
   pragma Inline (Set_First_Index);
   pragma Inline (Set_First_Literal);
   pragma Inline (Set_First_Private_Entity);
   pragma Inline (Set_Has_Address_Clause);
   pragma Inline (Set_Has_Alignment_Clause);
   pragma Inline (Set_Has_Completion);
   pragma Inline (Set_Has_Component_Size_Clause);
   pragma Inline (Set_Has_Controlled);
   pragma Inline (Set_Has_Convention_C);
   pragma Inline (Set_Has_Convention_Intrinsic);
   pragma Inline (Set_Has_Discriminants);
   pragma Inline (Set_Has_Enumeration_Rep_Clause);
   pragma Inline (Set_Has_Exit);
   pragma Inline (Set_Has_Homonym);
   pragma Inline (Set_Has_Master_Entity);
   pragma Inline (Set_Has_Record_Rep_Clause);
   pragma Inline (Set_Has_Size_Clause);
   pragma Inline (Set_Has_Small_Clause);
   pragma Inline (Set_Has_Storage_Size_Clause);
   pragma Inline (Set_Has_Tasks);
   pragma Inline (Set_In_Package_Body);
   pragma Inline (Set_In_Private_Part);
   pragma Inline (Set_In_Use);
   pragma Inline (Set_Init_Proc);
   pragma Inline (Set_Interface_Name);
   pragma Inline (Set_Is_Abstract);
   pragma Inline (Set_Is_Access_Constant);
   pragma Inline (Set_Is_Aliased);
   pragma Inline (Set_Is_Character_Type);
   pragma Inline (Set_Is_Constrained);
   pragma Inline (Set_Is_Controlled);
   pragma Inline (Set_Is_Delayed);
   pragma Inline (Set_Is_Dispatching_Operation);
   pragma Inline (Set_Is_Entry_Formal);
   pragma Inline (Set_Is_Frozen);
   pragma Inline (Set_Is_Generic_Type);
   pragma Inline (Set_Is_Immediately_Visible);
   pragma Inline (Set_Is_Imported);
   pragma Inline (Set_Is_Inlined);
   pragma Inline (Set_Is_Internal);
   pragma Inline (Set_Is_Intrinsic_Subprogram);
   pragma Inline (Set_Is_Limited_Record);
   pragma Inline (Set_Is_Packed);
   pragma Inline (Set_Is_Potentially_Use_Visible);
   pragma Inline (Set_Is_Preelaborated);
   pragma Inline (Set_Is_Private);
   pragma Inline (Set_Is_Private_Descendant);
   pragma Inline (Set_Is_Public);
   pragma Inline (Set_Is_Pure);
   pragma Inline (Set_Is_Remote_Call_Interface);
   pragma Inline (Set_Is_Remote_Types);
   pragma Inline (Set_Is_Shared_Passive);
   pragma Inline (Set_Is_Tagged_Type);
   pragma Inline (Set_Is_Concurrent_Record_Type);
   pragma Inline (Set_Is_Volatile);
   pragma Inline (Set_Last_Entity);
   pragma Inline (Set_Lit_Name_Table);
   pragma Inline (Set_Master_Id);
   pragma Inline (Set_Modulus);
   pragma Inline (Set_Needs_Discr_Check);
   pragma Inline (Set_Needs_No_Actuals);
   pragma Inline (Set_Next_Itype);
   pragma Inline (Set_Non_Binary_Modulus);
   pragma Inline (Set_Number_Simple_Entries);
   pragma Inline (Set_Original_Record_Component);
   pragma Inline (Set_Parent_Subtype);
   pragma Inline (Set_Primitive_Operations);
   pragma Inline (Set_Prival);
   pragma Inline (Set_Protected_Formal);
   pragma Inline (Set_Protected_Subprogram);
   pragma Inline (Set_Private_Subtype_List);
   pragma Inline (Set_Storage_Size_Variable);
   pragma Inline (Set_Reachable);
   pragma Inline (Set_Renamed_Object);
   pragma Inline (Set_Return_Present);
   pragma Inline (Set_Scalar_Range);
   pragma Inline (Set_Small_Value);
   pragma Inline (Set_Slice_Range);
   pragma Inline (Set_String_Literal_Length);
   pragma Inline (Set_Suppress_Access_Checks);
   pragma Inline (Set_Suppress_Accessibility_Checks);
   pragma Inline (Set_Suppress_Discriminant_Checks);
   pragma Inline (Set_Suppress_Division_Checks);
   pragma Inline (Set_Suppress_Elaboration_Checks);
   pragma Inline (Set_Suppress_Index_Checks);
   pragma Inline (Set_Suppress_Length_Checks);
   pragma Inline (Set_Suppress_Overflow_Checks);
   pragma Inline (Set_Suppress_Range_Checks);
   pragma Inline (Set_Suppress_Storage_Checks);
   pragma Inline (Set_Suppress_Tag_Checks);
   pragma Inline (Set_Table_High_Bound);
   pragma Inline (Set_Task_Activation_Chain_Entity);

end Einfo;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.238
--  date: Wed Aug 24 13:11:52 1994;  author: schenker
--  fix bug in documentation of Is_Limited_Type.
--  ----------------------------
--  revision 1.239
--  date: Wed Aug 24 23:27:15 1994;  author: giering
--  (Prival, Protected_Subprogram): Documentation change.  These are
--   now described as always present in component entity nodes, but empty
--   unless Is_Protected_Private is True.
--  (Corresponding_Unprotected): New attribute of procedures and functions.
--   This provides access to the unprotected, expanded version of a
--   protected subprogram.
--  (Protected_Formal): New attribute of formal parameters.
--   Present for the formal parameters of protected operations, this
--   provides access to the corresponding formal parameters of the expanded
--   unprotected version of the operation.  This allows references to the
--   formal parameters to be expanded to refer to the parameters of the
--   subprogram used to implement the operation.
--  ----------------------------
--  revision 1.240
--  date: Thu Aug 25 16:33:08 1994;  author: dewar
--  Minor comment updates
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
