------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              E X P _ C H 7                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.18 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Types; use Types;

package Exp_Ch7 is

   procedure Expand_N_Package_Body        (N : Node_Id);
   procedure Expand_N_Package_Declaration (N : Node_Id);

   --  Controlled Types Management

   procedure Expand_Cleanup_Actions (N : Node_Id);
   --  Expand the necessary stuff into a scope to enable finalization of local
   --  objects and deallocation of transient data when exiting the scope. N is
   --  a "scope node" that is to say one of the following: N_Block_Statement,
   --  N_Subprogram_Body, N_Task_Body, N_Entry_Body.

   function Make_Attach_Ctrl_Object
     (Ref  : Node_Id;
      Scop : Entity_Id)
      return Node_Id;
   --  Generates a call to Sys.Finalization_Implementation.Attach_To_Final_List
   --  in order to attach the referenced object to the list of the specified
   --  scope (the current scope is not always the right one for allocated
   --  objects)

   function Make_Adjust_Call
     (Ref  : Node_Id;
      Typ  : Entity_Id)
      return Node_Id;
   --  Generates a call to the primitive operation Adjust for the controlled
   --  object referenced by Ref.

   function Make_Adjust_Components_Call
     (Ref  : Node_Id;
      Typ  : Entity_Id)
      return Node_Id;
   --  Generates a call to the build-in procedure Adjust_Components for the
   --  controlled object referenced by Ref.

   function  Make_Init_Attach_Calls
     (Ref  : Node_Id;
      Scop : Entity_Id;
      Typ  : Entity_Id)
      return List_Id;
   --  Generates a call to the primitive operation Initialize for the
   --  controlled object referenced by Ref then attach the object to the
   --  finalization list of the specified scope.

   function  Make_Init_Attach_Components_Call
     (Ref  : Node_Id;
      Scop : Entity_Id;
      Typ  : Entity_Id)
      return Node_Id;
   --  Generates a call to the build-in procedure Init_Attach_Components for
   --  the controlled object referenced by Ref.

   function Make_Finalize_Call
     (Ref  : Node_Id;
      Typ  : Entity_Id)
      return Node_Id;
   --  Generates a call to the primitive operation Finalize for the
   --  controlled object referenced by Ref.

   function Make_Finalize_Components_Call
     (Ref  : Node_Id;
      Typ  : Entity_Id)
      return Node_Id;
   --  Generates a call to the build-in procedure Finalize_Components for the
   --  controlled object referenced by Ref.

   procedure Expand_Ctrl_Function_Call (N : Node_Id);
   --  Expand a call to a function returning a controlled value

   procedure Establish_Transient_Scope (N : Node_Id);
   --  Push a new transient scope on the scope stack. N is the node responsible
   --  for the need of a transient scope.

   function Node_To_Be_Wrapped return Node_Id;
   --  return the node to be wrapped if the current scope is transient.

   function Scope_Is_Transient  return Boolean;
   --  True if the current scope is transient.

   procedure Wrap_Transient_Declaration (N : Node_Id);
   --  N is an object declaration. Expand the finalization calls after the
   --  declaration and make the outer scope beeing the transient one.

   procedure Wrap_Transient_Expression (N : Node_Id);
   --  N is a sub-expression. Expand a transient block around an expression

   procedure Wrap_Transient_Statement (N : Node_Id);
   --  N is a statement. Expand a transient block around an instruction

end Exp_Ch7;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.16
--  date: Fri Apr 15 19:22:01 1994;  author: comar
--  Change profile of Establish_Transient_Scope.
--  Change Is_Expandable_Transient_Scope into Scope_Is_Transient for uniformity
--  Add function Expand_Ctrl_Function_Call.
--  Replace Wrap_Transient by the 3 Wrap_Transient_(Decl, Statement, Exp)
--  Add profile for Node_To_Be_Wrapped
--  ----------------------------
--  revision 1.17
--  date: Thu Apr 21 09:37:46 1994;  author: comar
--  Changed all Expand_Ctrl_* into Make_*_Call to emphasize the fact that this
--   functions don't analyze the tree they return.
--  Add Make_Attach_Ctrl_Object.
--  ----------------------------
--  revision 1.18
--  date: Mon May 23 22:54:21 1994;  author: schonber
--  (Expand_N_Package_Declaration): new subprogram.
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
