------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              S E M _ C H 4                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.14 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Types; use Types;

package Sem_Ch4  is
   procedure Analyze_Aggregate                          (N : Node_Id);
   procedure Analyze_Allocator                          (N : Node_Id);
   procedure Analyze_Arithmetic_Op                      (N : Node_Id);
   procedure Analyze_Call                               (N : Node_Id);
   procedure Analyze_Comparison_Op                      (N : Node_Id);
   procedure Analyze_Concatenation                      (N : Node_Id);
   procedure Analyze_Conditional_Expression             (N : Node_Id);
   procedure Analyze_Equality_Op                        (N : Node_Id);
   procedure Analyze_Explicit_Dereference               (N : Node_Id);
   procedure Analyze_Expression_Actions                 (N : Node_Id);
   procedure Analyze_Logical_Op                         (N : Node_Id);
   procedure Analyze_Membership_Op                      (N : Node_Id);
   procedure Analyze_Negation                           (N : Node_Id);
   procedure Analyze_Null                               (N : Node_Id);
   procedure Analyze_Qualified_Expression               (N : Node_Id);
   procedure Analyze_Range                              (N : Node_Id);
   procedure Analyze_Reference                          (N : Node_Id);
   procedure Analyze_Selected_Component                 (N : Node_Id);
   procedure Analyze_Short_Circuit                      (N : Node_Id);
   procedure Analyze_Slice                              (N : Node_Id);
   procedure Analyze_Type_Conversion                    (N : Node_Id);
   procedure Analyze_Unary_Op                           (N : Node_Id);
   procedure Analyze_Unchecked_Type_Conversion          (N : Node_Id);

   procedure Analyze_Expression (N : Node_Id);
   --  This is the top-level procedure for analyzing all expressions.
   --  For expressions that are not names, this is just a call to analyze.
   --  If the expression is a name, it may be a call to a parameterless
   --  procedure, and if so must be converted into an explicit call node
   --  and analyzed as such.

   procedure Analyze_Indexed_Component_Form (N : Node_Id);
   --  Prior to semantic analysis, an indexed component node can denote any
   --  of the following syntactic constructs:
   --    a) An indexed component of an array
   --    b) A function call
   --    c) A conversion
   --    d) A slice
   --  The resolution of the construct requires some semantic information
   --  on the prefix and the indices.

end Sem_Ch4;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.12
--  date: Mon Feb 28 00:08:59 1994;  author: dewar
--  (Analyze_Unchecked_Type_Conversion): New procedure
--  Change name Analyze_Conversion to Analyze_Type_Conversion
--  ----------------------------
--  revision 1.13
--  date: Fri Jul 22 11:40:59 1994;  author: dewar
--  (Analyze_Slice): New procedure (used to be Find_Slice in Sem_Ch8)
--  (Analyze_Indexed_Component_Form): New name for Find_Index_Or_Call
--   which used to be in body of Sem_Ch8
--  ----------------------------
--  revision 1.14
--  date: Fri Jul 22 14:58:36 1994;  author: dewar
--  (Analyze_Indexed_Component): Removed from spec, never called from outside
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
