/*
 * FIG : Facility for Interactive Generation of figures
 * Copyright (c) 1985 by Supoj Sutanthavibul
 *
 * "Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both the copyright
 * notice and this permission notice appear in supporting documentation. 
 * No representations are made about the suitability of this software for 
 * any purpose.  It is provided "as is" without express or implied warranty."
 */

#include "fig.h"
#include "resources.h"

/*********** icons for mode panel *****************/

static unsigned char	regpoly_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x00,0x00,0x00,0x04,
 0x00,0x01,0x00,0x00,0x04,0x00,0x01,0x00,0x00,0x02,0x00,
 0x02,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,
 0x00,0x80,0x00,0x00,0x08,0x00,0x80,0x00,0x00,0x08,0x00,
 0x40,0x10,0x00,0x10,0x00,0x20,0x18,0x00,0x20,0x00,0x20,
 0x10,0x07,0x20,0x00,0x10,0x10,0x07,0x40,0x00,0x20,0x10,
 0x07,0x20,0x00,0x20,0x10,0x00,0x20,0x00,0x40,0x38,0x00,
 0x10,0x00,0x80,0x00,0x00,0x08,0x00,0x80,0x00,0x00,0x08,
 0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,
 0x00,0x02,0x00,0x62,0x00,0x00,0x04,0x00,0x91,0x00,0x00,
 0x04,0xc0,0x81,0x00,0x00,0xf8,0xff,0x41,0x00,0x00,0x00,
 0xc0,0x21,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(regpoly_ic,36,32,1,regpoly_image);

static unsigned char	addpt_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0x80,0x1f,
 0x00,0x00,0x00,0x80,0x19,0x00,0x00,0x00,0x80,0x19,0x00,
 0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0xc0,0x3f,0x00,0x00,
 0x00,0x60,0x60,0x00,0x00,0x00,0x30,0xc0,0x00,0x00,0x00,
 0x18,0x80,0x01,0x00,0x00,0x0c,0x02,0x03,0x00,0x00,0x06,
 0x07,0x06,0x00,0x00,0x83,0x0a,0x0c,0x00,0x80,0x01,0x02,
 0x18,0x00,0xc0,0x00,0x02,0x30,0x00,0x60,0x00,0x02,0x60,
 0x00,0x30,0x00,0x02,0xc0,0x00,0x18,0x00,0x02,0x80,0x01,
 0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xa8,0xaa,0xaa,0xaa,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(addpt_ic,36,32,1,addpt_image);

static unsigned char	align_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x1f,0x00,0x00,0x00,0xc0,0x60,0x00,0x00,0x00,
 0x20,0x80,0x00,0x00,0x00,0x20,0x80,0x00,0x00,0x00,0x10,
 0x00,0x01,0x00,0x01,0x10,0x00,0x01,0x00,0xc1,0x13,0x00,
 0x01,0x80,0x42,0x12,0x00,0x01,0x80,0x42,0x12,0x00,0x01,
 0x40,0x44,0x22,0x80,0x00,0x40,0x44,0x22,0x80,0x00,0x20,
 0x48,0xc2,0x60,0x00,0xe0,0xcf,0x03,0x1f,0x00,0x54,0x55,
 0x55,0x55,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x31,0x00,0x00,
 0x00,0x40,0x22,0x02,0x00,0x00,0x20,0x24,0x00,0x00,0x00,
 0x20,0x24,0x63,0x35,0x00,0x20,0x24,0x92,0x4c,0x00,0xe0,
 0x27,0x92,0x44,0x00,0x20,0x24,0x62,0x44,0x00,0x20,0x24,
 0x12,0x44,0x00,0x20,0x74,0xe7,0x44,0x00,0x00,0x00,0x10,
 0x01,0x00,0x00,0x00,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(align_ic,36,32,1,align_image);

#ifdef notdef			/* not used yet in xfig */
static unsigned char	raise_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
 0xff,0x3f,0x00,0x00,0x80,0x00,0x20,0x00,0x00,0x80,0x00,
 0x20,0x00,0x00,0x80,0x00,0x20,0x00,0x00,0x80,0x00,0xe0,
 0x1f,0x00,0x80,0x00,0x20,0x11,0x00,0x80,0xff,0x3f,0x14,
 0x00,0x00,0x40,0x11,0x11,0x00,0x00,0x40,0x44,0x14,0x00,
 0x00,0x40,0x11,0x11,0x00,0x00,0xc0,0xff,0x1f,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,
 0x00,0x1c,0x00,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,
 0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x80,0xff,0x3f,0x3e,
 0x00,0x80,0x00,0x20,0x1c,0x00,0x80,0x00,0x20,0x08,0x00,
 0x80,0x00,0x20,0x00,0x00,0x80,0xc0,0xff,0x1f,0x00,0x80,
 0x40,0x11,0x11,0x00,0x80,0x7f,0x44,0x14,0x00,0x00,0x40,
 0x11,0x11,0x00,0x00,0x40,0x44,0x14,0x00,0x00,0x40,0x11,
 0x11,0x00,0x00,0xc0,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(raise_ic,36,32,1,raise_image);
#endif

static unsigned char	arc_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x80,0x38,0x00,0x00,0x00,0xc0,0xf8,
 0x00,0x00,0x00,0x80,0x38,0x03,0x00,0x00,0x80,0x00,0x0c,
 0x00,0x00,0x80,0x00,0x10,0x00,0x00,0x80,0x00,0x20,0x00,
 0x00,0xc0,0x01,0x20,0x00,0x00,0x00,0x00,0x40,0x00,0x00,
 0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x80,0x30,0x00,0x00,
 0x00,0x80,0x48,0x00,0x00,0x00,0xc0,0x41,0x00,0x00,0x00,
 0xc0,0x21,0x00,0x00,0x00,0xc0,0x11,0x00,0x00,0x00,0x80,
 0x08,0x00,0x00,0x00,0x80,0x78,0x00,0x00,0x00,0x40,0x00,
 0x00,0x00,0x00,0x40,0x00,0x00,0xc0,0x00,0x20,0x00,0x00,
 0x20,0x01,0x20,0x00,0x00,0x00,0x01,0x10,0x00,0x00,0xc0,
 0x00,0x0c,0x00,0x00,0x00,0x39,0x03,0x00,0x00,0x20,0xf9,
 0x00,0x00,0x00,0xc0,0x38,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(arc_ic,36,32,1,arc_image);

static unsigned char	autoarrow_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x07,
 0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x07,0x00,
 0x00,0x00,0x80,0x0a,0x00,0x00,0x00,0x80,0x0a,0x00,0x00,
 0x00,0x80,0x0a,0x00,0x00,0x00,0x40,0x12,0x00,0x00,0x00,
 0x40,0x12,0x00,0x00,0x00,0x40,0x12,0x00,0x00,0x00,0x20,
 0x22,0x00,0x00,0x00,0x20,0x22,0x00,0x00,0x00,0x20,0x22,
 0x00,0x00,0x00,0x10,0x42,0x00,0x00,0x00,0x10,0x42,0x00,
 0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x02,0x00,0x00,
 0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(autoarrow_ic,36,32,1,autoarrow_image);

static unsigned char	box_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0x1f,
 0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
 0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,
 0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,
 0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,
 0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,
 0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
 0x80,0x00,0x00,0x10,0x00,0x80,0xff,0xff,0x1f,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(box_ic,36,32,1,box_image);

static unsigned char	arc_box_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xfc,0xff,0x03,0x00,0x00,0x03,0x00,0x0c,
 0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
 0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,
 0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,
 0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,
 0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,
 0x00,0x40,0x00,0x00,0x20,0x00,0x80,0x00,0x00,0x10,0x00,
 0x80,0x00,0x00,0x10,0x00,0x00,0x03,0x00,0x0c,0x00,0x00,
 0xfc,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(arc_box_ic,36,32,1,arc_box_image);

static unsigned char	break_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x55,
 0x55,0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0xe0,
 0x40,0x00,0x00,0x3c,0x18,0x03,0x00,0x10,0x42,0x04,0x44,
 0x00,0x00,0x81,0x04,0x04,0x00,0x10,0x01,0x04,0x44,0x00,
 0x00,0x02,0x18,0x03,0x00,0x10,0x3c,0xe0,0x40,0x00,0x00,
 0x40,0x00,0x00,0x00,0x10,0x80,0x00,0x40,0x00,0x00,0x81,
 0x00,0x01,0x00,0x10,0x42,0x00,0x42,0x00,0x00,0x3c,0x00,
 0x04,0x00,0x10,0x00,0xfe,0x48,0x00,0x00,0x00,0x10,0x08,
 0x00,0x10,0x00,0x10,0x48,0x00,0x00,0xff,0x10,0x08,0x00,
 0x10,0x81,0x10,0x48,0x00,0x00,0x81,0x10,0x04,0x00,0x10,
 0x81,0x10,0x42,0x00,0x00,0xff,0x10,0x01,0x00,0x10,0x00,
 0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x55,0x55,
 0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(break_ic,36,32,1,break_image);

static unsigned char	cirrad_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x80,0x3f,0x00,0x00,0x00,0x60,0xc0,0x00,0x00,0x00,0x18,
 0x00,0x03,0x00,0x00,0x04,0x00,0x04,0x00,0x00,0x02,0x00,
 0x08,0x00,0x00,0x01,0x00,0x10,0x00,0x80,0x00,0x00,0x20,
 0x00,0x80,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x40,0x00,
 0x40,0x00,0x00,0x40,0x00,0x20,0x00,0x00,0x80,0x00,0x20,
 0x00,0x00,0x80,0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,
 0xae,0xaa,0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,0x00,
 0x80,0x00,0x20,0x00,0x00,0x80,0x00,0x40,0x00,0x00,0x40,
 0x00,0x40,0x00,0x00,0x40,0x00,0x80,0x00,0x00,0x20,0x00,
 0x80,0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,0x00,
 0x02,0x00,0x08,0x00,0x00,0x04,0x00,0x04,0x00,0x00,0x18,
 0x00,0x03,0x00,0x00,0x60,0xc0,0x00,0x00,0x00,0x80,0x3f,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(cirrad_ic,36,32,1,cirrad_image);

static unsigned char	cirdia_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x80,0x3f,0x00,0x00,0x00,0x60,0xc0,0x00,0x00,0x00,0x18,
 0x00,0x03,0x00,0x00,0x04,0x00,0x04,0x00,0x00,0x02,0x00,
 0x08,0x00,0x00,0x01,0x00,0x10,0x00,0x80,0x00,0x00,0x20,
 0x00,0x80,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x40,0x00,
 0x40,0x00,0x00,0x40,0x00,0x20,0x00,0x00,0x80,0x00,0x20,
 0x00,0x00,0x80,0x00,0x20,0x00,0x04,0x80,0x00,0xa0,0xaa,
 0xae,0xaa,0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,0x00,
 0x80,0x00,0x20,0x00,0x00,0x80,0x00,0x40,0x00,0x00,0x40,
 0x00,0x40,0x00,0x00,0x40,0x00,0x80,0x00,0x00,0x20,0x00,
 0x80,0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,0x00,
 0x02,0x00,0x08,0x00,0x00,0x04,0x00,0x04,0x00,0x00,0x18,
 0x00,0x03,0x00,0x00,0x60,0xc0,0x00,0x00,0x00,0x80,0x3f,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(cirdia_ic,36,32,1,cirdia_image);

static unsigned char	c_spl_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
 0x1f,0x00,0x00,0x00,0x1c,0x60,0x00,0x00,0x00,0x02,0x80,
 0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x01,0x00,0x01,
 0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
 0x00,0x02,0x30,0x00,0x00,0x00,0x3c,0x0c,0x00,0x00,0x00,
 0xc0,0x7f,0x00,0x00,0x00,0x30,0x80,0x07,0x00,0x00,0x0c,
 0x00,0x08,0x00,0x00,0x03,0x00,0x10,0x00,0x80,0x00,0x00,
 0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,
 0x00,0x20,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x20,0x00,
 0x20,0x00,0x00,0x10,0x00,0x40,0x00,0x00,0x08,0x00,0x40,
 0x00,0x00,0x04,0x00,0x80,0x00,0x00,0x03,0x00,0x00,0x07,
 0xf0,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(c_spl_ic,36,32,1,c_spl_image);

static unsigned char	copy_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
 0x03,0x00,0x1c,0x00,0xc0,0x07,0x00,0x3e,0x00,0x60,0x0c,
 0x00,0x63,0x00,0x30,0x0c,0x80,0x61,0x00,0x30,0x0c,0x80,
 0x61,0x00,0x30,0x0c,0x80,0x61,0x00,0x30,0x18,0x88,0xc1,
 0x00,0x30,0x18,0x90,0xc1,0x00,0x30,0xd8,0xbf,0xc1,0x00,
 0x30,0x18,0x90,0xc1,0x00,0x30,0x18,0x88,0xc1,0x00,0x30,
 0x0c,0x80,0x61,0x00,0x60,0x0c,0x00,0x63,0x00,0xc0,0x0c,
 0x00,0x66,0x00,0x80,0x0f,0x00,0x7c,0x00,0x00,0x07,0x00,
 0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x07,0x00,0x00,0x00,0x80,0x08,0x00,0x00,0x00,
 0x80,0x00,0x00,0x00,0x00,0x80,0xc0,0x69,0x22,0x00,0x80,
 0x20,0x9a,0x22,0x00,0x80,0x20,0x8a,0x22,0x00,0x80,0x28,
 0x9a,0x32,0x00,0x00,0xc7,0x69,0x2c,0x00,0x00,0x00,0x08,
 0x20,0x00,0x00,0x00,0x08,0x1e,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(copy_ic,36,32,1,copy_image);

static unsigned char	glue_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x38,0x00,0x00,0xe0,0x00,0xf8,0xff,
 0xff,0xff,0x00,0x38,0x00,0x00,0xe0,0x00,0x10,0x00,0xe0,
 0x40,0x00,0x10,0x3c,0x18,0x43,0x00,0x10,0x42,0x04,0x44,
 0x00,0x10,0x81,0x04,0x44,0x00,0x10,0x01,0x04,0x44,0x00,
 0x10,0x02,0x18,0x43,0x00,0x10,0x3c,0xe0,0x40,0x00,0x10,
 0x40,0x00,0x40,0x00,0x10,0x80,0x00,0x40,0x00,0x10,0x81,
 0x00,0x41,0x00,0x10,0x42,0x00,0x42,0x00,0x10,0x3c,0x00,
 0x44,0x00,0x10,0x00,0xfe,0x48,0x00,0x10,0x00,0x10,0x48,
 0x00,0x10,0x00,0x10,0x48,0x00,0x10,0xff,0x10,0x48,0x00,
 0x10,0x81,0x10,0x48,0x00,0x10,0x81,0x10,0x44,0x00,0x10,
 0x81,0x10,0x42,0x00,0x10,0xff,0x10,0x41,0x00,0x10,0x00,
 0x00,0x40,0x00,0x38,0x00,0x00,0xe0,0x00,0xf8,0xff,0xff,
 0xff,0x00,0x38,0x00,0x00,0xe0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(glue_ic,36,32,1,glue_image);

static unsigned char	deletept_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xc0,0x01,0x00,0x00,0x00,0x40,0x01,0x00,0x00,0x00,0xc0,
 0x01,0x00,0x00,0x80,0xc7,0x00,0x00,0x00,0x00,0xa9,0x00,
 0x00,0x00,0x00,0xb2,0x00,0x00,0x00,0x00,0xa4,0x00,0x00,
 0x00,0x00,0xc8,0x00,0x00,0x00,0x10,0x98,0x00,0x00,0x00,
 0x70,0x28,0x01,0x00,0x00,0x90,0x45,0x02,0x00,0x00,0x30,
 0x86,0x04,0x00,0x00,0xc0,0x9a,0x09,0x00,0x00,0x00,0xe3,
 0x12,0x00,0x00,0x00,0x8d,0x25,0x00,0x00,0x00,0xb1,0x4e,
 0x00,0x00,0x80,0xc0,0x58,0x00,0x00,0x80,0x80,0xe3,0x38,
 0x00,0x40,0x80,0xfe,0x7d,0x00,0x40,0x80,0xc0,0xcf,0x00,
 0x20,0x80,0x80,0x9d,0x00,0x20,0x80,0xc0,0xf3,0x00,0x10,
 0x80,0xc0,0x66,0x00,0x10,0x80,0xc0,0x0c,0x00,0x00,0x80,
 0x80,0x09,0x00,0x00,0x80,0x00,0x0b,0x00,0x00,0x80,0x00,
 0x0e,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(deletept_ic,36,32,1,deletept_image);

static unsigned char	ellrad_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,
 0x00,0x00,0x00,0x70,0xc0,0x01,0x00,0x00,0x0c,0x04,0x06,
 0x00,0x00,0x02,0x00,0x08,0x00,0x00,0x01,0x04,0x10,0x00,
 0x80,0x00,0x00,0x20,0x00,0x40,0x00,0x04,0x40,0x00,0x40,
 0x00,0x00,0x40,0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,
 0xae,0xaa,0x00,0x20,0x00,0x04,0x80,0x00,0x40,0x00,0x00,
 0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x80,0x00,0x00,0x20,
 0x00,0x00,0x01,0x00,0x10,0x00,0x00,0x02,0x00,0x08,0x00,
 0x00,0x0c,0x00,0x06,0x00,0x00,0x70,0xc0,0x01,0x00,0x00,
 0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(ellrad_ic,36,32,1,ellrad_image);

static unsigned char	elldia_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,
 0x00,0x00,0x00,0x70,0xc0,0x01,0x00,0x00,0x0c,0x04,0x06,
 0x00,0x00,0x02,0x00,0x08,0x00,0x00,0x01,0x04,0x10,0x00,
 0x80,0x00,0x00,0x20,0x00,0x40,0x00,0x04,0x40,0x00,0x40,
 0x00,0x00,0x40,0x00,0x20,0x00,0x04,0x80,0x00,0xa0,0xaa,
 0xae,0xaa,0x00,0x20,0x00,0x04,0x80,0x00,0x40,0x00,0x00,
 0x40,0x00,0x40,0x00,0x04,0x40,0x00,0x80,0x00,0x00,0x20,
 0x00,0x00,0x01,0x04,0x10,0x00,0x00,0x02,0x00,0x08,0x00,
 0x00,0x0c,0x04,0x06,0x00,0x00,0x70,0xc0,0x01,0x00,0x00,
 0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(elldia_ic,36,32,1,elldia_image);

static unsigned char	flip_x_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,
 0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0xa0,0x00,
 0x00,0x00,0x00,0xa0,0x00,0x04,0x00,0x00,0x10,0x01,0x02,
 0x00,0x00,0x10,0x01,0x0f,0x00,0x00,0x08,0x02,0x32,0x00,
 0x00,0x08,0x02,0x44,0x00,0x00,0x04,0x04,0x40,0x00,0x00,
 0xfc,0x07,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x50,0x55,
 0x55,0x81,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0xfc,0x07,
 0x80,0x00,0x00,0x04,0x04,0x40,0x00,0x00,0x08,0x02,0x44,
 0x00,0x00,0x08,0x02,0x32,0x00,0x00,0x10,0x01,0x0f,0x00,
 0x00,0x10,0x01,0x02,0x00,0x00,0xa0,0x00,0x04,0x00,0x00,
 0xa0,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x40,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(flip_x_ic,36,32,1,flip_x_image);

static unsigned char	flip_y_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x1c,0xc0,0x01,0x00,0x00,0x22,
 0x22,0x02,0x00,0x00,0x41,0x10,0x04,0x00,0x00,0x41,0x12,
 0x04,0x00,0x00,0x41,0x10,0x04,0x00,0x00,0x22,0x22,0x02,
 0x00,0x00,0x14,0x40,0x01,0x00,0x00,0x14,0x42,0x01,0x00,
 0x80,0xe3,0x38,0x0e,0x00,0x40,0x00,0x07,0x10,0x00,0x20,
 0xc3,0x18,0x24,0x00,0x90,0x22,0x27,0x4a,0x00,0x50,0x22,
 0x22,0x52,0x00,0x30,0x41,0x10,0x64,0x00,0x00,0x41,0x12,
 0x04,0x00,0x80,0x80,0x08,0x08,0x00,0x80,0x80,0x0a,0x08,
 0x00,0x40,0x00,0x05,0x10,0x00,0xc0,0xeb,0xbf,0x1e,0x00,
 0x00,0x2a,0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,
 0x2a,0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,0x2a,
 0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,0x3e,0xe0,
 0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(flip_y_ic,36,32,1,flip_y_image);

static unsigned char	intspl_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0xe0,
 0x1f,0x00,0x00,0x00,0x1c,0xe7,0x03,0x00,0x00,0x02,0x80,
 0x03,0x00,0x00,0x01,0x80,0x03,0x00,0x80,0x03,0x00,0x00,
 0x00,0x80,0x03,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x3c,0x0e,0x00,0x00,0x00,
 0xc0,0x7f,0x00,0x00,0x00,0x00,0x8e,0x07,0x00,0x00,0x00,
 0x00,0x08,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x20,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x70,
 0x00,0xe0,0x00,0x00,0x70,0x00,0xe0,0x00,0x00,0x20,0x00,
 0xe0,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x0c,0x00,0x00,
 0x01,0x00,0x03,0x00,0x00,0x8e,0xe3,0x00,0x00,0x00,0xf0,
 0x1f,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(intspl_ic,36,32,1,intspl_image);

static unsigned char	c_intspl_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0xe0,
 0x1f,0x00,0x00,0x00,0x9c,0x63,0x00,0x00,0x00,0x02,0xc0,
 0x01,0x00,0x80,0x03,0xc0,0x01,0x00,0x80,0x03,0xc0,0x01,
 0x00,0x80,0x03,0x80,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
 0x00,0x02,0x30,0x00,0x00,0x00,0x3c,0x1c,0x00,0x00,0x00,
 0xc0,0x7f,0x00,0x00,0x00,0x30,0x9c,0x07,0x00,0x00,0x0c,
 0x00,0x08,0x00,0x00,0x03,0x00,0x10,0x00,0x80,0x00,0x00,
 0x20,0x00,0x40,0x00,0x00,0x70,0x00,0x40,0x00,0x00,0x70,
 0x00,0xe0,0x00,0x00,0x70,0x00,0xe0,0x00,0x00,0x20,0x00,
 0xe0,0x00,0x00,0x10,0x00,0x40,0x00,0x00,0x08,0x00,0x40,
 0x00,0x00,0x04,0x00,0x80,0x00,0x00,0x03,0x00,0x00,0xc7,
 0xf1,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0xc0,0x01,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(c_intspl_ic,36,32,1,c_intspl_image);

static unsigned char	line_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x20,0x00,0x04,0x00,0x00,0x30,0x00,
 0x0c,0x00,0x00,0x50,0x00,0x0c,0x00,0x00,0x48,0x00,0x14,
 0x00,0x00,0x88,0x00,0x14,0x00,0x00,0x84,0x00,0x14,0x00,
 0x00,0x04,0x01,0x22,0x00,0x00,0x02,0x01,0x22,0x00,0x00,
 0x02,0x02,0x22,0x00,0x00,0x01,0x02,0x42,0x00,0x00,0x01,
 0x04,0x42,0x00,0x80,0x00,0x04,0x42,0x00,0x80,0x00,0x02,
 0x01,0x00,0x40,0x00,0x01,0x01,0x00,0x40,0x80,0x00,0x01,
 0x00,0x20,0x40,0x00,0x01,0x00,0x20,0x20,0x00,0x01,0x00,
 0x00,0x10,0x00,0x01,0x00,0x00,0x08,0x80,0x00,0x00,0x00,
 0x30,0x40,0x00,0x00,0x00,0xc0,0x20,0x00,0x00,0x00,0x00,
 0x13,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(line_ic,36,32,1,line_image);

static unsigned char	move_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x80,0x02,0x00,0x1c,0x00,0x20,0x00,
 0x00,0x3e,0x00,0x10,0x04,0x00,0x63,0x00,0x00,0x00,0x80,
 0x61,0x00,0x10,0x04,0x80,0x61,0x00,0x00,0x08,0x80,0x61,
 0x00,0x10,0x00,0x88,0xc1,0x00,0x00,0x08,0x90,0xc1,0x00,
 0x10,0xc0,0xbf,0xc1,0x00,0x00,0x08,0x90,0xc1,0x00,0x10,
 0x00,0x88,0xc1,0x00,0x00,0x04,0x80,0x61,0x00,0x20,0x00,
 0x00,0x63,0x00,0x00,0x04,0x00,0x66,0x00,0x80,0x02,0x00,
 0x7c,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x04,0x00,0x00,0x00,
 0xc0,0x06,0x00,0x00,0x00,0xc0,0xc6,0x89,0x1c,0x00,0x40,
 0x25,0x8a,0x22,0x00,0x40,0x25,0x8a,0x3e,0x00,0x40,0x24,
 0x52,0x02,0x00,0x40,0x24,0x52,0x22,0x00,0x40,0xc4,0x21,
 0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(move_ic,36,32,1,move_image);

static unsigned char	movept_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0xa0,0x02,
 0x08,0x7e,0x00,0x00,0x00,0x10,0x66,0x00,0x20,0xe2,0x3f,
 0x66,0x00,0x00,0x00,0x10,0x7e,0x00,0xa0,0x02,0x08,0x7e,
 0x00,0x00,0x00,0x00,0x1c,0x00,0x80,0x02,0x00,0x1e,0x00,
 0x00,0x00,0x00,0x1b,0x00,0x80,0x08,0x80,0x19,0x00,0x00,
 0x00,0xc0,0x18,0x00,0x80,0x20,0x60,0x18,0x00,0x00,0x00,
 0x30,0x18,0x00,0x80,0x80,0x18,0x18,0x00,0x00,0x00,0x0c,
 0x18,0x00,0x80,0x00,0x06,0x18,0x00,0x00,0x00,0x03,0x18,
 0x00,0x80,0x80,0x09,0x18,0x00,0x00,0xc0,0x00,0x18,0x00,
 0x80,0x60,0x20,0x18,0x00,0x00,0x30,0x00,0x18,0x00,0x80,
 0x18,0x80,0x18,0x00,0x00,0x0c,0x00,0x18,0x00,0x80,0x06,
 0x00,0x1a,0x00,0x00,0x03,0x00,0x18,0x00,0x80,0x01,0x00,
 0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(movept_ic,36,32,1,movept_image);

static unsigned char	polygon_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
 0x7f,0x00,0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x01,0x00,
 0x01,0x00,0x00,0x01,0x00,0x02,0x00,0x00,0x01,0x00,0x04,
 0x00,0x00,0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x08,0x00,
 0x00,0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x08,0x00,0x00,
 0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,
 0x00,0x02,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x01,0x80,
 0x00,0x00,0x00,0x01,0x7f,0x00,0x00,0x00,0x01,0x01,0x00,
 0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,
 0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,
 0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,
 0x01,0x00,0x00,0x00,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(polygon_ic,36,32,1,polygon_image);

static unsigned char	delete_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0xc0,
 0x0f,0x00,0x00,0x00,0xe0,0x1f,0x00,0x00,0x00,0x30,0x33,
 0x00,0x00,0x00,0x30,0x33,0x00,0x00,0x00,0xe0,0x1f,0x00,
 0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0x80,0x07,0x00,0x00,
 0x00,0x84,0x87,0x00,0x00,0x00,0x84,0x87,0x01,0x00,0x00,
 0x08,0x43,0x00,0x00,0x00,0x70,0x38,0x00,0x00,0x00,0x80,
 0x07,0x00,0x00,0x00,0xe0,0x1f,0x01,0x00,0x00,0x3c,0xf0,
 0x01,0x00,0x00,0x04,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0xc0,0x00,0x02,0x00,
 0x48,0x80,0x00,0x07,0x00,0x48,0x8e,0x38,0xc2,0x01,0x48,
 0x91,0x44,0x22,0x02,0x48,0x9f,0x7c,0xe2,0x03,0x48,0x81,
 0x04,0x22,0x00,0x48,0x91,0x44,0x2a,0x02,0x3c,0xce,0x39,
 0xc4,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(delete_ic,36,32,1,delete_image);

static unsigned char	rotCCW_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x80,
 0x02,0x00,0x00,0x00,0x40,0x1e,0x00,0x00,0x00,0x20,0x60,
 0x00,0x00,0x00,0x20,0x80,0x00,0x00,0x00,0x40,0x1e,0x01,
 0x00,0x00,0x80,0x22,0x01,0x00,0x00,0x00,0x43,0x02,0x00,
 0x00,0x00,0x42,0x02,0x00,0x00,0x78,0x40,0x02,0x00,0x00,
 0x48,0x40,0x02,0x00,0x00,0x48,0x40,0x02,0x00,0x00,0x90,
 0x20,0x01,0x00,0x00,0x10,0x1f,0x01,0x00,0x00,0x20,0x80,
 0x00,0x00,0x00,0xc0,0x60,0x00,0x00,0x00,0x00,0x1f,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x3c,0x80,0x00,0x04,0x00,0x44,0x80,0x00,0x04,0x00,0x44,
 0xce,0x71,0x8e,0x01,0x44,0x91,0x80,0x44,0x02,0x3c,0x91,
 0xf8,0xc4,0x03,0x44,0x91,0x88,0x44,0x00,0x44,0x91,0xca,
 0x54,0x02,0x44,0x0e,0xb1,0x88,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(rotCCW_ic,36,32,1,rotCCW_image);

static unsigned char	scale_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,
 0x00,0x04,0x00,0x00,0x00,0x00,0x0a,0x00,0x40,0x20,0x04,
 0x0a,0x00,0x40,0x10,0x08,0x11,0x00,0xa0,0xf8,0x1f,0x11,
 0x00,0xa0,0x10,0x88,0x20,0x00,0x10,0x21,0x84,0x20,0x00,
 0xf0,0x01,0x40,0x40,0x00,0x00,0x00,0x40,0x40,0x00,0x00,
 0x00,0x20,0x80,0x00,0x00,0x00,0x20,0x80,0x00,0x00,0x00,
 0x10,0x00,0x01,0x00,0x00,0xf0,0xff,0x01,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xe0,0x00,0xc0,0x00,0x00,0x10,0x01,0x80,0x00,0x00,
 0x10,0x00,0x80,0x00,0x00,0x10,0x38,0x8e,0x38,0x00,0xe0,
 0x44,0x90,0x44,0x00,0x00,0x05,0x9e,0x7c,0x00,0x00,0x05,
 0x91,0x04,0x00,0x10,0x45,0x99,0x44,0x00,0xe0,0x38,0xd6,
 0x39,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(scale_ic,36,32,1,scale_image);

static unsigned char	convert_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,
 0x00,0x80,0x00,0x00,0x01,0x00,0x40,0x00,0x80,0x00,0x00,
 0x20,0x00,0x40,0x00,0x00,0x10,0x00,0x20,0x00,0x00,0x08,
 0x00,0x20,0x00,0x00,0x04,0x00,0x10,0x00,0x00,0x02,0x00,
 0x10,0x00,0x00,0x01,0x00,0x10,0x00,0x80,0x00,0x00,0x10,
 0x00,0x40,0x00,0x00,0x20,0x00,0x80,0x00,0x00,0x20,0x00,
 0x00,0x01,0x00,0x40,0x00,0x00,0x02,0x00,0x40,0x00,0x00,
 0x04,0x00,0x80,0x00,0x00,0x08,0x00,0x80,0x40,0x20,0x10,
 0x00,0x00,0x21,0x40,0x20,0x00,0x00,0xf1,0xff,0x40,0x00,
 0x00,0x21,0x40,0x20,0x00,0x80,0x40,0x20,0x10,0x00,0x80,
 0x00,0x00,0x08,0x00,0x40,0x00,0x00,0x04,0x00,0x20,0x00,
 0x00,0x02,0x00,0x10,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(convert_ic,36,32,1,convert_image);

static unsigned char	spl_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,
 0x0f,0x00,0x00,0x00,0x0e,0x70,0x00,0x00,0x00,0x01,0x80,
 0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,
 0x00,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,
 0x00,0x01,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x00,
 0xe0,0x3f,0x00,0x00,0x00,0x00,0xc0,0x03,0x00,0x00,0x00,
 0x00,0x04,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x10,
 0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x08,0x00,
 0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x02,0x00,0x00,
 0x02,0x80,0x01,0x00,0x00,0x1c,0x78,0x00,0x00,0x00,0xe0,
 0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(spl_ic,36,32,1,spl_image);

static unsigned char	text_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,
 0x1f,0x00,0x80,0x83,0x1f,0x1c,0x00,0x80,0x01,0x0f,0x18,
 0x00,0x80,0x00,0x0f,0x10,0x00,0x00,0x00,0x0f,0x00,0x00,
 0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
 0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,
 0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,
 0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,
 0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,
 0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
 0x80,0x1f,0x00,0x00,0x00,0xe0,0x7f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(text_ic,36,32,1,text_image);

static unsigned char	epsobj_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0x01,0x00,0x00,
 0x10,0x00,0x01,0x7c,0x00,0x90,0x77,0x01,0x04,0x00,0x90,
 0x4c,0x01,0x04,0x00,0x10,0x65,0x01,0x04,0x8d,0x91,0x3f,
 0x01,0x3c,0x53,0x52,0x4e,0x01,0x04,0x91,0x50,0x55,0x01,
 0x04,0x13,0xd1,0x74,0x01,0x04,0x4d,0x12,0x04,0x01,0x7c,
 0x81,0x91,0x37,0x01,0x00,0x01,0x10,0x1e,0x01,0x00,0x01,
 0x10,0x0c,0x01,0x00,0x00,0x10,0x04,0x01,0x00,0x00,0x10,
 0x00,0x01,0x00,0x00,0xf0,0xff,0x01,0x38,0x00,0x00,0x00,
 0x00,0x44,0x01,0x02,0x80,0x00,0x44,0x01,0x00,0x80,0x00,
 0x44,0x0d,0x73,0xcc,0x01,0x44,0x13,0x8a,0x92,0x00,0x44,
 0x11,0xfa,0x82,0x00,0x44,0x11,0x0a,0x82,0x00,0x44,0x13,
 0x8a,0x92,0x02,0x38,0x4d,0x72,0x0c,0x01,0x00,0x80,0x01,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(epsobj_ic,36,32,1,epsobj_image);

static unsigned char	rotCW_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x08,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,
 0x28,0x00,0x00,0x00,0x00,0x4f,0x00,0x00,0x00,0xc0,0x80,
 0x00,0x00,0x00,0x20,0x80,0x00,0x00,0x00,0x10,0x4f,0x00,
 0x00,0x00,0x90,0x28,0x00,0x00,0x00,0x48,0x18,0x00,0x00,
 0x00,0x48,0x08,0x00,0x00,0x00,0x48,0xc0,0x03,0x00,0x00,
 0x48,0x40,0x02,0x00,0x00,0x48,0x40,0x02,0x00,0x00,0x90,
 0x20,0x01,0x00,0x00,0x10,0x1f,0x01,0x00,0x00,0x20,0x80,
 0x00,0x00,0x00,0xc0,0x60,0x00,0x00,0x00,0x00,0x1f,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x3c,0x80,0x00,0x04,0x00,0x44,0x80,0x00,0x04,0x00,0x44,
 0xce,0x71,0x8e,0x01,0x44,0x91,0x80,0x44,0x02,0x3c,0x91,
 0xf8,0xc4,0x03,0x44,0x91,0x88,0x44,0x00,0x44,0x91,0xca,
 0x54,0x02,0x44,0x0e,0xb1,0x88,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(rotCW_ic,36,32,1,rotCW_image);

static unsigned char	update_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xc0,0x07,0xff,0xff,0x01,0x60,0x0d,
 0x01,0x00,0x01,0xb0,0x1a,0x01,0x3e,0x01,0x50,0x35,0x3d,
 0x2a,0x01,0xb0,0x2a,0x01,0x36,0x01,0x50,0x35,0x7d,0x2a,
 0x01,0xb0,0x2a,0x01,0x3e,0x01,0x60,0x35,0x01,0x00,0x01,
 0xc0,0x1f,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
 0x01,0x00,0x01,0x00,0x80,0x03,0x80,0x03,0x00,0x40,0x05,
 0x40,0x05,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0xff,0xff,
 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x24,0x00,0x02,0x04,0x00,0x24,0x00,0x02,0x04,0x00,
 0xa4,0xc6,0x72,0x8e,0x01,0xa4,0x29,0x83,0x44,0x02,0xa4,
 0x28,0xfa,0xc4,0x03,0xa4,0x29,0x8a,0x44,0x00,0xa4,0x26,
 0xcb,0x54,0x02,0x98,0xc0,0xb2,0x88,0x01,0x80,0x00,0x00,
 0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(update_ic,36,32,1,update_image);

static unsigned char	change_image[160] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xa7,
 0xaa,0xff,0x00,0x60,0x0c,0x80,0x80,0x00,0x20,0x18,0x80,
 0x8e,0x00,0x30,0x30,0x80,0x80,0x00,0x10,0x20,0x80,0x9e,
 0x00,0x30,0x20,0x80,0x80,0x00,0x60,0x30,0x80,0x86,0x00,
 0xc0,0x18,0x80,0x80,0x00,0x80,0x0f,0x80,0xbe,0x00,0x00,
 0x20,0x80,0x80,0x00,0x00,0x80,0x80,0xbe,0x00,0x00,0x00,
 0x82,0x80,0x00,0x00,0x00,0x88,0x80,0x00,0x00,0x00,0xa0,
 0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x1f,0x04,0x00,0x00,0x00,0x01,0x44,0x04,0x00,
 0x00,0x01,0x04,0x04,0x00,0x00,0x81,0x65,0x0e,0x00,0x00,
 0x4f,0x46,0x04,0x00,0x00,0x41,0x44,0x04,0x00,0x00,0x41,
 0x44,0x04,0x00,0x00,0x41,0x46,0x14,0x00,0x00,0x9f,0xe5,
 0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(change_ic,36,32,1,change_image);

/********* icons for indicator panel **********/

static unsigned char	smartoff_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
 0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
 0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
 0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
 0x40,0x40,0x40,0x00,0xc0,0x3f,0x00,0x00,0x00,0x40,0x40,
 0x08,0x00,0x00,0x00,0x08,0x00,0x40,0x55,0x08,0x00,0x00,
 0x00,0x08,0x00,0xc0,0x7f,0x08,0x00,0x40,0x40,0x2a,0x00,
 0x40,0x40,0x1c,0x00,0x40,0x40,0x08,0x00,0x40,0x40,0x00,
 0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
 0x00,0x80,0xe3,0xf3,0x01,0x40,0x24,0x10,0x00,0x40,0xe4,
 0x70,0x00,0x40,0x24,0x10,0x00,0x80,0x23,0x10,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(smartoff_ic,32,32,1,smartoff_image);

static unsigned char	smartmove_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
 0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
 0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
 0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
 0x40,0x40,0x40,0x00,0x40,0x15,0x00,0x00,0x40,0x40,0x40,
 0x08,0x80,0x00,0x00,0x08,0x00,0x41,0x55,0x08,0x00,0x02,
 0x00,0x08,0x00,0xc4,0x7f,0x08,0x00,0x48,0x40,0x2a,0x00,
 0x50,0x40,0x1c,0x00,0x60,0x40,0x08,0x00,0x40,0x40,0x00,
 0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
 0x00,0x88,0x38,0x22,0x1f,0xd8,0x44,0x22,0x01,0xa8,0x44,
 0x22,0x07,0x88,0x44,0x14,0x01,0x88,0x38,0x08,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(smartmove_ic,32,32,1,smartmove_image);

static unsigned char	smartslide_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
 0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
 0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
 0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
 0x40,0x40,0x40,0x00,0x40,0x15,0x00,0x00,0x40,0x40,0x40,
 0x08,0x40,0x00,0x00,0x08,0x40,0x40,0x55,0x08,0x40,0x00,
 0x00,0x08,0x40,0xc0,0x7f,0x08,0x40,0x40,0x40,0x2a,0x40,
 0x40,0x40,0x1c,0xc0,0x7f,0x40,0x08,0x00,0x40,0x40,0x00,
 0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
 0x00,0x70,0x82,0x73,0x1e,0x08,0x02,0x91,0x02,0x70,0x02,
 0x91,0x0e,0x80,0x02,0x91,0x02,0x70,0x9e,0x73,0x1e,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(smartslide_ic,32,32,1,smartslide_image);

static unsigned char	solidline_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

mpr_static(solidline_ic,32,32,1,solidline_image);

static unsigned char	dashline_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x7c,0x7c,0x7c,0x7c,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

mpr_static(dashline_ic,32,32,1,dashline_image);

static unsigned char	dottedline_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x08,0x21,0x84,0x10,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

mpr_static(dottedline_ic,32,32,1,dottedline_image);

static unsigned char	grid1_image[128] = {
 0x08,0x82,0x20,0x08,0x08,0x82,0x20,0x08,0x08,0x82,0x20,
 0x08,0x08,0x82,0x20,0x08,0xff,0xff,0xff,0xff,0x08,0x82,
 0x20,0x08,0x08,0x82,0x20,0x08,0x08,0x82,0x20,0x08,0x08,
 0x82,0x20,0x08,0x08,0x82,0x20,0x08,0xff,0xff,0xff,0xff,
 0x08,0x82,0x20,0x08,0x08,0x82,0x20,0x08,0x08,0x82,0x20,
 0x08,0x08,0x82,0x20,0x08,0x08,0x82,0x20,0x08,0xff,0xff,
 0xff,0xff,0x08,0x82,0x20,0x08,0x08,0x82,0x20,0x08,0x08,
 0x82,0x20,0x08,0x08,0x82,0x20,0x08,0x08,0x82,0x20,0x08,
 0xff,0xff,0xff,0xff,0x08,0x82,0x20,0x08,0x08,0x82,0x20,
 0x08,0x08,0x82,0x20,0x08,0x08,0x82,0x20,0x08,0x08,0x82,
 0x20,0x08,0xff,0xff,0xff,0xff,0x08,0x82,0x20,0x08,0x08,
0x82,0x20,0x08,0x08,0x82,0x20,0x08,};

mpr_static(grid1_ic,32,32,1,grid1_image);

static unsigned char	grid2_image[128] = {
 0x08,0x80,0x00,0x08,0x08,0x80,0x00,0x08,0x08,0x80,0x00,
 0x08,0x08,0x80,0x00,0x08,0xff,0xff,0xff,0xff,0x08,0x80,
 0x00,0x08,0x08,0x80,0x00,0x08,0x08,0x80,0x00,0x08,0x08,
 0x80,0x00,0x08,0x08,0x80,0x00,0x08,0x08,0x80,0x00,0x08,
 0x08,0x80,0x00,0x08,0x08,0x80,0x00,0x08,0x08,0x80,0x00,
 0x08,0x08,0x80,0x00,0x08,0x08,0x80,0x00,0x08,0xff,0xff,
 0xff,0xff,0x08,0x80,0x00,0x08,0x08,0x80,0x00,0x08,0x08,
 0x80,0x00,0x08,0x08,0x80,0x00,0x08,0x08,0x80,0x00,0x08,
 0x08,0x80,0x00,0x08,0x08,0x80,0x00,0x08,0x08,0x80,0x00,
 0x08,0x08,0x80,0x00,0x08,0x08,0x80,0x00,0x08,0x08,0x80,
 0x00,0x08,0xff,0xff,0xff,0xff,0x08,0x80,0x00,0x08,0x08,
0x80,0x00,0x08,0x08,0x80,0x00,0x08,};

mpr_static(grid2_ic,32,32,1,grid2_image);

static unsigned char	fine_grid_image[128] = {
 0x00,0x00,0x00,0x00,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
 0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,
 0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
 0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
 0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,
 0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,
 0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
 0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
 0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,
 0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(fine_grid_ic,32,32,1,fine_grid_image);

static unsigned char	unconstrained_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xa0,0xfa,0x01,0x00,0x08,0xf4,0x01,0x00,0x02,
 0xe0,0x01,0x00,0x00,0xc4,0x02,0x80,0x00,0x00,0x06,0x00,
 0x00,0x02,0x08,0x20,0x00,0x00,0x0c,0x00,0x00,0x02,0x16,
 0x10,0x00,0x80,0x13,0x00,0x00,0xe2,0x10,0x08,0x00,0x70,
 0x20,0x00,0x00,0x19,0xf8,0x08,0x00,0x0e,0x70,0x00,0x00,
 0x03,0x70,0x08,0x00,0x14,0x70,0x00,0x00,0x42,0x20,0x08,
 0x00,0x00,0x21,0x00,0x00,0x08,0x04,0x10,0x00,0x00,0x10,
 0x00,0x00,0x10,0x00,0x20,0x00,0x00,0x08,0x00,0x00,0x20,
 0x00,0x80,0x00,0x00,0x02,0x00,0x00,0x40,0x00,0x00,0x02,
 0x80,0x00,0x00,0x08,0x20,0x00,0x00,0xa0,0x0a,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

mpr_static(unconstrained_ic,32,32,1,unconstrained_image);

static unsigned char	latexline_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,
 0x00,0x00,0xf8,0x01,0x00,0x00,0x0f,0x00,0x00,0x80,0xf7,
 0x03,0x00,0x80,0x09,0xfc,0x00,0x40,0x31,0x00,0x0f,0x20,
 0xc1,0x00,0x00,0x10,0x01,0x01,0x00,0x10,0x01,0x06,0x00,
 0x08,0x01,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x18,0xf0,0x83,0x61,0x18,0xf3,0x03,0x33,0x98,
 0xc4,0x00,0x33,0x98,0xc4,0x00,0x1e,0x98,0xc7,0x3e,0x0c,
 0x98,0xc4,0x06,0x0c,0x98,0xc4,0x06,0x1e,0x18,0xc0,0x06,
 0x33,0xf8,0xc1,0x1e,0x33,0xf8,0xc1,0x86,0x61,0x00,0x00,
 0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x3e,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

mpr_static(latexline_ic,32,32,1,latexline_image);

static unsigned char	latexarrow_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x1f,
 0x00,0x00,0xf8,0x0c,0x00,0x00,0x0f,0x00,0x00,0x80,0xf7,
 0x03,0x00,0x80,0x09,0xfc,0x06,0x40,0x31,0x00,0x0f,0x20,
 0xc1,0x02,0x1f,0x98,0x03,0x03,0x00,0xb8,0x03,0x07,0x00,
 0x18,0x01,0x0f,0x00,0x08,0x01,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x18,0xf0,0x83,0x61,0x18,0xf3,0x03,0x33,0x98,
 0xc4,0x00,0x33,0x98,0xc4,0x00,0x1e,0x98,0xc7,0x3e,0x0c,
 0x98,0xc4,0x06,0x0c,0x98,0xc4,0x06,0x1e,0x18,0xc0,0x06,
 0x33,0xf8,0xc1,0x1e,0x33,0xf8,0xc1,0x86,0x61,0x00,0x00,
 0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x3e,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

mpr_static(latexarrow_ic,32,32,1,latexarrow_image);

static unsigned char	mounthattan_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,
 0x98,0x01,0x00,0x00,0x98,0x01,0x02,0x00,0x98,0x01,0x07,
 0x00,0x98,0x81,0x0d,0x00,0x9c,0xc3,0x18,0x80,0x9c,0x63,
 0x30,0xc0,0x0d,0x33,0x20,0x60,0x0f,0x1b,0x00,0x30,0x0e,
 0x0f,0x00,0x18,0x0c,0x07,0x00,0x0c,0x0c,0x03,0x00,0x04,
 0x0c,0x03,0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,0x1f,0x00,
 0x00,0x0c,0x1f,0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(mounthattan_ic,32,32,1,mounthattan_image);

static unsigned char	manhattan_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,
 0xf8,0x01,0x00,0x00,0x98,0x01,0x00,0x00,0x98,0x01,0x00,
 0x00,0x98,0x01,0x00,0x00,0x9c,0x03,0x00,0x00,0x9c,0x03,
 0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,
 0x03,0x00,0x7c,0x0c,0xf3,0x01,0x7c,0x0c,0xf3,0x01,0x60,
 0x0c,0xb3,0x01,0x60,0x0c,0xbf,0x01,0x60,0x0c,0xbf,0x01,
 0xe0,0x0f,0x80,0x01,0xe0,0x0f,0x80,0x01,0x00,0x00,0x80,
 0x3f,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(manhattan_ic,32,32,1,manhattan_image);

static unsigned char	mountain_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,
 0x00,0x00,0x00,0x70,0x00,0x00,0x00,0xd8,0x00,0x00,0x00,
 0x8c,0x01,0x00,0x00,0x04,0x03,0x00,0x00,0x00,0x06,0x00,
 0x00,0x00,0x0c,0x00,0x04,0x00,0x18,0x00,0x0e,0x00,0x30,
 0x00,0x1b,0x00,0x60,0x80,0x31,0x00,0xc0,0xc0,0x20,0x00,
 0x80,0x61,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x1e,0x00,
 0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(mountain_ic,32,32,1,mountain_image);

static unsigned char	halignl_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,
 0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,
 0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,
 0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x68,0x00,
 0x00,0x00,0x88,0x01,0x00,0x00,0x08,0x06,0x00,0x00,0x88,
 0x01,0x00,0x00,0x68,0x00,0x00,0x00,0x18,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,
 0x00,0x08,0x00,0x80,0x00,0x08,0x00,0x80,0x00,0x08,0x00,
 0x80,0x00,0xf8,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(halignl_ic,32,32,1,halignl_image);

static unsigned char	halignr_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xfe,0x1f,0x00,0x00,0x02,0x10,0x00,0x00,
 0x02,0x10,0x00,0x00,0x02,0x10,0x00,0x00,0x02,0x10,0x00,
 0x00,0x02,0x10,0x00,0x00,0x02,0x10,0x00,0x00,0x02,0x10,
 0x00,0x00,0x02,0x10,0x00,0x00,0xfe,0x1f,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,
 0x00,0x16,0x00,0x00,0x80,0x11,0x00,0x00,0x60,0x10,0x00,
 0x00,0x80,0x11,0x00,0x00,0x00,0x16,0x00,0x00,0x00,0x18,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
 0x1f,0x00,0x01,0x00,0x10,0x00,0x01,0x00,0x10,0x00,0x01,
 0x00,0x10,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(halignr_ic,32,32,1,halignr_image);

static unsigned char	halignc_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xfc,0x3f,0x00,0x00,0x04,0x20,0x00,0x00,0x04,
 0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,0x00,
 0x04,0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,
 0x00,0x04,0x20,0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x80,
 0x02,0x00,0x00,0x80,0x02,0x00,0x00,0x40,0x04,0x00,0x00,
 0x40,0x04,0x00,0x00,0x20,0x08,0x00,0x00,0xe0,0x0f,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,
 0x07,0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,
 0x00,0x04,0xe0,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(halignc_ic,32,32,1,halignc_image);

static unsigned char	valignt_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xf8,0x9f,0x3f,0x1f,0x08,0x90,0x20,0x11,0x08,0x10,
 0x11,0x11,0x08,0x10,0x11,0x11,0x08,0x10,0x0a,0x11,0x08,
 0x10,0x0a,0x11,0x08,0x10,0x04,0x11,0x08,0x10,0x04,0x11,
 0x08,0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,0x00,0x00,0x00,
 0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
 0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,
 0x00,0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(valignt_ic,32,32,1,valignt_image);

static unsigned char	valignb_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
 0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
 0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0xf8,
 0x1f,0x00,0x11,0x08,0x10,0x00,0x11,0x08,0x10,0x00,0x11,
 0x08,0x10,0x04,0x11,0x08,0x10,0x0a,0x11,0x08,0x10,0x0a,
 0x11,0x08,0x10,0x11,0x11,0x08,0x10,0x11,0x11,0x08,0x90,
 0x20,0x11,0xf8,0x9f,0x3f,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(valignb_ic,32,32,1,valignb_image);

static unsigned char	valignc_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
 0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,
 0xf8,0x1f,0x00,0x11,0x08,0x10,0x30,0x11,0x08,0x10,0x2c,
 0x11,0x08,0x10,0x23,0x11,0x08,0x90,0x20,0x11,0x08,0x10,
 0x23,0x11,0x08,0x10,0x2c,0x11,0x08,0x10,0x30,0x11,0x08,
 0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,0x00,0x00,0x00,0x11,
 0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
 0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(valignc_ic,32,32,1,valignc_image);

static unsigned char	any_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x1f,0x08,0x00,
 0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,
 0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,
 0x08,0x21,0x12,0x11,0x88,0x22,0x12,0x11,0x48,0x64,0xa2,
 0x10,0x48,0x64,0xa2,0x10,0x48,0xa4,0x42,0x10,0xc8,0xa7,
 0x42,0x10,0x48,0x24,0x43,0x10,0x48,0x24,0x43,0x10,0x48,
 0x24,0x42,0x10,0x48,0x24,0x42,0x10,0x08,0x00,0x00,0x10,
 0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,
 0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0xf8,0xff,
 0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(any_ic,32,32,1,any_image);

static unsigned char	none_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x1f,0x08,0x00,
 0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,
 0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,
 0x28,0x32,0xd1,0x17,0x28,0x4a,0x51,0x10,0x68,0x4a,0x53,
 0x10,0x68,0x4a,0x53,0x10,0xa8,0x4a,0xd5,0x11,0xa8,0x4a,
 0x55,0x10,0x28,0x4b,0x59,0x10,0x28,0x4b,0x59,0x10,0x28,
 0x4a,0x51,0x10,0x28,0x32,0xd1,0x17,0x08,0x00,0x00,0x10,
 0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,
 0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0xf8,0xff,
 0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(none_ic,32,32,1,none_image);

static unsigned char	fill_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,
 0x03,0x00,0x00,0xac,0x06,0x00,0x00,0x54,0x0d,0x00,0x00,
 0xae,0x1a,0x00,0x00,0x56,0x35,0x00,0x00,0xab,0x6a,0x00,
 0x00,0x55,0xd5,0x00,0x00,0xab,0xaa,0x01,0x00,0x55,0x55,
 0x01,0x00,0xab,0xaa,0x01,0x80,0x55,0x55,0x01,0x80,0xaa,
 0xaa,0x01,0x80,0x55,0x55,0x03,0x80,0xaa,0xaa,0x02,0x80,
 0x55,0x55,0x03,0x00,0xab,0xaa,0x02,0x00,0x5e,0x55,0x03,
 0x00,0xb0,0xaa,0x02,0x00,0x60,0x55,0x03,0x00,0xc0,0xaa,
 0x02,0x00,0x40,0x55,0x01,0x00,0x80,0xff,0x01,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(fill_ic,32,32,1,fill_image);

static unsigned char	blank_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(blank_ic,32,32,1,blank_image);

static unsigned char	textL_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x3f,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xf8,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xf8,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(textL_ic,32,32,1,textL_image);

static unsigned char	textC_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
 0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0x07,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(textC_ic,32,32,1,textC_image);

static unsigned char	textR_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x80,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x1f,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x80,0xff,0x1f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xfc,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(textR_ic,32,32,1,textR_image);

static unsigned char	noarrows_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

mpr_static(noarrows_ic,32,32,1,noarrows_image);

static unsigned char	farrows_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x80,
 0x03,0x00,0x00,0x80,0x0f,0xfc,0xff,0xff,0x1f,0x00,0x00,
 0x80,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(farrows_ic,32,32,1,farrows_image);

static unsigned char	barrows_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0xe0,0x00,0x00,
 0x00,0xf8,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0xf8,0x00,
 0x00,0x00,0xe0,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(barrows_ic,32,32,1,barrows_image);

static unsigned char	fbarrows_image[128] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0xe0,0x00,0x80,
 0x03,0xf8,0x00,0x80,0x0f,0xfc,0xff,0xff,0x1f,0xf8,0x00,
 0x80,0x0f,0xe0,0x00,0x80,0x03,0x80,0x00,0x80,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(fbarrows_ic,32,32,1,fbarrows_image);

/*************** misc icons *************/

static unsigned char	printer_image[210] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0x0f,0x20,
 0x00,0x00,0x00,0x00,0x00,0x08,0x20,0x00,0x00,0x00,0x00,
 0x00,0x08,0x20,0x00,0x00,0x00,0x00,0x00,0x08,0xe0,0xff,
 0xff,0xff,0xff,0xff,0x0f,0xa0,0x00,0x00,0x00,0x00,0x00,
 0x08,0xa0,0x00,0x00,0xf8,0x03,0x00,0x08,0xa0,0x00,0x00,
 0x08,0x02,0x00,0x08,0xa0,0x00,0x00,0xa8,0x02,0x00,0x04,
 0xa0,0x00,0x00,0xf8,0x03,0x00,0x02,0xa0,0x00,0x00,0x00,
 0x00,0x00,0x01,0xe0,0xff,0xff,0xff,0xff,0xff,0x00,0x80,
 0x00,0x00,0x00,0x00,0x80,0x00,0xfc,0xf8,0xff,0xff,0xff,
 0x9f,0x00,0x84,0x00,0x00,0x00,0x00,0x80,0x00,0x84,0xf8,
 0xff,0xff,0xff,0x9f,0x00,0xfc,0x00,0x00,0x00,0x00,0x80,
 0x00,0xe0,0xf8,0xff,0xff,0xff,0x9f,0x00,0xc0,0x00,0x00,
 0x00,0x00,0x80,0x00,0x80,0xf8,0xff,0xff,0xff,0x9f,0x00,
 0x00,0x01,0x00,0x00,0x00,0x80,0x00,0x00,0xfe,0xff,0xff,
 0xff,0xff,0x00,0x00,0x7c,0x00,0x00,0x00,0x7c,0x00,0x00,
 0x38,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

mpr_static(printer_ic,54,28,1,printer_image);

#ifdef notdef			/* not used yet */
static unsigned char	kbd_image[133] = {
 0xef,0xbd,0xf7,0xde,0x7b,0xef,0xfd,0x29,0xa5,0x94,0x52,
 0x4a,0x29,0x85,0x29,0xa5,0x94,0x52,0x4a,0x29,0x85,0xef,
 0xbd,0xf7,0xde,0x7b,0xef,0xfd,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xbc,0xf7,0xde,0x7b,0xef,0xbd,0xf7,0xa4,0x94,
 0x52,0x4a,0x29,0xa5,0x94,0xa4,0x94,0x52,0x4a,0x29,0xa5,
 0x94,0xbc,0xf7,0xde,0x7b,0xef,0xbd,0x97,0x00,0x00,0x00,
 0x00,0x00,0x00,0x90,0xf0,0xde,0x7b,0xef,0xbd,0xf7,0x9e,
 0x90,0x52,0x4a,0x29,0xa5,0x94,0x82,0x90,0x52,0x4a,0x29,
 0xa5,0x94,0x82,0xf0,0xde,0x7b,0xef,0xbd,0xf7,0xfe,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xef,0xbd,0xf7,0xde,
 0x7b,0x7f,0x20,0x28,0xa5,0x94,0x52,0x4a,0x41,0x20,0x28,
 0xa5,0x94,0x52,0x4a,0x41,0xe0,0xef,0xbd,0xf7,0xde,0x7b,
0x7f};

mpr_static(kbd_ic,56,19,1,kbd_image);
#endif
