
/* The cut-paste module for splitvt */

#include	<stdio.h>
#include	"vt100.h"
#include	"video.h"

#define Min(A,B)	((A>B)?B:A)
#define Max(A,B)	((A>B)?A:B)

extern struct physical physical;

/* This function assumes that it alone will print selected text */
unsigned char put_sel_char(win, x, y, oldattr, on)
window *win;
int x, y;
int oldattr;
unsigned char *on;
{
	int c;

	c = get_video(win, x, y);
	if ( c&0xFF ) {
		if ( ((c>>8)&SELECTED) == SELECTED ) {
			c &= ~(SELECTED<<8);
			if ( (*on&SELECTED) == SELECTED ) {
				vt_resetattr();
				*on = NORMAL;
				oldattr = 0;
			}
		} else {
			c |= (SELECTED<<8);
			if ( (*on&SELECTED) == SELECTED )
				*on &= ~SELECTED;
		}
		oldattr=check_attr(c, oldattr, on);
		put_video(c, win, x, y);
		printf("%c", c&0xFF);
	} else
		printf(" ");
	fflush(stdout);
	return(oldattr);
}

/* Get a window selection */
char *vt_getsel(win, buf, len)
int win;
char *buf;
int len;
{
	int i, j;
	int c, oldattr=0, marked=0;
	window *thiswin;
	unsigned char on=NORMAL;
	position here, cursor, mark1, mark2;
	position startsel, endsel;
	
	thiswin = physical.subwins[win];
	here=cursor=thiswin->cursor;
	vt_info("Mark beginning of selection: ");
	while ( (c=getchar()) != EOF ) {
		switch (c) {
			case 'j':	/* Move down one line */
					if ( cursor.x < thiswin->rows ) {
						if ( marked ) {
							for (j=cursor.y; j<thiswin->cols; ++j) {
								oldattr=
				put_sel_char(thiswin, cursor.x, j, oldattr, &on);
							}
							printf("\r");
							vt_down(1);
							++cursor.x;
							for ( j=1; j<cursor.y; ++j ) {
								oldattr=
				put_sel_char(thiswin, cursor.x, j, oldattr, &on);
							}
						} else {
							vt_down(1);
							++cursor.x;
						}
					}
					break;
			case 'k':	/* Move up one line */
					if ( cursor.x > 1 ) {
						--cursor.x;
						if ( marked ) {
							vt_up(1);
							for (j=cursor.y; j<thiswin->cols; ++j) {
								oldattr=
				put_sel_char(thiswin, cursor.x, j, oldattr, &on);
							}
							printf("\r");
							vt_down(1);
							++cursor.x;
							for ( j=1; j<cursor.y; ++j ) {
								oldattr=
				put_sel_char(thiswin, cursor.x, j, oldattr, &on);
							}
							vt_up(1);
							--cursor.x;
						} else 
							vt_up(1);
					}
					break;
			case 'l':	/* Move right one char */
					if ( cursor.y < thiswin->cols ) {
						if ( marked ) {
							oldattr=
				put_sel_char(thiswin, cursor.x, cursor.y, oldattr, &on);
						} else
							vt_right(1);
						++cursor.y;
					}
					break;
			case 'h':	/* Move left one char */
					if ( cursor.y > 1 ) {
						--cursor.y;
						if ( marked ) {
							vt_left(1);
							oldattr=
				put_sel_char(thiswin, cursor.x, cursor.y, oldattr, &on);
							vt_left(1);
						} else
							vt_left(1);
					}
					break;
			case ' ':	/* Mark selection */
					if ( marked ) {
						mark2=cursor;
						/* Copy and deselect area */
						/* upper-left -> lower-right */
						if ( mark1.x < mark2.x )
						{
							startsel = mark1;
							endsel = mark2;
						}
						else if ( mark2.x < mark1.x )
						{
							startsel = mark2;
							endsel = mark1;
						}
						else if ( mark1.y < mark2.y )
						{
							startsel = mark1;
							endsel = mark2;
						}
						else
						{
							startsel = mark2;
							endsel = mark1;
						}
						getsel_video(thiswin, buf, len,
							startsel.x, endsel.x,
							startsel.y, endsel.y);
						clrsel_video(thiswin);
						vt_info("Region selected.");
						/* Repaint the screen */
						paint_video(thiswin);
						return(buf);
					} else {
						mark1=cursor;
						marked=1;
						vt_info(
						"Mark end of selection: ");
						/* Set reverse here */
						vt_update();
					}
					break;
			case '\033':
			case 'q':	/* Cancel selection */
					clrsel_video(thiswin);
					vt_goto((here.x+thiswin->row_offset),
									here.y);
					vt_info("Selection cancelled.");
					return(NULL);
					break;
			default:	break;
		}
	}
	return;	/* Hopefully, we never reach here */
}


/* Set a window selection */
char *vt_setsel(buf, len, startx, endx, starty, endy)
char *buf;
int len;
int startx, starty;
int endx, endy;
{
	window *thiswin;

	/* If nothing selected, return old selection */
	if ( (startx == endx) && (starty == endy) )
		return(buf);

	if ( startx < (physical.subwins[LOWER])->row_offset )
		thiswin = physical.subwins[UPPER];
	else {
		thiswin = physical.subwins[LOWER];
		startx-=thiswin->row_offset;
		endx-=thiswin->row_offset;
	}
	getsel_video(thiswin, buf, len, startx, endx, starty, endy);
	return(buf);
}
