:
#!/bin/sh
# @(#)conf/lib/mkdirs.sh	1.3 7/11/92 12:09:44
# Create directories, if they do not already exist.
#
# usage: sh mkdirs.sh [-u user] [-g group] [-m mode] dir ...
#
#    Copyright (C) 1987, 1988 Ronald S. Karr and Landon Curt Noll
#    Copyright (C) 1992  Ronald S. Karr
# 
# See the file COPYING, distributed with smail, for restriction
# and warranty information.

# Don't use getopt(1), as we can't rely on it being built yet, or
# existing on the system.
usage="Usage: mkdirs.sh [-u user] [-g group] [-m mode] dir ..."
user=
group=
mode=
err=0
dbg=

# put /etc in path, for chmod
PATH="$PATH:/etc"

# Note:  this shell script uses case rather than test, where possible
#	 to prevent a fork/exec on systems where test is not a builtin.

# process the list of options.
# Note:  the option letters and option arguments must be separate tokens.
while : ; do
	case $# in
	0)	break;
	esac
	case "$1" in
	--)	shift; break;;
	-[ugm])case $# in
		1)	err=1;;
		esac
		case "$1" in
		-u)	user="$2";;
		-g)	group="$2";;
		-m)	mode="$2";;
		esac
		shift; shift;;
	-D)	dbg=echo; shift;;
	-*)	err=1; break;;
	*)	break;
	esac
done

# There must be some operands
case $# in
0)	err=1;;
esac

# If an error occured, spit out a usage message.
case "$err" in
1)	echo "$usage" 1>&2
	exit 1;;
esac

# first mkdir all the directories
for dir in "$@"; do
	if $dbg mkdir "$dir" 2> /dev/null; then
		case "$user" in
		?*)	if $dbg chown "$user" "$dir"; then
				:
			else
				$dbg rmdir "$dir"
				echo "mkdirs: failed to change owner of $dir" 1>&2
				exit 1
			fi;;
		esac
		case "$group" in
		?*)	if $dbg chgrp "$group" "$dir"; then
				:
			else
				$dbg rmdir "$dir"
				echo "mkdirs: failed to change group of $dir" 1>&2
				exit 1
			fi;;
		esac
		case "$mode" in
		?*)	if $dbg chmod "$mode" "$dir"; then
				:
			else
				$dbg rmdir "$dir"
				echo "mkdirs: failed to change mode of $dir" 1>&2
				exit 1
			fi;;
		esac
		echo "created directory $dir"
	elif [ ! -d "$dir" ]; then
		# if the directory doesn't already exist, complain
		echo "mkdirs: failed to create directory $dir" 1>&2
	fi
done

exit 0
