/* strlen -- determine the length of a string.
   For Intel 80x86, x>=3.
   Copyright (C) 1991, 1992, 1993 Free Software Foundation, Inc.
   Contributed by Torbjorn Granlund (tege@sics.se).

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <ansidecl.h>
#include <string.h>

size_t
DEFUN(strlen, (str), CONST char *str)
{
#if 1
  register size_t __res;
  __asm__("cld\n\t"
	  "repne\n\t"
	  "scasb\n\t"
	  "notl %0\n\t"
	  "decl %0"
	  :"=c" (__res):"D" (str),"a" (0),"0" (0xffffffff):"di");
  return __res;
#else
  int cnt;

  asm("cld\n"			/* Search forward.  */
      /* Some old versions of gas need `repne' instead of `repnz'.  */
      "repnz\n"			/* Look for a zero byte.  */
      "scasb" /* %0, %1, %3 */ :
      "=c" (cnt) : "D" (str), "0" (-1), "a" (0));

  return -2 - cnt;
#endif
}
