.TH statevars 3U "6 August 1990" "Unidraw" "InterViews Reference Manual"
.SH NAME
BrushVar, ColorVar, CompNameVar, FontVar, GravityVar, MagnifVar,
ModifStatusVar, NameVar, PatternVar \- state variable subject subclasses
.SH SYNOPSIS
.B #include <Unidraw/statevars.h>
.SH DESCRIPTION
Unidraw predefines several state variable subject subclasses:
BrushVar, ColorVar, FontVar, and PatternVar store the graphics state
information their names suggest; GravityVar records whether gravity is
in effect; MagnifVar records the current viewer magnification;
ModifStatusVar records whether state-modifying operations have been
applied to a component being edited; NameVar stores a string of
interest; and CompNameVar is a NameVar that stores a component and
keeps track of its catalog name.  These variables represent state that
is basic to graphical components and state that is often globally
accessible in graphics applications.
.SH PUBLIC OPERATIONS
.TP
.B "BrushVar(PSBrush* = nil)"
.ns
.TP
.B "virtual PSBrush* BrushVar::GetBrush()"
.ns
.TP
.B "virtual void BrushVar::SetBrush(PSBrush*)"
.TP
.B "ColorVar(PSColor* = nil)"
.ns
.TP
.B "virtual PSColor* ColorVar::GetColor()"
.ns
.TP
.B "virtual void ColorVar::SetColor(PSColor*)"
.TP
.B "FontVar(PSFont* = nil)"
.ns
.TP
.B "virtual PSFont* FontVar::GetFont()"
.ns
.TP
.B "virtual void FontVar::SetFont(PSFont*)"
.TP
.B "PatternVar(PSPattern* = nil)"
.ns
.TP
.B "virtual PSPattern* PatternVar::GetPattern()"
.ns
.TP
.B "virtual void PatternVar::SetPattern(PSPattern*)"
Each graphics state state variable subclass defines a constructor that
takes an initial value for the state it represents and adds operations
for assigning and retrieving that state.
.TP
.B "GravityVar(boolean = false)"
.ns
.TP
.B "virtual boolean GravityVar::IsActive();
.ns
.TP
.B "virtual void GravityVar::Activate(boolean)"
The GravityVar constructor takes an initial value that specifies
whether gravity is on or off.  IsActive returns the current value, and
Activate changes it to the one supplied.
.TP
.B "MagnifVar(float = 1)"
.ns
.TP
.B "virtual float MagnifVar::GetMagnif()"
.ns
.TP
.B "virtual void MagnifVar::SetMagnif(float)"
The MagnifVar constructor takes an initial value for the magnification
factor, and SetMagnify and GetMagnif assign and return the current
value.
.TP
.B "ModifStatusVar(Component* = nil, boolean = false)"
.ns
.TP
.B "virtual boolean ModifStatusVar::GetModifStatus()"
.ns
.TP
.B "virtual void ModifStatusVar::SetModifStatus(boolean)"
.ns
.TP
.B "virtual Component* ModifStatusVar::GetComponent()"
.ns
.TP
.B "virtual void ModifStatusVar::SetComponent(Component*)"
The ModifStatusVar constructor takes a component instance and an
initial value as arguments.  The ModifStatusVar is responsible for
indicating whether the given component is modified.  GetModifStatus,
SetModifStatus, GetComponent, and SetComponent get and set these
arguments.  The modification status will be set automatically (in
editors that maintain a ModifStatusVar instance) when an reversible
operation is performed on the component.
.TP
.B "NameVar(const char* = nil)"
.ns
.TP
.B "virtual const char* NameVar::GetName()"
.ns
.TP
.B "virtual void NameVar::SetName(const char*)"
The NameVar constructor takes a string as an optional arguement, while
GetName and SetName retrieve and assign the string.
.TP
.B "CompNameVar(Component* = nil)"
.ns
.TP
.B "virtual Component* CompNameVar::GetComponent()"
.ns
.TP
.B "virtual void CompNameVar::SetComponent(Component*)"
.ns
.TP
.B "virtual void CompNameVar::UpdateName()"
.ns
.TP
.B "virtual const char* PartOf()"
The CompNameVar constructor takes a component as an optional argument.
CompNameVar inherits the GetName operation from NameVar; calling
GetName returns the name associated with the component that the
CompNameVar stores.  The GetComponent and SetComponent calls get and
set the component.  UpdateName updates the string that GetName returns
to reflect the component's catalog name.  SetComponent calls this
operation automatically when it changes the CompNameVar's component.
PartOf returns the name of the root component in the CompNameVar
component's hierarchy.
.SH SEE ALSO
Catalog(3U), Component(3U), Editor(3U), StateVar(3U), pspaint(3U)
