Summary: Shadow password file utilities for Linux
Name: shadow-utils
Version: 971001
Release: 1
Copyright: Free
Group: Utilities/System
Source: ftp://ftp.ists.pwr.wroc.pl/pub/linux/shadow/beta/shadow_971001.tar.gz
BuildRoot: /tmp/shadow-utils
Packager: Timo Karjalainen <timok@iki.fi>

%description
This package includes the programs necessary to convert traditional
V7 UNIX password files to the SVR4 shadow password format and additional
tools to work with shadow passwords.
	- 'pwconv' converts everything to the shadow password format.
	- 'pwunconv' converts back to non-shadow passwords.
	- 'pwck' checks the integrity of the password and shadow files.
	- 'lastlog' prints out the last login times of all users.
	- 'useradd', 'userdel', 'usermod' to manage user accounts.
	- 'groupadd', 'groupdel', 'groupmod' to manage groups.

A number of man pages are also included that relate to these utilities,
and shadow passwords in general.

%changelog

* Sun Jun 08 1997 Timo Karjalainen <timok@iki.fi>

- Initial release

%prep
# This is just a few of the core utilities from the shadow suite...
# packaged up for use w/PAM
%setup -n shadow-971001

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=/usr --exec-prefix=/usr

make

%install
rm -rf $RPM_BUILD_ROOT

mkdir -p $RPM_BUILD_ROOT/etc/default
make prefix=$RPM_BUILD_ROOT/usr exec_prefix=$RPM_BUILD_ROOT/usr install
install -m 644 -o 0 -g 0 man/pwunconv.8 $RPM_BUILD_ROOT/usr/man/man8
install -m 755 -o 0 -g 0 src/{grpconv,pwconv,pwunconv} $RPM_BUILD_ROOT/usr/sbin

touch $RPM_BUILD_ROOT/etc/{login.defs,default/useradd}
chmod 640 $RPM_BUILD_ROOT/etc/{login.defs,default/useradd}
chown root $RPM_BUILD_ROOT/etc/{login.defs,default/useradd}
chgrp root $RPM_BUILD_ROOT/etc/{login.defs,default/useradd}

%clean
rm -rf $RPM_BUILD_ROOT

%files
%config /etc/login.defs
/etc/default
/usr/bin/chage
/usr/bin/gpasswd
/usr/man/man1/chage.1
/usr/man/man1/gpasswd.1
/usr/man/man3/shadow.3
/usr/man/man5/shadow.5
/usr/man/man8/chpasswd.8
/usr/man/man8/groupadd.8
/usr/man/man8/groupdel.8
/usr/man/man8/groupmod.8
/usr/man/man8/grpck.8
/usr/man/man8/lastlog.8
/usr/man/man8/newusers.8
/usr/man/man8/pwck.8
/usr/man/man8/pwunconv.8
/usr/man/man8/useradd.8
/usr/man/man8/userdel.8
/usr/man/man8/usermod.8
/usr/sbin/chpasswd
/usr/sbin/groupadd
/usr/sbin/groupdel
/usr/sbin/groupmod
/usr/sbin/grpck
/usr/sbin/grpconv
/usr/sbin/lastlog
/usr/sbin/newusers
/usr/sbin/pwck
/usr/sbin/pwconv
/usr/sbin/pwunconv
/usr/sbin/useradd
/usr/sbin/userdel
/usr/sbin/usermod
