#include <unistd.h>
#include <errno.h>
#include <dirent.h>

/*
 * rewinddir() just does an lseek(fd,0,0) - see close for comments
 */
void
_rewinddir(DIR * dir)
{
  if (!dir) {
    errno = EBADF;
    return;
  }
  _lseek(dir->dd_fd,0,SEEK_SET);
}

#ifdef ELF_LIBRARY
__asm__(".weak rewinddir; rewinddir = _rewinddir");
#endif
