/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include "global.h"

/*
 * Global variables
 */

/*********************************************************
 * name:	init_move
 * description:	Files verschieben
 * input:	char *from	- Quellfile
 *		char *to	- Zielfile
 * output:	none
 * date:	10.6.93
 *********************************************************/
void	init_move (char *from, char *to)
{
	Widget	but;

	/*
	 * Das Dialogfenster erzeugen
	 */
	but = makeDialog(2,"From :","To   :",from,to,"Moving & Renaming Files",TRUE,
				FALSE,Icon_Move_PM);

	XtAddCallback(but,XtNcallback,(XtCallbackProc) exec_move_cb,NULL);

	/*
	 * Zum Schluss die Dialogshell managen
	 */
	XtManageChild (dialog);

	/*
	 * Max und Minsize setzen
	 */
	setSize();
}


/*********************************************************
 * name:	exec_move_cb
 * description:	Ausfuehren der Verschiebeoperation
 * input:	nichts
 * output:	nichts
 * date:	14.6.93
 *********************************************************/
void	exec_move_cb (void)
{
	char	*from, *to;
	Arg	args[1];
	char	buf[1024];

	/*
	 * Die Texte der beiden Textfelder holen
	 */
	XtSetArg(args[0],XtNstring,&from);
	XtGetValues(text_1,args,1);

	XtSetArg(args[0],XtNstring,&to);
	XtGetValues(text_2,args,1);

	/*
	 * Ueberpruefen ob in beiden ein Text steht, sonst
	 * Warnung ausgeben
	 */
	if (!strlen(from) || !strlen(to)) {
		WARNING ("Insuffisant Arguments.\nOperation aborted.");
		return;
	}
	if (!MULTI)
		exec_move(from,to);
	else {
		char	*bot,*top;

		bot = from;
		top = strchr(bot,'\n');
		while (top) {
			*top++ = '\0';
			sprintf(buf,"%s %s %s\0",MOVE_CMD,bot,to);
			system(buf);
			bot = top;
			top = strchr(bot,'\n');
		}
		/*
		 * Dialogfenster loeschen
		 */
		if (dialog)
			XtDestroyWidget(dialog);
		dialog = NULL;

		/*
		 * Hier muss ein Update der veranderten Felder kommen
		 * Bisher unvollstaendig
		 */
		bot = from;
		multi_fo = NULL;
		multi_vs = 16000;
		multi_ve = 16000;
		refreshFolderByPathname(bot);
		/* Quellfolder oder Dir refreshen falls dargestellt */
		refreshFolderByPathname (to);
#ifdef	HAS_QUOTA
		showQuota(quota_label);
#endif
		MULTI = FALSE;
	}
}

/*********************************************************
 * name:	exec_move
 * description:	Ausfuehren der Verschiebeoperation
 * input:	nichts
 * output:	nichts
 * date:	14.6.93
 *********************************************************/
void	exec_move (char *from, char *to)
{
	char	buf[1024];

	/*
	 * Befehl generieren und ausfuehren
	 */
	sprintf(buf,"%s %s %s",MOVE_CMD,from,to);

	system(buf);
	{
		/*
		 * Dialogfenster loeschen
		 */
		if (dialog)
			XtDestroyWidget(dialog);
		dialog = NULL;

		/*
		 * Hier muss ein Update der veranderten Felder kommen
		 * Bisher unvollstaendig
		 */
		/* Zielfolder oder Dir refreshen falls dargestellt */
		refreshFolderByPathname (from);

		/* Quellfolder oder Dir refreshen falls dargestellt */
		refreshFolderByPathname (to);
#ifdef	HAS_QUOTA
		showQuota(quota_label);
#endif
	}
}

