/*
 * Decompiled with CFR 0.152.
 */
package sun.beans.editors;

import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class ColorEditor
extends Panel
implements PropertyEditor {
    private String[] colorNames = new String[]{" ", "white", "lightGray", "gray", "darkGray", "black", "red", "pink", "orange", "yellow", "green", "magenta", "cyan", "blue"};
    private Color[] colors = new Color[]{null, Color.white, Color.lightGray, Color.gray, Color.darkGray, Color.black, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue};
    private Canvas sample;
    private int sampleHeight = 20;
    private int sampleWidth = 40;
    private int hPad = 5;
    private int ourWidth;
    private Color color;
    private TextField text;
    private Choice choser;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public ColorEditor() {
        this.setLayout(null);
        this.ourWidth = this.hPad;
        Panel panel = new Panel();
        panel.setLayout(null);
        panel.setBackground(Color.black);
        this.sample = new Canvas();
        panel.add(this.sample);
        this.sample.reshape(2, 2, this.sampleWidth, this.sampleHeight);
        this.add(panel);
        panel.reshape(this.ourWidth, 2, this.sampleWidth + 4, this.sampleHeight + 4);
        this.ourWidth += this.sampleWidth + 4 + this.hPad;
        this.text = new TextField("", 14);
        this.add(this.text);
        this.text.reshape(this.ourWidth, 0, 100, 30);
        this.ourWidth += 100 + this.hPad;
        this.choser = new Choice();
        int n = 0;
        while (n < this.colorNames.length) {
            this.choser.addItem(this.colorNames[n]);
            ++n;
        }
        this.add(this.choser);
        this.choser.reshape(this.ourWidth, 0, 100, 30);
        this.ourWidth += 100 + this.hPad;
        this.resize(this.ourWidth, 40);
    }

    public void setValue(Object object) {
        this.color = (Color)object;
        this.changeColor(this.color);
    }

    public Dimension preferredSize() {
        return new Dimension(this.ourWidth, 40);
    }

    public boolean keyUp(Event event, int n) {
        block2: {
            if (event.target != this.text) break block2;
            try {
                this.setAsText(this.text.getText());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return false;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int n = string.indexOf(44);
        int n2 = string.indexOf(44, n + 1);
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException(string);
        }
        try {
            int n3 = Integer.parseInt(string.substring(0, n));
            int n4 = Integer.parseInt(string.substring(n + 1, n2));
            int n5 = Integer.parseInt(string.substring(n2 + 1));
            Color color = new Color(n3, n4, n5);
            this.changeColor(color);
            return;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(string);
        }
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.choser) {
            this.changeColor(this.colors[this.choser.getSelectedIndex()]);
        }
        return false;
    }

    public String getJavaInitializationString() {
        return "new java.awt.Color(" + this.getAsText() + ")";
    }

    private void changeColor(Color color) {
        this.color = color;
        ((TextComponent)this.text).setText(color.getRed() + "," + color.getGreen() + "," + color.getBlue());
        int n = 0;
        int n2 = 0;
        while (n2 < this.colorNames.length) {
            if (this.color.equals(this.colors[n2])) {
                n = n2;
            }
            ++n2;
        }
        this.choser.select(n);
        this.sample.setBackground(this.color);
        this.sample.repaint();
        this.support.firePropertyChange("", null, null);
    }

    public Object getValue() {
        return this.color;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 3, rectangle.height - 3);
        graphics.setColor(this.color);
        graphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 4, rectangle.height - 4);
        graphics.setColor(color);
    }

    public String getAsText() {
        return this.text.getText();
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

