#include <ibcs/signal.h>


#ifdef __sparc__
#define SIGUNUSED 32
#define SIGPWR    19
#endif


#ifdef EMU_SCO
static long linux_to_sco_signals[NSIGNALS+1] = {
	0,
	IBCS_SIGHUP,	IBCS_SIGINT,	IBCS_SIGQUIT,	IBCS_SIGILL,
	IBCS_SIGTRAP,	IBCS_SIGABRT,	-1,		IBCS_SIGFPE,
	IBCS_SIGKILL,	IBCS_SIGUSR1,	IBCS_SIGSEGV,	IBCS_SIGUSR2,
	IBCS_SIGPIPE,	IBCS_SIGALRM,	IBCS_SIGTERM,	IBCS_SIGSEGV,
	IBCS_SIGCHLD,	IBCS_SIGCONT,	IBCS_SIGSTOP,	IBCS_SIGTSTP,
	IBCS_SIGTTIN,	IBCS_SIGTTOU,	IBCS_SIGUSR1,	IBCS_SIGGXCPU,
	IBCS_SIGGXFSZ,	IBCS_SIGVTALRM,	IBCS_SIGPROF,	IBCS_SIGWINCH,
	IBCS_SIGIO,	IBCS_SIGPWR,	-1,		-1
};

static long sco_to_linux_signals[NSIGNALS+1] = {
	0,
	SIGHUP,		SIGINT,		SIGQUIT,	SIGILL,
	SIGTRAP,	SIGIOT,		SIGUNUSED,	SIGFPE,
	SIGKILL,	SIGUNUSED,	SIGSEGV,	SIGUNUSED,
	SIGPIPE,	SIGALRM,	SIGTERM,	SIGURG,
	SIGUSR2,	SIGCHLD,	SIGPWR,		SIGWINCH,
	SIGUNUSED,	SIGPOLL,	SIGSTOP,	SIGTSTP,
	SIGCONT,	SIGTTIN,	SIGTTOU,	SIGVTALRM,
	SIGPROF,	SIGXCPU,	SIGXFSZ,	-1
};
#endif


static long linux_to_ibcs_signals[NSIGNALS+1] = {
	0,
	IBCS_SIGHUP,	IBCS_SIGINT,	IBCS_SIGQUIT,	IBCS_SIGILL,
	IBCS_SIGTRAP,	IBCS_SIGABRT,	-1,		IBCS_SIGFPE,
	IBCS_SIGKILL,	IBCS_SIGUSR1,	IBCS_SIGSEGV,	IBCS_SIGUSR2,
	IBCS_SIGPIPE,	IBCS_SIGALRM,	IBCS_SIGTERM,	IBCS_SIGSEGV,
	IBCS_SIGCHLD,	IBCS_SIGCONT,	IBCS_SIGSTOP,	IBCS_SIGTSTP,
	IBCS_SIGTTIN,	IBCS_SIGTTOU,	IBCS_SIGURG,	IBCS_SIGGXCPU,
	IBCS_SIGGXFSZ,	IBCS_SIGVTALRM,	IBCS_SIGPROF,	IBCS_SIGWINCH,
	IBCS_SIGIO,	IBCS_SIGPWR,	-1,		-1
};

static long ibcs_to_linux_signals[NSIGNALS+1] = {
	0,
	SIGHUP,		SIGINT,		SIGQUIT,	SIGILL,
	SIGTRAP,	SIGIOT,		SIGUNUSED,	SIGFPE,
	SIGKILL,	SIGUNUSED,	SIGSEGV,	SIGUNUSED,
	SIGPIPE,	SIGALRM,	SIGTERM,	SIGUSR1,
	SIGUSR2,	SIGCHLD,	SIGPWR,		SIGWINCH,
	SIGURG,		SIGPOLL,	SIGSTOP,	SIGTSTP,
	SIGCONT,	SIGTTIN,	SIGTTOU,	SIGVTALRM,
	SIGPROF,	SIGXCPU,	SIGXFSZ,	-1
};


#ifdef EMU_ISC
static long linux_to_isc_signals[NSIGNALS+1] = {
	0,
	IBCS_SIGHUP,	IBCS_SIGINT,	IBCS_SIGQUIT,	IBCS_SIGILL,
	IBCS_SIGTRAP,	IBCS_SIGABRT,	-1,		IBCS_SIGFPE,
	IBCS_SIGKILL,	IBCS_SIGUSR1,	IBCS_SIGSEGV,	IBCS_SIGUSR2,
	IBCS_SIGPIPE,	IBCS_SIGALRM,	IBCS_SIGTERM,	IBCS_SIGSEGV,
	IBCS_SIGCHLD,	ISC_SIGCONT,	ISC_SIGSTOP,	ISC_SIGTSTP,
	IBCS_SIGTTIN,	IBCS_SIGTTOU,	IBCS_SIGUSR1,	IBCS_SIGGXCPU,
	IBCS_SIGGXFSZ,	IBCS_SIGVTALRM,	IBCS_SIGPROF,	IBCS_SIGWINCH,
	IBCS_SIGIO,	IBCS_SIGPWR,	-1,		-1
};

static long isc_to_linux_signals[NSIGNALS+1] = {
	0,
	SIGHUP,		SIGINT,		SIGQUIT,	SIGILL,
	SIGTRAP,	SIGIOT,		SIGUNUSED,	SIGFPE,
	SIGKILL,	SIGUNUSED,	SIGSEGV,	SIGUNUSED,
	SIGPIPE,	SIGALRM,	SIGTERM,	SIGUSR1,
	SIGUSR2,	SIGCHLD,	SIGPWR,		SIGWINCH,
	-1,		SIGPOLL,	SIGCONT,	SIGSTOP,
	SIGTSTP,	SIGTTIN,	SIGTTOU,	SIGVTALRM,
	SIGPROF,	SIGXCPU,	SIGXFSZ,	-1
};
#endif /* EMU_ISC */

#ifndef __sparc__
static long linux_to_xnx_signals[NSIGNALS+1] = {
	0,
	IBCS_SIGHUP,	IBCS_SIGINT,	IBCS_SIGQUIT,	IBCS_SIGILL,
	IBCS_SIGTRAP,	IBCS_SIGABRT,	-1,		IBCS_SIGFPE,
	IBCS_SIGKILL,	IBCS_SIGUSR1,	IBCS_SIGSEGV,	IBCS_SIGUSR2,
	IBCS_SIGPIPE,	IBCS_SIGALRM,	IBCS_SIGTERM,	IBCS_SIGSEGV,
	IBCS_SIGCHLD,	IBCS_SIGCONT,	IBCS_SIGSTOP,	IBCS_SIGTSTP,
	IBCS_SIGTTIN,	IBCS_SIGTTOU,	IBCS_SIGUSR1,	IBCS_SIGGXCPU,
	IBCS_SIGGXFSZ,	IBCS_SIGVTALRM,	IBCS_SIGPROF,	IBCS_SIGWINCH,
	20 /*XNX_SIGIO*/, IBCS_SIGPWR,	-1,		-1
};

static long xnx_to_linux_signals[NSIGNALS+1] = {
	0,
	SIGHUP,		SIGINT,		SIGQUIT,	SIGILL,
	SIGTRAP,	SIGIOT,		SIGUNUSED,	SIGFPE,
	SIGKILL,	SIGUNUSED,	SIGSEGV,	SIGUNUSED,
	SIGPIPE,	SIGALRM,	SIGTERM,	SIGUSR1,
	SIGUSR2,	SIGCHLD,	SIGPWR,		SIGPOLL,
	-1,		-1,		-1,		-1,
	-1,		-1,		-1,		-1,
	-1,		-1,		-1,		-1
};


#ifdef EMU_BSD
static long linux_to_bsd_signals[NSIGNALS+1] = {
	0,
	BSD_SIGHUP,	BSD_SIGINT,	BSD_SIGQUIT,	BSD_SIGILL,
	BSD_SIGTRAP,	BSD_SIGABRT,	BSD_SIGEMT,	BSD_SIGFPE,
	BSD_SIGKILL,	BSD_SIGUSR1,	BSD_SIGSEGV,	BSD_SIGUSR2,
	BSD_SIGPIPE,	BSD_SIGALRM,	BSD_SIGTERM,	BSD_SIGSEGV,
	BSD_SIGCHLD,	BSD_SIGCONT,	BSD_SIGSTOP,	BSD_SIGTSTP,
	BSD_SIGTTIN,	BSD_SIGTTOU,	BSD_SIGIO,	BSD_SIGXCPU,
	BSD_SIGXFSZ,	BSD_SIGVTALRM,	BSD_SIGPROF,	BSD_SIGWINCH,
	-1,		BSD_SIGTERM,	-1,		-1
};

static long bsd_to_linux_signals[NSIGNALS+1] = {
	0,
	SIGHUP,		SIGINT,		SIGQUIT,	SIGILL,
	SIGTRAP,	SIGABRT,	SIGUNUSED,	SIGFPE,
	SIGKILL,	SIGUNUSED,	SIGSEGV,	SIGUNUSED,
	SIGPIPE,	SIGALRM,	SIGTERM,	SIGURG,
	SIGSTOP,	SIGTSTP,	SIGCONT,	SIGCHLD,
	SIGTTIN,	SIGTTOU,	SIGIO,		SIGXCPU,
	SIGXFSZ,	SIGVTALRM,	SIGPROF,	SIGWINCH,
	29,		SIGUSR1,	SIGUSR2,	-1
};
#endif
#endif /* !__sparc__ */
#ifndef INIT_MM
long *signal_map_to_linux[] = {
	NULL,
	ibcs_to_linux_signals,	/* SVR4 */
	ibcs_to_linux_signals,	/* SVR3 is a subset of SVR4 */
#ifdef EMU_SCO
	sco_to_linux_signals,	/* SCO SVR3 */
#else
	ibcs_to_linux_signals,	/* SCO SVR3 */
#endif
	ibcs_to_linux_signals,	/* Wyse V/386 */
#ifdef EMU_ISC
	isc_to_linux_signals,	/* ISC R4 */
#else
	NULL,
#endif /* EMU_ISC */
#ifdef EMU_BSD
	bsd_to_linux_signals,	/* BSD-ish - probably wrong so far. */
#else
	NULL,
#endif /* EMU_BSD */
	xnx_to_linux_signals	/* Xenix */
};

long *signal_map_from_linux[] = {
	NULL,
	linux_to_ibcs_signals,	/* SVR4 */
	linux_to_ibcs_signals,	/* SVR3 is a subset of SVR4 */
#ifdef EMU_SCO
	linux_to_sco_signals,	/* SCO SVR3 */
#else
	linux_to_ibcs_signals,	/* SCO SVR3 */
#endif
	linux_to_ibcs_signals,	/* Wyse V/386 */
#ifdef EMU_ISC
	linux_to_isc_signals,	/* ISC R4 */
#else
	NULL,
#endif /* EMU_ISC */
#ifdef EMU_BSD
	linux_to_bsd_signals,	/* BSD-ish - probably wrong so far. */
#else
	NULL,
#endif /* EMU_BSD */
	linux_to_xnx_signals	/* Xenix */
};
#endif /* !INIT_MM */
