/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DirectColorModel;

public abstract class ColorModel {
    private int pData;
    protected int pixel_bits;
    private static ColorModel RGBdefault;

    public static ColorModel getRGBdefault() {
        if (RGBdefault == null) {
            RGBdefault = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        }
        return RGBdefault;
    }

    public ColorModel(int n) {
        this.pixel_bits = n;
    }

    public int getPixelSize() {
        return this.pixel_bits;
    }

    public abstract int getRed(int var1);

    public abstract int getGreen(int var1);

    public abstract int getBlue(int var1);

    public abstract int getAlpha(int var1);

    public int getRGB(int n) {
        return this.getAlpha(n) << 24 | this.getRed(n) << 16 | this.getGreen(n) << 8 | this.getBlue(n);
    }

    private native void deletepData();

    public void finalize() {
        this.deletepData();
    }
}

