/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import netscape.plugin.composer.TagRecord;
import netscape.plugin.composer.io.Comment;
import netscape.plugin.composer.io.Entity;
import netscape.plugin.composer.io.JavaScriptEntity;
import netscape.plugin.composer.io.LexicalStream;
import netscape.plugin.composer.io.Tag;
import netscape.plugin.composer.io.Text;
import netscape.plugin.composer.io.Token;

public class TagTrackerStream
extends LexicalStream {
    private Token currentToken;
    private TagRecord currentTag = null;
    private boolean selectionOnly;
    private boolean beforeSelection;
    private PrintWriter out;
    private static final String[] formatTags = new String[]{"B", "I", "U", "DL", "DD", "DT", "EM", "STRONG", "PRE", "DIV", "CENTER", "BLOCKQUOTE", "TT", "STRIKE", "BIG", "SMALL", "SUB", "SUP", "DFN", "CODE", "SAMP", "KBD", "VAR", "CITE", "FONT", "H1", "H2", "H3", "H4", "H5", "H6", "LI", "ADDRESS"};

    public TagTrackerStream(Reader reader, boolean bl, PrintWriter printWriter) {
        super(reader);
        this.out = printWriter;
        this.selectionOnly = bl;
        this.beforeSelection = true;
    }

    public TagTrackerStream(String string, boolean bl, PrintWriter printWriter) {
        super(string);
        this.out = printWriter;
        this.selectionOnly = bl;
        this.beforeSelection = true;
    }

    public Token next() throws IOException {
        if (this.selectionOnly && this.beforeSelection) {
            this.skipToSelectionStart();
            this.beforeSelection = false;
            return Comment.createSelectionStart();
        }
        this.getNextToken();
        return this.tokenCopy(this.currentToken);
    }

    public void finish() {
        try {
            Token token;
            while ((token = super.next()) != null) {
                this.out.print(token);
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public boolean tagApplies(String string) {
        boolean bl = false;
        TagRecord tagRecord = this.currentTag;
        while (tagRecord != null && !bl) {
            if (tagRecord != null && tagRecord.tag.getName().equals(string)) {
                bl = true;
            }
            if (bl) continue;
            tagRecord = tagRecord.next;
        }
        return bl;
    }

    public Tag findTag(String string) {
        boolean bl = false;
        TagRecord tagRecord = this.currentTag;
        while (tagRecord != null && !bl) {
            if (tagRecord != null && tagRecord.tag.getName().equals(string)) {
                bl = true;
            }
            if (bl) continue;
            tagRecord = tagRecord.next;
        }
        if (tagRecord != null) {
            return tagRecord.tag;
        }
        return null;
    }

    public String currentTags() {
        return this.recurseCurrentTags(this.currentTag);
    }

    public int currentSize() {
        boolean bl = false;
        String string = "";
        TagRecord tagRecord = this.currentTag;
        while (tagRecord != null && !bl) {
            string = tagRecord.tag.getName();
            if (tagRecord != null && (tagRecord.tag.getName().equals("FONT") && tagRecord.tag.containsAttribute("SIZE") || tagRecord.tag.getName().equals("BIG") || tagRecord.tag.getName().equals("SMALL") || tagRecord.tag.getName().charAt(0) == 'H' && Character.isDigit(tagRecord.tag.getName().charAt(1)))) {
                bl = true;
            }
            if (bl) continue;
            tagRecord = tagRecord.next;
        }
        try {
            if (!bl) {
                Tag tag = this.findTag("BASEFONT");
                if (tag != null) {
                    return Integer.parseInt(tag.lookupAttribute("SIZE"));
                }
                return 3;
            }
            if (string.equals("FONT")) {
                String string2 = tagRecord.tag.lookupAttribute("SIZE");
                if (string2.charAt(0) == '+' || string2.charAt(0) == '-') {
                    int n = 3;
                    Tag tag = this.findTag("BASEFONT");
                    if (tag != null) {
                        n = Integer.parseInt(tag.lookupAttribute("SIZE"));
                    }
                    if (string2.charAt(0) == '-') {
                        return n - Integer.parseInt(string2.substring(1));
                    }
                    return n + Integer.parseInt(string2.substring(1));
                }
                return Integer.parseInt(string2);
            }
            if (string.charAt(0) == 'H') {
                int n = Integer.parseInt(string.substring(1));
                return 7 - n;
            }
            if (string.equals("BIG")) {
                return 4;
            }
            if (string.equals("SMALL")) {
                return 2;
            }
            return 3;
        }
        catch (NumberFormatException numberFormatException) {
            return 3;
        }
    }

    public String currentFormatTags() {
        return this.recurseCurrentFormatTags(this.currentTag, false);
    }

    public String currentFormatEndTags() {
        return this.recurseCurrentFormatTags(this.currentTag, true);
    }

    private String recurseCurrentFormatTags(TagRecord tagRecord, boolean bl) {
        if (tagRecord == null) {
            return "";
        }
        String string = tagRecord.tag.getName();
        boolean bl2 = false;
        int n = 0;
        while (n < formatTags.length && !bl2) {
            if (string.equals(formatTags[n])) {
                bl2 = true;
            }
            ++n;
        }
        if (bl2 && !bl) {
            return String.valueOf(this.recurseCurrentFormatTags(tagRecord.next, bl)) + tagRecord.tag.toString();
        }
        if (bl2 && bl) {
            return String.valueOf(this.recurseCurrentFormatTags(tagRecord.next, bl)) + new Tag(string, false);
        }
        return this.recurseCurrentFormatTags(tagRecord.next, bl);
    }

    private String recurseCurrentTags(TagRecord tagRecord) {
        if (tagRecord != null) {
            return String.valueOf(this.recurseCurrentTags(tagRecord.next)) + tagRecord.tag.toString();
        }
        return "";
    }

    private void getNextToken() throws IOException {
        this.currentToken = super.next();
        if (this.currentToken instanceof Tag) {
            Tag tag = (Tag)this.currentToken;
            if (tag.isOpen()) {
                TagRecord tagRecord;
                this.currentTag = tagRecord = new TagRecord(tag, this.currentTag);
                return;
            }
            this.removeTag(tag.getName());
        }
    }

    private Token tokenCopy(Token token) {
        if (token == null) {
            return null;
        }
        if (token instanceof Tag) {
            return (Token)((Tag)token).clone();
        }
        if (token instanceof Comment) {
            return new Comment(((Comment)token).getText());
        }
        if (token instanceof Entity) {
            return new Entity(new StringBuffer("#" + ((Entity)token).getValue()));
        }
        if (token instanceof JavaScriptEntity) {
            return new JavaScriptEntity(new StringBuffer(((JavaScriptEntity)token).getScript()));
        }
        return new Text(token.toString());
    }

    private void skipToSelectionStart() throws IOException {
        while (!(this.currentToken instanceof Comment) || !((Comment)this.currentToken).isSelectionStart()) {
            this.getNextToken();
            this.out.print(this.currentToken);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeTag(String var1_1) {
        block2: {
            var2_2 = this.currentTag;
            if (var2_2 == null) break block2;
            if (!var2_2.tag.getName().equals(var1_1)) ** GOTO lbl7
            this.currentTag = var2_2.next;
            return;
lbl-1000:
            // 1 sources

            {
                var2_2 = var2_2.next;
lbl7:
                // 2 sources

                ** while (var2_2.next != null && !var2_2.next.tag.getName().equals((Object)var1_1))
            }
lbl8:
            // 1 sources

            if (var2_2.next != null) {
                var2_2.next = var2_2.next.next;
            }
        }
    }
}

