#include <stdio.h>

#include "abi.h"

struct symbol abi_plus[] = {
  /*
   *	This file describes the entry points which we must supply according
   * to the ABI+ documents for the SVr4 ABI.
   *
   *Contents of libsys from figure 6-2.  Each of these must have a synonym.
   */
  {"access", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"acct", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"alarm", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"catclose", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"catgets", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"catopen", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"chdir", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"chmod", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"chown", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"chroot", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"close", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"closedir", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"creat", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"dup", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"execl", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"execle", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"execlp", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"execv", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"fattach", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"fchdir", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"fchmod", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"fchown", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"fcntl", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"fdetach", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"fork", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"fpathconf", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"fstatvfs", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"fsync", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"makecontext", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"ftok", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getcontext", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getcwd", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getegid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"geteuid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getgid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getgrgid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getgrnam", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getgroups", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getlogin", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getmsg", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getpgid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getpgrp", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getpid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getpmsg", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getppid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getpwnam", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getpwuid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getrlimit", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getsid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"gettxt", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"getuid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"grantpt", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"initgroups", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"ioctl", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"isastream", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"kill", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"lchown", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"link", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"lseek", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"swapcontext", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"memcntl", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"mkdir", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"mknod", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"mlock", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"mmap", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"mount", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"mprotect", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"msgctl", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"msgget", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"msgrcv", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"msgsnd", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"msync", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"munlock", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"munmap", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"nice", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"open", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"opendir", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"pathconf", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"pause", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"pipe", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"poll", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"profil", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"ptrace", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"ptsname", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"putmsg", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"putpmsg", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"read", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"readdir", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"readlink", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"readv", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"rename", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"rewinddir", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"rmdir", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"seekdir", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"semctl", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"semget", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"semop", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"setcontext", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"setgid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"setgroups", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"setpgid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"setpgrp", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"setrlimit", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"setsid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"shmat", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"shmctl", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"shmdt", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"shmget", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sigaction", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sigaddset", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sigalstack", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"segdelset", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sigemptyset", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sigfillset", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sighold", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sigignore", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sigismember", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"siglongjmp", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sigpause", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sigpending", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sigprocmask", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sigrelse", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sigsend", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sigsendset", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sigset", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sigsetjmp", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sigsuspend", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"statvfs", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"stime", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"symlink", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sync", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"sysconf", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"telldir", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"time", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"times", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"ttyname", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"ulimit", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"umask", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"umount", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"unlink", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"unlockpt", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"utime", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"wait", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"waitid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"waitpid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"write", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  {"writev", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBSYS, 0},
  
  /*
   * Contents of libsys, functions without synonyms(Figure 6-3):
   */
  {"atexit", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"calloc", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"exit", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"_exit", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"free", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"localeconv", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"malloc", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"realloc", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"remove", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"setlocale", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"signal", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"strcoll", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"strerror", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"strftime", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"strxfrm", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"system", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  
  /*
   * Processor specific entry points (no synonyms):
   */
  {"_fxstat", SYM_OPTIONAL | SYM_FUNCTION | SYM_I386, LIBSYS, 0},
  {"_lxstat", SYM_OPTIONAL | SYM_FUNCTION | SYM_I386, LIBSYS, 0},
  {"nuname", SYM_OPTIONAL | SYM_FUNCTION | SYM_I386, LIBSYS, 0},
  {"_xmknod", SYM_OPTIONAL | SYM_FUNCTION | SYM_I386, LIBSYS, 0},
  {"_xstat", SYM_OPTIONAL | SYM_FUNCTION | SYM_I386, LIBSYS, 0},
  
  /*
   * Support routines:
   */
  {"_fpstart", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"sbrk", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  {"_sbrk", SYM_OPTIONAL | SYM_FUNCTION, LIBSYS, 0},
  
  
  /*
   * Global data symbols(Figure 6-5):
   */
  {"altzone", SYM_OPTIONAL | SYM_DATA | SYM_SYNONYM, LIBSYS, 4},
  {"_ctype", SYM_OPTIONAL | SYM_DATA | SYM_SYNONYM, LIBSYS, 521},
  {"_numeric", SYM_OPTIONAL | SYM_DATA, LIBSYS, 2},
  {"daylight", SYM_OPTIONAL | SYM_DATA | SYM_SYNONYM, LIBSYS, 4},
  {"timezone", SYM_OPTIONAL | SYM_DATA | SYM_SYNONYM, LIBSYS, 4},
  {"tzname", SYM_OPTIONAL | SYM_DATA | SYM_SYNONYM, LIBSYS, 8},
  
  /*
   * Global data symbols (i386 specific):
   */
  {"__flt_rounds", SYM_OPTIONAL | SYM_DATA | SYM_I386, LIBSYS, 4},
  {"_fp_hw", SYM_OPTIONAL | SYM_DATA | SYM_I386, LIBSYS, 4},
  {"__huge_val", SYM_OPTIONAL | SYM_DATA | SYM_I386, LIBSYS, 8},
  
  /*
   * Application contraints:
   */
  {"environ", SYM_OPTIONAL | SYM_DATA | SYM_SYNONYM, LIBSYS, 4},
  
  /*
   * Application contraints(i386 specific):
   */
  {"_end", SYM_OPTIONAL | SYM_DATA | SYM_I386, LIBSYS, 0},
  {"_lib_version", SYM_OPTIONAL | SYM_DATA | SYM_I386, LIBSYS, 4},
  
  /*
   * Contents of C library (without synonyms)(Figure 6-6):
   */
  {"abort", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"abs", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"asctime", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"atof", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"atoi", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"atol", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"bsearch", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"clearerr", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"clock", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"ctime", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"difftime", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"div", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"fclose", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"feof", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"ferror", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"fflush", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"fgetc", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"fgetpos", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"fgets", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"fopen", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"fprintf", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"fputc", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"fputs", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"fread", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"freopen", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"frexp", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"fscanf", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"fseek", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"fsetpos", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"ftell", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"fwrite", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"getc", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"getchar", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"getenv", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"gets", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"gmtime", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"isalnum", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"isalpha", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"iscntrl", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"isdigit", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"isgraph", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"islower", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"isprint", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"ispunct", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"isspace", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"isupper", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"isxdigit", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"labs", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"ldexp", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"ldiv", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"locaktime", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"longjmp", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"mblen", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"mbstowcs", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"mbtowc", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"memchr", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"memcmp", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"memcpy", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"memmove", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"memset", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"mktime", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"perror", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"printf", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"putc", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"putchar", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"puts", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"qsort", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"raise", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"rand", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"rewind", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"scanf", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"setbuf", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"setjmp", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"setvbuf", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"sprintf", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"srand", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"sscanf", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"strcat", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"strchr", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"strcmp", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"strcpy", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"strcspn", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"strlen", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"strncat", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"strncmp", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"strncpy", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"strpbrk", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"strrchr", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"strspn", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"strstr", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"strtok", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"strtol", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"strtoul", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"tmpfile", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"tmpnam", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"tolower", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"toupper", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"ungetc", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"vfprintf", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"vprintf", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"vsprintf", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"wcstombs", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"wctomb", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"logb", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  
  /*
   * Libc contents with synonyms(Figure 6-7):
   */
  {"cfgetispeed", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"cfgetospeed", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"cfsetispeed", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"cfsetospeed", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"ctermid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"cuserid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"dup2", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"fdopen", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"fileno", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"fmtmsg", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"getdate", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"getopt", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"getpass", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"getsubopt", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"getw", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"hcreate", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"hdestroy", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"headrch", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"isascii", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"isatty", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"isnan", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"isnand", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"lfind", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"nextafter", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"lockf", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"lsearch", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"memccpy", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"mkfifo", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"mktemp", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"monitor", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"nftw", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"nl_langinfo", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"pclose", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"popen", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"putenv", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"scalb", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"putw", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"setlabel", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"sleep", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"strdup", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"swab", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"tcdrain", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"tcflow", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"tcflush", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"tcgetattr", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"tcgetpgrp", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"tcgetsid", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"modf", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"tcsendbreak", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"tcsetattr", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"tcsetpgrp", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"tdelete", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"tell", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"tempnam", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"tfind", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"toascii", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"tsearch", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"twalk", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  {"tzset", SYM_OPTIONAL | SYM_FUNCTION | SYM_SYNONYM, LIBC, 0},
  
  
  /*
   * libc contents without synonyms.  Non-ANSI (Figure 6-8):
   */
  {"_cleanup", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"_tolower", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"_toupper", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"_xftw", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"__assert", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"__filbuf", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"__flsbuf", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  
  /*
   * Libc global data symbols(Figure 6-9)
   */
  {"getdate_err", SYM_REQUIRED | SYM_DATA | SYM_SYNONYM, LIBC, 4},
  {"_iob", SYM_REQUIRED | SYM_DATA | SYM_SYNONYM, LIBC, 960},
  {"optarg", SYM_REQUIRED | SYM_DATA, LIBC, 4},
  {"opterr", SYM_REQUIRED | SYM_DATA, LIBC, 4},
  {"optind", SYM_REQUIRED | SYM_DATA, LIBC, 4},
  {"optopt", SYM_REQUIRED | SYM_DATA, LIBC, 4},
  
  /*
   * Additional support routines (i386):
   */
  {"__fpstart", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  
  /*
   * libnsl contents(Figure 6-10):
   */
  {"t_accept", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_alloc", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_bind", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_close", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_connect", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_error", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_free", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_getinfo", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_getstate", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_listen", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_look", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_open", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_optmgmt", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_rcv", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_rcvconnect", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_rcvdis", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_rcvrel", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_rcvudata", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_rcvuderr", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_snd", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_snddis", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_sndrel", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_sndudata", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_sync", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  {"t_unbind", SYM_REQUIRED | SYM_FUNCTION, LIBNSL, 0},
  
  /*
   * Optional components of libnsl (Figure 6-11):
   */
  {"authdes_getucred", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"authdes_seccreate", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"aughnone_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"aughsys_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"authsys_create_default", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"clnt_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"clnt_dg_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"clnt_pcreateerror", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"clnt_perrno", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"clnt_perror", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"clnt_raw_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"cnlt_sperrno", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"cnlt_sperror", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"cnlt_tli_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"cnlt_tp_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"clnt_vc_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"endnetconfig", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"endnetpath", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"freenetconfigent", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"getnetconfig", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"getnetconfigent", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"getnetname", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"getnetpath", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"getpublickey", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"getsecretkey", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"host2netname", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"key_decryptsession", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"key_encryptsession", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"key_gendes", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"key_setsecret", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"nc_perror", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"netdir_free", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"netdir_getbyaddr", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"netdir_getbyname", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"netdir_options", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"netname2host", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"netname2user", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"rpc_broadcast", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"rpc_call", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"rpc_reg", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"rpcb_getaddr", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"rpcb_getmaps", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"rpcb_gettime", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"rpcbrmtcall", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"rpcb_set", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"rpcb_unset", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"setnetconfig", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"setnetpath", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"svc_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"svc_dg_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"svc_fd_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"svc_raw_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"svc_reg", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"svc_run", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"svc_sendreply", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"svc_tli_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"svc_tp_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"svc_unreg", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"svc_vc_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"svcerr_decode", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"svcerr_noproc", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"svcerr_noprog", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"svcerr_progvers", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"svcerr_wakauth", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"taddr2uaddr", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"uaddr2taddr", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"user2netname", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_accepted_reply", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_array", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_authsys_parms", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_bool", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_bytes", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_callhdr", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_callmsg", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_char", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_double", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_enum", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_float", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_free", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_int", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_long", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_opaque", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_opaque_width", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_pointer", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_reference", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_rejected_reply", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_replaymsg", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_short", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_string", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_u_char", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_u_long", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_u_short", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_union", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_vector", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_void", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdr_wrapstring", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdrmem_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdrrec_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdrrec_eof", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdrrec_sliprecord", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xdrstdio_create", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xprt_register", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"xprt_unregister", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  
  /*
   * libnsl global external data symbols
   */
  {"_nderror", SYM_REQUIRED | SYM_DATA, LIBNSL, 4},
  {"rpc_createerr", SYM_REQUIRED | SYM_DATA, LIBNSL, 16},
#if 0
  /*
   * I cannot find an entry for this in any of the current systems.
   * it is referenced in the ABI+ documentation, however.
   */
  {"svc_fds", SYM_REQUIRED | SYM_DATA, LIBNSL, 0},
#endif
  {"t_errno", SYM_REQUIRED | SYM_DATA, LIBNSL, 4},

  /*
   * The following symbols are not in the ABI, but ABI compliant programs
   * seem to need them to be defined.
   */
 
  {"__thr_errno", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"__xtol", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"_doscan", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"_dtop", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"_host_stayopen", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"_ltostr", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"getservbyname", SYM_OPTIONAL | SYM_FUNCTION, LIBNSL, 0},
  {"gettimeofday", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"openlog", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"pfmt", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"select", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"setitimer", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"sysinfo", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"syslog", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},
  {"vfork", SYM_OPTIONAL | SYM_FUNCTION, LIBC, 0},

  {NULL, 0, 0}
};
