/*  LAST EDIT: Wed Mar 31 06:06:41 1993 by Swen Thmmler (swen)  */
/* Copyright (C) 1991 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <ansidecl.h>
#include <stddef.h>
#include <stdio.h>
#include <string.h>
#include <pwd.h>

#ifdef YP
#include <rpc/rpc.h>
#include <rpcsvc/yp_prot.h>
#include <rpcsvc/ypclnt.h>
typedef struct
{
  char *buf;
  size_t buflen;
  struct passwd p;
} pwdread_info;

extern int __ypparsepwd(struct passwd *, char *);
extern char *__yp_getdomain(void);
extern struct passwd *
DEFUN(__pwdread_noyp, (stream, p), FILE *stream AND PTR CONST p) ;
#endif


/* Search for an entry with a matching name.  */
struct passwd *
DEFUN(getpwnam, (name), register CONST char *name)
{
  static PTR info = NULL;
  register FILE *stream;
  register struct passwd *p;

  if (info == NULL)
    {
      info = __pwdalloc();
      if (info == NULL)
	return(NULL);
    }

  stream = __pwdopen();
  if (stream == NULL)
    return(NULL);
#ifdef YP
  while ((p = __pwdread_noyp(stream, info)) != NULL)
    if (!strcmp(p->pw_name, name))
      break;

  (void) fclose(stream);
  if (p == NULL)
    {
      char *indomain ;
      char *outkey = NULL ;
      int r, outkeylen ;
      p = &((pwdread_info *) info)->p ;
      indomain = __yp_getdomain() ;
      if (indomain)
	{
	  r = yp_match(indomain, "passwd.byname",
		       name, strlen(name),
		       &outkey, &outkeylen) ;
	  switch (r)
	    {
	    case 0:
	      (void)__ypparsepwd(p, outkey) ;
	      break ;
	    default:
	      free(outkey) ;
	      outkey = NULL;
	      p = NULL ;
	    }
	}
      else
	p = NULL ;
    }
#else  
  while ((p = __pwdread(stream, info)) != NULL)
    if (!strcmp(p->pw_name, name))
      break;

  (void) fclose(stream);
#endif /* YP */
  return(p);
}
