/*
 * Copyright (c) 1987 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdlib.h>
#include <stddef.h>
#include <string.h>

#ifdef ELF_LIBRARY
#define __libc_environ _environ
#else
#ifdef COFF_LIBRARY
#define __libc_environ	(*_libc_environ)
#else
#define __libc_environ	_libc_environ
#endif
#endif

/*
 * _findenv --
 *	Returns pointer to value associated with name, if any, else NULL.
 *	Sets offset to be the offset of the name/value combination in the
 *	environmental array, for use by setenv(3) and unsetenv(3).
 *	Explicitly removes '=' in argument name.
 *
 *	This routine *should* be a static; don't use it.
 */

char *_findenv (register const char *name, int *offset)
    {
    extern   char **__libc_environ;
    register char **ppszEnviron;
    register char *pchTemp;
    register int len;
/*
 *  Find the length of the keyword
 */
    pchTemp = (char *) name;
    len     = 0;

    while (*pchTemp != '\0')
        {
	if (*pchTemp == '=')
	    {
	    break;
	    }
	++pchTemp;
	++len;
        }
/*
 *  Locate the item in the environment strings.
 */
    ppszEnviron = __libc_environ;
    pchTemp     = *ppszEnviron;
    while (pchTemp != NULL)
        {
	if (memcmp (name, pchTemp, len) == 0)
	    {
	    pchTemp += len;
	    if (*pchTemp++ == '=')
	        {
		*offset = (int) (ppszEnviron - __libc_environ);
		break;
	        }
	    }
	pchTemp = *(++ppszEnviron);
        }
/*
 *  Return the pointer to the string value.
 */
    return (pchTemp);
    }

/*
 * getenv --
 *	Returns ptr to value associated with name, if any, else NULL.
 */

char *getenv (const char *name)
    {
    int offset;
    return (_findenv (name, &offset));
    }
