#include "E.h"

Snapshot           *
FindSnapshot(EWin * ewin)
{
  Snapshot           *sn;

  char                buf[4096];

  if ((ewin->client.name) && (ewin->client.class))
    Esnprintf(buf, sizeof(buf), "%s.%s", ewin->client.name, ewin->client.class);
  else if (ewin->client.title)
    Esnprintf(buf, sizeof(buf), "TITLE.%s", ewin->client.title);
  else
    return NULL;
  sn = FindItem(buf, 0, LIST_FINDBY_NAME, LIST_TYPE_SNAPSHOT);
  return sn;
}

Snapshot           *
GetSnapshot(EWin * ewin)
{
  Snapshot           *sn;

  char                buf[4096];

  if ((ewin->client.name) && (ewin->client.class))
    Esnprintf(buf, sizeof(buf), "%s.%s", ewin->client.name, ewin->client.class);
  else if (ewin->client.title)
    Esnprintf(buf, sizeof(buf), "TITLE.%s", ewin->client.title);
  else
    return NULL;
  sn = FindItem(buf, 0, LIST_FINDBY_NAME, LIST_TYPE_SNAPSHOT);
  if (!sn)
    {
      sn = Emalloc(sizeof(Snapshot));
      sn->name = duplicate(buf);
      AddItem(sn, sn->name, 0, LIST_TYPE_SNAPSHOT);
      if ((ewin->client.name) && (ewin->client.class))
	{
	  sn->win_title = NULL;
	  sn->win_name = duplicate(ewin->client.name);
	  sn->win_class = duplicate(ewin->client.class);
	}
      else
	{
	  sn->win_title = duplicate(ewin->client.title);
	  sn->win_name = NULL;
	  sn->win_class = NULL;
	}
      sn->border_name = NULL;
      sn->use_desktop = 0;
      sn->desktop = 0;
      sn->use_area = 0;
      sn->area_x = 0;
      sn->area_y = 0;
      sn->use_wh = 0;
      sn->w = 0;
      sn->h = 0;
      sn->use_xy = 0;
      sn->x = 0;
      sn->y = 0;
      sn->use_layer = 0;
      sn->layer = 0;
      sn->use_sticky = 0;
      sn->sticky = 0;
      sn->iclass_name = NULL;
      sn->use_shade = 0;
      sn->shade = 0;
    }
  return sn;
}

Snapshot           *
NewSnapshot(char *name)
{
  Snapshot           *sn;

  sn = Emalloc(sizeof(Snapshot));
  sn->name = duplicate(name);
  sn->win_title = NULL;
  sn->win_name = NULL;
  sn->win_class = NULL;
  sn->border_name = NULL;
  sn->use_desktop = 0;
  sn->desktop = 0;
  sn->use_area = 0;
  sn->area_x = 0;
  sn->area_y = 0;
  sn->use_wh = 0;
  sn->w = 0;
  sn->h = 0;
  sn->use_xy = 0;
  sn->x = 0;
  sn->y = 0;
  sn->use_layer = 0;
  sn->layer = 0;
  sn->use_sticky = 0;
  sn->sticky = 0;
  sn->iclass_name = NULL;
  sn->use_shade = 0;
  sn->shade = 0;
  AddItem(sn, sn->name, 0, LIST_TYPE_SNAPSHOT);
  return sn;
}

/* record info about this Ewin's attributes */
void
SnapshotEwinBorder(EWin * ewin)
{
  Snapshot           *sn;

  sn = GetSnapshot(ewin);
  if (!sn)
    return;
  if (sn->border_name)
    Efree(sn->border_name);
  sn->border_name = NULL;
  sn->border_name = duplicate(ewin->border->name);
}

void
SnapshotEwinDesktop(EWin * ewin)
{
  Snapshot           *sn;

  sn = GetSnapshot(ewin);
  if (!sn)
    return;
  sn->use_desktop = 1;
  sn->desktop = ewin->desktop;
}

void
SnapshotEwinArea(EWin * ewin)
{
  Snapshot           *sn;

  sn = GetSnapshot(ewin);
  if (!sn)
    return;
  sn->use_area = 1;
  sn->area_x = ewin->area_x;
  sn->area_y = ewin->area_y;
}

void
SnapshotEwinSize(EWin * ewin)
{
  Snapshot           *sn;

  sn = GetSnapshot(ewin);
  if (!sn)
    return;
  sn->use_wh = 1;
  sn->w = ewin->client.w;
  sn->h = ewin->client.h;
}

void
SnapshotEwinLocation(EWin * ewin)
{
  Snapshot           *sn;

  sn = GetSnapshot(ewin);
  if (!sn)
    return;
  sn->use_xy = 1;
  if (ewin->pager)
    {
      sn->x = ewin->x + ewin->border->border.left;
      sn->y = ewin->y + ewin->border->border.top;
    }
  else
    {
      sn->x = ewin->x;
      sn->y = ewin->y;
    }
}

void
SnapshotEwinLayer(EWin * ewin)
{
  Snapshot           *sn;

  sn = GetSnapshot(ewin);
  if (!sn)
    return;
  sn->use_layer = 1;
  sn->layer = ewin->layer;
}

void
SnapshotEwinSticky(EWin * ewin)
{
  Snapshot           *sn;

  sn = GetSnapshot(ewin);
  if (!sn)
    return;
  sn->use_sticky = 1;
  sn->sticky = ewin->sticky;
}

void
SnapshotEwinIcon(EWin * ewin)
{
  Snapshot           *sn;

  sn = GetSnapshot(ewin);
  if (!sn)
    return;
  if (sn->iclass_name)
    Efree(sn->iclass_name);
  sn->iclass_name = NULL;
/*  sn->iclass_name = duplicate(ewin->border->name); */
}

void
SnapshotEwinShade(EWin * ewin)
{
  Snapshot           *sn;

  sn = GetSnapshot(ewin);
  if (!sn)
    return;
  sn->use_shade = 1;
  sn->shade = ewin->shaded;
}

/* record ALL the ewins state info */
void
SnapshotEwinAll(EWin * ewin)
{
  SnapshotEwinBorder(ewin);
  SnapshotEwinDesktop(ewin);
  SnapshotEwinArea(ewin);
  SnapshotEwinSize(ewin);
  SnapshotEwinLocation(ewin);
  SnapshotEwinLayer(ewin);
  SnapshotEwinSticky(ewin);
  SnapshotEwinIcon(ewin);
  SnapshotEwinShade(ewin);
}

/* unsnapshot any saved info about this ewin */
void
UnsnapshotEwin(EWin * ewin)
{
  Snapshot           *sn;

  char                buf[4096];

  if ((ewin->client.name) && (ewin->client.class))
    Esnprintf(buf, sizeof(buf), "%s.%s", ewin->client.name, ewin->client.class);
  else if (ewin->client.title)
    Esnprintf(buf, sizeof(buf), "TITLE.%s", ewin->client.title);
  else
    return;
  sn = RemoveItem(buf, 0, LIST_FINDBY_NAME, LIST_TYPE_SNAPSHOT);
  if (sn)
    {
      if (sn->name)
	Efree(sn->name);
      if (sn->border_name)
	Efree(sn->border_name);
      if (sn->iclass_name)
	Efree(sn->iclass_name);
      Efree(sn);
    }
}

/* save out all snapped info to disk */
void
SaveSnapInfo(void)
{
  Snapshot          **lst, *sn;
  int                 i, num;
  char                buf[4096], s[4096];
  FILE               *f;

  {
    Pager             **pl;

    pl = (Pager **) ListItemType(&num, LIST_TYPE_PAGER);
    if (pl)
      {
	for (i = 0; i < num; i++)
	  {
	    if (pl[i]->ewin)
	      {
		SnapshotEwinBorder(pl[i]->ewin);
		SnapshotEwinSize(pl[i]->ewin);
		SnapshotEwinLocation(pl[i]->ewin);
		SnapshotEwinLayer(pl[i]->ewin);
	      }
	  }
	Efree(pl);
      }
  }
/*  Esnprintf(buf, sizeof(buf), "%s.snapshots.%i", GetSMFile(), root.scr); */
  Etmp(s);
  f = fopen(s, "w");
  if (!f)
    return;
  lst = (Snapshot **) ListItemType(&num, LIST_TYPE_SNAPSHOT);
  if (lst)
    {
      for (i = 0; i < num; i++)
	{
	  sn = lst[i];
	  fprintf(f, "NEW: %s\n", sn->name);
	  if (sn->win_title)
	    fprintf(f, "TITLE: %s\n", sn->win_title);
	  if (sn->win_name)
	    fprintf(f, "NAME: %s\n", sn->win_name);
	  if (sn->win_class)
	    fprintf(f, "CLASS: %s\n", sn->win_class);
	  if (sn->use_desktop)
	    fprintf(f, "DESKTOP: %i\n", sn->desktop);
	  if (sn->use_area)
	    fprintf(f, "AREA: %i %i\n", sn->area_x, sn->area_y);
	  if (sn->use_wh)
	    fprintf(f, "WH: %i %i\n", sn->w, sn->h);
	  if (sn->use_xy)
	    fprintf(f, "XY: %i %i\n", sn->x, sn->y);
	  if (sn->use_layer)
	    fprintf(f, "LAYER: %i\n", sn->layer);
	  if (sn->use_sticky)
	    fprintf(f, "STICKY: %i\n", sn->sticky);
	  if (sn->use_shade)
	    fprintf(f, "SHADE: %i\n", sn->shade);
	  if (sn->border_name)
	    fprintf(f, "BORDER: %s\n", sn->border_name);
	  if (sn->iclass_name)
	    fprintf(f, "ICON: %s\n", sn->iclass_name);
	}
      Efree(lst);
    }
  fclose(f);
  Esnprintf(buf, sizeof(buf), "%s.snapshots.%i", GetGenericSMFile(), root.scr);
  rm(buf);
  mv(s, buf);
  if (!isfile(buf))
    Alert("Error saving snaps file\n");
/*  
 * if (strcmp(GetSMFile(), GetGenericSMFile()))
 * {
 * char                s22[4096];
 * 
 * Esnprintf(buf, sizeof(buf), "%s.snapshots.%i", GetGenericSMFile(), root.scr);
 * Esnprintf(s22, sizeof(s22), "%s.snapshots.%i", GetSMFile(), root.scr);
 * if (exists(buf))
 * rm(buf);
 * symlink(s22, buf);
 * }
 */
}

/* load all snapped info */
void
LoadSnapInfo(void)
{
  Snapshot           *sn = NULL;
  char                buf[4096], s[4096];
  FILE               *f;

  Esnprintf(buf, sizeof(buf), "%s.snapshots.%i", GetSMFile(), root.scr);
  if (!exists(buf))
    Esnprintf(buf, sizeof(buf), "%s.snapshots.%i", GetGenericSMFile(), root.scr);
  f = fopen(buf, "r");
  if (!f)
    return;
  while (fgets(buf, sizeof(buf), f))
    {
      /* nuke \n */
      buf[strlen(buf) - 1] = 0;
      word(buf, 1, s);
      if (!strcmp(s, "NEW:"))
	sn = NewSnapshot(atword(buf, 2));
      else if (sn)
	{
	  if (!strcmp(s, "TITLE:"))
	    sn->win_title = duplicate(atword(buf, 2));
	  else if (!strcmp(s, "NAME:"))
	    sn->win_name = duplicate(atword(buf, 2));
	  else if (!strcmp(s, "CLASS:"))
	    sn->win_class = duplicate(atword(buf, 2));
	  else if (!strcmp(s, "DESKTOP:"))
	    {
	      sn->use_desktop = 1;
	      word(buf, 2, s);
	      sn->desktop = atoi(s);
	    }
	  else if (!strcmp(s, "AREA:"))
	    {
	      sn->use_area = 1;
	      word(buf, 2, s);
	      sn->area_x = atoi(s);
	      word(buf, 3, s);
	      sn->area_y = atoi(s);
	    }
	  else if (!strcmp(s, "WH:"))
	    {
	      sn->use_wh = 1;
	      word(buf, 2, s);
	      sn->w = atoi(s);
	      word(buf, 3, s);
	      sn->h = atoi(s);
	    }
	  else if (!strcmp(s, "XY:"))
	    {
	      sn->use_xy = 1;
	      word(buf, 2, s);
	      sn->x = atoi(s);
	      word(buf, 3, s);
	      sn->y = atoi(s);
	    }
	  else if (!strcmp(s, "LAYER:"))
	    {
	      sn->use_layer = 1;
	      word(buf, 2, s);
	      sn->layer = atoi(s);
	    }
	  else if (!strcmp(s, "STICKY:"))
	    {
	      sn->use_sticky = 1;
	      word(buf, 2, s);
	      sn->sticky = atoi(s);
	    }
	  else if (!strcmp(s, "SHADE:"))
	    {
	      sn->use_shade = 1;
	      word(buf, 2, s);
	      sn->shade = atoi(s);
	    }
	  else if (!strcmp(s, "BORDER:"))
	    sn->border_name = duplicate(atword(buf, 2));
	  else if (!strcmp(s, "ICON:"))
	    sn->iclass_name = duplicate(atword(buf, 2));
	}
    }
  fclose(f);
}

/* make a client window conform to snapshot info */
void
MatchEwinToSnapInfo(EWin * ewin)
{
  Snapshot           *sn;
  Border             *b;

  sn = FindSnapshot(ewin);
  if (!sn)
    return;

  if (sn->use_desktop)
    ewin->desktop = sn->desktop;
  if (sn->use_area)
    {
      /* FIXME: fill this in */
    }
  if (sn->use_wh)
    {
      ewin->client.w = sn->w;
      ewin->client.h = sn->h;
    }
  if (sn->use_xy)
    {
      ewin->client.already_placed = 1;
      ewin->x = sn->x;
      ewin->y = sn->y;
      ewin->client.x = sn->x;
      ewin->client.y = sn->y;
    }
  if (sn->use_layer)
    ewin->layer = sn->layer;
  if (sn->use_sticky)
    ewin->sticky = sn->sticky;
  if (sn->use_shade)
    ewin->shaded = sn->shade;
  if (sn->iclass_name)
    {
      /* FIXME: fill this in */
    }
  if (sn->border_name)
    {
      b = (Border *) FindItem(sn->border_name, 0, LIST_FINDBY_NAME,
			      LIST_TYPE_BORDER);
      if (b)
	{
	  ewin->border_new = 1;
	  SetEwinToBorder(ewin, b);
	}
    }
}

void
MatchEwinToSnapInfoAfter(EWin * ewin)
{
  Snapshot           *sn;
  Border             *b;

  sn = FindSnapshot(ewin);
  if (!sn)
    return;

  if (sn->use_desktop)
    MoveEwinToDesktop(ewin, sn->desktop);
  if (sn->use_area)
    {
      /* FIXME: fill this in */
    }
  if (sn->use_wh)
    ResizeEwin(ewin, sn->w, sn->h);
  if (sn->use_xy)
    MoveEwin(ewin, sn->x, sn->y);
  if (sn->use_layer)
    {
      ewin->layer = sn->layer;
      RaiseEwin(ewin);
    }
  if (sn->use_sticky)
    {
      if (sn->sticky)
	MakeWindowSticky(ewin);
      else
	MakeWindowSticky(ewin);
    }
  if (sn->use_shade)
    {
      if (sn->shade)
	InstantShadeEwin(ewin);
      else
	InstantUnShadeEwin(ewin);
    }
  if (sn->iclass_name)
    {
      /* FIXME: fill this in */
    }
  if (sn->border_name)
    {
      b = (Border *) FindItem(sn->border_name, 0, LIST_FINDBY_NAME,
			      LIST_TYPE_BORDER);
      if (b)
	{
	  ewin->border_new = 1;
	  SetEwinToBorder(ewin, b);
	  ICCCM_MatchSize(ewin);
	  MoveResizeEwin(ewin, ewin->x, ewin->y, ewin->client.w,
			 ewin->client.h);
	}
    }
}
