# Note that this is NOT a relocatable package
%define name		gnomeicu
%define version		0.65
%define release		1

# defaults for redhat
%define prefix		/usr
%define sysconfdir	/etc

Summary: GnomeICU is a clone of Mirabilis' popular ICQ written with GTK.
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: Applications/Communications
URL: http://gnomeicu.gdev.net/
Source: ftp://gnomeicu.gdev.net/pub/gnomeicu/%{name}-%{version}.tar.gz
Requires: gnome-libs >= 1.0.0
Requires: ORBit >= 0.4.0
Requires: gtk+ >= 1.2.0
Packager: Herbert Valerio Riedel <hvr@hvrlab.dhs.org>
BuildRoot: /var/tmp/%{name}-%{version}-root

%description
GnomeICU is a clone of Mirabilis' popular ICQ written with GTK.
The original source was taken from Matt Smith's mICQ.  This is ment as
a replacement for the JavaICQ, which is slow and buggy.  If you would
like to contribute, please contact Jeremy Wise <jwise@pathwaynet.com>.


%prep
%setup -q

# seems as if xss support is broken on alpha :-(
%ifarch alpha
  ARCH_FLAGS="--host=alpha-redhat-linux --without-xss"
%endif

if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $ARCH_FLAGS --prefix=%{prefix} --sysconfdir=%{sysconfdir}
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure $ARCH_FLAGS --prefix=%{prefix} --sysconfdir=%{sysconfdir}
fi

%build
make

%install
make prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT%{sysconfdir}  install-strip

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc AUTHORS COPYING ChangeLog INSTALL NEWS README TODO
%config %{sysconfdir}/CORBA/servers/GnomeICU.gnorba
%config %{sysconfdir}/sound/events/GnomeICU.soundlist
%{prefix}/bin/gnomeicu
%{prefix}/share/applets/Network/GnomeICU.desktop
%{prefix}/share/pixmaps/*
%{prefix}/share/sounds/gnomeicu/*

###################################################################
%changelog

* Tue Jun 29 1999 Herbert Valerio Riedel <hvr@hvrlab.dhs.org>
- first try at an official RPM
