#include <string.h>
#include <gdk_imlib.h>
#include <applet-widget.h>
#include "applet.h"
#include "pixmaps.h"
#include "loadpixmap.h"

#include <gnome.h>
#include "../config.h"

GtkWidget *frame;
GtkWidget *frame_outline;
GtkWidget *frame_outline2;
GtkWidget *mess_label;
GtkWidget *mess_pm;
GtkWidget *applet;

static PanelOrientType orient;

gint applet_save_state_cb( GtkWidget * w, const char *privcfgpath, const char *globcfgpath, gpointer data );
void applet_exposed_cb( GtkWidget *widget, gpointer data );
GtkWidget *create_applet( void );
void init_applet_signals( GtkWidget *window, struct sokandlb *data );
static void applet_change_orient( GtkWidget *w, PanelOrientType o, gpointer data );

gint applet_save_state_cb( GtkWidget * w, const char *privcfgpath, const char *globcfgpath, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "applet_save_state_cb\n");
#endif
	/* save info here */

	gnome_config_sync();
	gnome_config_drop_all();

	return FALSE;
}

void applet_exposed_cb( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "applet_exposed_cb\n" );
#endif
	applet_update( Current_Status, NULL, data );
}

void applet_update( DWORD status, GdkPixmap *flash, struct sokandlb *data )
{
	GdkPixmap *status_pix;
	GdkBitmap *status_bit;
	char *message_count;
	int num_messages = 0;
	int cx;
	char *tooltips_str;
	char type = 0;

	if( applet_toggle == FALSE )
		return;

	message_count = (char *)g_malloc( 16 );
	tooltips_str = (char *)g_malloc( 64 );

	if( status == STATUS_OFFLINE )
	{
		status_pix = icon_offline_pixmap;
		status_bit = icon_offline_bitmap;
	}
	else switch( status & 0xffff )
	{
		case STATUS_ONLINE:
			status_pix = icon_online_pixmap;
			status_bit = icon_online_bitmap;
			break;
		case STATUS_AWAY:
			status_pix = icon_away_pixmap;
			status_bit = icon_away_bitmap;
			break;
		case STATUS_NA:
			status_pix = icon_na_pixmap;
			status_bit = icon_na_bitmap;
			break;
		case STATUS_DND:
			status_pix = icon_dnd_pixmap;
			status_bit = icon_dnd_bitmap;
			break;
		case STATUS_FREE_CHAT:
			status_pix = icon_ffc_pixmap;
			status_bit = icon_ffc_bitmap;
			break;
		case STATUS_OCCUPIED:
			status_pix = icon_occ_pixmap;
			status_bit = icon_occ_bitmap;
			break;
		case STATUS_INVISIBLE:
			status_pix = icon_inv_pixmap;
			status_bit = icon_inv_bitmap;
			break;
		default:
			status_pix = icon_offline_pixmap;
			status_bit = icon_offline_bitmap;
			break;
	}

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].messages && type == 0 )
			type = Contacts[ cx ].message[0][0];
		num_messages += Contacts[ cx ].messages;
	}

	if( flash != NULL )
		switch( type )
		{
			case 'c':
				gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_chat_pixmap,
				                icon_chat_bitmap );
				break;
			case 'f':
				gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_file_pixmap,
				                icon_file_bitmap );
				break;
			case 'u':
				gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_url_pixmap,
				                icon_url_bitmap );
			default:
				gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_message_pixmap,
				                icon_message_bitmap );
		}

	else if( num_messages )
		gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_blank_pixmap,
		                icon_blank_bitmap );
	else
		gtk_pixmap_set( GTK_PIXMAP( mess_pm ), status_pix,
		                status_bit );


	sprintf( message_count, "%d", num_messages );

	gtk_label_set( GTK_LABEL( mess_label ), message_count );

	sprintf( tooltips_str, "%u: %u User(s) Online", our_info->uin, MainData->online );
	applet_widget_set_tooltip( APPLET_WIDGET( applet ), tooltips_str );

	g_free( message_count );
	g_free( tooltips_str );
}

void applet_hide_main( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "applet_hide_main\n" );
#endif

	if( !applet_toggle )
		return;

	if( !GTK_WIDGET_VISIBLE( app ) )
		gtk_widget_show( app );
	else
		gtk_widget_hide( app );
}

void applet_clicked_cb( GtkWidget *widget, GdkEventButton *ev, gpointer data )
{
	int cx = 0;

#ifdef TRACE_FUNCTION
	g_print( "applet_clicked_cb\n" );
#endif

	if( ev == NULL )
		return;

	if( ev->button != 1 || ev->type != GDK_2BUTTON_PRESS )
		return;

	while( cx < Num_Contacts && Contacts[ cx ].messages == 0 )
		cx ++;

	if( cx == Num_Contacts )
	{
		if( !GTK_WIDGET_VISIBLE( app ) )
			gtk_widget_show( app );
		else
			gtk_widget_hide( app );
	}
	else
		show_contact_message( cx, data );
}

extern void about( GtkWidget *widget, struct sokandlb *data );

void init_applet_signals( GtkWidget *window, struct sokandlb *data )
{
	gtk_widget_set_events( window, gtk_widget_get_events( window ) |
	                       GDK_BUTTON_PRESS_MASK | GDK_EXPOSURE_MASK );
	gtk_signal_connect( GTK_OBJECT( window ), "expose_event",
	                    GTK_SIGNAL_FUNC( applet_exposed_cb ), data );
	gtk_signal_connect( GTK_OBJECT( window ), "button_press_event",
	                    GTK_SIGNAL_FUNC( applet_clicked_cb ), data );
	gtk_signal_connect( GTK_OBJECT( window ), "change_orient",
	                    GTK_SIGNAL_FUNC( applet_change_orient ), NULL );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "about",
	                                       GNOME_STOCK_MENU_ABOUT,
	                                       _("About..."),
	                                       (AppletCallbackFunc)about,
	                                       NULL );
	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "options",
	                                       GNOME_STOCK_MENU_PROP,
	                                       _("Options..."),
	                                       (AppletCallbackFunc)configure_window,
	                                       MainData );
	applet_widget_register_callback( APPLET_WIDGET( applet ),
	                                       "set_online",
	                                       _("Online"),
	                                       (AppletCallbackFunc)icq_set_status_online,
	                                       MainData );
	applet_widget_register_callback( APPLET_WIDGET( applet ),
	                                       "set_away",
	                                       _("Away"),
	                                       (AppletCallbackFunc)icq_set_status_away,
	                                       MainData );
	applet_widget_register_callback( APPLET_WIDGET( applet ),
	                                       "set_na",
	                                       _("Not Available"),
	                                       (AppletCallbackFunc)icq_set_status_na,
	                                       MainData );
	applet_widget_register_callback( APPLET_WIDGET( applet ),
	                                       "set_ffc",
	                                       _("Free for Chat"),
	                                       (AppletCallbackFunc)icq_set_status_ffc,
	                                       MainData );
	applet_widget_register_callback( APPLET_WIDGET( applet ),
	                                       "set_occupied",
	                                       _("Occupied"),
	                                       (AppletCallbackFunc)icq_set_status_occ,
	                                       MainData );
	applet_widget_register_callback( APPLET_WIDGET( applet ),
	                                       "set_dnd",
	                                       _("Do Not Disturb"),
	                                       (AppletCallbackFunc)icq_set_status_dnd,
	                                       MainData );
	applet_widget_register_callback( APPLET_WIDGET( applet ),
	                                       "set_invisible",
	                                       _("Invisible"),
	                                       (AppletCallbackFunc)icq_set_status_invisible,
	                                       MainData );
	applet_widget_register_callback( APPLET_WIDGET( applet ),
	                                       "set_offline",
	                                       _("Offline"),
	                                       (AppletCallbackFunc)icq_set_status_offline,
	                                       MainData );
}

GtkWidget *create_applet( void )
{
#if 0
	GtkStyle *style;
#endif
	GtkWidget *table;
	GtkWidget *eventbox;

#ifdef TRACE_FUNCTION
	g_print( "create_applet\n" );
#endif

	if( mess_label == NULL )
		mess_label = gtk_label_new( "0" );

	if( mess_pm == NULL )
		mess_pm = gtk_pixmap_new( icon_blank_pixmap, icon_blank_bitmap );

	gtk_widget_push_visual (gdk_imlib_get_visual ());
	gtk_widget_push_colormap (gdk_imlib_get_colormap ());

	table = gtk_table_new( 2, 1, FALSE );
	eventbox = gtk_event_box_new();
	frame_outline = gtk_frame_new( NULL );
	frame_outline2 = gtk_frame_new( NULL );
	gtk_container_add( GTK_CONTAINER( eventbox ), frame_outline );
	
	frame = gtk_fixed_new();
	gtk_widget_set_usize( frame, 26, 44 );

	gtk_container_add( GTK_CONTAINER( frame_outline ), frame_outline2 );
	gtk_container_add( GTK_CONTAINER( frame_outline2 ), frame );
	gtk_frame_set_shadow_type( GTK_FRAME( frame_outline ), GTK_SHADOW_IN );
	gtk_frame_set_shadow_type( GTK_FRAME( frame_outline2 ), GTK_SHADOW_OUT );
	gtk_widget_set_usize( frame_outline, 28, 48 );
	gtk_widget_show( frame_outline );
	gtk_widget_show( frame_outline2 );

	gtk_widget_show( table );
	gtk_widget_show( frame );

/*  gtk_fixed_put( GTK_FIXED( frame ), mess_pm,
                 (frame->allocation.width - mess_pm->allocation.width)/2, 3);
*/
	gtk_fixed_put( GTK_FIXED( frame ), mess_pm, 2, 3 );
	gtk_widget_show( mess_pm );

	gtk_misc_set_alignment( GTK_MISC( mess_label ), 0.5, 0.5 );
	gtk_fixed_put( GTK_FIXED( frame ), mess_label, 5, 22 );
	gtk_widget_show( mess_label );

	gtk_widget_pop_colormap ();
	gtk_widget_pop_visual ();
        return eventbox;
}

static char *cfnp;

void
make_applet( int argc, char *argv[], struct sokandlb *data )
{
	int cx;

	GtkStyle *style;

	static struct poptOption arguments[] =
	{
		{"uin", 'u', POPT_ARG_STRING, &cfnp, 0, N_("Use the defined UIN"), N_("UIN")},
		{"noapplet", 'a', POPT_ARG_NONE, 0, 0, N_("startup without applet support"), NULL},
		{NULL, 0, 0, NULL, 0, NULL, NULL}
	};

	GtkWidget *widget;

#ifdef TRACE_FUNCTION
	g_print( "make_applet\n" );
#endif

	for( cx = 0; cx < argc; cx ++ )
	{
		if( !strcmp( "-a", argv[ cx ] ) ||
		    !strcmp( "--noapplet", argv[ cx ] ) )
			applet_toggle = FALSE;
	}

	if( applet_toggle == FALSE )
		return;

	cfnp = 0;
	applet_widget_init( "gnomeicu", VERSION, argc, argv,
	                    arguments, 0, NULL );

	if( cfnp )
		sprintf( configfilename, "/GnomeICU_%s/", cfnp );

	applet = applet_widget_new( "gnomeicu" );
	if ( !applet )
		g_error( _( "Can't create applet!\n" ) );

	style = gtk_widget_get_style( applet );

	init_applet_signals( applet, data );
	gtk_widget_realize( applet );
	init_pixmaps( style, applet );
	widget = create_applet();
	gtk_widget_show( widget );

	applet_widget_add( APPLET_WIDGET( applet ), widget );

	gtk_widget_show( applet );

	gtk_signal_connect( GTK_OBJECT(applet), "save_session",
	                    GTK_SIGNAL_FUNC(applet_save_state_cb),
	                    NULL);

	/* EKP 3.10.99 - changed connect_object to connect,
	   icq_quit_object to icq_quit, and &data to data */
	gtk_signal_connect( GTK_OBJECT( applet ), "destroy",
	                    GTK_SIGNAL_FUNC( icq_quit ),
	                    (gpointer)data );

}

/* A lot of this code was ripped out of the modemlights applet, so I can't
 * take credit for it myself :)
 */

static void applet_change_orient( GtkWidget *w, PanelOrientType o, gpointer data )
{
	orient = o;

	if( orient == ORIENT_LEFT || orient == ORIENT_RIGHT )
	{
		gtk_widget_set_usize( frame, 44, 26 );
		gtk_widget_set_usize( frame_outline, 48, 28 );
/*		gtk_misc_set_alignment( GTK_MISC( mess_label ), 0.5, 0.5 );*/
		gtk_fixed_move( GTK_FIXED( frame ), mess_label, 30, 2 );
	}
	else
	{
		gtk_widget_set_usize( frame, 26, 44 );
		gtk_widget_set_usize( frame_outline, 28, 48 );
/*		gtk_misc_set_alignment( GTK_MISC( mess_label ), 0.5, 0.5 );*/
		gtk_fixed_move( GTK_FIXED( frame ), mess_label, 6, 22 );
	}
}
