/* vi:set ts=8 sts=0 sw=8:
 * $Id: misc.c,v 1.5 1999/01/18 20:03:04 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <time.h>
#include <glib.h>
#include "main.h"
#include "misc.h"
#include "prefs.h"


/*** global function definitions ***/
char *
my_tempname(void)
{
	char *fname;

	/*
	 * is tempnam() portable?  if so, we could do:
	 *	fname = tempnam(tmpdir, ".gnp");
	 * but i don't think it's ANSI compliant...
	 */
	fname = (char *)g_malloc(255);
	g_snprintf(fname, 255, "%s/.gnp%d%d",
		   prefs.tmpdir, (int)time(NULL), (int)getpid());

	return fname;
} /* my_tempnam() */


#ifndef GTK_HAVE_FEATURES_1_1_0
const char *
my_basename(const char *name)
{
	register gchar *base;

	if (name == NULL)
		return NULL;

	base = strrchr(name, '/');
	if (base)
		return base + 1;

	return (char *)name;
} /* my_basename */
#endif


/*
 * PUBLIC: misc_button_new_w_label
 *
 * convenience routine for creating button with label
 */
GtkWidget *
misc_button_new_w_label(char *labelname,
			GtkSignalFunc cbfunc,
			gpointer cbdata,
			GtkWidget *parent,
#ifdef GTK_HAVE_FEATURES_1_1_0
			GtkReliefStyle relief,
#endif
			GtkWidget *table,
			int lft1, int rht1, int top1, int bot1)
{
	GtkWidget *tmp;

	tmp = gtk_button_new_with_label(labelname);
	if (cbfunc)
		gtk_signal_connect(GTK_OBJECT(tmp), "clicked",
				   GTK_SIGNAL_FUNC(cbfunc), cbdata);

	if (table) {
		gtk_table_attach_defaults(GTK_TABLE(table),
					  tmp, lft1, rht1, top1, bot1);
	} else
		gtk_box_pack_start(GTK_BOX(parent), tmp, TRUE, TRUE, 0);

#ifdef GTK_HAVE_FEATURES_1_1_0
	gtk_button_set_relief(GTK_BUTTON(tmp), relief);
#endif
	return tmp;
} /* misc_button_new_w_label */


/*
 * PUBLIC: ttoa
 *
 * converts time_t to an ascii string.  non-reentrant because ctime() is
 * non-reentrant.
 */
char *
ttoa(time_t curtime, bool_t append_nl)
{
	char *timestr;

	timestr = ctime(&curtime);
	if (!append_nl) {
		if (timestr[strlen(timestr) - 1] == '\n')
			timestr[strlen(timestr) - 1] = '\0';
	}

	return timestr;
} /* ttoa */


/*
 * PUBLIC: ltoa
 *
 * converts a (long) number to an ascii string.  non-reentrant because i use a
 * static local variable.
 */
char *
ltoa(long num)
{
	static char str[MAXPATH];

	g_snprintf(str, MAXPATH, "%ld", num);
	return str;
} /* ltoa */


/*
 * PUBLIC: strcasestr
 *
 * strcasestr() is basically the code for strstr() taken from glibc.
 * toupper() statements are used where needed so that comparisons between
 * differing case no longer matter.  the original author's comment follows:
 */
/*
 * My personal strstr() implementation that beats most other algorithms.
 * Until someone tells me otherwise, I assume that this is the
 * fastest implementation of strstr() in C.
 * I deliberately chose not to comment it.  You should have at least
 * as much fun trying to understand it, as I had to write it :-).
 *
 * Stephen R. van den Berg, berg@pool.informatik.rwth-aachen.de	*/
typedef unsigned chartype;
char *
strcasestr(const char *phaystack, const char *pneedle)
{
	register const unsigned char *haystack, *needle;
	register chartype b, c;

	haystack = (const unsigned char *)phaystack;
	needle = (const unsigned char *)pneedle;

	b = *needle;
	if (b != '\0')
	{
		haystack--;	/* possible ANSI violation */
		do
		{
			c = *++haystack;
			if (c == '\0')
				goto ret0;
		}
		while (toupper(c) != toupper(b));

		c = *++needle;
		if (c == '\0')
			goto foundneedle;
		++needle;
		goto jin;

		for (;;)
		{
			register chartype a;
			register const unsigned char *rhaystack, *rneedle;

			do
			{
				a = *++haystack;
				if (a == '\0')
					goto ret0;
				if (toupper(a) == toupper(b))
					break;
				a = *++haystack;
				if (a == '\0')
					goto ret0;
shloop:				if (0) goto shloop;	/* avoid ANSI warning */
			}
			while (toupper(a) != toupper(b));

jin:	  a = *++haystack;
			if (a == '\0')
				goto ret0;

			if (toupper(a) != toupper(c))
				goto shloop;

			rhaystack = haystack-- + 1;
			rneedle = needle;
			a = *rneedle;

			if (toupper(*rhaystack) == toupper(a))
				do
				{
					if (a == '\0')
						goto foundneedle;
					++rhaystack;
					a = *++needle;
					if (toupper(*rhaystack) != toupper(a))
						break;
					if (a == '\0')
						goto foundneedle;
					++rhaystack;
					a = *++needle;
				}
				while (toupper(*rhaystack) == toupper(a));

			needle = rneedle;/* took the register-poor approach */

			if (a == '\0')
				break;
		}
	}
foundneedle:
	return (char*) haystack;
ret0:
	return 0;
} /* strcasestr */


/* the end */
