# ScrollText -- Scrollbar/Text Entry valuator widget
#
# Copyright 1998, Jon A. Christopher
#
@class XltEntrySB (XmManager) @file=XltEntrySB
@ The |XltEntrySB| widget implements a valuator that can be changed either
by entering a value in an |XmTextEntry| field, or by moving an
|XmScale|.  The value is a float, but it is pased as a
string because C cannot cast floats to pointers.  This is the Motif
version of MmwEntrySB.
 

@PUBLIC
@ |minval| and |maxval| are the minimum and maximum values for the
valuator, respectivly.  |decimals| indicates how many decimal places
should be indicated in the text entry field, and may be zero.
	@var String minval = "0.0"
	@var String maxval = "100.0"
	@var int decimals = 0
@ This is the value of the Widget.
	@var String value  = "0.0"

@ The following resourses are only used on creation:

@ The width of the scrollbar is specified by |scrollWidth|.  
	@var Dimension scrollWidth = 200
@ This is the overall height of the widget.  If not specified, one is
calculated. 
        @var Dimension height = 0
@ This is the number of characters in the text entry widget
        @var int textWidth = 7
@ The label, if any, to be used for the scrollbar.
	@var String label = NULL

@ The |valueChanged| callback is invoked when the value changes via a new
text entry or the slider moving
	@var <Callback> XtCallbackList valueChanged = NULL

@PRIVATE
	@var Widget scrollbar
	@var Widget text
	@var Widget label_widget
        @var int manual_update
        @var float internal_min
        @var float internal_max
        @var float internal_value
        @var char value_buf[25];

@METHODS
@proc initialize
{
  char tmp[25];
  char fmt[10];
  Widget rowcol;
  float init_val;
  Position x, y;
  Dimension h,w,width,height,label_height;
  int direction, font_ascent, font_descent;
  XCharStruct overall;

  XmFontList font_list;
  XFontStruct *font, **FontList;
  XtPointer FontPtr;
#if (XmREVISION <= 1)
  XmStringCharSet CharSet;
  XmFontContext FontContext;
#else
  XmFontType FontType;
#endif
  int NrOfFonts;
  char **FontNameList;
  
  if (!sscanf($value,"%f",&$internal_value))
    return;
  if (!sscanf($minval,"%f",&$internal_min))
    return;
  if (!sscanf($maxval,"%f",&$internal_max))
    return;

  sprintf($value_buf,$value);
  rowcol = XtVaCreateManagedWidget
    ("box", xmRowColumnWidgetClass, $,
     XmNorientation, XmHORIZONTAL,
     NULL);
  
  $scrollbar = XtVaCreateManagedWidget
    ("scrollbar", xmScaleWidgetClass, rowcol,
     XmNscaleWidth, $scrollWidth,
     XmNscaleHeight, 20,
     XmNorientation, XmHORIZONTAL,
     NULL);
  XtAddCallback($scrollbar, XmNvalueChangedCallback, (XtPointer) scroll_CB, $);
  XtAddCallback($scrollbar, XmNdragCallback, (XtPointer) scroll_CB, $);
  
  if ($label) {
    XmString xmstr;
    xmstr=XmStringCreateSimple($label);
    XtVaSetValues($scrollbar,
		  XmNtitleString, xmstr,
		  NULL);
    XmStringFree(xmstr);
    $label_widget=XtNameToWidget($scrollbar,"Title");

    /* all this shit just to get the font from Motif?! What the fuck? */
    XtVaGetValues($label_widget,
		  XmNfontList, &font_list,
		  NULL);
#if (XmREVISION <= 1)
    XmFontListInitFontContext(&FontContext, font_list);
    XmFontListGetNextFont(FontContext, &CharSet, &font);
    XtFree(CharSet);
    XmFontListFreeFontContext(FontContext);
#else
    FontPtr = XmFontListEntryGetFont(font_list, &FontType);
    if ( FontType == XmFONT_IS_FONT )
      font = (XFontStruct *) FontPtr;
    else {
      NrOfFonts = XFontsOfFontSet((XFontSet) FontPtr,
				  &FontList, &FontNameList);
      font = FontList[0];
    }
#endif
      /* get label width and height */
      XTextExtents(font, $label, strlen($label), &direction,
		   &font_ascent, &font_descent, &overall);
      label_height=overall.ascent+overall.descent+4;
      w=overall.width+4;
      height=(label_height>20?2*label_height:40); /* 2*max height */
      width=($scrollWidth>w?$scrollWidth:w);
  }
  else {
    height=20; /* scrollbar height */
    width=$scrollWidth;
  }

  $text = XtVaCreateManagedWidget
    ("text", xmTextFieldWidgetClass, rowcol,
     XmNcolumns, $textWidth+1,
     NULL);
  XtVaGetValues($text,
		XtNwidth, &w,
		XtNheight, &h,
		NULL);
  $->core.width=w+10+width;
  if ($height)
    $->core.height=$height;
  else 
    $->core.height=(h>height?h+10:height+10);
  XtAddCallback($text, XmNactivateCallback, (XtPointer) activate_CB, $);
  XtAddCallback($text,XmNfocusCallback,(XtPointer)focusCB,NULL);
  update_display($);
  $manual_update=False;
}

@ The |set_values| method updates any changed resources.
@proc set_values
{
  float new_val;
  Boolean need_redraw = False;

  if ($old$minval != $minval) {
    if (!sscanf($minval,"%f",&$internal_min)) {
      XtError("MmwSetValues called with invalid minval");
      return FALSE;
    }
    else {
      update_display($);
      need_redraw=TRUE;
    }
  }
  if ($old$maxval != $maxval) {
    if (!sscanf($maxval,"%f",&$internal_max)) {
      XtError("MmwSetValues called with invalid maxval");
      return FALSE;
    }
    else {
      update_display($);
      need_redraw=TRUE;
    }
  }
  if ($old$value != $value) {
    if (!sscanf($value,"%f",&$internal_value)) {
      XtError("MmwSetValues called with invalid maxval");
      return FALSE;
    }
    else {
      update_display($);
      need_redraw=TRUE;
    }
  }
  if ($old$decimals != $decimals) {
    update_display($);
    need_redraw=TRUE;
  }
  return need_redraw;
}

@UTILITIES
@proc activate_CB(Widget w, $, XtPointer call)
{
  /* this should check for a valid value, then
     1) change the scrollbar,
     2) call valueChanged 
     */
  float new_value;
  char *call_data = XmTextFieldGetString(w);

  if (!sscanf(call_data,"%f",&new_value)) 
    XBell(XtDisplay($),100);
  else if ((new_value>=$internal_min && new_value<=$internal_max) ||
	   ($internal_min>$internal_max && 
	    (new_value<=$internal_min && new_value>=$internal_max))) {
    $internal_value=new_value;
    XtCallCallbackList($, $valueChanged, (XtPointer)call_data); 
  }
  else 
    XBell(XtDisplay($),100);

  update_display($);
}

@proc scroll_CB(Widget w, $, XmScaleCallbackStruct *call_data)
{
  /* convert from fraction, update the text entry area,
     and call valueChanged */
  $internal_value=((float)(call_data->value)/100.0)*
    ($internal_max-$internal_min)+$internal_min;
  update_display($);
  XtCallCallbackList($, $valueChanged, (XtPointer)$value_buf);
}

@UTILITIES

@ The |focusCB| routine selects the current contents of the text entry
field when it accepts input focus.

@proc focusCB( Widget w, XtPointer client, XmAnyCallbackStruct *call)
{
  XmTextFieldSetSelection(w,0,XmTextFieldGetLastPosition(w),
			  XtLastTimestampProcessed(XtDisplay(w)));
}


@ The |update_display| utility updates the scrollbar and text widgets to
reflect the new value.  The |valueChanged| callback is not called.

@proc update_display($)
{
  float new_val;
  char fmt[10];

  new_val=($internal_value-$internal_min)/($internal_max-$internal_min);
  if (new_val<0.0)
    new_val=0.0;
  if (new_val>1.0)
    new_val=1.0;
  XmScaleSetValue($scrollbar, (int)floor((double)(0.5+(new_val*100.0f))));
  
  sprintf(fmt,"%%%d.%df",$textWidth,$decimals);
  $value=$value_buf;
  sprintf($value,fmt, $internal_value);
  XmTextFieldSetString($text,$value);
  XmTextFieldSetSelection($text,0,strlen($value),
			  XtLastTimestampProcessed(XtDisplay($)));
}

@IMPORTS
@incl <Xm/RowColumn.h>
@incl <Xm/Scale.h>
@incl <Xm/TextF.h>
@incl <math.h>
@incl <stdio.h>



