/**
 *
 * $Id: Container.c,v 1.2 1999/08/17 22:09:54 rwscott Exp $
 *
 * Copyright (C) 1997 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#include <LTconfig.h>
#include <XmI/XmI.h>

#include <Xm/XmP.h>
#include <Xm/BaseClassP.h>
#include <Xm/Container.h>
#include <Xm/ContainerP.h>
#include <Xm/ContainerT.h>

#include <XmI/DebugUtil.h>


/* 
  MODULE: Container.c
  DESCRIPTION:
  This is just a stub.
  END:
*/

/*
 * Forward Declarations
 */

static void class_part_initialize(WidgetClass widget_class);

static void initialize(Widget request,
		       Widget new_w,
		       ArgList args,
		       Cardinal *num_args);

static void resize(Widget w);

static Boolean set_values(Widget current,
			  Widget request,
			  Widget new_w,
			  ArgList args,
			  Cardinal *num_args);

static void expose(Widget w, XEvent *event, Region region);

static XtGeometryResult query_geometry(Widget w,
				       XtWidgetGeometry *request,
				       XtWidgetGeometry *reply);

/* composite */
static XtGeometryResult geometry_manager(Widget w,
					 XtWidgetGeometry *request,
					 XtWidgetGeometry *reply);

static void change_managed(Widget w);

/* constraint */
static void constraint_initialize(Widget request,
				  Widget new_w,
				  ArgList args,
				  Cardinal *num_args);

static void constraint_destroy(Widget w);

static Boolean constraint_set_values(Widget current,
				     Widget request,
				     Widget new_w,
				     ArgList args,
				     Cardinal *num_args);

/*
 * resources for the Container class
 */
#define Offset(field) XtOffsetOf(XmContainerRec, container.field)
static XtResource resources[] =
{
    {
	XmNmarginHeight, XmCMarginHeight, XmRVerticalDimension,
	sizeof(Dimension), Offset(margin_height),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNmarginWidth, XmCMarginWidth, XmRHorizontalDimension,
	sizeof(Dimension), Offset(margin_width),
	XmRImmediate, (XtPointer)0
    }
};


/* *INDENT-OFF* */
XmContainerClassRec xmContainerClassRec = {
    /* Core class part */
    {
	/* superclass            */ (WidgetClass) &xmManagerClassRec,
        /* class_name            */ "XmContainer",
	/* widget_size           */ sizeof(XmContainerRec),
	/* class_initialize      */ NULL /*class_initialize*/,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ False,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ XtInheritRealize,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ True,
	/* compress_exposure     */ XtExposeCompressMaximal,
	/* compress_enterleave   */ True,
	/* visible_interest      */ False,
	/* destroy               */ NULL,
	/* resize                */ resize,
	/* expose                */ expose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ XtInheritTranslations,
	/* query_geometry        */ query_geometry,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)NULL /*&_XmContainerCoreClassExtRec*/
    },
    /* Composite class part */
    {
	/* geometry manager */ geometry_manager, 
        /* change_managed   */ change_managed, 
        /* insert_child     */ XtInheritInsertChild,
        /* delete_child     */ XtInheritDeleteChild,
        /* extension        */ (XtPointer)NULL
    },
    /* Constraint class part */
    {
	/* subresources      */ NULL /*containerConstraintResources*/,
        /* subresource_count */ 0 /*XtNumber(containerConstraintResources)*/, 
        /* constraint_size   */ 0 /*sizeof(XmContainerConstraintRec)*/,
        /* initialize        */ constraint_initialize,
        /* destroy           */ constraint_destroy,
        /* set_values        */ constraint_set_values,
        /* extension         */ NULL,  
    },
    /* XmManager class part */
    {
	/* translations                 */ XtInheritTranslations,
        /* syn_resources                */ NULL,
        /* num_syn_resources            */ 0,
        /* syn_constraint_resources     */ NULL,
        /* num_syn_constraint_resources */ 0,
        /* parent_process               */ XmInheritParentProcess,
	/* extension                    */ (XtPointer)NULL
    },
    /* XmContainer Area part */
    {
	/* extension */ NULL,
    },
};
/* *INDENT-ON* */

WidgetClass xmContainerWidgetClass = (WidgetClass)&xmContainerClassRec;

Widget XmCreateContainer(Widget parent,
                         String name,
                         ArgList arglist,
                         Cardinal argcount)
{
   /* FIXTHIS: Needs to be implemented */
   return NULL;
}

static void class_part_initialize(WidgetClass widget_class)
{
   /* FIXTHIS: Needs to be implemented */
}

static void initialize(Widget request,
		       Widget new_w,
		       ArgList args,
		       Cardinal *num_args)
{
   /* FIXTHIS: Needs to be implemented */
}

static void resize(Widget w)
{
   /* FIXTHIS: Needs to be implemented */
}


static Boolean set_values(Widget current,
			  Widget request,
			  Widget new_w,
			  ArgList args,
			  Cardinal *num_args)
{
    /* FIXTHIS: Needs to be implemented */
    return False;
}

static void expose(Widget w, XEvent *event, Region region)
{
    /* FIXTHIS: Needs to be implemented */
}

static XtGeometryResult query_geometry(Widget w,
				       XtWidgetGeometry *request,
				       XtWidgetGeometry *reply)
{
    /* FIXTHIS: Needs to be implemented */
    return XtGeometryNo;
}

/* composite */
static XtGeometryResult geometry_manager(Widget w,
					 XtWidgetGeometry *request,
					 XtWidgetGeometry *reply)
{
    /* FIXTHIS: Needs to be implemented */
    return XtGeometryNo;
}

static void change_managed(Widget w)
{
    /* FIXTHIS: Needs to be implemented */
}

/* constraint */
static void constraint_initialize(Widget request,
				  Widget new_w,
				  ArgList args,
				  Cardinal *num_args)
{
    /* FIXTHIS: Needs to be implemented */
}

static void constraint_destroy(Widget w)
{
    /* FIXTHIS: Needs to be implemented */
}

static Boolean constraint_set_values(Widget current,
				     Widget request,
				     Widget new_w,
				     ArgList args,
				     Cardinal *num_args)
{
    /* FIXTHIS: Needs to be implemented */
    return False;
}
