/*
 *  desktop -- The 3dfx Desktop Demo 
 *  COPYRIGHT 3DFX INTERACTIVE, INC. 1999
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>

#include <signal.h>

#include "init.h"
#include "global.h"
#include "render.h"
#include "control.h"
#include "util.h"
#include "model.h"
#include "flight.h"
#include "window.h"
#include "window_state.h"
#include "gxf.h"
#include "mathutil.h"
#include "tux.h"
#include "bird.h"



/*#include "util.h"*/

#include <sys/time.h>
#include <unistd.h>

#define FRAME_AVG 1

key_t shmkeys[HTILES * VTILES];
int   shmids [HTILES * VTILES];
unsigned char* shmptrs[HTILES * VTILES]; 

#ifndef USE_GLIDE3
GrHwConfiguration hwconfig;
#endif
GrScreenResolution_t resolution = RESOLUTION;

/* This stuff is for making glide3x behave like glide2x */
#ifdef USE_GLIDE3
FxU32 GR_WDEPTHVALUE_FARTHEST;
#endif

int
main (int argc, char **argv)
{
  float the_time = 0;
  Demo_State state;
  Matrix frustum, scale, rotate;

  
  /* Stuff for frame rate calculation */
  float time_for_frames = 0;
  int frame_count = 0;

  /* X stuff */
  Display *display;
  
  /* Control Stuff */
  Main_Window *mw;

  Window root, parent, *children;
  unsigned int nchildren;
  int wait;

  struct timeval tv_end;

  /* A flight model */
  Flight_Model flight;

  display = init_X ();

  root = RootWindow (display, 0);
  XQueryTree (display, RootWindow (display, 0), &root, &parent, &children,
  	      &nchildren);
  XSync (display, False);
  XFree (children);

  mw = init_control (display, &state);

  /* An environment variable is used to control the desktop overlay hack
   * for glide.  It is a bit dangerous to run this demo without using
   * the desktop overlay hack (your screen turns pink and you can't find
   * the quit button) so I always force the hack to be on. */
  setenv ("SSTH3_DESKTOP_OVERLAY", "1", 1);

#ifdef GPROG
  init_glide ();
  init_textures (&state);
  render_newframe (&state);
  grBufferSwap (1);
#endif  

  /* Get state ready */
  state.back = BACK_NONE;
  mw->bmode = BG_SCALED;
  state.tile_string = "Scaled";
  state.background_texture_half_width =  128;
  state.background_texture_half_height = 128 * 512.f / 640.f;
  state.background_index = 0;
  state.wave_amplitude = 18.75;
  state.need_clears = 1;
  state.n_wstates = 0;

  /* Setup the view matrix */
  ViewportMat (state.project, 0.0f, GLIDE_WIDTH, 0.0f, GLIDE_HEIGHT, 
	       1.0f, DESKTOP_DEPTH);
  PerspectiveMat (frustum, DEG_TO_RAD (60.f), 
  		  (float)GLIDE_WIDTH / (float)(GLIDE_HEIGHT), 
  		  1.0f, DESKTOP_DEPTH);
  MatMultMat4x4 (state.project, state.project, frustum);
  /* Now take the inverse of the project to get the unproject */
  if (!InvertMatrix4x4Cramer (state.unproject, state.project))
    printf ("could not invert projection matrix\n");

  //exit (-1);
  /* Setup the flying object */
  flight.X[0] = 10.0;
  flight.X[1] = 0;
  flight.X[2] = -60;
  /* Initial velocity */
  flight.dX[0] = -0.7;
  flight.dX[1] = 0;
  flight.dX[2] = 0;
  state.flight = &flight;

  init_wave (&state);
  gettimeofday (&state.cur_frame_time, NULL);

  srand (time(NULL));

  /* Get the spider model */
  state.spider_walk = open_gxf (&state, "data/spider/spider.GXF");  
  /* Get the bird model */
  state.bird_fly = open_gxf (&state, "data/bird/bird.GXF");

  state.back = BACK_NONE;
  mw->bmode = BG_SCALED;
  state.tile_string = "Scaled";
  state.background_texture_half_width =  128;
  state.background_texture_half_height = 128 * 512.f / 640.f;
  state.background_index = 0;
  state.wave_amplitude = 18.75;
  state.need_clears = 1;
  state.n_wstates = 0;

  /* Global world matrix */
  /* Build Spider Orientation Matrix */
  UniformScaleMat (scale, 1.f / 1.5f);
  MatrixCopy (state.spider_orientation, scale);

  /* Initialize tux's state */
  init_tux (&state);
  /* Initialize the bird */
  init_bird (&state);

  IdentityMat (state.model);
  IdentityMat (state.identity);

  /* Main Loop */
  while (1)
  {
    /* Take a time snapshot */
    state.prev_frame_time = state.cur_frame_time;
    gettimeofday (&state.cur_frame_time, NULL);
    state.delta_time = timeval_sub (&state.cur_frame_time, 
				    &state.prev_frame_time);


    /* Calculate frame rate.  Do this before removing X time so it is a real frame rate */
    time_for_frames += state.delta_time;
    frame_count++;

    if (frame_count >= FRAME_AVG)
    {
      //#define PRINT_FPS
#ifdef PRINT_FPS
      printf ("fps: %.2f\n", 1000000 * frame_count / time_for_frames);
#endif
      time_for_frames = 0;
      frame_count = 0;
    }

    /* If X took more than 1/30 of a second (one frame) then drop its time from the counter */
    /* The time may have been very long.  This could happen if X was waiting
     * while the user had the mouse down, or if I am debugging and 
     * have stopped the program.  If this takes more than 1/15 of a second
     * (two frames) then cap the time at 1/15.  If the times get too
     * big the geometry can jump to huge coordinates which will hang the 
     * hardware.  Also if I am debugging I want to debug animation that
     * thinks its running normally.
     */
    if (state.delta_time >= 66667)
    {
      state.delta_time = 66667;
    }
    /* Compute delta time in floating point in seconds */
    state.dt = state.delta_time / 1000000.f;

    build_window_list (display, &state, mw);
    /* A current window list now exists so update the window states */
    window_state_update (&state, state.wstates, &state.n_wstates);

    

    the_time += state.dt;
    RotateMat (rotate, 0, 1, 0, 0);
    //MatMultMat4x4 (state.model, xlate, rotate);    
    //MatMultMat4x4 (state.model, state.model, Rotate);
    //MatrixCopy (state.model, scale);
#ifdef GPROG
    render_newframe (&state);
    render_background (&state);
#endif


    /* Now draw stuff */
    depthify_desktop (display, &state, mw);
    render_decorations (&state, mw);

    /* Make X get going while I wait on my swap buffer */
    /* This shouldn't take long.  But X calls may have to wait
     * for a stall? */
    XFlush (display);

#ifdef GPROG
    grBufferSwap (1);
#endif    

    /* Process events for the control app.  */
    window_process (mw);
    XSync (display, False);

    /* Poll waiting for correct end of frame time.  Don't use usleep
     * since it isn't accurate enough */
    do 
    {
      gettimeofday (&tv_end, NULL);
      wait = timeval_sub (&tv_end, &state.cur_frame_time);
    }
    while (wait < FRAMETIME_us);
  }  

  return (0);
}



