/*
 *  desktop -- The 3dfx Desktop Demo 
 *  COPYRIGHT 3DFX INTERACTIVE, INC. 1999
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glide.h>
#include <X11/Xlib.h>

#include "global.h"
#include "window.h"
#include "control.h"

/* Don't support more than 200 windows */
GrVertex vtx[WINDOW_MAX][4];
Window windows[WINDOW_MAX];
int ordered_states[WINDOW_MAX];
FxU32 color[WINDOW_MAX];
int win_count;
int depth_base;
float current_depth;
int mw_index;

/* Another cheesy color hack */
FxU32 wild_colors[] = {
  0x000000FF, /* Red */
  0x0000FF00, /* Green */
  0x00FF0000, /* Blue */
  0x00FF00FF, /* Magenta */
  0x00FFFF00, /* Cyan */
  0x0000FFFF, /* Yellow */
  0x00FFFFFF, /* White */

  0x00000080, /* Red */
  0x00008000, /* Green */
  0x00800000, /* Blue */
  0x00800080, /* Magenta */
  0x00808000, /* Cyan */
  0x00008080, /* Yellow */
  0x00808080, /* White */
  0x00000000  /* Black */
};

/* This function is an attempt at doing a fancier window depth processing.
 * It isn't currently used.  The strategy was that some attempt should be
 * made to keep non-overlapping windows at the same depth. */
#ifdef FANCY_WINDOW_DEPTH
static int
overlap (int i, int j)
{
  /* FIXME: Make faster */
  
  /* test against edge from 0 to 1 of i  */
  if (vtx[j][0].y <= vtx[i][0].y &&
      vtx[j][1].y <= vtx[i][0].y &&
      vtx[j][2].y <= vtx[i][0].y &&
      vtx[j][3].y <= vtx[i][0].y)
    return (0);
  /* test against edge from 2 to 3 of i */
  if (vtx[j][0].y >= vtx[i][2].y &&
      vtx[j][1].y >= vtx[i][2].y &&
      vtx[j][2].y >= vtx[i][2].y &&
      vtx[j][3].y >= vtx[i][2].y)
    return (0);
  /* test against edge from 0 to 3 of i */
  if (vtx[j][0].x <= vtx[i][0].x &&
      vtx[j][1].x <= vtx[i][0].x &&
      vtx[j][2].x <= vtx[i][0].x &&
      vtx[j][3].x <= vtx[i][0].x)
    return (0);
  /* test against edge from 1 to 2 of i */
  if (vtx[j][0].x >= vtx[i][2].x &&
      vtx[j][1].x >= vtx[i][2].x &&
      vtx[j][2].x >= vtx[i][2].x &&
      vtx[j][3].x >= vtx[i][2].x)
    return (0);

  return (1);
}
#endif

/* Find the depth of the last window */
static int
find_depth ()
{
#ifdef FANCY_WINDOW_DEPTH
  /* Go through all of the previous boxes in the current depth group */
  for (i = depth_base; i < win_count; i++)
  {
    /* Check for overlap */
    if (overlap (i, win_count))
    {
      /* This is in a new depth class */
      current_depth += DEPTH_FACTOR;
      depth_base = win_count;
    }
  }
#else
  current_depth += DEPTH_FACTOR;
#endif

  vtx[win_count][0].z   = current_depth;  
  vtx[win_count][0].oow = 1.0 / (current_depth);  
  vtx[win_count][1].z   = current_depth;  
  vtx[win_count][1].oow = vtx[win_count][0].oow;
  vtx[win_count][2].z   = current_depth;  
  vtx[win_count][2].oow = vtx[win_count][0].oow;
  vtx[win_count][3].z   = current_depth;  
  vtx[win_count][3].oow = vtx[win_count][0].oow;
  
  return (depth_base);
}

void
build_window_list (Display *display, Demo_State *state, Main_Window *mw)
{
  Window root, parent, *children;
  unsigned int nchildren;
  XWindowAttributes attr[WINDOW_MAX];
  int i;
  int total = 0;

  /* Get the tree of windows */
  root = RootWindow (display, 0);

  XGrabServer (display);
  XQueryTree (display, RootWindow (display, 0), &root, &parent, &children,
  	      &nchildren);

  /* Quickly count all of the windows */
  

  /* Query all of the windows */
  win_count = 0;
  depth_base = 0;
  for (i = nchildren-1; i >= 0 && win_count < WINDOW_MAX; i--)
  {
    XGetWindowAttributes (display, children[i], &attr[win_count]);    
    /* Only keep viewable on screen windows */
    /* Also impose a minimum size */
    if (attr[win_count].map_state == IsViewable && 
	(attr[win_count].x + attr[win_count].width) >= 0 
	&& (attr[win_count].y + attr[win_count].height) >= 0
	&& attr[win_count].x < DESKTOP_WIDTH
	&& attr[win_count].y < DESKTOP_HEIGHT)
    {
      windows[win_count] = children[i];
      win_count++;
    }
  }
  XUngrabServer (display);
  /*XFlush (display);*/
  XFree (children);
  
  current_depth = DEPTH_FACTOR * 8;

  /* Build rectangles for all of the windows */
  total = win_count;
  win_count=0;
  for (i = total-1; i >= 0 && win_count < WINDOW_MAX; i--)
  {
    /* Build 4 Glide Vertices for this rectangle */

    vtx[win_count][0].x = attr[win_count].x * SCALE_FACTOR;
    vtx[win_count][0].y = attr[win_count].y * SCALE_FACTOR;
    
    vtx[win_count][1].x = (attr[win_count].x + attr[win_count].width) * 
      SCALE_FACTOR;
    vtx[win_count][1].y = attr[win_count].y * SCALE_FACTOR;
    
    vtx[win_count][2].x = (attr[win_count].x + attr[win_count].width) * 
      SCALE_FACTOR;
    vtx[win_count][2].y = (attr[win_count].y + attr[win_count].height) * 
      SCALE_FACTOR;
    
    vtx[win_count][3].x = attr[win_count].x * SCALE_FACTOR;
    vtx[win_count][3].y = (attr[win_count].y + attr[win_count].height) * 
      SCALE_FACTOR;

    depth_base = find_depth ();

#ifdef RENDER_WINDOW_NUMBERS
    /* Set the texture coordinates in case window numbering is on */
    vtx[win_count][0].tmuvtx[0].sow = 0;
    vtx[win_count][0].tmuvtx[0].tow = 0;
    vtx[win_count][1].tmuvtx[0].sow = 255 * vtx[win_count][1].oow;
    vtx[win_count][1].tmuvtx[0].tow = 0;
    vtx[win_count][2].tmuvtx[0].sow = 255 * vtx[win_count][2].oow;
    vtx[win_count][2].tmuvtx[0].tow = 255 * vtx[win_count][2].oow;
    vtx[win_count][3].tmuvtx[0].sow = 0;
    vtx[win_count][3].tmuvtx[0].tow = 255 * vtx[win_count][3].oow;
#endif
    win_count++;
  }


  state->one_over_desktop_w = 1.f / DESKTOP_DEPTH;
}

void
free_window_list ();
