/********************************************************************

"THIS SOFTWARE IS SUBJECT TO COPYRIGHT PROTECTION AND IS OFFERED ONLY
PURSUANT TO THE 3DFX FXT1 GENERAL PUBLIC LICENSE. A COPY OF THIS
LICENSE MAY BE OBTAINED FROM THE DISTRIBUTOR OR BY CONTACTING 3DFX
INTERACTIVE INC.  

TO THE EXTENT PERMITTED BY APPLICABLE LAW, THERE IS NO WARRANTY FOR
THIS PROGRAM. THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THIS
PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR
IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK
AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD
THIS PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
SERVICING, REPAIR OR CORRECTION.

IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, WILL 3DFX INTERACTIVE,
INC., OR ANY OTHER COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY
AND/OR REDISTRIBUTE THIS PROGRAM OR DERIVATIVE WORKS AS PERMITTED
ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
INABILITY TO USE THIS PROGRAM OR DERIVATIVE WORKS (INCLUDING BUT NOT
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES
SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THIS PROGRAM OR
DERIVATIVE WORKS TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH
HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
DAMAGES.

USE, DUPLICATION OR DISCLOSURE BY THE GOVERNMENT IS SUBJECT TO
RESTRICTIONS AS SET FORTH IN SUBDIVISION (C)(1)(II) OF THE RIGHTS IN
TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 252.227-7013,
AND/OR IN SIMILAR OR SUCCESSOR CLAUSES IN THE FAR, DOD OR NASA FAR
SUPPLEMENT. UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS OF
THE UNITED STATES.  COPYRIGHT 3DFX INTERACTIVE, INC. 1999, ALL RIGHTS
RESERVED"

********************************************************************/

/*
** DECOMPPB.C
** 
** 9/02/99 rufus@3dfx.com
** Original release cleanup.
*/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#ifdef __MSC__
#include <io.h>
#endif
#include <string.h>
#include <math.h>

#include "3dfxpb.h"
#include "fximgpb.h"

#include <assert.h>
#include "comppb.h"

#include "fxt1gpl.h"

/*----------------------------------------------------------------------
** MAIN PROGRAM
**----------------------------------------------------------------------
*/
void main(int argc, char **argv)
{
  int ppm = 0, output = 1, verbose = 0;
  ImgInfo info;
  CompHeader hd;
  FILE *inf;
  char *program = argv[0];
  
  while (--argc > 0 && **++argv == '-') {
    char *token;
    
    for (token = argv[0] + 1; *token; token++) 
      switch (*token) {
      case 'n':
        output = 0;
        break;
      case 'p':
        ppm = 1;
        break;
      case 'v':
        verbose ++;
        break;
      default:
        fprintf (stderr,"%s: illegal option %c\n", program, *token);
        break;
      }
  }
  
  if (argc < 1 || argc > 2) {
    fprintf(stderr, FXT1GPL_TXT);
    fprintf(stderr, "usage: %s [-npv] [[inimage1] outimage]\n", program);
    exit(1);
  }

  /* read the input texture file */
  if (argc > 1) {
    inf = fopen(argv[0], "rb");
    if (!inf) {
      fprintf(stderr, "%s: couldn't open input file %s\n", program, argv[0]);
      exit(1);
    }
  } else {
#ifdef __MSC__
    _setmode( _fileno(stdin), _O_BINARY);
#endif
    inf = stdin;
  }
  fread(&hd, sizeof(hd), 1, inf);
  if (hd.magic != COMP_MAGIC) {
    fprintf(stderr, "%s: bad magic %s\n", program, argv[0]);
    exit(1);
  }
  info.any.width = hd.width;
  info.any.height = hd.height;
  info.any.sizeInBytes = sizeof(FxI32) * hd.width * hd.height;
  info.any.data = (unsigned char *) calloc(hd.width * hd.height, sizeof(FxI32));
  assert(info.any.data);
  
  decode4x8(&info, inf, verbose);
  
  if (output) {
    info.tgaInfo.yOrigin = 0;
    if (argc >= 1)
      imgWriteFile(argv[argc - 1],&info, ppm?IMG_P6:IMG_TGA32,info.any.data);
    else 
      imgWriteImage( stdout, &info, ppm?IMG_P6:IMG_TGA32,info.any.data);
  }   
  
  free(info.any.data);
}