/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef BUTTONBAR_H
#define BUTTONBAR_H


#include <qwidget.h>
#include <qpushbutton.h>


#define BBARBTNSIZE 36
#define BBARBTNSPACE 39



class MyPushButton : public QPushButton
{
	Q_OBJECT;
public:
   MyPushButton( QWidget *parent );
   ~MyPushButton();

private:
	bool draw_down;
   bool buttonpressed;

protected:
	void enterEvent( QEvent * );
   void leaveEvent( QEvent * );
   void paint( QPainter *painter );
   void drawButtonLabel( QPainter *painter );
   void mousePressEvent( QMouseEvent *e );
   void mouseReleaseEvent( QMouseEvent *e );
   void mouseMoveEvent( QMouseEvent *e );
   void drawButton( QPainter *p ) { paint(p);}
};


class ButtonBar : public QWidget
{
	Q_OBJECT;
public:
	enum Direction { Horizontal, Vertical };

   ButtonBar( QWidget *parent, Direction d=Vertical );
   ~ButtonBar();

   void setDirection( Direction d );
   void resizeEvent( QResizeEvent *event );

public slots:
	void btnConnClicked();
   void btnDiscClicked();
   void btnConfigClicked();
   void btnFileSendClicked();
   void btnFileRecClicked();

signals:
   void connClicked();
   void discClicked();
   void configClicked();
   void fileSendClicked();
   void fileRecClicked();

private:
	MyPushButton *btnConn, *btnDisc, *btnConfig, *btnFileSend, *btnFileRec;
   Direction direct;
};


#endif

