/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "userinfo.h"
#include "global.h"
#include "toolbox.h"
#include "flags.h"

#include <stdio.h>
#include <stdlib.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>



UserInfo::UserInfo( char *rx_call )
{
   clearData();
   strcpy(call, rx_call);

   if (!readData())
   {
      remotes = REMOTE_STD_TERMINAL;
      type = TYPE_TERMINAL;
      flags = CH_UI_STDFLAGS;
   }

   autoSave = true;
}


UserInfo::~UserInfo()
{
}


void UserInfo::clearData()
{
   name[0] = '\0';
   call[0] = '\0';
   flags = 0;
   pwmode = 0;
   password = NULL;
   type = TYPE_TERMINAL;
   remotes = 0;
   pwanswer = 0;
   pwcommand[0] = '\0';
   pwanswerstr[0] = '\0';
   pwanswerlen = 10;
   umbruch = config->zeilenumbruch;
   umbruchpos = config->umbruchpos;
   swtype = 0;
   boxCheck[0] = '\0';
}


// User-Informationen wenn vorhanden aus dem User-Info-File holen und
// lokal abspeichern.
bool UserInfo::readData()
{
   int f;
   char filename[500],line[500],str1[500],str2[5];
   int i;
   FILE *fs;
  
  
   strcpy(str1,call);
   Klein(str1);
   COPY(str2,str1,0,3);
   sprintf(filename,"%s/userdb/%s.../%s",config->maindir,str2,str1);
  
  
   if ((f = open(filename,O_RDONLY)) == -1) return(false);
  
   fs = fdopen(f,"r");
  
   while (fgets(line,499,fs) != NULL)
   {
      if (line[0] != '#')
      {	/* keine Kommentare */
         if ((i = POS('\n',line)) != -1) line[i] = '\0';
         if ((i = POS('\r',line)) != -1) line[i] = '\0';
    
         if ((line[0] != '\0') && ((i = POS(' ',line)) != -1))
         {
            COPY(str1,line,0,i);
            COPY(line,line,i+1,strlen(line)-i-1);
        
            if (!strcmp(str1,"name"))
            {
               if (strlen(line)>20) line[21] = '\0';
               strcpy(name,line);
            }
            if (!strcmp(str1,"flags"))
               flags = atoi(line);
            if (!strcmp(str1,"pwmode"))
               pwmode = atoi(line);
            if (!strcmp(str1,"remotes"))
               remotes = atol(line);
            if (!strcmp(str1,"pwanswer"))
               pwanswer = atoi(line);
            if (!strcmp(str1,"pwanswerlen"))
               pwanswerlen = atoi(line);
            if (!strcmp(str1,"password"))
               password = (char *) strdup(line);
            if (!strcmp(str1,"pwcommand"))
            {
               if (strlen(line)>20) line[21] = '\0';
               strcpy(pwcommand,line);
            }
            if (!strcmp(str1,"pwanswerstr"))
            {
               if (strlen(line)>50) line[51] = '\0';
               strcpy(pwanswerstr,line);
            }
            if (!strcmp(str1,"type"))
            {
               type = atoi(line);
               if (type == 0) type = 1;
            }
            if (!strcmp(str1,"umbruch"))
            {
               if (atoi(line) == 0)
                  umbruch = false;
               else
                  umbruch = true;
            }
            if (!strcmp(str1,"umbruchpos"))
            {
               umbruchpos = atoi(line);
               if (umbruchpos == 0)
                  umbruchpos = 78;
            }
            if (!strcmp(str1,"swtype"))
               swtype = atoi(line);
            if (!strcmp(str1,"boxcheck"))
               strcpy(boxCheck, line);
         }
      }
   }

   ::close(f);

   return(true);
}


/* Userdaten in das File schreiben */
void UserInfo::writeData()
{
   int f;
   char filename[500],str1[256],str2[5];
  
   strcpy(str1,call);
   Klein(str1);
   COPY(str2,str1,0,3);
   sprintf(filename,"%s/userdb/%s...",config->maindir,str2);
  
   /* Verzeichnis erzeugen, wenns noch nicht der da ist */
   if (mkdir(filename,448) == -1)
   {}
   sprintf(filename,"%s/%s",filename,str1);


   f = open(filename,(O_WRONLY|O_CREAT));

   /* Zugriffsrechte einstellen */
   fchmod(f,S_IRUSR|S_IWUSR);


   sprintf(str1,"name %s\xA",name);
   write(f,str1,strlen(str1));
   sprintf(str1,"flags %i\xA",flags);
   write(f,str1,strlen(str1));
   sprintf(str1,"pwmode %i\xA",pwmode);
   write(f,str1,strlen(str1));
   if (password != NULL)
   {
      sprintf(str1,"password %s\xA",password);
      write(f,str1,strlen(str1));
   }
   sprintf(str1,"type %i\xA",type);
   write(f,str1,strlen(str1));
   sprintf(str1,"remotes %li\xA",remotes);
   write(f,str1,strlen(str1));
   sprintf(str1,"pwanswer %i\xA",pwanswer);
   write(f,str1,strlen(str1));
   sprintf(str1,"pwanswerstr %s\xA", pwanswerstr);
   write(f,str1,strlen(str1));
   sprintf(str1,"pwanswerlen %i\xA", pwanswerlen);
   write(f,str1,strlen(str1));
   sprintf(str1,"pwcommand %s\xA", pwcommand);
   write(f,str1,strlen(str1));
   if (umbruch)
      strcpy(str1,"umbruch 1\xA");
   else
      strcpy(str1,"umbruch 0\xA");
   write(f,str1,strlen(str1));
   sprintf(str1,"umbruchpos %i\xA", umbruchpos);
   write(f,str1,strlen(str1));
   sprintf(str1,"swtype %i\xA", swtype);
   write(f,str1,strlen(str1));
   sprintf(str1, "boxcheck %s\xA", boxCheck);
   write(f,str1,strlen(str1));

   ftruncate(f, lseek(f, 0, SEEK_CUR));

   ::close(f);
}


char * UserInfo::getName()
{
   return name;
}


int UserInfo::getFlags()
{
   return flags;
}


int UserInfo::getPwmode()
{
   return pwmode;
}


char * UserInfo::getPwd()
{
   return password;
}


int UserInfo::getType()
{
   return type;
}


long UserInfo::getRemotes()
{
   return remotes;
}


bool UserInfo::getUmbruch()
{
   return umbruch;
}


int UserInfo::getUmbruchPos()
{
   return umbruchpos;
}


int UserInfo::getSwType()
{
   return swtype;
}



void UserInfo::setName( const char *newname )
{
   char *tmpname;

   if (newname == NULL)
      name[0] = '\0';
   else
   {
      tmpname = (char *) strdup(newname);
      if (strlen(tmpname) > 20) tmpname[21] = '\0';
      strcpy(name, tmpname);
      free(tmpname);
   }

   if (autoSave) writeData();
}


void UserInfo::setFlags( const int newflags )
{
   flags = newflags;

   if (autoSave) writeData();
}


void UserInfo::setPwmode( const int newpwmode )
{
   pwmode = newpwmode;

   if (autoSave) writeData();
}


void UserInfo::setPwd( const char *newPwd )
{
   if (password != NULL) free(password);
   if (newPwd == NULL)
      password = NULL;
   else
      password = (char *) strdup(newPwd);

   if (autoSave) writeData();
}


void UserInfo::setType( const int newtype )
{
   type = newtype;

   if (autoSave) writeData();
}


void UserInfo::setRemotes( const long newremotes )
{
   remotes = newremotes;

   if (autoSave) writeData();
}


void UserInfo::setPWInfos( const int answer, const char *command, const char *answerstr)
{
   pwanswer = answer;
   strcpy(pwcommand, command);
   strcpy(pwanswerstr, answerstr);

   if (autoSave) writeData();
}


int UserInfo::getPwAnswer()
{
   return pwanswer;
}


char * UserInfo::getPwCommand()
{
   return pwcommand;
}


char * UserInfo::getPwAnswerStr()
{
   return pwanswerstr;
}


int UserInfo::getPwAnswerLen()
{
   return pwanswerlen;
}


void UserInfo::setPwAnswerLen( const int len )
{
   pwanswerlen = len;

   if (autoSave) writeData();
}


void UserInfo::setUmbruch( const bool _umbruch, const int _umbruchpos )
{
   umbruch = _umbruch;
   umbruchpos = _umbruchpos;

   if (autoSave) writeData();
}


void UserInfo::setSwType( const int _swtype )
{
   swtype = _swtype;

   if (autoSave) writeData();
}


char * UserInfo::getBoxCheck()
{
   return boxCheck;
}


void UserInfo::setBoxCheck( const char *boxcheck )
{
   strcpy(boxCheck, boxcheck);

   if (autoSave) writeData();
}



