/*********************************************************************
 *      play.h - defined used by all the applications 
 * 
 *      Copyright (C) 1999 Rui Sousa
 *********************************************************************
 *     This program is free software; you can redistribute it and/or
 *     modify it under the terms of the GNU General Public License as
 *     published by the Free Software Foundation; either version 2 of
 *     the License, or (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public
 *     License along with this program; if not, write to the Free
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *     USA.
 *********************************************************************
*/

#include<fcntl.h>

#define DEBUG 1 

/* audio format */
#define SPEED  48000
#define STEREO 1 
#define FORMAT AFMT_S16_LE

/* buffer parameters */
#define BUF_SIZE 1024 
#define FRAGS 10 
#define FRAGSHIFT 10 

/* frequency in Hz for left/right channel */
#define FREQL 1000
#define FREQR 400

/* Volume percentage for left/right channel */
#define VL 20
#define VR 20


struct wave {

    double buf[BUF_SIZE];
    double w;
    double t0;

};

int setup(char *, mode_t);

void fill_devbuf(struct wave *, struct wave *,
                 unsigned char *);

void print_info(int, mode_t);
