#!/bin/sh
#
# rc.M		This file is executed by init(8) when the system is being
#		initialized for one of the "multi user" run levels (i.e.
#		levels 1 through 6).  It usually does mounting of file
#		systems et al.
#
# Version:	@(#)/etc/rc.d/rc.M	2.02	02/26/93
#
# Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
#		Heavily modified by Patrick Volkerding <volkerdi@ftp.cdrom.com>
#

# Tell the viewers what's going to happen...
echo "Going multiuser..."

# Screen blanks after 15 minutes idle time.
/bin/setterm -blank 15

# Look for a CD-ROM in a CD-ROM drive, and if one is found,
# mount it under /cdrom.  This must happen before any of the
# binaries on the CD are needed.
#
# If you don't have a CD-ROM and want to disable this, set the
# /etc/rc.d/rc.cdrom permissions to non-executable: chmod 644 /etc/rc.d/rc.cdrom
# 
if [ -x /etc/rc.d/rc.cdrom ]; then
  . /etc/rc.d/rc.cdrom
fi

# If there's no /etc/HOSTNAME, fall back on this default:
if [ ! -r /etc/HOSTNAME ]; then
 echo "darkstar.example.net" > /etc/HOSTNAME
fi

# Set the hostname.  This might not work correctly if TCP/IP is not 
# compiled in the kernel.
/bin/hostname `cat /etc/HOSTNAME | cut -f1 -d .`

# Initialize the NET subsystem.
if [ -x /etc/rc.d/rc.inet1 ]; then
  . /etc/rc.d/rc.inet1
  . /etc/rc.d/rc.inet2
else
  if [ -x /usr/sbin/syslogd ]; then
    /usr/sbin/syslogd
    sleep 1 # Prevents a race condition with SMP kernels
    # '-c 3' displays level 'error' or higher messages on the console
    /usr/sbin/klogd -c 3
  fi
  if [ -x /usr/sbin/lpd ]; then
    /usr/sbin/lpd
  fi
fi

# Start netatalk. (a file/print server for Macs using Appletalk)
#if [ -x /etc/rc.d/rc.atalk ]; then
#  /etc/rc.d/rc.atalk
#fi

# Start crond (Dillon's crond):
# If you want cron to actually log activity to /var/adm/cron, then change
# -l10 to -l8 to increase the logging level.
/usr/sbin/crond -l10 >>/var/adm/cron 2>&1

# Start atd (manages jobs scheduled with 'at'):
/usr/sbin/atd -b 15 -l 1

# Remove stale locks and junk files (must be done after mount -a!)
/bin/rm -f /var/lock/* /var/spool/uucp/LCK..* /tmp/.X*lock /tmp/core /core 1> /dev/null 2> /dev/null

# Remove stale hunt sockets so the game can start.
if [ -r /tmp/hunt -o -r /tmp/hunt.stats ]; then
  echo "Removing your stale hunt sockets from /tmp..."
  /bin/rm -f /tmp/hunt*
fi

# Ensure basic filesystem permissions sanity.
chmod 755 /
chmod 1777 /tmp /var/tmp

# Update all the shared library links automatically
/sbin/ldconfig

# Slackware-Mini-Quota-HOWTO:
# To really activate quotas, you'll need to add 'usrquota' to the appropriate
# partitions as listed in /etc/fstab.  Here's an example:
# /dev/hda2   /home   ext2   defaults,usrquota    1   1
# You'll then need to setup initial quota files at the top of the partitions
# to support quota, like this:
# touch /home/quota.user /home/quota.group
# chmod 600 /home/quota.user /home/quota.group
# Then, reboot to activate the system.
# To edit user quotas, use 'edquota'.  See 'man edquota'.  Also, the
# official Quota Mini-HOWTO has lots of useful information.  That can be found
# here:  ftp://ftp.cdrom.com/pub/linux/slackware/docs/mini/Quota

# Check quotas and then turn quota system on:
if fgrep quota /etc/fstab 1> /dev/null 2> /dev/null ; then
  if [ -x /sbin/quotacheck ]; then
    echo "Checking filesystem quotas..."
    /sbin/quotacheck -avug
  fi
  if [ -x /sbin/quotaon ]; then
    echo "Activating filesystem quotas..."
    /sbin/quotaon -avug
  fi
fi

# Start the sendmail daemon:
if [ -x /usr/sbin/sendmail ]; then
  echo "Starting sendmail daemon (/usr/sbin/sendmail -bd -q15m)..."
  /usr/sbin/sendmail -bd -q15m
fi

# Start the APM daemon if APM is enabled in the kernel:
if [ -x /usr/sbin/apmd ]; then
  if cat /proc/apm 1> /dev/null 2> /dev/null ; then
    echo "Starting APM daemon..."
    /usr/sbin/apmd
  fi
fi

# Load a custom screen font if the user has an rc.font script.
if [ -x /etc/rc.d/rc.font ]; then
  . /etc/rc.d/rc.font
fi

# Load a custom keymap if the user has an rc.keymap script.
if [ -x /etc/rc.d/rc.keymap ]; then
  . /etc/rc.d/rc.keymap
fi

# iBCS Emulation for Linux
# The Intel Binary Compatibility Specification, or iBCS, specifies the
# interfaces between application programs and the surrounding operating
# system environment for i386 based systems. There are however several
# flavours of iBCS in use - SVR4, SVR3 plus several vendor specific
# extensions to SVR3 which are slightly different and incompatible. The
# iBCS emulator for Linux supports all flavours known so far.
if [ -x /etc/rc.d/rc.ibcs2 ]; then
  . /etc/rc.d/rc.ibcs2
fi

# Start Web server:
if [ -x /etc/rc.d/rc.httpd ]; then
  . /etc/rc.d/rc.httpd
fi

# Start Samba (a file/print server for Win95/NT machines):
if [ -x /etc/rc.d/rc.samba ]; then
  . /etc/rc.d/rc.samba
fi

# Start the GPM mouse server:
if [ -x /etc/rc.d/rc.gpm ]; then
  . /etc/rc.d/rc.gpm
fi

# If there are SystemV init scripts for this runlevel, run them.
if [ -x /etc/rc.d/rc.sysvinit ]; then
  . /etc/rc.d/rc.sysvinit
fi

# Start the local setup procedure.
if [ -x /etc/rc.d/rc.local ]; then
  . /etc/rc.d/rc.local
fi

# All done.
