" Vim support file to detect file types in scripts
"
" Maintainer:	Bram Moolenaar <Bram@vim.org>
" Last change:	2000 Jan 06

" This file is called by an autocommand for every file that has just been
" loaded into a buffer.  It checks if the type of file can be recognized by
" the file contents.  The autocommand is in $VIMRUNTIME/filetype.vim.


" Load the user defined scripts file first
" Only do this when the FileType autocommand has not been triggered yet
if !did_filetype() && exists("myscriptsfile") && file_readable(expand(myscriptsfile))
  execute "source " . myscriptsfile
endif

" Only do this when the FileType autocommand has not been triggered yet
if !did_filetype()

" Line continuation is used here, remove 'C' from 'cpoptions'
let scr_cpo_save = &cpo
set cpo-=C

" Bourne-like shell scripts: sh ksh bash
if getline(1) =~ '^#!.*[/\\][bk]\=a\=sh\>'
  if exists("is_bash")
    unlet is_bash
  endif
  if exists("is_kornshell")
    unlet is_kornshell
  endif
  " if bash is sh on your system as on Linux, you may prefer to
  " add the following in your .vimrc file:
  " let bash_is_sh=1
  if exists("bash_is_sh") || getline(1) =~ '^#!.*[/\\]bash\>'
    let is_bash=1
  elseif getline(1) =~ '^#!.*[/\\]ksh\>'
    let is_kornshell=1
  endif
  set ft=sh

" csh and tcsh scripts
elseif getline(1) =~ '^#!.*[/\\]t\=csh\>'
  set ft=csh

" Z shell scripts
elseif getline(1) =~ '^#!.*[/\\]zsh\>'
	\ || getline(1) =~ '^#compdef\>'
	\ || getline(1) =~ '^#autoload\>'
  set ft=zsh

" TCL scripts
elseif getline(1) =~ '^#!.*[/\\]\(tclsh\|wish\|expectk\|itclsh\|itkwish\)\>'
  set ft=tcl

" ELM Mail files
elseif getline(1) =~ '^From [a-zA-Z][a-zA-Z_0-9\.=-]*\(@[^ ]*\)\= .*[12][09]\d\d$'
  set ft=mail

" Expect scripts
elseif getline(1) =~ '^#!.*[/\\]expect\>'
  set ft=expect

" Gnuplot scripts
elseif getline(1) =~ '^#!.*[/\\]gnuplot\>'
  set ft=gnuplot

" Makefiles
elseif getline(1) =~ '^#!.*[/\\][^/\\]*make\>'
  set ft=make

" Perl
elseif getline(1) =~ '^#!.*[/\\][^/\\]*perl[^/\\]*\>'
  set ft=perl

" Python
elseif getline(1) =~ '^#!.*[/\\][^/\\]*python[^/\\]*\>'
  set ft=python

" sed
elseif getline(1) =~ '^#!.*sed\>'
  set ft=sed

" Vim scripts (must have '" vim' as the first line to trigger this)
elseif getline(1) =~ '^" *[vV]im$'
  set ft=vim

" Diff file:
" - "diff" in first line (context diff)
" - "Only in " in first line
" - "--- " in first line and "+++ " in second line (unified diff).
" - "*** " in first line and "--- " in second line (context diff).
" - "# It was generated by makepatch " in the second line (makepatch diff).
" - "Index: <filename>" in the first line (CVS file)
elseif getline(1) =~ '^diff\>' || getline(1) =~ '^Only in '
	\ || (getline(1) =~ '^--- ' && getline(2) =~ '^+++ ')
	\ || (getline(1) =~ '^\*\*\* ' && getline(2) =~ '^--- ')
	\ || getline(1) =~ '^\d\+\(,\d\+\)\=[cda]\d\+\>'
	\ || getline(2) =~ '^# It was generated by makepatch '
	\ || getline(1) =~ '^Index:\s\+\f\+$'
  set ft=diff

" PostScript Files (must have %!PS as the first line, like a2ps output)
elseif getline(1) =~ '^%![ \t]*PS'
  set ft=postscr

" Awk scripts
elseif getline(1) =~ '^#!.*awk\>'
  set ft=awk

" M4 scripts: Guess there is a line that starts with "dnl".
elseif getline(1) =~ '^\s*dnl\>'
	\ || getline(2) =~ '^\s*dnl\>'
	\ || getline(3) =~ '^\s*dnl\>'
	\ || getline(4) =~ '^\s*dnl\>'
	\ || getline(5) =~ '^\s*dnl\>'
  set ft=m4

" AmigaDos scripts
elseif $TERM == "amiga"
	\ && (getline(1) =~ "^;" || getline(1) =~ '^\.[bB][rR][aA]')
  set ft=amiga

" SiCAD scripts (must have procn or procd as the first line to trigger this)
elseif getline(1) =~ '^ *[pP][rR][oO][cC][nNdD] *$'
  set ft=sicad

" Purify log files start with "****  Purify"
elseif getline(1) =~ '^\*\*\*\*  Purify'
  set ft=purifylog

" XML
elseif getline(1) =~ '<?\s*xml.*?>'
  set ft=xml

" XXD output
elseif getline(1) =~ '^\x\{7}: \x\{4} \x\{4} '
  set ft=xxd

" RCS/CVS log output
elseif getline(1) =~ '^RCS file:' || getline(2) =~ '^RCS file:'
  set ft=rcslog

endif

" Restore 'cpoptions'
let &cpo = scr_cpo_save
unlet scr_cpo_save

endif " !did_filetype()

" vim: ts=8 tw=0 sts=0
