/*******************************
 Common user dialog boxes
 (c) 1999 Jeremy Wise
 GnomeICU
********************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <string.h>

/*** Local function declarations ***/
static void change_show( GtkWidget *widget, gboolean *toggle_me );

/*** Global functions ***/
void OK_Box( const gchar *header, const gchar *message )
{
	GtkWidget *window;
	GtkWidget *dialog_vbox1;
	GtkWidget *button3;
	GtkWidget *dialog_action_area1;

	gchar *joined;

#ifdef TRACE_FUNCTION
	g_print( "OK_Box\n" );
#endif

	joined = g_strdup_printf( "%s\n%s", header, message );
	
	window = gnome_message_box_new ( joined,
	                            GNOME_MESSAGE_BOX_INFO, NULL);
	gtk_object_set_data (GTK_OBJECT (window), "window", window);
	gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
	gnome_dialog_set_close (GNOME_DIALOG (window), TRUE);

	gtk_window_set_title( GTK_WINDOW( window ), _("GnomeICU: Information") );

	dialog_vbox1 = GNOME_DIALOG (window)->vbox;
	gtk_object_set_data (GTK_OBJECT (window), "dialog_vbox1", dialog_vbox1);
	gtk_widget_show (dialog_vbox1);

	gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_OK);
	button3 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
	gtk_widget_ref (button3);
	gtk_object_set_data_full (GTK_OBJECT (window), "button3", button3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button3);
	GTK_WIDGET_SET_FLAGS (button3, GTK_CAN_DEFAULT);

	dialog_action_area1 = GNOME_DIALOG (window)->action_area;
	gtk_widget_ref (dialog_action_area1);
	gtk_object_set_data_full (GTK_OBJECT (window), "dialog_action_area1", dialog_action_area1,
	                          (GtkDestroyNotify) gtk_widget_unref);

	gtk_signal_connect_object( GTK_OBJECT( button3 ), "clicked",
	                           (GtkSignalFunc) gtk_widget_destroy,
	                           GTK_OBJECT( window ) );

	gtk_widget_show_all( window );
}

void AMessage_Box( const gchar *header, const gchar *message, UIN_T uin )
{
  GtkWidget *window;
  GtkWidget *dialog_vbox2;
  GtkWidget *vbox1;
  GtkWidget *label9;
  GtkWidget *scrolledwindow2;
  GtkWidget *text2;
  GtkWidget *checkbutton2;
  GtkWidget *dialog_action_area2;
  GtkWidget *button4;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "AMessage_Box\n" );
#endif

	contact = Contacts;

	while( contact != NULL )
	{
		if( ((CONTACT_PTR)contact->data)->uin == uin )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
		return;

	if( ((CONTACT_PTR)contact->data)->show_again == FALSE )
		return;

	window = gnome_dialog_new (_("GnomeICU: Message"), NULL);
	gtk_object_set_data (GTK_OBJECT (window), "window", window);
	gtk_window_set_default_size( GTK_WINDOW( window ), 200, 250 );
	gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, FALSE);

	dialog_vbox2 = GNOME_DIALOG (window)->vbox;
	gtk_object_set_data (GTK_OBJECT (window), "dialog_vbox2", dialog_vbox2);
	gtk_widget_show (dialog_vbox2);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (window), "vbox1", vbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox2), vbox1, TRUE, TRUE, 0);

	label9 = gtk_label_new ( header );
	gtk_widget_ref (label9);
	gtk_object_set_data_full (GTK_OBJECT (window), "label9", label9,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label9);
	gtk_box_pack_start (GTK_BOX (vbox1), label9, FALSE, FALSE, 0);

	scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow2);
	gtk_object_set_data_full (GTK_OBJECT (window), "scrolledwindow2", scrolledwindow2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow2);
	gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow2, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	text2 = gtk_text_new (NULL, NULL);
	gtk_widget_ref (text2);
	gtk_object_set_data_full (GTK_OBJECT (window), "text2", text2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (text2);
	gtk_text_set_word_wrap( GTK_TEXT( text2 ), TRUE );
	gtk_text_set_editable( GTK_TEXT( text2 ), FALSE );
	gtk_container_add (GTK_CONTAINER (scrolledwindow2), text2);

	if( message != NULL && strcmp( message, "" ) )
		gtk_text_insert( GTK_TEXT( text2 ), NULL, NULL, NULL, message, -1 );

	checkbutton2 = gtk_check_button_new_with_label (_("Show Again"));
	gtk_widget_ref (checkbutton2);
	gtk_object_set_data_full (GTK_OBJECT (window), "checkbutton2", checkbutton2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (checkbutton2);
	gtk_box_pack_start (GTK_BOX (vbox1), checkbutton2, FALSE, FALSE, 0);

	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( checkbutton2 ),
	                             ((CONTACT_PTR)contact->data)->show_again );

	dialog_action_area2 = GNOME_DIALOG (window)->action_area;
	gtk_object_set_data (GTK_OBJECT (window), "dialog_action_area2", dialog_action_area2);
	gtk_widget_show (dialog_action_area2);
	gtk_button_box_set_layout( GTK_BUTTON_BOX( dialog_action_area2 ), GTK_BUTTONBOX_END );
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area2), 8);

	gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_OK);
	button4 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
	gtk_widget_ref (button4);
	gtk_object_set_data_full (GTK_OBJECT (window), "button4", button4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button4);
	GTK_WIDGET_SET_FLAGS (button4, GTK_CAN_DEFAULT);

	gtk_signal_connect (GTK_OBJECT (checkbutton2), "toggled",
	                    GTK_SIGNAL_FUNC (change_show),
	                    &((CONTACT_PTR)contact->data)->show_again);
	gtk_signal_connect_object (GTK_OBJECT (button4), "clicked",
	                           GTK_SIGNAL_FUNC (gtk_widget_destroy),
	                           GTK_OBJECT( window ));

	gtk_widget_show_all( window );
}

/*** Local functions ***/
void change_show( GtkWidget *widget, int *toggle_me )
{
#ifdef TRACE_FUNCTION
	g_print( "change_show\n" );
#endif
   
	*toggle_me = !*toggle_me;
}
