/* memcmp.c -- Implementation of memcmp
   Copyright (C) 1998 John Harper <john@dcs.warwick.ac.uk>
   $Id: memcmp.c,v 1.1 1999/02/28 18:34:21 john Exp $

   This file is part of Jade.

   Jade is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Jade is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jade; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <sys/types.h>

int
memcmp(unsigned char *s1, unsigned char *s2, unsigned int n)
{
    while(n-- > 0)
    {
	if(*s1 != *s2)
	    return *s1 - *s2;
	s1++;
	s2++;
    }
    return 0;
}
