/*
 * Copyright (c) 1990,1993 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#include <stdio.h>
#include <sys/cdefs.h>

#include <netatalk/endian.h>
#include "volume.h"

struct ofork {
    struct adouble	of_ad;
    struct vol          *of_vol;
    struct dir		*of_dir;
    char		*of_name;
    int                 of_namelen;
    u_int16_t           of_refnum;
    int                 of_flags;
    struct ofork        **prevp, *next;
};

#define OPENFORK_DATA	(0)
#define OPENFORK_RSCS	(1<<7)

#define OPENACC_RD	(1<<0)
#define OPENACC_WR	(1<<1)
#define OPENACC_DRD	(1<<4)
#define OPENACC_DWR	(1<<5)

#define AFPFORK_OPEN	(1<<0)
#define AFPFORK_RSRC	(1<<1)
#define AFPFORK_DATA	(1<<2)
#define AFPFORK_DIRTY   (1<<3)

struct ofork	*of_alloc __P((struct vol *, struct dir *, 
			       char *, u_int16_t *, const int));
void            of_dealloc __P((struct ofork *));
struct ofork	*of_find __P((const u_int16_t));
struct ofork    *of_findname __P((const struct vol *, const struct dir *,
				  const char *));
int             of_rename __P((const struct vol *, 
			       struct dir *, const char *,
			       struct dir *, const char *));
int             of_flush __P((const struct vol *));
