/*
 * Copyright (c) 1990,1992 Regents of The University of Michigan.
 * All Rights Reserved. See COPYRIGHT.
 */

struct interface {
    struct interface	*i_next;
    char		i_name[ IFNAMSIZ ];
    int			i_flags;
    int			i_time;
    struct sockaddr_at	i_addr;
    struct sockaddr_at	i_caddr;
    struct ziptab	*i_czt;
    struct rtmptab	*i_rt;
    struct gate		*i_gate;
    struct atport	*i_ports;
};

#define IFACE_PHASE1	0x001
#define IFACE_PHASE2	0x002
#define IFACE_LOOPBACK	0x004		/* is the loopback interface */
#define IFACE_SEED	0x008		/* act as seed */
#define IFACE_ADDR	0x010		/* has an address set */
#define IFACE_CONFIG	0x020		/* has been configured */
#define IFACE_NOROUTER	0x040		/* no router on interface */
#define IFACE_LOOP	0x080		/* has a loopback route */
#define IFACE_RSEED     0x100           /* actually the same as seed, but for
					   single interfaces as well */

#define UNSTABLE	2
#define STABLE		0
#define STABLEANYWAY	-2

#define IFBASE		2	/* base number of interfaces */

#ifdef linux
#define LOOPIFACE	"lo"
#else linux
#define LOOPIFACE	"lo0"
#endif linux

extern struct interface	*interfaces;
extern struct interface	*ciface;
extern int		ninterfaces;
struct interface	*newiface();
