/* symbols_spkout.h - header file for speakups SpeakOut driver. */
#define VERSION_SPKOUT 07
#define NUM_STATIC_SPKOUT 7
#define NUM_XTEND_SPKOUT 1
#define NUM_ALIAS_SPKOUT 1 /* ZILCH counts as one, so everything lines up */

/* note the trailing comma... */
#define DEFAULT_STATIC_SPKOUT \
	"\x18", "\x05P3", "\x05R7", "\x05Ti", "\x05V9",\
	"\x05P+", "\x05P-",

/* if empty, should *not* have a trailing comma... */
#define DEFAULT_XTEND_SPKOUT \
	  "\x05Mn",

/* required settings and functionality */
#define STATIC_STR_SPKOUT \
	{ "#flush", "\x18", "_", (BUILDER | HARD_DIRECT | NO_USER), { -1 } },\
	{ "pitch", "3", "\x05P_", (NUMERIC | HARD_DIRECT | USE_RANGE), { "0,9" } }, \
	{ "rate", "7", "\x05R_", (NUMERIC | HARD_DIRECT | USE_RANGE), { "0,9" } }, \
	{ "tone", "i", "\x05T_", (HARD_DIRECT | USE_RANGE), { "a,z" } }, \
	{ "volume", "9", "\x05V_", (NUMERIC | HARD_DIRECT | USE_RANGE), { "0,9" } }, \
	{ "caps_start", "\x05P+", "_", 0, { -1 } }, \
	{ "caps_stop", "\x05P-", "_", 0, { -1 } }

/* additional settings and functionality */
#define XTEND_STR_SPKOUT \
	{ "punct", "n", "\x05M_", HARD_DIRECT, { "nmsa\xff" } }

#define ALIAS_STR_SPKOUT ZILCH
