/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#ifndef MAIN_H
#define MAIN_H

#include <ktmainwindow.h>

#include "channel.h"
#include <qobject.h>
#include <qpopupmenu.h>
#include <qaccel.h>
#include <qrect.h>

#include <kapp.h>
#include <kstatusbar.h>
#include <kmenubar.h>

#include "ax25k.h"
#include "chanlist.h"
#include "sound.h"
//---------------------------------------------------------------------------
/*
 *  typedef struct _s_chanlist (s_chanlist)
 * Hier wird eine Liste aller im Augenblick offener Kanaele abgespeichert.
 */
typedef struct _s_chanlist
{
   struct _s_chanlist *next;
   Channel *channel;
} s_chanlist;
//---------------------------------------------------------------------------
class TopLevel : public KTMainWindow
{
   Q_OBJECT;
public:
   TopLevel( const char *name=0 );
   ~TopLevel();

   s_chanlist * addChannelList();
   s_chanlist * getChanListPtr();
   ChanList *chanListTable;
   void deleteChannelList( Channel *chan );
   void checkForFirstRun();
   void setMainwinSize();
   void activateChannel(QWidget *win, QWidget *oldwin, bool show);
   QWidget *currentChannel;
	void toolbarMoved( Channel *chan, KToolBar *toolbar );

   int makeConnect( char *call, char *digis, char *mycall, char *port, int * error );
   bool incSSID(char *call);

   void setQsoWinGeometry( const QRect rect );
   QRect & getQsoWinGeometry();
   bool qsoWinGeometrySet();
   void playSound( int id );
   QPoint *lastWinPos;

private:
   QPopupMenu *file, *channel, *help;
   KMenuBar *menubar;
   LinKTSound *sound;

   QRect qsoWinGeometry;
   bool qsoWinGeometryFlag;

   void setupMenuBar();
   void setupChanListWidget();

   s_chanlist *chanlist;

public slots:
   void slotBeenden();
   void slotConnect();
   void slotAbout();
	void slotWhatsThis();
   void slotHelp();
   void slotAway();
	void slotPreferences();
	void slotUserSettings();
	void slotCallKey(int id);
   void slotCTRLUp();
   void slotCTRLDown();
	void slotAwayDataChanged();

protected:
   void closeEvent(QCloseEvent *e);
};
//---------------------------------------------------------------------------
/////////////////////////////////////////////////////////////////////
// Sonstige Prototypen
/////////////////////////////////////////////////////////////////////
//---------------------------------------------------------------------------
//   void init_globals()
// Globale Variablen aus dem linktrc-File holen und in die config-
// Struktur packen.
void init_globals();
//---------------------------------------------------------------------------
void getarg( char *line, char *arg );
//---------------------------------------------------------------------------
//   void createDirectories()
//
// Verzechnisse erstellen, wenn es sie noch nicht gibt.
void createDirectories();
//---------------------------------------------------------------------------
//   void readBoxCheckFile()
//
// Einlesen der Daten, die fuers BoxCheck benoetigt werden
void readBoxCheckFile();
//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------

