/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2001 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#include "userinfo.h"
#include "global.h"
#include "toolbox.h"
#include "flags.h"

#include <qfile.h>
//---------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
//---------------------------------------------------------------------------
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
//---------------------------------------------------------------------------
UserInfo::UserInfo( const QString & sCall )
{
   clearData();

   call = sCall.lower();

   if (!readData())
   {
      remotes = REMOTE_STD_TERMINAL;
      type = TYPE_TERMINAL;
      flags = CH_UI_STDFLAGS;
   }

   autoSave = true;
}
//---------------------------------------------------------------------------
UserInfo::~UserInfo()
{
}
//---------------------------------------------------------------------------
void UserInfo::clearData()
{
   call = "";
   name = "";
   flags = 0;
   pwmode = 0;
   password = "";
   type = TYPE_TERMINAL;
   remotes = 0;
   pwanswer = 0;
   pwcommand = "";
   pwanswerstr = "";
   pwanswerlen = 10;
   umbruch = conf->getFlag( CFG_UMBRUCH );
   umbruchpos = conf->getUmbruchPos();
   swtype = 0;
   boxCheck = "";
}
//---------------------------------------------------------------------------
// User-Informationen wenn vorhanden aus dem User-Info-File holen und
// lokal abspeichern.
bool UserInfo::readData()
{
   int i;
   long l;
   QString filename, id, value;
   bool ok;
  

   filename = conf->localDir()+"/userdb/"+call.left(3)+".../"+call;

   QFile f( filename );
   if (!f.open(IO_ReadOnly)) return false;

   QTextStream t( &f );

   while (!t.eof())
   {
      id = t.readLine();

      if (id[0] == '#') continue;		// Kommentare

		if ((i = id.find(' ')) > -1)
      {
         value = id.mid( i+1 );
         id.truncate( i );

         if (id == "name")
         {
         	// Workaround - TODO: remove soon
         	if (value != "(null)")
	         	name = value;
            continue;
			}
         if (id == "flags")
         {
         	i = value.toInt( &ok );
         	if (ok) flags = i;
            continue;
			}
         if (id == "pwmode")
         {
         	i = value.toInt( &ok );
         	if (ok) pwmode = i;
            continue;
			}
         if (id == "remotes")
         {
         	l = value.toLong( &ok );
         	if (ok) remotes = l;
            continue;
			}
         if (id == "pwanswer")
         {
         	i = value.toInt( &ok );
         	if (ok) pwanswer = i;
            continue;
			}
         if (id == "pwanswerlen")
         {
         	i = value.toInt( &ok );
         	if (ok) pwanswerlen = i;
            continue;
			}
         if (id == "password")
         {
         	// Workaround - TODO: remove soon
         	if (value != "(null)")
	         	password = value;
            continue;
			}
         if (id == "pwcommand")
         {
         	// Workaround - TODO: remove soon
         	if (value != "(null)")
	         	pwcommand = value;
            continue;
			}
         if (id == "pwanswerstr")
         {
         	pwanswerstr = value;
            continue;
			}
         if (id == "type")
         {
         	i = value.toInt( &ok );
         	if (ok) type = i;
            continue;
			}
         if (id == "umbruch")
         {
         	i = value.toInt( &ok );
         	if (ok)
            {
            	if (i == 0)
               	umbruch = false;
               else
                  umbruch = true;
				}
            continue;
			}
			if (id == "umbruchpos")
			{
         	i = value.toInt( &ok );
            if (ok)
            {
            	umbruchpos = i;
					if (umbruchpos == 0)
						umbruchpos = 78;
            }
            continue;
			}
			if (id == "swtype")
         {
         	i = value.toInt( &ok );
         	if (ok) swtype = i;
            continue;
			}
			if (id == "boxcheck")
         {
         	// Workaround - TODO: remove soon
         	if (value != "(null)")
					boxCheck = value;
            continue;
			}
      }
   }

   return true;
}
//---------------------------------------------------------------------------
/* Userdaten in das File schreiben */
void UserInfo::writeData()
{
   int f;
   char str1[256];
   QString filename;

   
   filename = conf->localDir()+"/userdb/"+call.left(3)+"...";
  
   /* Verzeichnis erzeugen, wenns noch nicht der da ist */
   if (mkdir(filename, 448) == -1)
   {}
   filename += "/"+call;


   f = open( filename.latin1(), (O_WRONLY|O_CREAT) );

   /* Zugriffsrechte einstellen */
   fchmod(f,S_IRUSR|S_IWUSR);


   if (!name.isEmpty())
   {
	   sprintf(str1,"name %s\xA",name.latin1());
	   write(f,str1,strlen(str1));
	}
   sprintf(str1,"flags %i\xA",flags);
   write(f,str1,strlen(str1));
   sprintf(str1,"pwmode %i\xA",pwmode);
   write(f,str1,strlen(str1));
   if (!password.isEmpty())
   {
      sprintf(str1,"password %s\xA",password.latin1());
      write(f,str1,strlen(str1));
   }
   sprintf(str1,"type %i\xA",type);
   write(f,str1,strlen(str1));
   sprintf(str1,"remotes %li\xA",remotes);
   write(f,str1,strlen(str1));
   sprintf(str1,"pwanswer %i\xA",pwanswer);
   write(f,str1,strlen(str1));
   if (!pwanswerstr.isEmpty())
   {
	   sprintf(str1,"pwanswerstr %s\xA", pwanswerstr.latin1());
	   write(f,str1,strlen(str1));
	}
   sprintf(str1,"pwanswerlen %i\xA", pwanswerlen);
   write(f,str1,strlen(str1));
   if (!pwcommand.isEmpty())
   {
	   sprintf(str1,"pwcommand %s\xA", pwcommand.latin1());
	   write(f,str1,strlen(str1));
	}
   if (umbruch)
      strcpy(str1,"umbruch 1\xA");
   else
      strcpy(str1,"umbruch 0\xA");
   write(f,str1,strlen(str1));
   sprintf(str1,"umbruchpos %i\xA", umbruchpos);
   write(f,str1,strlen(str1));
   sprintf(str1,"swtype %i\xA", swtype);
   write(f,str1,strlen(str1));
   if (!boxCheck.isEmpty())
   {
	   sprintf(str1, "boxcheck %s\xA", boxCheck.latin1());
	   write(f,str1,strlen(str1));
	}

   ftruncate(f, lseek(f, 0, SEEK_CUR));

   ::close(f);
}
//---------------------------------------------------------------------------
const QString & UserInfo::getName()
{
   return name;
}
//---------------------------------------------------------------------------
int UserInfo::getFlags()
{
   return flags;
}
//---------------------------------------------------------------------------
int UserInfo::getPwmode()
{
   return pwmode;
}
//---------------------------------------------------------------------------
const QString & UserInfo::getPwd()
{
   return password;
}
//---------------------------------------------------------------------------
int UserInfo::getType()
{
   return type;
}
//---------------------------------------------------------------------------
long UserInfo::getRemotes()
{
   return remotes;
}
//---------------------------------------------------------------------------
bool UserInfo::getUmbruch()
{
   return umbruch;
}
//---------------------------------------------------------------------------
int UserInfo::getUmbruchPos()
{
   return umbruchpos;
}
//---------------------------------------------------------------------------
int UserInfo::getSwType()
{
   return swtype;
}
//---------------------------------------------------------------------------
void UserInfo::setName( const QString & sName )
{
	name = sName;

	if (autoSave) writeData();
}
//---------------------------------------------------------------------------
void UserInfo::setFlags( const int newflags )
{
   flags = newflags;

   if (autoSave) writeData();
}
//---------------------------------------------------------------------------
void UserInfo::setPwmode( const int newpwmode )
{
   pwmode = newpwmode;

   if (autoSave) writeData();
}
//---------------------------------------------------------------------------
void UserInfo::setPwd( const QString & sPwd )
{
	password = sPwd;

   if (autoSave) writeData();
}
//---------------------------------------------------------------------------
void UserInfo::setType( const int newtype )
{
   type = newtype;

   if (autoSave) writeData();
}
//---------------------------------------------------------------------------
void UserInfo::setRemotes( const long newremotes )
{
   remotes = newremotes;

   if (autoSave) writeData();
}
//---------------------------------------------------------------------------
void UserInfo::setPWInfos( const int answer, const QString & sCommand, const QString & sAnswStr )
{
   pwanswer = answer;
   pwcommand = sCommand;
   pwanswerstr = sAnswStr;

   if (autoSave) writeData();
}
//---------------------------------------------------------------------------
int UserInfo::getPwAnswer()
{
   return pwanswer;
}
//---------------------------------------------------------------------------
const QString & UserInfo::getPwCommand()
{
   return pwcommand;
}
//---------------------------------------------------------------------------
const QString & UserInfo::getPwAnswerStr()
{
   return pwanswerstr;
}
//---------------------------------------------------------------------------
int UserInfo::getPwAnswerLen()
{
   return pwanswerlen;
}
//---------------------------------------------------------------------------
void UserInfo::setPwAnswerLen( const int len )
{
   pwanswerlen = len;

   if (autoSave) writeData();
}
//---------------------------------------------------------------------------
void UserInfo::setUmbruch( const bool _umbruch, const int _umbruchpos )
{
   umbruch = _umbruch;
   umbruchpos = _umbruchpos;

   if (autoSave) writeData();
}
//---------------------------------------------------------------------------
void UserInfo::setSwType( const int _swtype )
{
   swtype = _swtype;

   if (autoSave) writeData();
}
//---------------------------------------------------------------------------
const QString & UserInfo::getBoxCheck()
{
   return boxCheck;
}
//---------------------------------------------------------------------------
void UserInfo::setBoxCheck( const QString & sBoxcheck )
{
   boxCheck = sBoxcheck;

   if (autoSave) writeData();
}
//---------------------------------------------------------------------------
void UserInfo::typeChecked( int type, int software )
{
	autoSave = false;

	setType( type );
	setSwType( software );

	switch (type)
   {
   	case TYPE_DIGI:
			setFlags( (getFlags() & ~FLAGS_SAVE) | FLAGS_STD_DIGI );
			setRemotes( REMOTE_STD_DIGI );
      	break;
		case TYPE_MAILBOX:
			setFlags( (getFlags() & ~FLAGS_SAVE) | FLAGS_STD_MAILBOX );
			setRemotes( REMOTE_STD_MAILBOX );
      	break;
		case TYPE_TERMINAL:
			setFlags( (getFlags() & ~FLAGS_SAVE) | FLAGS_STD_TERMINAL );
			setRemotes( REMOTE_STD_TERMINAL );
      	break;
   }

   autoSave = true;
   writeData();
}
//---------------------------------------------------------------------------

