/*
 *  MoniKT - a monitor for LinKT
 *  Copyright (C) 1998-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifndef GLOBAL_H
#define GLOBAL_H


#include <time.h>
#include <qcolor.h>
#include <qfont.h>
#include <qlist.h>
#include <qwidget.h>
#include <stdlib.h>
#include <klocale.h>

#include "locator.h"


#define BUFSIZE         1500


#define COLOR_BLACK 0
#define COLOR_WHITE 1
#define COLOR_DARKGRAY 2
#define COLOR_GRAY 3
#define COLOR_LIGHTGRAY 4
#define COLOR_RED 5
#define COLOR_GREEN 6
#define COLOR_BLUE 7
#define COLOR_CYAN 8
#define COLOR_MAGENTA 9
#define COLOR_YELLOW 10
#define COLOR_DARKRED 11
#define COLOR_DARKGREEN 12
#define COLOR_DARKBLUE 13
#define COLOR_DARKCYAN 14
#define COLOR_DARKMAGENTA 15
#define COLOR_DARKYELLOW 16


#define SPY_EVERYTHING 1
#define SPY_NOTHING 2
#define SPY_FOLLOWING 3


typedef struct
{
   int background;          // Hintergrundfarbe Monitor

   int qsoWinMarkColor;     // Farbe von markiertem Text im QSO-Fenster
   int qsoWinMarkBack;      // Hintergrund von markiertem Text im QSO-Fenster
   bool mark_bold;          // markierten Text fett schreiben?

   int spyColor1;
   int spyColor2;
   int spyColorStatus;

   int colorError;
   int colorPort;
   int colorKiss;
   int colorBpq;
   int colorData;
   int colorProtocol;
   int colorAxhdr;
   int colorAddr;
   int colorIphdr;
   int colorTcphdr;
   int colorRosehdr;
   int colorTimestamp;
   int colorFlexnet;
   int colorZierrat;
   int colorCall;
   int colorFmCall;
   int colorToCall;
   int colorViaCall;
   int colorHdrVal;
   bool boldHeader;
} s_conf_colors;


typedef struct
{
   int buffersize;
   int tblsize;

   s_conf_colors *colors;
   char *maindir;

   int ax25spyd_port;       // Port, auf dem ax25spyd lauscht

   int dxWinSize;         // Groesse des DX-Cluster-Fensters in Prozent
   bool monWin;           // Soll das Monitor-Fenster angezeigt werden?
   bool dxWin;            // Soll das DX-Cluster-Fenster angezeigt werden?
   int updatemheard;      // Nach welchem Zeitraum (in ms) soll die MH-Liste
                          // upgedated werden?

   // Eigenschaften der Monitorausgabe
   bool timestamp;
   bool onlyIFrames;
   bool onlyHeaders;
   bool dxclusterspy;
   bool mheard;

   // Meine Position
   Locator *mypos;
/*   long mylatitude;
   long mylongitude;*/
   // Welches dx-data-file soll verwendet werden?
   char *dxdata_file;
   // Die Distanz in KM oder Meilen?
   bool distKM;

   // QSO-Spy aktivieren?
   bool qsospy;
   int spywhat;
   int ignorewhat;

   QStrList *spy, *ignore;

   char *font_output;
   int size_output;

} s_config;

extern s_config *config;

extern QColor colors[17];

extern KLocale *klocale;


#endif   /* GLOBAL_H */

