/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *                                                                              
 * As a special exception, you have permission to link this program             
 * with the Qt library and distribute executables, as long as you               
 * follow the requirements of the GNU GPL in regard to all of the               
 * software in the executable aside from Qt.                                    
 */

#include "boxcheck.h"
#include "boxcheck.moc"

#include "toolbox.h"
#include "channel.h"
#include "main.h"
#include "gpg.h"

#include <stdio.h>
#include <stdlib.h>

#include <kmessagebox.h>
#include <kwin.h>
#include <klocale.h>
#include <kiconloader.h>

#include <qcolor.h>
#include <qkeycode.h>
#include <qtooltip.h>
#include <qlayout.h>


#define BTNLENGTH 80
#define BTNHEIGHT 30

#define CMBWIDTH 150
#define CMBHEIGHT 20

#define TOOLWIDTH 32
#define TOOLHEIGHT 32


extern TopLevel *toplevel;
extern KApplication *mykapp;

int sortField;


//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


DlgTransfer::DlgTransfer( const QString & board, int nr)
                   : QDialog( 0, "", true )
{
   QString tmp, tmp2;


   setCaption(i18n("LinKT: Transfer Mail"));

   resize( 235, 120 );
   setFixedSize(size());

   if (!board.isEmpty())
      tmp = "Transfer: "+board+tmp2.sprintf(" %i", nr);
   else
      tmp.sprintf("Transfer: No %i", nr);
   lTInfo = new QLabel( this, tmp );
   lTInfo->setGeometry( 10, 10, 250, 20 );
   lTInfo->setText( tmp );

   le_board = new QLineEdit( this );
   le_board->setGeometry( 10, 40, 60, 20 );
   le_board->setText("");
   le_board->setMaxLength( 8 );

   lAt = new QLabel( this );
   lAt->setGeometry( 82, 40, 15, 20);
   lAt->setText( "@" );

   le_mbx = new QLineEdit( this );
   le_mbx->setGeometry( 105, 40, 60, 20 );
   le_mbx->setText("");
   le_mbx->setMaxLength( 8 );

   lLt = new QLabel( this );
   lLt->setGeometry( 175, 40, 15, 20 );
   lLt->setText( "#" );

   eLt = new KIntLineEdit( this );
   eLt->setGeometry( 190, 40, 35, 20 );
	eLt->setMaxLength( 3 );



   int abstand = (width()-(2*BTNLENGTH))/3;
   btnSend = new QPushButton( this );
   btnSend->setGeometry(abstand, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   btnSend->setText( i18n("&Send") );
   connect(btnSend, SIGNAL(clicked()), this, SLOT(accept()));
   btnSend->setDefault( true );

   btnAbort = new QPushButton( this );
   btnAbort->setGeometry(abstand*2+BTNLENGTH, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   btnAbort->setText( i18n("&Close") );
   connect(btnAbort, SIGNAL(clicked()), this, SLOT(reject()));

   le_board->setFocus();
}


DlgTransfer::~DlgTransfer()
{
	delete le_board;
	delete le_mbx;
	delete eLt;

	delete lAt;
	delete lTInfo;
	delete lLt;

	delete btnAbort;
	delete btnSend;
}


void DlgTransfer::getInfo( QString & board, QString & mbx, int & lt )
{
   bool ok;


   board = le_board->text();
   mbx = le_mbx->text();
   lt =eLt->text().toInt(&ok);
   if (!ok) lt = -1;
}


//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


DlgSetLT::DlgSetLT( const char *board, int nr )
                   : QDialog( 0, "", true )
{
   char tmp[100];

   setCaption(i18n("LinKT: Set New Lifetime"));


   resize( 230, 120 );
   setFixedSize(size());

   if (board != NULL)
	   sprintf(tmp, "Set lifetime for %s %i", board, nr);
	else
	   sprintf(tmp, "Set lifetime for No %i", nr);
   lLtInfo = new QLabel( tmp, this );
   lLtInfo->setGeometry( 10, 10, 250, 20 );

   eNewLt = new KIntLineEdit( this );
   eNewLt->setGeometry( 100, 40, 50, 20 );
   eNewLt->setText("");
   eNewLt->setMaxLength( 3 );

   lNewLt = new QLabel( "new lifetime:", this );
   lNewLt->setGeometry( 10, 40, 80, 20);



   int abstand = (width()-(2*BTNLENGTH))/3;
   btnSend = new QPushButton( this );
   btnSend->setGeometry(abstand, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   btnSend->setText( i18n("&Send") );
   connect(btnSend, SIGNAL(clicked()), this, SLOT(slotReturn()));
   btnSend->setDefault( true );

   btnAbort = new QPushButton( this );
   btnAbort->setGeometry(abstand*2+BTNLENGTH, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   btnAbort->setText( i18n("&Abort") );
   connect(btnAbort, SIGNAL(clicked()), this, SLOT(reject()));

   eNewLt->setFocus();
}


DlgSetLT::~DlgSetLT()
{
   delete eNewLt;
   delete lNewLt;
   delete lLtInfo;

   delete btnAbort;
   delete btnSend;
}


int DlgSetLT::getLT()
{
   return newlt;
}


void DlgSetLT::slotReturn()
{
   newlt = atoi(eNewLt->text());

   if (newlt > 999 || newlt < 1)
   {
		KMessageBox::sorry( this,
							i18n("The lifetime must be between 1 and 999."),
							i18n("Set Lifetime"));
      return;
   }

   accept();
}


/////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

BoxCheckEntry::BoxCheckEntry( QListView *parent, const QString & line, const QString & sender, const QString & rubrik, int nr, int bytes, int lt )
						: QListViewItem( parent, line )
{
	board = rubrik;
	this->nr = nr;
   this->lt = lt;
   this->size = bytes;
   this->sender = sender;
}


BoxCheckEntry::~BoxCheckEntry()
{
}


const QString & BoxCheckEntry::getBoardName()
{
	return board;
}


int BoxCheckEntry::getMailNr()
{
	return nr;
}


int BoxCheckEntry::getLifetime()
{
	return lt;
}

const QString & BoxCheckEntry::getSender()
{
	return sender;
}


QString BoxCheckEntry::key( int col, bool absteigend ) const
{
	static char tmp[100];


   switch (sortField)
   {
   	case BCFIELD_NUMBER:
         if (board == NULL)
				sprintf(tmp, "%6i", nr);
			else
				sprintf(tmp, "%-8s%.6i", board.latin1(), nr);
         return tmp;
		case BCFIELD_LIFETIME:
      	sprintf(tmp, "%.5i", lt);
         return tmp;
		case BCFIELD_SIZE:
      	sprintf(tmp, "%.10i", size);
         return tmp;
		case BCFIELD_SENDER:
      	sprintf(tmp, "%6s", sender.latin1());
         return tmp;
      default: return QListViewItem::key( col, absteigend );
   }
}


//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


BoxCheckWin::BoxCheckWin( Channel *chan )
     : QDialog( chan, "BoxCheckWin", false ), SendData( chan )
{
	QPixmap pm;
   QVBoxLayout *vbox, *vboxMain = new QVBoxLayout( this );
   QHBoxLayout *hbox;


   status = 0;
   wronglines = 0;
   titelFound = false;
   this->chan = chan;


   resize(600, 350);

   setCaption( "LinKT: "+i18n("BoxCheck") );


   vboxMain->setMargin( 5 );
   vboxMain->addSpacing( 5 );
   hbox = new QHBoxLayout( vboxMain );

	// Buttons fuer die anderen Funktionen
   btnTrans = new QPushButton( this );
   btnTrans->setFixedSize( TOOLWIDTH, TOOLHEIGHT );
   btnTrans->setPixmap( BarIcon( "linkt_mail_tr" ) );
	QToolTip::add( btnTrans, i18n("Transfer mail") );
   if (btnTrans->pixmap() == NULL)
	   btnTrans->setText( "TR");
   connect( btnTrans, SIGNAL(clicked()), this, SLOT(slotTransClicked()));
   aTr = new QAccel( this );
   aTr->connectItem( aTr->insertItem( Key_T ), this, SLOT(slotTransClicked()) );

   hbox->addWidget( btnTrans );



   btnSetLT = new QPushButton( this );
   btnSetLT->setFixedSize( TOOLWIDTH, TOOLHEIGHT );
   btnSetLT->setPixmap( BarIcon( "linkt_mail_lt" ) );
	QToolTip::add( btnSetLT, i18n("Change lifetime") );
   if (btnSetLT->pixmap() == NULL)
	   btnSetLT->setText( "LT" );
   connect( btnSetLT, SIGNAL(clicked()), this, SLOT(slotSetLTClicked()));

   aLt = new QAccel( this );
   aLt->connectItem( aLt->insertItem( Key_L ), this, SLOT(slotSetLTClicked()) );

   hbox->addWidget( btnSetLT );


   btnRead = new QPushButton( this );
   btnRead->setFixedSize( TOOLWIDTH, TOOLHEIGHT );
   btnRead->setPixmap( BarIcon( "linkt_mail_r" ) );
	QToolTip::add( btnRead, i18n("Read mail") );
   if (btnRead->pixmap() == NULL)
	   btnRead->setText( "R" );
   connect( btnRead, SIGNAL(clicked()), this, SLOT(slotReadClicked()));

   aR = new QAccel( this );
   aR->connectItem( aR->insertItem( Key_R ), this, SLOT(slotReadClicked()) );

   hbox->addWidget( btnRead );


   btnErase = new QPushButton( this );
   btnErase->setFixedSize( TOOLWIDTH, TOOLHEIGHT );
   btnErase->setPixmap( BarIcon( "linkt_mail_e" ) );
	QToolTip::add( btnErase, i18n("Delete mail") );
   if (btnErase->pixmap() == NULL)
	   btnErase->setText( "E" );
   connect( btnErase, SIGNAL(clicked()), this, SLOT(slotEraseClicked()));

   aE = new QAccel( this );
   aE->connectItem( aE->insertItem( Key_E ), this, SLOT(slotEraseClicked()) );

   hbox->addWidget( btnErase );


   hbox->addSpacing( 5 );


   btnReply = new QPushButton( this );
   btnReply->setFixedSize( TOOLWIDTH, TOOLHEIGHT );
	btnReply->setPixmap( BarIcon( "linkt_mail_rep" ) );
	QToolTip::add( btnReply, i18n("Reply to mail") );
   if (btnReply->pixmap() == NULL)
	   btnReply->setText( "REP" );
   connect( btnReply, SIGNAL(clicked()), SLOT(slotReplyClicked()));

	hbox->addWidget( btnReply );


   btnComment = new QPushButton( this );
   btnComment->setFixedSize( TOOLWIDTH, TOOLHEIGHT );
	btnComment->setPixmap( BarIcon( "linkt_mail_com" ) );
	QToolTip::add( btnComment, i18n("Comment mail") );
   if (btnComment->pixmap() == NULL)
	   btnComment->setText( "COM" );
	connect( btnComment, SIGNAL(clicked()), SLOT(slotCommentClicked()));

	hbox->addWidget( btnComment );

   hbox->addStretch( 1 );

   vbox = new QVBoxLayout( hbox );

   hbox = new QHBoxLayout( vbox );

	vbox->addStretch( 1 );

	// Liste der Sortiermoeglichkeiten
	lSort = new QLabel( this );
	lSort->setText(i18n("Sort by"));
   hbox->addWidget( lSort );
   hbox->addSpacing( 5 );

   cmbSort = new QComboBox( this );
   connect( cmbSort, SIGNAL(activated(const QString &)), this, SLOT(slotChangeSorting(const QString &)));
   hbox->addWidget( cmbSort );

   vbox->addStretch( 1 );

   vboxMain->addSpacing( 10 );


	liste = new QListView( this );
   liste->setGeometry( 0, BTNHEIGHT+15, width(), height()-2*(BTNHEIGHT+15));
   liste->setFont( conf->bcFont() );
   liste->setMultiSelection( true );
   liste->setFocus();

	liste->addColumn("");
   liste->setColumnWidth(0, liste->width());

	liste->setSorting( 0, true );

	vboxMain->addWidget( liste, 2 );


	connect( liste, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(slotReadCmd(QListViewItem *)));


   hbox = new QHBoxLayout( vboxMain );

   hbox->addStretch( 1 );

   btnSend = new QPushButton( this );
   btnSend->setText( i18n("&Read") );
   btnSend->setDefault( true );
   connect( btnSend, SIGNAL(clicked()), this, SLOT(slotSend()) );

   hbox->addWidget( btnSend );
   hbox->addStretch( 1 );

   btnAbort = new QPushButton( this );
   btnAbort->setText( i18n("&Abort") );
   connect(btnAbort, SIGNAL(clicked()), this, SLOT(reject()));

   hbox->addWidget( btnAbort );
   hbox->addStretch( 1 );


   liste->setFocus();
}


BoxCheckWin::~BoxCheckWin()
{
}


void BoxCheckWin::setData( int type, char *title )
{
   this->type = type;
   liste->setColumnText( 0, title );
	liste->clearSelection();
	liste->clear();
}


void BoxCheckWin::setFields( int fields )
{
	cmbSort->clear();

   if (fields & BCFIELD_NUMBER)
   {
	   if (fields & BCFIELD_BOARD)
	   {
	   	cmbSort->insertItem( i18n("Board & Number") );
	      if (cmbSort->count() == 1)
	         sortField = BCFIELD_NUMBER;
		}
      else
      {
	   	cmbSort->insertItem( i18n("Number") );
	      if (cmbSort->count() == 1)
	         sortField = BCFIELD_NUMBER;
      }
	}

	if (fields & BCFIELD_LIFETIME)
	{
   	cmbSort->insertItem( i18n("Lifetime") );
      if (cmbSort->count() == 1)
         sortField = BCFIELD_LIFETIME;
	}

	if (fields & BCFIELD_SIZE)
 	{
   	cmbSort->insertItem( i18n("Size") );
      if (cmbSort->count() == 1)
         sortField = BCFIELD_SIZE;
	}

	if (fields & BCFIELD_SENDER)
	{
   	cmbSort->insertItem( i18n("Sender") );
      if (cmbSort->count() == 1)
         sortField = BCFIELD_SENDER;
	}

   cmbSort->setFixedWidth( cmbSort->sizeHint().width() );

   if (data->type == BCTYPE_BAYBOX)
   {
		btnSetLT->setEnabled( fields & BCFIELD_LIFETIME );
	   btnReply->setEnabled( true );
	   btnComment->setEnabled( true );
	}

   if (data->type == BCTYPE_F6FBB)
   {
		btnSetLT->setEnabled( false );
	   btnReply->setEnabled( false );
	   btnComment->setEnabled( false );
   }


}


void BoxCheckWin::addEntry( const QString & line, const QString & sender, const QString & rubrik, int nr, int bytes, int lt )
{
	new BoxCheckEntry( liste, line, sender, rubrik, nr, bytes, lt );
}


void BoxCheckWin::clear()
{
	liste->clear();
}


void BoxCheckWin::slotSend()
{
   BoxCheckEntry *entry;
   QString board="", tmp="", str="", lastboard="";
   int nr, startnr=-1, endnr=-1;


   if ((entry = (BoxCheckEntry *)liste->firstChild()) == NULL) return;


   if (data->type == BCTYPE_BAYBOX)
	{
	   if (entry->getBoardName().isEmpty())
	   {
		   do
		   {
		      if (entry->isSelected())
		      {
		         nr = entry->getMailNr();
					if (nr > 0)
					{
						if (nr == endnr+1)
						{
							// Die folgende Mail im selben Board.
							endnr++;
						}
						else
						{
							// Eine neue Mail der gleichen Rubrik.
	                  if (startnr != -1)
								if (startnr != endnr)
									tmp.sprintf( "R %i-%i", startnr, endnr );
								else
									tmp.sprintf( "R %i", startnr );
							startnr = nr;
							endnr = nr;
							if (str.length() == 0)
	                  	str = tmp;
							else
	                  	str += ";"+tmp;
						}
		         }
		         entry->setSelected( false );
		      }
		   } while ((entry = (BoxCheckEntry *)entry->nextSibling()) != NULL);


		   if (startnr != -1)
		   {
				if (startnr != endnr)
					tmp.sprintf("R %i-%i", startnr, endnr);
				else
					tmp.sprintf("R %i", startnr);

				if (str.length() == 0)
	         	str = tmp;
				else
	            str += ";"+tmp;
		  	}
	   }
	   else
	   {
		   do
		   {
		      if (entry->isSelected())
		      {
		         nr = entry->getMailNr();
		         board = entry->getBoardName();
					if (nr > 0)
					{
						if (lastboard == board)
						{
							// Das selbe Board.
							if (nr == endnr+1)
							{
								// Die folgende Mail im selben Board.
								endnr++;
							}
							else
							{
								// Eine neue Mail der gleichen Rubrik.
								if (startnr != endnr)
									tmp.sprintf("R %s %i-%i", board.latin1(), startnr, endnr);
								else
									tmp.sprintf("R %s %i", board.latin1(), startnr);
								startnr = nr;
								endnr = nr;
								if (str.length() == 0)
	                     	str += tmp;
								else
	                     	str += ";"+tmp;
							}
						}
						else
						{
							// Ein anderes Board
							if (startnr != -1)
								if (startnr != endnr)
									tmp.sprintf("R %s %i-%i", lastboard.latin1(), startnr, endnr);
							else
								tmp.sprintf("R %s %i", lastboard.latin1(), startnr);
							startnr = nr;
							endnr = nr;
	                  lastboard = board;
							if (str.length() == 0)
								str = tmp;
							else
								str += ";"+tmp;
					   }
		         }
		         entry->setSelected( false );
		      }
		   } while ((entry = (BoxCheckEntry *)entry->nextSibling()) != NULL);


		   if (startnr != -1)
		   {
				if (startnr != endnr)
					tmp.sprintf("R %s %i-%i", lastboard.latin1(), startnr, endnr);
				else
					tmp.sprintf("R %s %i", lastboard.latin1(), startnr);

				if (str.length() == 0)
	         	str = tmp;
				else
	            str += ";"+tmp;
		  	}
		}
	}

   // F6FBB-Mailbox: R <Nr> <Nr> <Nr> <Nr>...
   if (data->type == BCTYPE_F6FBB)
   {
	   do
	   {
	      if (entry->isSelected())
	      {
	         nr = entry->getMailNr();
				if (nr > 0)
				{
               if (str.length() == 0)
               	str.sprintf( "R %i", nr );
					else
               	str += tmp.sprintf(" %i", nr);
					if (str.length() > 80)
               {
				   	str += "\r";
						sendString( str );
                  str = "";
               }
	         }
	         entry->setSelected( false );
 			}
		} while ((entry = (BoxCheckEntry *)entry->nextSibling()) != NULL);
   }

	if (str.length() != 0)
	{
   	str += "\r";
		sendString( str );
	}


   accept();
}


void BoxCheckWin::slotReadCmd(QListViewItem *item)
{
	QString board;
   int nr;
   QString tmp;


   board = ((BoxCheckEntry *)item)->getBoardName();
   nr = ((BoxCheckEntry *)item)->getMailNr();

	if (board.isEmpty())
   	tmp.sprintf("R %i\r", nr);
	else
		tmp.sprintf("R %s %i\r", board.latin1(), nr);

	sendString( tmp );
}


void BoxCheckWin::slotChangeSorting( const QString & string )
{
	// TODO: liste->setSorting wird bei Qt2 durch sort() ersetzt.
	if (string == i18n("Board & Number") ||
	    string == i18n("Number"))
	{
		sortField = BCFIELD_NUMBER;
		liste->sort();
		return;
	}

	if (string == i18n("Lifetime"))
	{
		sortField = BCFIELD_LIFETIME;
		liste->sort();
      return;
	}

	if (string == i18n("Size"))
	{
		sortField = BCFIELD_SIZE;
		liste->sort();
      return;
	}

	if (string == i18n("Sender"))
	{
		sortField = BCFIELD_SENDER;
		liste->sort();
      return;
	}
}


void BoxCheckWin::slotTransClicked()
{
   BoxCheckEntry *entry;
   QString newboard, newmbx;
   QString tmp, tmp2;
   QString board;
   int nr, newlt;


   if ((entry = (BoxCheckEntry *)liste->currentItem()) == NULL) return;
   board = QString(entry->getBoardName());
   nr = entry->getMailNr();

   DlgTransfer *dlg = new DlgTransfer(board, nr);

   dlg->setGeometry((this->width()-dlg->width())/2,
     		           (this->height()-dlg->height())/2,
  		              dlg->width(),dlg->height());

   if (dlg->exec() == 1)
   {
      dlg->getInfo( newboard, newmbx, newlt );

      if (data->type == BCTYPE_BAYBOX)
      {
	      if (newboard.isEmpty()) return;
	      tmp = "TR "+board+tmp2.sprintf(" %i ", nr)+newboard;
			if (!newmbx.isEmpty())
	         tmp += " @ "+newmbx;
	   	if (newlt != -1)
	         tmp += tmp2.sprintf(" #%i\r", newlt);
			else
				tmp += "\r";
		}

      if (data->type == BCTYPE_F6FBB)
		{
			tmp = "SC "+newboard;
			if (!newmbx.isEmpty())
				tmp += "@"+newmbx;
			tmp += "\r/ex\r";
		}
      sendString( tmp );
   }

   delete dlg;
}


void BoxCheckWin::slotSetLTClicked()
{
   BoxCheckEntry *entry;
   char tmp[500];
   int nr, newlt;
   const char *board;

   
   if ((entry = (BoxCheckEntry *)liste->currentItem()) == NULL) return;
   board = entry->getBoardName();
   nr = entry->getMailNr();

   DlgSetLT *dlg = new DlgSetLT(board, nr);

   dlg->setGeometry((this->width()-dlg->width())/2,
     		           (this->height()-dlg->height())/2,
  		              dlg->width(),dlg->height());

   if (dlg->exec() == 1)
   {
      newlt = dlg->getLT();

      sprintf(tmp,"SETL %s %i %i\r", board, nr, newlt);
      sendString( tmp );
   }

   delete dlg;
}


void BoxCheckWin::slotReadClicked()
{
   BoxCheckEntry *entry;
   QString tmp, board;
   int nr;


   if ((entry = (BoxCheckEntry *)liste->currentItem()) == NULL) return;

   if (data->type == BCTYPE_F6FBB)
   {
   	nr = entry->getMailNr();

      tmp.sprintf( "R %i\r", nr );
   }
	else
   {
	   board = entry->getBoardName();
	   nr = entry->getMailNr();

	   tmp.sprintf( "R %s %i\r", board.latin1(), nr );
	}
   sendString( tmp );
}


void BoxCheckWin::slotEraseClicked()
{
   QString tmp, board;
   int nr;
   BoxCheckEntry *entry;


   if ((entry = (BoxCheckEntry *)liste->currentItem()) == NULL) return;
   board = entry->getBoardName();
   nr = entry->getMailNr();

   if (!board.isEmpty())
	   tmp.sprintf( i18n("Do you really want to delete the mail %s %i?"),
	                board.latin1(), nr);
	else
	   tmp.sprintf( i18n("Do you really want to delete the mail %i?"), nr);

   if (KMessageBox::questionYesNo(this,
                      tmp,
                      i18n("Delete Mail?"),
                      i18n("&Yes"),
                      i18n("&No")) != KMessageBox::Yes)
      return;

	if (data->type == BCTYPE_BAYBOX)
   {
	   if (!board.isEmpty())
			tmp.sprintf( "E %s %i\r", board.latin1(), nr );
		else
	      tmp.sprintf( "E %i\r", nr);
	}

   if (data->type == BCTYPE_F6FBB)
   {
   	tmp.sprintf( "K %i\r", nr );
   }

   sendString( tmp );
}


void BoxCheckWin::slotReplyClicked()
{
   BoxCheckEntry *entry;
   QString title, sendstring, board;
   int nr;


   if ((entry = (BoxCheckEntry *)liste->currentItem()) == NULL) return;


	GPGDialog *dlg = new GPGDialog( this, chan );

	QPoint point = this->mapToGlobal (QPoint (0,0));

	QRect pos = this->geometry();
	dlg->setGeometry(point.x() + pos.width()/2  - dlg->width()/2,
				point.y() + pos.height()/2 - dlg->height()/2,
				dlg->width(),dlg->height());

	board = entry->getBoardName();
   nr = entry->getMailNr();

	if (data->type == BCTYPE_BAYBOX)
		sendstring.sprintf("REP %s %i\r", board.latin1(), nr );
	dlg->setReply( sendstring, nr, board, entry->getSender() );

	dlg->show();

   // Den Speicher nicht wieder freigeben, das erledigt GPGDialog selbst.
}


void BoxCheckWin::slotCommentClicked()
{
   BoxCheckEntry *entry;
   QString title, sendstring, board;
   int nr;


   if ((entry = (BoxCheckEntry *)liste->currentItem()) == NULL) return;


	GPGDialog *dlg = new GPGDialog( this, chan );

	QPoint point = this->mapToGlobal (QPoint (0,0));

	QRect pos = this->geometry();
	dlg->setGeometry(point.x() + pos.width()/2  - dlg->width()/2,
				point.y() + pos.height()/2 - dlg->height()/2,
				dlg->width(),dlg->height());

	board = entry->getBoardName();
   nr = entry->getMailNr();

	if (data->type == BCTYPE_BAYBOX)
		sendstring.sprintf("COMMENT %s %i\r", board.latin1(), nr );
	dlg->setComment( sendstring, nr, board, entry->getSender() );

	dlg->show();

   // Den Speicher nicht wieder freigeben, das erledigt GPGDialog selbst.
}


void BoxCheckWin::setNewFont()
{
   liste->setFont( conf->bcFont() );
   liste->triggerUpdate();
}



void BoxCheckWin::setData( s_boxcheck *data )
{
	this->data = data;
}


void BoxCheckWin::readData( const char *desc )
{
	s_boxcheck *tmp;


	titelFound = false;
   checkAll = false;
   if (!strcmp(desc, i18n("check every entry")))
   {
	   checkAll = true;
      return;
	}

	for (tmp=boxcheckroot; tmp; tmp=tmp->next)
		if (!strcmp(tmp->desc, desc) && tmp->enabled)
		{
			data = tmp;
			return;
		}

	data = NULL;
}


void BoxCheckWin::proceed( char *rxdata, int len )
{		// TODO: Auf QString umbauen
	char *rxstr;
   int i, tmplen;
   char tmp[500], board[500]="", sender[500]="";
   int number=-1, lifetime=-1, size=-1;
	s_boxcheck *bctmp;


   // Wenn keine BoxCheck-Konfiguration vorhanden ist, haben wir hier
   // nichts zu suchen.
   if (data == NULL && !checkAll) return;

   rxstr = (char *) malloc(len+1);
   memcpy(rxstr, rxdata, len);
   rxstr[len] = '\0';

   if ((i = POS('\r', rxstr)) > -1) rxstr[i] = '\0';
   if ((i = POS('\n', rxstr)) > -1) rxstr[i] = '\0';

   // Kommt eine neue Titelzeile an?
   if (checkAll)
   {
   	// Alle durchsuchen
		for (bctmp=boxcheckroot; bctmp; bctmp=bctmp->next)
      {
		   if (!strcmp(rxstr, bctmp->title))
		   {
       		data = bctmp;
			  	// Ja, neuer Titel. Fenster wenn noch nicht vorhanden erstellen,
			  	// sonst leeren.
			   wronglines = 0;
				setData( data->type, data->title );
            titelFound = true;
			   chan->enableBoxcheckMenu();
				setFields( data->fields );
			   free(rxstr);
			   return;
			}
		}
   }
   else
   {
	   if (!strcmp(rxstr, data->title))
	   {
	   	// Ja, neuer Titel. Fenster wenn noch nicht vorhanden erstellen,
	   	// sonst leeren.
	      wronglines = 0;
			setData( data->type, data->title );
			titelFound = true;
	      chan->enableBoxcheckMenu();
			setFields( data->fields );
	      free( rxstr );
	      return;
	   }
   }

   if (wronglines >= 5)
   {
   	free( rxstr );
      return;
   }

   // Keine Titelzeile. Wenn das Fenster nicht vorhanden ist, abbrechen.
   if (!titelFound)
   {
   	free( rxstr );
   	return;
	}

	// Wenn die Zeile zu kurz ist, wird auch nicht weitergemacht.
   if (strlen(rxstr) < data->minlen)
   {
      wronglines++;
      free( rxstr );
   	return;
   }

   // Sooo... Anhand der festen Zeichen wird ueberprueft, ob dieser Eintrag
   // korrekt ist. Nach mehr als 5 falschen Zeilen wird die Ueberpruefung
   // abgebrochen.
   for (i=0; i<data->mustcount; i++)
   {
      if (rxstr[data->must[i].pos] != data->must[i].zeichen)
      {
         wronglines++;
			free(rxstr);
         return;
      }
	}

	// Korrekter Eintrag
	wronglines = 0;


   if (data->board != NULL)
   {
   	strncpy(board, rxstr+data->board->pos, data->board->len);
      i = strlen(board)-1;
      while (board[i] == '.' && i >= 0)
      {
      	board[i] = '\0';
         i--;
		}
	}

	if (data->number != NULL)
   {
   	strncpy(tmp, rxstr+data->number->pos, data->number->len);
      tmplen = strlen(tmp);
      while (tmp[0] == '.')
      {
      	tmplen--;
         memmove(tmp, tmp+1, tmplen);
      }
      tmp[tmplen] = '\0';
      number = atoi(tmp);
   }

   // Absender
   if (data->sender != NULL)
   {
   	strncpy(sender, rxstr+data->sender->pos, data->sender->len);
      KillSpacesRight(sender);
   }

   if (data->lifetime != NULL)
   {
   	strncpy(tmp, rxstr+data->lifetime->pos, data->lifetime->len);
		KillSpacesRight(tmp);
		KillSpacesLeft(tmp);
      lifetime = atoi(tmp);
      if (lifetime == 0) lifetime = -1;
   }

   if (data->size != NULL)
   {
   	strncpy(tmp, rxstr+data->size->pos, data->size->len);
		KillSpacesRight(tmp);
		KillSpacesLeft(tmp);
      size = atoi(tmp);
      if (size == 0) size = -1;
   }


   addEntry( rxstr, sender, board, number, size, lifetime );

   free(rxstr);
}


void BoxCheckWin::showWindow()
{
   if (!titelFound)
   {
		KMessageBox::error( chan,
							i18n("Cannot comply: No checklist received yet."),
							i18n("BoxCheck"));
      return;
   }

	KWin::setActiveWindow( winId() );
   show();
   setFocus();

   liste->setFocus();
}


