/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#ifndef DIALOG_H
#define DIALOG_H
//---------------------------------------------------------------------------
#include <qdialog.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qtabdialog.h>
#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qtimer.h>
#include <qspinbox.h>
#include <qstring.h>
#include <qvalidator.h>

#include <time.h>

#include <kurllabel.h>
//---------------------------------------------------------------------------
class ConnDlgValidator : public QValidator
{
	Q_OBJECT;
public:
	ConnDlgValidator( QWidget *parent, const char *name=0 );
   ~ConnDlgValidator();

   QValidator::State validate( QString & str, int & ) const;
};
//---------------------------------------------------------------------------
class Connect : public QDialog
{
   Q_OBJECT;
public:
   Connect( QWidget *parent );
   ~Connect();
   const QString getText();
   const QString getPort();
   const QString getMycall();

private:
   QComboBox *cmbPorts;
   QComboBox *cmbCall;
   QLineEdit *edMyCall;
   QPushButton *btnOk, *btnAbort;

   QAccel *a;
};
//---------------------------------------------------------------------------
class AboutDlg : public QDialog
{
   Q_OBJECT

public:
   AboutDlg(QWidget *parent = 0);

public slots:
	void slotSendEMail();
   void slotDataShow();
   void slotDataWait();
   void slotDataAway();
   void slotDataEmpty();

private:
	void displayCreditID( int id );

	KURLLabel *url;
   QWidget *frameWidget;
   QLabel *credit;
   QTimer *timer;
   int creditid;
};
//---------------------------------------------------------------------------
class AwayDlg : public QDialog
{
   Q_OBJECT;

public:
   AwayDlg( QWidget *parent );
   ~AwayDlg();

public slots:
	void slotOkClicked();

signals:
	void awayDataChanged();

private:
   QListBox *lbAction;
   QPushButton *btnOk, *btnAbort;
};
//---------------------------------------------------------------------------
class DlgYAPP : public QDialog
{
   Q_OBJECT;
public:
   DlgYAPP( QWidget *parent, const char *name );
   ~DlgYAPP();

	void getFilename( QString & name );

public slots:
   void slotBrowseFile();

private:
   QPushButton *btnok, *btnabort;
   QLabel *lFName;
   QLineEdit *filename;
   QPushButton *browse;
};
//---------------------------------------------------------------------------
class DlgPasswordAdd : public QDialog
{
	Q_OBJECT;
public:
	DlgPasswordAdd( QWidget *parent );
   ~DlgPasswordAdd();

public slots:
	void btnOkClicked();
  	void btnHelpClicked();

private:
   QComboBox *cmbType;
   QLineEdit *edCmd, *edPwd, *edAnsw;
   QCheckBox *chkbPWChars, *chkbEdAnsw, *chkbAZ, *chkbaz, *chkb09;
   QSpinBox *sbAnswLen;
	QPushButton *btnOk, *btnAbort, *btnHelp, *btnImport;
};
//---------------------------------------------------------------------------
#endif /* DIALOG_H */
//---------------------------------------------------------------------------

