/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * As a special exception, you have permission to link this program
 * with the Qt library and distribute executables, as long as you
 * follow the requirements of the GNU GPL in regard to all of the
 * software in the executable aside from Qt.
 */

#include "abin.h"
#include "abin.moc"

#include "toolbox.h"
#include "dostime.h"
#include "dialog.h"
#include "channel.h"
#include "checksums.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>


ABinTX::ABinTX( Channel *chan, const QString & filename )
			: FileTransfer( chan, filename )
{
	struct stat stat_data;
   unsigned short time, date;


	crc = CheckSums::calcCrcthpWholefile( longname );

   stat(longname.latin1(), &stat_data);
   date_unix2dos(stat_data.st_mtime, &time, &date);
   fulldostime = (date << 16) + time;

   size = stat_data.st_size;

   fd = -1;
   bytes_sent = 0;
   this->chan = chan;
   ready = SQTRSTAT_NOSTOP;
}


ABinTX::~ABinTX()
{
	if (fd != -1)
   	::close(fd);

   emit unshowStatus();
}


void ABinTX::startSending()
{
	char tmp[500];


   // Normaler #BIN# - Header
   sprintf( tmp,"#BIN#%li#|%i#$%lX#%s\r", size, crc, fulldostime, shortname.latin1() );

	emit sendString( tmp, strlen(tmp), true );
}


void ABinTX::getFileData()
{
	static char tmp[513];
   int len;


	if (fd == -1)
   	return;

	len = read( fd, tmp, 512 );

	if (len != 512)
	{
		::close(fd);
		fd = -1;
		ready = SQTRSTAT_STDSTOP;
   }

   if (len == -1) len = 0;

   bytes_sent += len;

   emit statusRxBytes( bytes_sent );
   emit sendString( tmp, len, false );

   if (ready != 0)
      showEndText();
}


void ABinTX::slotReceivedString( const char *data, int len )
{
	if (!strncmp(data, "#ABORT#", 7) ||
		 !strncmp(data, "#NO#", 4))
   {
   	ready = SQTRSTAT_STDSTOP;
      return;
   }

	if (!strncmp(data, "#OK#", 4))
   {
   	if (fd == -1)
      {
	   	if ((fd = open(longname.latin1(), O_RDONLY)) == -1)
         {
	   		ready = SQTRSTAT_ABORT;
            return;
			}
         starttime = time(NULL);
         emit showStatus( this, shortname, size, 0, TRANSART_ABINTX );
         emit sendData();
		}
   }
}


void ABinTX::showEndText()
{
   time_t timediff;
   char *timeptr;
   char tmp2[100];

   timediff = time(NULL) - starttime;
   if (timediff == 0) timediff = 1;
   timeptr = (char *)spec_time(timediff);

   sprintf(tmp2,"<LinKT>: AutoBIN-TX OK. CRC: %i (time: %s, %li bit/s)\xD",
                crc, timeptr, (size*8)/timediff);

   if (chan->userinfo->getType() == TYPE_TERMINAL)
		emit sendString( tmp2, strlen(tmp2), true );
   else
      chan->outText( tmp2, strlen(tmp2), OUTCOLOR_TXTEXT );

   free(timeptr);
}


int ABinTX::sentReady()
{
	return ready;
}


void ABinTX::abortTransmission()
{
	char tmp[100];


	::close(fd);
	fd = -1;

   emit deleteFTData();
	ready = SQTRSTAT_ABORT;

	sprintf( tmp, "\r#ABORT#\r" );
	emit sendString( tmp, strlen(tmp), false );

   sprintf(tmp, "<LinKT>: AutoBIN-TX aborted.\xD");

   if (chan->userinfo->getType() == TYPE_TERMINAL)
		emit sendString( tmp, strlen(tmp), true );
   else
      chan->outText( tmp, strlen(tmp), OUTCOLOR_TXTEXT );
}


