/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#ifndef AUTO7_H
#define AUTO7_H
//---------------------------------------------------------------------------
#include "filetransfer.h"
#include "sendqueue.h"

#include <stdio.h>
//---------------------------------------------------------------------------
class Channel;
//---------------------------------------------------------------------------
typedef struct _s_7files
{
	struct _s_7files *next;
	char *name;
   int nr;
} s_7files;
//---------------------------------------------------------------------------
class Auto7Plus : public FileTransfer
{
	Q_OBJECT;

public:
	Auto7Plus( Channel *chan, const char *filename, s_sqsendinfo *info );
   ~Auto7Plus();

	void getFileData();
   void startSending();
   int sentReady();
	void abortTransmission();

public slots:
	void slotReceivedString( const char *, int );

signals:

private:
	void SendString( const char *data );
	void encode7plusFiles();
	void getSendFilelist();
	void addFile( const char *filename, int nr );
	void deleteFileRoot();
	void macroLine( char *dest, const char *src, int filenr );

	FILE *f;
   Channel *chan;
   s_sqsendinfo *sendinfo;
   int nextfile;
   bool ready;
   char *dirname;
   int filecount;
   s_7files *fileroot;
};
//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------

