/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#ifndef CFG_H
#define CFG_H
//---------------------------------------------------------------------------
#include <qfont.h>
#include <qstringlist.h>
//---------------------------------------------------------------------------
class KConfig;
//---------------------------------------------------------------------------
#define CFG_SHOWTSID 1
#define CFG_USELOG 2
#define CFG_INCSSID 4
#define CFG_ALLOWANSI 8
#define CFG_TXWINOBEN 16
#define CFG_CLOSEWINDISC 32
#define CFG_HIDEWINSWITCH 64
#define CFG_OPENCHANWIN 128
#define CFG_LOCALECHO 256
#define CFG_BEEPCTRLG 512
#define CFG_UMBRUCH 1024
#define CFG_OVERWRITEXIST 2048
#define CFG_EXTRATRANSWIN 4096		// REMOVED
#define CFG_YAPPRESUME 8192
#define CFG_GPGSUPPORT 16384
#define CFG_GPGIMPORTKEYS 32768
#define CFG_GPGASKIMPORTKEYS 65536
#define CFG_GPGADDSIG 131072
//---------------------------------------------------------------------------
// Standard-Werte
#define CFG_STANDARD (CFG_USELOG+CFG_INCSSID+CFG_ALLOWANSI+CFG_OPENCHANWIN+ \
							 CFG_LOCALECHO+CFG_UMBRUCH+CFG_GPGSUPPORT+CFG_GPGIMPORTKEYS+ \
							 CFG_GPGASKIMPORTKEYS)
//---------------------------------------------------------------------------
#define CFG_COLORCOUNT 13
#define CFG_COLOR_RX 0
#define CFG_COLOR_TX 1
#define CFG_COLOR_STATUS 2
#define CFG_COLOR_GPG 3
#define CFG_COLOR_BG 4
#define CFG_COLOR_TXWIN 5
#define CFG_COLOR_TXWINBG 6
#define CFG_COLOR_MARKBACK 7
#define CFG_COLOR_MARKFORE 8
#define CFG_COLOR_CL_INF 9
#define CFG_COLOR_CL_SETUP 10
#define CFG_COLOR_CL_DISC 11
#define CFG_COLOR_CL_FILETRANS 12
//---------------------------------------------------------------------------
#define SOUNDCOUNT 8
#define SOUND_CONN_SETUP 0
#define SOUND_CONN_IN 1
#define SOUND_CONN_OUT 2
#define SOUND_CONN_CLOSED 3
#define SOUND_RING 4
#define SOUND_FILE_START 5
#define SOUND_FILE_READY 6
#define SOUND_FILE_ABORT 7
//---------------------------------------------------------------------------
class AwayInfo
{
public:
	AwayInfo();
	AwayInfo( const QString & action, const QString & text="" );
	~AwayInfo();

	const QString & getAction();
	const QString & getText();

	void setAction( const QString & action );
	void setText( const QString & text );

private:
	QString sAction;
	QString sText;
};
//---------------------------------------------------------------------------
typedef struct _s_listCalls
{
   struct _s_listCalls *next;
   char *call;
} s_listCalls;
//---------------------------------------------------------------------------
typedef struct
{
   char call[10];       // Dieses Rufzeichen soll gesucht werden
   bool ssid;           // SSID-Sensitiv?
} s_callKey;
//---------------------------------------------------------------------------
class Config
{
public:
   Config( KConfig *kconfig );
   ~Config();

   QFont qsoFont();
   QFont txFont();
   QFont bcFont();
   QFont gpgFont();
   void setQsoFont( const QFont & font );
   void setTxFont( const QFont & font );
   void setBcFont( const QFont & font );
   void setGpgFont( const QFont & font );

	void saveFlagToFile( KConfig *kconfig, int flag, const QString & key, bool enable );
   void saveColorToFile( KConfig *kconfig, int flag, const QString & key, int value );

   QString localDir();
	void setLocalDir( QString dir );
	QString globalDir();
   void setGlobalDir( QString dir );
   const QString & getStartDirUp();
   const QString & getDirUp();
   void setDirUp( const QString & dir );
   void setStartDirUp( const QString & dir );
   const QString & getStartDirDown();
   const QString & getDirDown();
   void setDirDown( const QString & dir );
   void setStartDirDown( const QString & dir );
   const QString & getStartDir7plus();
   const QString & getDir7plus();
   void setDir7plus( const QString & dir );
   void setStartDir7plus( const QString & dir );
   const QString & getStartDirABin();
   const QString & getDirABin();
   void setDirABin( const QString & dir );
   void setStartDirABin( const QString & dir );
   const char *getGpgID();
	void setGpgID( const char *key );
   QString getSig();
   void setSig( QString sig );
   void setListenCalls( s_listCalls *calls );
   void setDiscCalls( s_listCalls *calls );
   s_listCalls * getListenCalls();
   s_listCalls * getDiscCalls();

   // AX.25-Sachen
   const QString & getPorts();
   void setPorts( const QString & p );
   const QString & getTxMycall();
   void setTxMycall( const QString & m );

   // Filetransfer-Infos
   int getRBlocksize();
   void setRBlocksize( int size );

   // Sound-Infos
	void setSound( int id, const QString & file );
	const QString & getSound( int id );

   // Abfrage der Flags
	bool getFlag( int flag );
	void setFlag( int flag, bool enable );

   // Abfrage der Farben
   int getColor( int nr );
   void setColor( int nr, int id );

   // Irgendwelche Positionen
   int getTxWinSize();
	void setTxWinSize( int size );
   int getUmbruchPos();
   void setUmbruchPos( int pos );

   // Puffergroessen
   int getRxBuffersize();
   void setRxBuffersize( int size );
   int getTxBuffersize();
   void setTxBuffersize( int size );

   // Toolbar-Sachen
   int getTbarPos();
   void setTbarPos( int pos );
   int getTbarFlg();
   void setTbarFlg( int flg );

   // CallKey
   s_callKey * getCallKey( int id );
   void setCallKey( int id, const QString & ccall, bool ssid );
	void delCallKey( int id );

   // Shortcuts
   const QString & getShortcut( int id );
   void setShortcut( int id, const QString & string );

   // Letzter aktiver Preferences-Eintrag
   int getLastPref();
   void setLastPref( int pref );

   // Die 15 zuletzt connecteten Gegenstationen
   const QStringList & getConnList();
   void addConnEntry( const QString & call );
   void saveConnList();

   const QValueList<AwayInfo> & getAway();
   void setAway( const QValueList<AwayInfo> & list );
	const QString & getAwayText( int id );

private:
   void doDirectories();
   void cfgReadFonts( KConfig *kconfig );
	void cfgReadTerminal( KConfig *kconfig );
	void cfgReadAX25( KConfig *kconfig );
   void cfgReadBuffersizes( KConfig *kconfig );
	void cfgReadColors( KConfig *kconfig );
   void cfgReadSounds( KConfig *kconfig );
	void cfgReadScreen( KConfig *kconfig );
	void cfgReadFiletransfer( KConfig *kconfig );
	void cfgReadShortcuts( KConfig *kconfig );
   void cfgReadCallkey( KConfig *kconfig );
	void cfgReadDirectories( KConfig *kconfig );
   void cfgReadGnuPG( KConfig *kconfig );
   void cfgReadLastConn( KConfig *kconfig );
   void cfgReadAway( KConfig * );


	QFont decodeFontInfo( QString & str, bool & ok );
	s_listCalls * decodeCallList( QString & text, s_listCalls * list );


	QFont qso_font, tx_font, bc_font, gpg_font;
   QString localdir, globaldir, ports, txMycall;
   long flags;
   s_listCalls *listenCalls, *discCalls;
   int rxBuffer, txBuffer;
   int colornr[CFG_COLORCOUNT];
   int lastpref, txwinsize, umbruchpos, tbarflg, tbarpos;
	int rblocksize;
   QStringList shortcuts;
   s_callKey *callKey[10];
   QString dirUp, dirDown, dir7plus, dirABin;
   QString lastDirUp, lastDirDown, lastDir7plus, lastDirABin;
	char *gpgId;
   QString sign;
   QStringList sounds, conncalls;
   QValueList<AwayInfo> awaylist;
};
//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------

