/* ddate.c .. converts boring normal dates to fun Discordian Date -><-
   original incarnation written the 65th day of The Aftermath in the 
   Year of Our Lady of Discord 3157 by Druel the Chaotic aka Jeremy Johnson 
   aka mpython@gnu.ai.mit.edu.
   Majorly hacked, extended and bogotified/debogotified on 
   Sweetmorn, Bureaucracy 42, 3161 YOLD, by Lee H:. O:. Smith, KYTP, 
   aka Andrew Bulhak, aka acb@zikzak.net

   Hacked for simple use in LinKT by Jochen Sarrazin, DG6VJ

   and I'm not responsible if this program messes anything up (except your 
   mind, I'm responsible for that) (and that goes for me as well --lhos)
*/
//---------------------------------------------------------------------------
#include "ddate.h"
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
//---------------------------------------------------------------------------

/* configuration options  VVVVV   READ THIS!!! */

/* If you wish ddate(1) to print the date in the same format as Druel's 
 * original ddate when called in immediate mode, define OLD_IMMEDIATE_FMT 
 */

/* #define OLD_IMMEDIATE_FMT */

/* If you wish to use the US format for aneristic dates (m-d-y), as opposed to
 * the Commonwealth format, define US_FORMAT.
 */

/* #define US_FORMAT */

/* If you are ideologically, theologically or otherwise opposed to the 
 * Church of the SubGenius and do not wish your copy of ddate(1) to contain
 * code for counting down to X-Day, undefine PRAISE_BOB */

#define PRAISE_BOB 13013

/*#include <time.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#ifndef __GNUC__
#define inline
#endif*/

/* string constants */

char *day_long[5] = { 
    "Sweetmorn", "Boomtime", "Pungenday", "Prickle-Prickle", "Setting Orange"
};

char *day_short[5] = {"SM","BT","PD","PP","SO"};

char *season_long[5] = { 
    "Chaos", "Discord", "Confusion", "Bureaucracy", "The Aftermath"
};

char *season_short[5] = {"Chs", "Dsc", "Cfn", "Bcy", "Afm"};

char *holyday[5][2] = { 
    {"Mungday", "Chaoflux"},
    {"Mojoday", "Discoflux"},
    {"Syaday",  "Confuflux"},
    {"Zaraday", "Bureflux"},
    {"Maladay", "Afflux"}
};

struct disc_time {
    int season; /* 0-4 */
    int day; /* 0-72 */
    int yday; /* 0-365 */
    int year; /* 3066- */
};

char *excl[] = {
    "Hail Eris!", "All Hail Discordia!", "Kallisti!", "Fnord.", "Or not.",
    "Wibble.", "Pzat!", "P'tang!", "Frink!",
#ifdef PRAISE_BOB
    "Slack!", "Praise \"Bob\"!", "Or kill me.",
#endif /* PRAISE_BOB */
    /* randomness, from the Net and other places. Feel free to add (after
       checking with the relevant authorities, of course). */
    "Grudnuk demand sustenance!", "Keep the Lasagna flying!", 
    "Umlaut Zebra ber alles!",
    ""
};

char default_fmt[] = "%{%A, %B %d%}, %Y YOLD";
char *default_immediate_fmt=
"Today is %{%A, the %e day of %B%} in the YOLD %Y%N";
char *endings[]={"st","nd","rd","th"
};

#define DY(y) (y+1166)


/*inline */char *ending(int i) { return (i%10==1)?endings[0]:(i%10==2?endings[1]:(i%10==3?endings[2]:endings[3]));}
/*inline */int leapp(int i) { return (!(DY(i)%4))&&((DY(i)%100)||(!(DY(i)%400)));}

void print(struct disc_time,char **); /* old */
void format(char *buf, const char* fmt, struct disc_time dt);
/* select a random string */
/*inline */char *sel(char **strings, int num) {return(strings[rand()%num]); }
/* read a fortune file */
int load_fortunes(char *fn, char *delim, char** result);

int xday_countdown(int yday, int year);

struct disc_time convert(int,int);
struct disc_time makeday(int,int,int);


void format(char *buf, const char* fmt, struct disc_time dt)
{
    int tib_start=-1, tib_end=0;
    int i, fmtlen=strlen(fmt);
    char *bufptr=buf;

/*    fprintf(stderr, "format(%p, \"%s\", dt)\n", buf, fmt);*/

    /* first, find extents of St. Tib's Day area, if defined */
    for(i=0; i<fmtlen; i++) {
	if(fmt[i]=='%') {
	    switch(fmt[i+1]) {
	    case 'A':
	    case 'a':
	    case 'd':
	    case 'e':
		if(tib_start>0)	    tib_end=i+1;
		else		    tib_start=i;
		break;
	    case '{': tib_start=i; break;
	    case '}': tib_end=i+1; break;
	    }
	}
    }

    /* now do the formatting */
    buf[0]=0;

    for(i=0; i<fmtlen; i++) {
	if((i==tib_start) && (dt.day==-1)) {
	    /* handle St. Tib's Day */
	    strcpy(bufptr, "St. Tib's Day"); bufptr += 13;
	    i=tib_end;
	} else {
	    if(fmt[i]=='%') {
		char *wibble=0, snarf[23];
		switch(fmt[++i]) {
		case 'A': wibble=day_long[dt.yday%5]; break;
		case 'a': wibble=day_short[dt.yday%5]; break;
		case 'B': wibble=season_long[dt.season]; break;
		case 'b': wibble=season_short[dt.season]; break;
		case 'd': sprintf(snarf, "%d", dt.day+1); wibble=snarf; break;
		case 'e': sprintf(snarf, "%d%s", dt.day+1, ending(dt.day+1)); 
		    wibble=snarf; break;
		case 'H': if(dt.day==4||dt.day==49)
		    wibble=holyday[dt.season][dt.day==49]; break;
		case 'N': if(dt.day!=4&&dt.day!=49) goto eschaton; break;
		case 'n': *(bufptr++)='\n'; break;
		case 't': *(bufptr++)='\t'; break;
		    
		case 'Y': sprintf(snarf, "%d", dt.year); wibble=snarf; break;
		case '.': wibble=sel(excl, sizeof(excl)/sizeof(excl[0]));
		    break;
#ifdef PRAISE_BOB
		case 'X': sprintf(snarf, "%d", 
				  xday_countdown(dt.yday, dt.year));
				  wibble = snarf; break;
#endif /* PRAISE_BOB */
		}
		if(wibble) {
/*		    fprintf(stderr, "wibble = (%s)\n", wibble);*/
		    strcpy(bufptr, wibble); bufptr+=strlen(wibble);
		}
	    } else {
		*(bufptr++) = fmt[i];
	    }
	}
    }
  eschaton:
    *(bufptr)=0;
}

struct disc_time makeday(int imonth,int iday,int iyear) /*i for input */
{ 
    struct disc_time funkychickens;
    
    int cal[12] = { 31,28,31,30,31,30,31,31,30,31,30,31 };
    int dayspast=0;
    
    imonth--;
    funkychickens.year= iyear+1166;
    while(imonth>0) { dayspast+=cal[--imonth]; }
    funkychickens.day=dayspast+iday-1;
    funkychickens.season=0;
    if((funkychickens.year%4)==2) {
	if (funkychickens.day==59)  funkychickens.day=-1;
    }
    funkychickens.yday=funkychickens.day;
/*               note: EQUAL SIGN...hopefully that fixes it */
    while(funkychickens.day>=73) {
	funkychickens.season++;
	funkychickens.day-=73;
    }
    return funkychickens;
}

#if 0
char *ending(int num)
{  
 int temp;
 char *funkychickens;
 
 funkychickens=(char *)malloc(sizeof(char)*3);
 
  temp=num%10; /* get 0-9 */  
  switch (temp)
  { case 1:
      strcpy(funkychickens,"st");
      break;
    case 2:
      strcpy(funkychickens,"nd");
      break;
    case 3:
      strcpy(funkychickens,"rd");
      break;
    default:
      strcpy(funkychickens,"th");
    }
 return funkychickens;
}
#endif

struct disc_time convert(int nday, int nyear)
{  struct disc_time funkychickens;
   
   funkychickens.year = nyear+3066;
   funkychickens.day=nday;
   funkychickens.season=0;
   if ((funkychickens.year%4)==2)
     {if (funkychickens.day==59)
	funkychickens.day=-1;
     else if (funkychickens.day >59)
       funkychickens.day-=1;
    }
   funkychickens.yday=funkychickens.day;
   while (funkychickens.day>=73)
     { funkychickens.season++;
       funkychickens.day-=73;
     }
   return funkychickens;
  
 }


#ifdef PRAISE_BOB

/* Code for counting down to X-Day, X-Day being Cfn 40, 3164 */

int xday_countdown(int yday, int year) {
    int r=(185-yday)+(((yday<59)&&(leapp(year)))?1:0);
    while(year<3164) r+=(leapp(++year)?366:365);
    while(year>3164) r-=(leapp(year--)?366:365);
    return r;
}

#endif

#if 0
void print(struct disc_time tick, char **args)
{ 
  if (args[1]==NULL)
    printf("Today is ");
  else
    printf("%s-%s-%s is ",args[1],args[2],args[3]);
  if (tick.day==-1) printf("St. Tib's Day!");
  else
    { tick.day++;
      printf("%s",days[tick.yday%5]);
      printf(",the %d", tick.day);
      printf("%s day of %s",ending(tick.day),seasons[tick.season]) ;
    }
  printf(" in the YOLD %d\n",tick.year);
  if ((tick.day==5)||(tick.day==50))
    { printf("Celebrate ");
      if (tick.day==5)
	printf("%s\n",holidays[tick.season][0]);
      else
	printf("%s\n",holidays[tick.season][1]);
    }
}
#endif


void getDiscordianDate( char *schwa, int day, int mon, int year, bool today )
{
   struct disc_time hastur;
   char *fnord=0;

   srand(time(NULL));

	hastur=makeday(day, mon, year);
// 	hastur=convert(bob,raw);
   if (today)
   	fnord=fnord?fnord:default_immediate_fmt;
   else
   	fnord=fnord?fnord:default_fmt;
   format(schwa, fnord, hastur);
}

//---------------------------------------------------------------------------
DDate::DDate()
{
}
//---------------------------------------------------------------------------
DDate::~DDate()
{
}
//---------------------------------------------------------------------------
const QString & DDate::getDate( int day, int mon, int year, bool today )
{
   struct disc_time hastur;
   char *fnord=0;
   char schwa[200];


   srand(time(NULL));

	hastur=makeday(day, mon, year);
// 	hastur=convert(bob,raw);
   if (today)
   	fnord=fnord?fnord:default_immediate_fmt;
   else
   	fnord=fnord?fnord:default_fmt;
   format(schwa, fnord, hastur);

   back = schwa;
   return back;
}
//---------------------------------------------------------------------------
