/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  As a special exception, you have permission to link this program
 *  with the Qt library and distribute executables, as long as you
 *  follow the requirements of the GNU GPL in regard to all of the
 *  software in the executable aside from Qt.
 */
//---------------------------------------------------------------------------
#include "settings.h"
#include "settings.moc"
#include "global.h"
#include "flags.h"
#include "userdata.h"
#include "dialog.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qbuttongroup.h>

#include <klocale.h>
#include <kapp.h>
//---------------------------------------------------------------------------
#define OKCANCELWIDTH 80
#define OKCANCELHEIGHT 30
//---------------------------------------------------------------------------
extern KApplication *mykapp;	// TODO: evtl. auf KGlobal umstellen
//---------------------------------------------------------------------------
UserSettings::UserSettings( QWidget *parent )
                    : QDialog( parent, "settings", true )
{
	QButtonGroup *btnGrpCalls;
   QHBoxLayout *hbox;
   QVBoxLayout *vboxmain, *grpbox;


   listTabs = new QList<SettTabBase>();


   vboxmain = new QVBoxLayout( this );
   vboxmain->setMargin( 5 );

   hbox = new QHBoxLayout( vboxmain );

   btnGrpCalls = new QButtonGroup( this );
   btnGrpCalls->setFrameStyle( 49 );
   btnGrpCalls->setAlignment( 1 );
   btnGrpCalls->lower();
   btnGrpCalls->setTitle(i18n ("Calls"));

   hbox->addWidget( btnGrpCalls );

   lbCalls = new QListBox( btnGrpCalls );
   lbCalls->insertStringList( userdata->getUserList() );
   lbCalls->setFixedWidth( lbCalls->maxItemWidth()+20 );
	connect( lbCalls, SIGNAL(highlighted(const QString &)), this, SLOT(slotCallHighlighted(const QString &)) );

   grpbox = new QVBoxLayout( btnGrpCalls );
   grpbox->setMargin( 5 );
   grpbox->addSpacing( 10 );
   grpbox->addWidget( lbCalls );

   hbox->addSpacing( 5 );


   tabs = new QTabWidget( this );
   hbox->addWidget( tabs, 1 );

   // Tabs hinzufuegen
	addTab( new SettPersonalWidget(this), i18n("&Personal") );
	addTab( new SettPasswordsWidget(this), i18n("P&asswords") );

   // Push-Buttons
   hbox = new QHBoxLayout( vboxmain );

   btnHelp = new QPushButton( this );
   btnHelp->resize( OKCANCELWIDTH, OKCANCELHEIGHT );
   btnHelp->setText( i18n("&Help") );
   connect( btnHelp, SIGNAL(clicked()), this, SLOT(slotBtnHelpClicked()) );

   btnOk = new QPushButton( this );
   btnOk->resize( OKCANCELWIDTH, OKCANCELHEIGHT );
   btnOk->setText( i18n("&Ok") );
   connect( btnOk, SIGNAL(clicked()), this, SLOT(slotBtnOkClicked()) );

   btnCancel = new QPushButton( this );
   btnCancel->resize( OKCANCELWIDTH, OKCANCELHEIGHT );
   btnCancel->setText( i18n("&Cancel") );
   connect( btnCancel, SIGNAL(clicked()), this, SLOT(reject()) );


   hbox->addStretch( 1 );

   hbox->addWidget( btnHelp );
   hbox->addSpacing( 10 );
   hbox->addWidget( btnOk );
   hbox->addWidget( btnCancel );


	currentData = NULL;
   changed = false;

	callShowTimer = new QTimer( this );
   connect( callShowTimer, SIGNAL(timeout()), SLOT(slotShowCall()) );
}
//---------------------------------------------------------------------------
UserSettings::~UserSettings()
{
	delete listTabs;
}
//---------------------------------------------------------------------------
void UserSettings::slotBtnOkClicked()
{
	accept();
}
//---------------------------------------------------------------------------
void UserSettings::slotBtnHelpClicked()
{
}
//---------------------------------------------------------------------------
void UserSettings::addTab( SettTabBase *settingsTab, const QString & label )
{
   tabs->addTab( settingsTab, label );
   listTabs->append( settingsTab );
}
//---------------------------------------------------------------------------
void UserSettings::slotCallHighlighted( const QString & )
{
	// Nur anzeigen, wenn dieser Eintrag 250ms lang ausgewaehlt ist.
   callShowTimer->start( 250, true );
}
//---------------------------------------------------------------------------
void UserSettings::slotShowCall()
{
	SettTabBase *tmp;


	// Die Daten von der Datenbank holen.
   currentData = userdata->getUserData( lbCalls->currentText() );

	// Die Daten sollen angezeigt werden.
   for (tmp=listTabs->first(); tmp; tmp = listTabs->next())
   	tmp->setData( currentData );
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
SettPersonalWidget::SettPersonalWidget( QWidget *parent ) : SettTabBase( parent )
{
	setupWidget();
}
//---------------------------------------------------------------------------
SettPersonalWidget::~SettPersonalWidget()
{
}
//---------------------------------------------------------------------------
void SettPersonalWidget::setupWidget()
{
	int i;
	QLabel *l;
   QHBoxLayout *hboxmain = new QHBoxLayout( this );
   QVBoxLayout *vbox = new QVBoxLayout( hboxmain );


   hboxmain->setMargin( 10 );

   l = new QLabel( i18n("Name:"), this );
   vbox->addWidget( l );

	edName = new QLineEdit( this );
   vbox->addWidget( edName, 1 );
   vbox->addSpacing( 5 );

   vbox->addSpacing( 5 );

   l = new QLabel( i18n("Software:"), this );
   vbox->addWidget( l );

   cmbSoftware = new QComboBox( this );
   vbox->addWidget( cmbSoftware );
   vbox->addSpacing( 5 );

   for (i=0; i<SW_ANZ; i++)
      cmbSoftware->insertItem( swType[i].text );

   l = new QLabel( i18n("Type:"), this );
	vbox->addWidget( l );

   cmbType = new QComboBox( this );
   vbox->addWidget( cmbType );
   vbox->addSpacing( 5 );

   cmbType->insertItem( i18n("Terminal") );
   cmbType->insertItem( i18n("Mailbox") );
   cmbType->insertItem( i18n("Digi") );
   cmbType->insertItem( i18n("Convers") );

   vbox->addStretch( 1 );


   hboxmain->addSpacing( 10 );
   vbox = new QVBoxLayout( hboxmain );

   chkbAuto7 = new QCheckBox( i18n("7plus - Autosave"), this );
   vbox->addWidget( chkbAuto7 );
   chkbAutoBIN = new QCheckBox( i18n("BIN - Autosave"), this );
   vbox->addWidget( chkbAutoBIN );
   chkbAutoR = new QCheckBox( i18n("DIDADIT - Autosave"), this );
   vbox->addWidget( chkbAutoR );
   chkbRecConn = new QCheckBox( i18n("recognize 'connected to'"), this );
   vbox->addWidget( chkbRecConn );
   chkbRecReconn = new QCheckBox( i18n("recognize 'reconnected to'"), this );
   vbox->addWidget( chkbRecReconn );
   chkbRemote = new QCheckBox( i18n("remote access"), this );
   vbox->addWidget( chkbRemote );
   chkbCOMP = new QCheckBox( i18n("//COMP active"), this );
   vbox->addWidget( chkbCOMP );
   chkbHUFallowed = new QCheckBox( i18n("#HUF# allowed"), this );
   vbox->addWidget( chkbHUFallowed );
   chkbHUFTX = new QCheckBox( i18n("#HUF# TX active"), this );
   vbox->addWidget( chkbHUFTX );
   chkbHUFRX = new QCheckBox( i18n("#HUF# RX active"), this );
   vbox->addWidget( chkbHUFRX );

   vbox->addStretch( 1 );
}
//---------------------------------------------------------------------------
void SettPersonalWidget::setData( UDataUser *data )
{
	int i;
   long software, flags;


	edName->setText( data->getName() );

   software = data->getSoftware();
   for (i=0; i<SW_ANZ; i++)
   	if (swType[i].id == software)
      {
		   cmbSoftware->setCurrentItem( i );
         break;
		}

	cmbType->setCurrentItem( data->getType()-1 );

	// Folgende Flags werden in der User-Datenbank abgespeichert
	flags = data->getFlags();
   chkbAuto7->setChecked( flags & CH_CHECK7PLUS );
   chkbAutoBIN->setChecked( flags & CH_CHECKAUTOBIN );
   chkbAutoR->setChecked( flags & CH_CHECKDIDADIT );
   chkbRecConn->setChecked( flags & CH_CHECKDISC );
   chkbRecReconn->setChecked( flags & CH_CHECKCONN );
   chkbRemote->setChecked( flags & CH_REMOTE );
   chkbHUFallowed->setChecked( flags & CH_HUFALLOW );

   // Folgende Flags werden nicht abgespeichert und sind jetzt gueltig
/*   chkbCOMP->setChecked( flags & CH_COMP );
   chkbHUFTX->setChecked( flags & CH_HUF_TX );
   chkbHUFRX->setChecked( flags & CH_HUF_RX );*/
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
SettPasswordsWidget::SettPasswordsWidget( QWidget *parent )
			: SettTabBase( parent )
{
	setupWidget();
}
//---------------------------------------------------------------------------
SettPasswordsWidget::~SettPasswordsWidget()
{
}
//---------------------------------------------------------------------------
void SettPasswordsWidget::setupWidget()
{
	QHBoxLayout *hboxmain = new QHBoxLayout( this );
   QVBoxLayout *vbox;


   hboxmain->setMargin( 10 );

   // Passwoerter-Tabelle einfuegen
	table = new QListView( this );

   table->addColumn( i18n("Type") );
   table->addColumn( i18n("Command") );
   table->addColumn( i18n("Auto") );

   hboxmain->addWidget( table, 1 );


   hboxmain->addSpacing( 10 );
   vbox = new QVBoxLayout( hboxmain );

   btnAdd = new QPushButton( i18n("&Add"), this );
   connect( btnAdd, SIGNAL(clicked()), SLOT(slotAddClicked()) );
   btnDel = new QPushButton( i18n("&Delete"), this );
   connect( btnDel, SIGNAL(clicked()), SLOT(slotDelClicked()) );

   vbox->addWidget( btnAdd );
   vbox->addWidget( btnDel );
   vbox->addStretch( 1 );
}
//---------------------------------------------------------------------------
void SettPasswordsWidget::setData( UDataUser *data )
{
}
//---------------------------------------------------------------------------
void SettPasswordsWidget::slotAddClicked()
{
   DlgPasswordAdd *dlg = new DlgPasswordAdd( this );

   dlg->setGeometry((mykapp->desktop()->width()-dlg->width())/2,
             (mykapp->desktop()->height()-dlg->height())/2,
          dlg->width(),dlg->height());

   dlg->exec();

   delete dlg;
}
//---------------------------------------------------------------------------
void SettPasswordsWidget::slotDelClicked()
{
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
SettTabBase::SettTabBase( QWidget *parent ) : QWidget( parent )
{
}
//---------------------------------------------------------------------------
SettTabBase::~SettTabBase()
{
}
//---------------------------------------------------------------------------

