/*  
 *  xconvers - GTK+ client for amateur radio convers
 *  Copyright (C) 2000 Joop Stakenborg <pa4tu@amsat.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/*
 *  main.c - start of gtk loop.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <gtk/gtk.h>
#include "interface.h"
#include "support.h"
#include "history.h"
#include "preferences.h"
#include "types.h"
#include "../pixmaps/xconvers.xpm"

GtkWidget *mainwindow;
extern preferencestype preferences;

/*
 * The program starts here. After gtk_main is called the behaviour of the 
 * program strictly depends user action. See callbacks.c for callbacks
 * generated by widgets (buttons, windows and menus) and all other C files
 * for private functions.
 */
 
int
main(int argc, char *argv[])
{
  GdkBitmap *bitmap, *mask;
  GdkPixmap *icon, *pixmap;
  GtkStyle *mainwindowstyle, *maintextstyle;
  GtkWidget *maintext;

  /* language support */
  bindtextdomain(PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain(PACKAGE);
  gtk_set_locale();

  gtk_init(&argc, &argv);
  add_pixmap_directory(PACKAGE_DATA_DIR "/pixmaps");
  add_pixmap_directory(PACKAGE_SOURCE_DIR "/pixmaps");

  dircheck();
  loadpreferences();
  loadhistory();

  /* Do this before setting the background. Otherwise we have a NULL window and colormap*/
  mainwindow = create_mainwindow();
  gtk_widget_show(mainwindow);

  /* Set the background depending on whether we have recalled a pixmap or not */
  maintext = lookup_widget(mainwindow, "maintext");
  if (preferences.backgroundpixmap) 
  { 
    if (preferences.backgroundpixmap->len > 0)
    {
      pixmap = gdk_pixmap_create_from_xpm(maintext->window, &mask, NULL, preferences.backgroundpixmap->str);
      maintextstyle = gtk_style_copy(maintext->style);
      gtk_style_ref(maintextstyle);
      maintextstyle->bg_pixmap[GTK_STATE_NORMAL] = pixmap;
      gtk_widget_set_style(maintext, maintextstyle);
      gtk_style_unref(maintextstyle);
    }
  }
  else
  {
    maintextstyle = gtk_style_new();
    maintextstyle->base[GTK_STATE_NORMAL] = preferences.backgroundcolor;
    maintextstyle->base[GTK_STATE_INSENSITIVE] = preferences.backgroundcolor;
    gtk_widget_set_style(maintext, maintextstyle);
  }

  /* Set the minimalized-window icon */
  mainwindowstyle = gtk_widget_get_style(mainwindow);
  icon = gdk_pixmap_create_from_xpm_d(mainwindow->window, &bitmap, &mainwindowstyle->bg[GTK_STATE_NORMAL], xconvers_xpm);
  gdk_window_set_icon(mainwindow->window, NULL, icon, bitmap);

  gtk_main();
  return 0;
}