/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *
 * ac3_codec.h
 *
 * AC3 Video Codec.
 * @Author Chavarria Damien.
 * 	   Copyright 1999-2000
 */

#ifndef _AC3_CODEC_H
#define _AC3_CODEC_H

/*********************************************************************
 *                             INCLUDES                              *
 *********************************************************************/

#include "libxmps/libxmps.h"

#include "ring.h"
#include "ac3.h"
#include "ac3_internal.h"
#include "bitstream.h"
#include "downmix.h"
#include "imdct.h"
#include "exponent.h"
#include "coeff.h"
#include "bit_allocate.h"
#include "parse.h"
#include "crc.h"
#include "stats.h"
#include "rematrix.h"
#include "sanity_check.h"
#include "debug.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/*********************************************************************
 *                            FUNCTIONS                              *
 *********************************************************************/


unsigned int ac3_open      (xmps_audio_decoder_plugin_t *audio_decoder);
void*        ac3_get       (xmps_audio_decoder_plugin_t *audio_decoder, unsigned int flag, void *data);
unsigned int ac3_set       (xmps_audio_decoder_plugin_t *audio_decoder, unsigned int flag, void *data);
unsigned int ac3_decompress(xmps_audio_decoder_plugin_t *audio_decoder, void *in_buffer, void *out_buffer, unsigned int size);
unsigned int ac3_close     (xmps_audio_decoder_plugin_t *audio_decoder);

#endif


