/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *
 * mpeg3_codec.c
 *
 * FLI/FLC Codec.
 * @Author Chavarria Damien.
 *         Jasper Berlijn <jasper@il.fontys.nl>
 * 	   Copyright 1999-2000
 */

#include "mpeg2_codec.h"

/* 
 * variables 
 *
 */

double mpeg2_frame_rate_table[16] =
{
  0.0,
  24000.0/1001.0,
  24.0,
  25.0,
  30000.0/1001.0,
  30.0,
  50.0,
  ((60.0*1000.0)/1001.0),
  60.0,
  0,
  0,
};


typedef struct _mpeg2_decoder_t {
  
  xmps_system_plugin_t *our_system;
  xmps_video_info_t    *video_info;
  xmps_video_format_t   format;
  unsigned int          our_stream_id;

} mpeg2_decoder_t;

/*
 * get_video_decoder_info : MANDATORY
 *
 * used by scanplugins to get 
 * a pointer to the decoder.
 *
 */

xmps_video_decoder_plugin_t *get_video_decoder_info()
{
  xmps_video_decoder_plugin_t *video_decoder;
  
  video_decoder = (xmps_video_decoder_plugin_t *) malloc(sizeof(xmps_video_decoder_plugin_t));

  video_decoder->name = "MPEG2";
  video_decoder->data = (void *) malloc(sizeof(mpeg2_decoder_t));

  video_decoder->open       = mpeg2_open;
  video_decoder->get        = mpeg2_get;
  video_decoder->set        = mpeg2_set;
  video_decoder->decompress = mpeg2_decompress;
  video_decoder->close      = mpeg2_close;

  ((mpeg2_decoder_t *) video_decoder->data)->our_system    = NULL;
  ((mpeg2_decoder_t *) video_decoder->data)->our_stream_id = 0;
  ((mpeg2_decoder_t *) video_decoder->data)->video_info    = (xmps_video_info_t *) malloc(sizeof(xmps_video_info_t));

  return video_decoder;
}

/*
 * Codec functions.
 *
 */

unsigned int mpeg2_open(xmps_video_decoder_plugin_t *video_decoder)
{
  if(((mpeg2_decoder_t *) video_decoder->data)->our_system != NULL)
    return 0;
  
  XMPS_DEBUG("mpeg2 codec init");

  return 1;
}

void* mpeg2_get(xmps_video_decoder_plugin_t *video_decoder, unsigned int flags, void *arg)
{
  mpeg2_decoder_t *data;

  if(video_decoder == NULL)
    return NULL;

  data = (mpeg2_decoder_t *) video_decoder->data;

  if(data == NULL) {
    return 0;
  }

  switch(flags)
    {

    case XMPS_FLAG_VIDEO_FORMAT_LIST:
      {
	GList *list = NULL;
	
	data->format.type = XMPS_VIDEO_FORMAT_YUV12;
	data->format.bpp  = 12;

	list = g_list_prepend(list, (void *) &data->format);

	return list;
      }
      break;

    case XMPS_FLAG_VIDEO_INFO:
      {
	XMPS_DEBUG("giving video info!");
	  
	if(data == NULL) {
	  
	  XMPS_DEBUG("problem!");
	  return NULL;
	}

	data->video_info->width       = mpeg2_width();
	data->video_info->height      = mpeg2_height();
	
	data->video_info->format.type = XMPS_VIDEO_FORMAT_YUV12;
	data->video_info->format.bpp  = 12;

	if(data->video_info == NULL) {
	  
	  XMPS_DEBUG("big problem!");
	  return NULL;
	}

	return (void *) data->video_info;
      }
      break;

    default:
      return NULL;
      break;
    }
}

unsigned int mpeg2_set(xmps_video_decoder_plugin_t *video_decoder, unsigned int flag, void *arg)
{
  mpeg2_decoder_t *data;

  if(video_decoder == NULL)
    return 0;

  data = (mpeg2_decoder_t *) video_decoder->data;

  if(data == NULL) {
    return 0;
  }
  
  switch(flag)
    { 
    case XMPS_FLAG_INPUT:
      {
	xmps_data_t    *data_stream;

	data_stream = (xmps_data_t *) arg;

	if(data_stream == NULL) {
	  return 0;
	}

	XMPS_DEBUG("trying to open data stream!");

	if(data_stream->type == XMPS_DATA_VIDEO_COMP) {
	  
	  if(strstr(data_stream->video_compression, "MPG3") != NULL) {

	    mpeg2_init();

	    XMPS_DEBUG("trying to decode one frame");
	    
	    data->our_system = (xmps_system_plugin_t *) data_stream->plugin;
	    data->our_stream_id = data_stream->id;

	    mpeg2_decode_data (NULL, data->our_system, data_stream->id);

	    XMPS_DEBUG("frame rate : %d", (unsigned int) mpeg2_frame_rate_table[mpeg2_frame_rate_code()]);

	    if(data_stream->user_data != NULL) {
	      *((unsigned int *) data_stream->user_data) = (unsigned int) mpeg2_frame_rate_table[mpeg2_frame_rate_code()];
	    }

	    return 1;
	  }
	}
	
	return 0;
      }

    case XMPS_FLAG_DROPFRAME:

      mpeg2_drop(1);
      mpeg2_decode_data (NULL, data->our_system, data->our_stream_id);

      return 1;
      break;
      
    default:
      return 0;
      break;
    }

  return 0;
}

unsigned int mpeg2_decompress(xmps_video_decoder_plugin_t *video_decoder, void *in_buffer, void *out_buffer, unsigned int size)
{
  /*
   * security check
   *
   */
  
  mpeg2_decoder_t       *data;	

  if(video_decoder == NULL) {
    return 0;
  }
  
  data = (mpeg2_decoder_t *) video_decoder->data;
  
  if(data == NULL) {
    return 0;
  }
  
  mpeg2_decode_data (out_buffer, data->our_system, data->our_stream_id);
  
  return 1;
}

unsigned int mpeg2_close(xmps_video_decoder_plugin_t *video_decoder)
{
  XMPS_DEBUG("close");

  ((mpeg2_decoder_t *) video_decoder->data)->our_system = NULL;
  
  mpeg2_closempeg2();
  
  return 1;
}






